/* cStringBuffer: a file-like string buffer.
   Copyright (C) 2004 Mooneer Salem <mooneer@translator.cx>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CSB_PRIVATE_H
#define CSB_PRIVATE_H

/* csb_buf: the main string buffer.
   Elements:
      string: the contents of the buffer (\0 terminated)
      fileptr: the current position of the "file pointer"
      length: length of allocated memory
      stringsize: length of the string itself.
*/
struct csb_buf {
	/*@owned@*/ char *string;
	/*@dependent@*/ char *fileptr;
	size_t length;
	size_t stringsize;
#ifdef CSB_OPTIMIZE_AND_EAT_RAM
	size_t multipletwo;
#endif
	/*@only@*/ /*@null@*/ /*@reldef@*/ char *ungetc_buffer;
	size_t ungetc_length;
#ifdef HAVE_PTHREAD_H
	/*@dependent@*/ pthread_mutex_t buf_mtx;
#endif
};

/* Preprocessor defines:
   BUFFER_INCREMENT: the size of every chunk allocated. This normally
     doesn't need to be changed.
   TRUE: A value representing true.
   FALSE: A value representing false.
   CSB_RESIZE_TO_FIT: automatically resize buffer based on string
     passed in.
   CSB_SEEK_NORESET: seeks to position without a reset.
*/
#define BUFFER_INCREMENT (size_t)1024
#define TRUE 1
#define FALSE 0

/*#define CSB_RESIZE_TO_FIT(buf, string) \
	while (buf->stringsize + strlen(string) > (buf->length - 1)) { \
		csb_addchunk(buf); \
	}
*/
#define CSB_RESIZE_TO_FIT(buf, string) \
	if (buf->stringsize + strlen(string) > (buf->length - 1)) { \
		(void)csb_prealloc(buf, buf->stringsize + strlen(string)); \
	}

#define CSB_SEEK_NORESET(buf, pos) buf->fileptr = buf->string + pos

/* Prototypes for private functions. */
void csb_addchunk(struct csb_buf *buf) /*@modifies buf->length, buf->string, buf->fileptr@*/;

#endif
