#include <stdio.h>
#include <stdlib.h>
#include <src/csb.h>

int main (void)
{
   csb_buf *ps1 = NULL, *ps2 = NULL;
   char bangbuf[2];

   ps1 = csb_new();
   if (ps1 == NULL) return 1;

   printf ("ps1 created:\t\t\t'%s', length %lu, memory size %lu\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   ps2 = csb_new_withstring ("HelloWorld!");
   if (ps2 == NULL) {
      csb_destroy(ps1);
      return 1;
   }

   printf ("ps2 created from buffer:\t'%s', (%lu, %lu)\n", csb_cstring(ps2), (unsigned long)csb_length(ps2), (unsigned long)csb_memorysize(ps2));
   (void)csb_putc (ps1, 'h');    printf ("csb_putc(ps1,'h'):\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   (void)csb_puts (ps1, "ellO");    printf ("csb_puts(ps1,\"ellO\"):\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   csb_rewind (ps1);
   (void)csb_putc (ps1, 'H');
   printf ("csb_rewind()\n");
   printf ("csb_putc(ps1,'H'):\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   (void)csb_seek (ps1, 4);
   printf ("csb_seek(ps1,4):\t\t'%c'\n", csb_getc (ps1));
   (void)csb_ungetc (ps1, 'o');
   printf ("csb_ungetc(ps1,'o'):\t\t'%c'\n", csb_getc (ps1));
   printf ("csb_tellpos(ps1):\t\t%lu\n", (unsigned long)csb_tellpos(ps1));
   csb_strcat (ps1, "World");
   printf ("csb_strcat(ps1,\"World\"):\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   csb_prealloc (ps1, 12);
   printf ("csb_prealloc(ps1,12):\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   csb_seek (ps1, 10);
   if (csb_tellpos (ps1) != 10) {
    printf ("Error: seek to position 10 failed (pos = %lu)\n", (unsigned long)csb_tellpos(ps1));
    csb_destroy(ps1);
    csb_destroy(ps2);
    return (1);
   }
   printf ("csb_seek(ps1,10):\t\t%sEOF\n", (csb_getc (ps1) == EOF ? "" : "not "));
   csb_seek (ps1, 10);
   csb_write (ps1, "!", 2);
   printf ("csb_write(ps1,\"!\", 2):\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   csb_seek (ps1, 10);
   if (csb_tellpos (ps1) != 10) {
    printf ("Error: seek to position 10 failed (pos = %lu)\n", (unsigned long)csb_tellpos(ps1));
    csb_destroy(ps1);
    csb_destroy(ps2);
    return (1);
   }
   printf ("csb_seek(ps1,10):\t\t'%c'\n", csb_getc (ps1));
   csb_seek (ps1, 10);
   (void)csb_read (ps1, bangbuf, 2);
   printf ("csb_read(ps1,bangbuf, 2):\t'%s'\n", bangbuf);
   csb_rewind (ps1);
   csb_printf (ps1, "%s == %s, %lu, %lu", csb_cstring(ps2), csb_cstring(ps2), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));
   printf ("csb_printf:\t\t\t'%s', (%lu, %lu)\n", csb_cstring(ps1), (unsigned long)csb_length(ps1), (unsigned long)csb_memorysize(ps1));

   csb_destroy (ps2);
   csb_destroy (ps1);
   return (0);
} 
