#include <stdio.h>
#include <stdlib.h>
#include <src/csb.h>

int main(void) {
	csb_buf *buf = csb_new_withstring("0123456789|0123456789");
	int retval = 0;

	if (buf == NULL) {
		return (1);
	}

	csb_seek(buf, 10);
	printf("buffer contains: %s, position %d, length %d\n", csb_cstring(buf), (int)csb_tellpos(buf), (int)csb_length(buf));
	(void)csb_movebegin(buf);
	printf("buffer contains: %s, position %d, length %d\n", csb_cstring(buf), (int)csb_tellpos(buf), (int)csb_length(buf));

	if (csb_length(buf) != 11 || csb_tellpos(buf) > 0) {
		retval = 1;
	}

	csb_destroy(buf);
	return (retval);
}
