#include <stdio.h>
#include <stdlib.h>
#include <src/csb.h>

int main(void) {
	csb_buf *buf = csb_new_withstring("0123456789");
	int retval = 0;
	FILE *fptr;
	
	if (buf == NULL) {
		return (1);
	}

	fptr = fopen("test11.data", "wb");
	if (fptr == NULL) {
		return (1);
	}

	printf("Writing %s\n", csb_cstring(buf));
	csb_netstring_tofile(buf, fptr);
	fclose(fptr);
	csb_destroy(buf);

	fptr = fopen("test11.data", "rb");
	if (fptr == NULL) {
		return (1);
	}

	buf = csb_netstring_fromfile(fptr);
	if (buf == NULL) {
		return (1);
	}
	fclose(fptr);

	printf("file contains: %s\n", csb_cstring(buf));

	if (strcmp("0123456789", csb_cstring(buf)) != 0) {
		retval = 1;
		printf("ERROR READING\n");
	}

	csb_destroy(buf);
	return (retval);
}
