/* cStringBuffer: a file-like string buffer.
   Copyright (C) 2004 Mooneer Salem <mooneer@translator.cx>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CSB_H
#define CSB_H

/* csb_buf: the main data type in this library. */
struct csb_buf;
typedef struct csb_buf csb_buf;

/* Function prototypes. */
/*@only@*/ /*@null@*/ /*@partial@*/ csb_buf *csb_new (void);
/*@only@*/ /*@null@*/ csb_buf *csb_new_withstring (const char *);
int csb_puts(csb_buf *buf, /*@unique@*/ const char *str) /*@modifies buf->fileptr, buf->string, buf->stringsize, buf->length, buf->ungetc_buffer, buf->ungetc_length@*/;
int csb_putc(csb_buf *buf, const char ch) /*@modifies buf->fileptr, buf->string, buf->stringsize, buf->length, buf->ungetc_buffer, buf->ungetc_length@*/;
void csb_seek(csb_buf *buf, size_t pointer) /*@modifies buf->fileptr, buf->ungetc_buffer, buf->ungetc_length@*/;
void csb_rewind(csb_buf *buf) /*@modifies buf->fileptr, buf->ungetc_buffer, buf->ungetc_length@*/;
void csb_destroy(/*@only@*/ /*@in@*/ /*@notnull@*/ csb_buf *);
int csb_getc(csb_buf *buf) /*@modifies buf->ungetc_buffer, buf->fileptr, buf->ungetc_length@*/;
void csb_ungetc(csb_buf *buf, const char ch) /*@modifies buf->ungetc_buffer, buf->ungetc_length@*/;
size_t csb_tellpos(csb_buf *) /*@*/;
int csb_strcat(csb_buf *buf, /*@unique@*/ const char *str) /*@modifies buf->string, buf->stringsize, buf->length, buf->fileptr, buf->ungetc_buffer@*/;
/*@exposed@*/ char *csb_cstring(csb_buf *);
int csb_prealloc(csb_buf *buf, size_t length) /*@modifies buf->string, buf->length, buf->fileptr@*/;
int csb_write(csb_buf *buf, /*@unique@*/ const void *data, size_t length) /*@modifies buf->fileptr, buf->string, buf->stringsize, buf->length, buf->ungetc_buffer@*/;
int csb_printf(csb_buf *buf, const char *fmt, ...) /*@modifies buf->fileptr, buf->string, buf->stringsize, buf->length, buf->ungetc_buffer@*/;
size_t csb_read(csb_buf *buf, void *data, size_t length) /*@modifies buf->fileptr, data, buf->fileptr, buf->ungetc_buffer, buf->ungetc_length@*/;
size_t csb_length(csb_buf *);
size_t csb_memorysize(csb_buf *);
void csb_lock(csb_buf *buf) /*@modifies buf->buf_mtx@*/;
void csb_unlock(csb_buf *buf) /*@modifies buf->buf_mtx@*/;
size_t csb_searchforward(csb_buf *buf, const char *str) /*@modifies buf->fileptr, buf->ungetc_buffer@*/;
size_t csb_searchbackward(csb_buf *buf, const char *str) /*@modifies buf->fileptr, buf->ungetc_buffer@*/;
int csb_trunc(csb_buf *buf) /*@modifies buf->fileptr, buf->stringsize@*/;
int csb_movebegin(csb_buf *buf) /*@modifies buf->fileptr, buf->string, buf->stringsize, buf->ungetc_buffer, buf->ungetc_length@*/;
size_t csb_file_read(csb_buf *buf, FILE *fptr, size_t length);
size_t csb_file_write(csb_buf *buf, FILE *fptr, size_t length);
/*@null@*/ csb_buf *csb_netstring_fromfile(FILE *fptr);
int csb_netstring_tofile(csb_buf *buf, FILE *fptr);

#endif /* CSB_H */
