/* cStringBuffer: a file-like string buffer.
   Copyright (C) 2004 Mooneer Salem <mooneer@translator.cx>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Include necessary includes. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>
#include <unistd.h>
#include "config.h"

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

#include "csb_private.h"
#include "csb.h"

/* csb_file_read(): read bytes from file into buffer.
   Parameters:
     buf: The buffer to operate on.
     fptr: The file pointer to read from.
     length: The amount to read.
   Returns: amount read, or 0 if EOF.
*/

size_t csb_file_read(csb_buf *buf, FILE *fptr, size_t length) {
	/* Declare variables. */
	char buffer[length];
	size_t amountread;

	/* Read information from buffer. */
	amountread = fread(buffer, length, (size_t)1, fptr);
	if (amountread > 0) {
		(void)csb_puts(buf, buffer);
	}

	/* Return amount read. */
	return (amountread);
}

/* csb_file_write(): write buffer to a file.
   Parameters:
     buf: The buffer to operate on.
     fptr: The file to write to.
     length: The amount to write.
   Returns: amount written, or false on error.
*/

size_t csb_file_write(csb_buf *buf, FILE *fptr, size_t length) {
	/* Declare variables. */
	size_t amountwritten;

	/* Verify length. */
	if ((buf->fileptr - buf->string + length) > buf->stringsize) {
		length = buf->stringsize;
	}

	/* Perform file write. */
	amountwritten = fwrite(csb_cstring(buf) + csb_tellpos(buf), length, (size_t)1, fptr);

	/* Return to client. */
	return (amountwritten);
}
