/* cStringBuffer: a file-like string buffer.
   Copyright (C) 2004 Mooneer Salem <mooneer@translator.cx>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Include necessary includes. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>
#include <unistd.h>

#include "config.h"

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

#include "csb_private.h"
#include "csb.h"

/* csb_lock(): Lock buffer to all but the caller.
   Parameters:
     buf: the buffer to lock.
   Returns: none.
*/
void csb_lock (csb_buf *buf) /*@modifies buf->buf_mtx@*/ {
	/* Lock mutex. */
#ifdef HAVE_PTHREAD_H
	(void)pthread_mutex_lock(&(buf)->buf_mtx);
#else
	/* Do nothing. */
#endif
}

/* csb_unlock(): Unlock buffer. 
   Parameters:
     buf: the buffer to unlock.
   Returns: none.
*/
void csb_unlock (csb_buf *buf) /*@modifies buf->buf_mtx@*/ {
	/* Unlock mutex. */
#ifdef HAVE_PTHREAD_H
	(void)pthread_mutex_unlock(&(buf)->buf_mtx);
#else
	/* Do nothing. */
#endif
}
