/* cStringBuffer: a file-like string buffer.
   Copyright (C) 2004 Mooneer Salem <mooneer@translator.cx>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Include necessary includes. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>
#include <unistd.h>
#include "config.h"

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

#include "csb_private.h"
#include "csb.h"

/* csb_searchforward(): Searches forward from current position.
   Parameters:
     buf: Buffer to search.
     string: string to search for.
   Returns: false if nothing's found, or true if found. File pointer will
     change to position of match.
*/
size_t csb_searchforward(csb_buf *buf, const char *str) /*@modifies buf->fileptr, buf->ungetc_buffer@*/ {
	/* Declare variables. */
	size_t searchlen = strlen(str);
	size_t pos = (size_t)((unsigned long)(buf->fileptr) - (unsigned long)(buf->string));

	/* Proceed with search. */
	while (pos < (buf->stringsize - searchlen)) {
		if (strncmp(str, buf->string + pos, searchlen) == 0) {
			/* String found. Seek here and return. */
			CSB_SEEK_NORESET(buf, pos);
			return((size_t)TRUE);
		}
		pos++;
	}

	/* Nothing found; return false. */
	return(FALSE);
}

/* csb_searchbackward(): Searches backward from current position.
   Parameters:
     buf: Buffer to search.
     string: string to search for.
   Returns: false if nothing's found, or true if found. File pointer will
     change to position of match.
*/
size_t csb_searchbackward(csb_buf *buf, const char *str) /*@modifies buf->fileptr, buf->ungetc_buffer@*/ {
	/* Declare variables. */
	size_t searchlen = strlen(str);
	long pos = (long)((unsigned long)(buf->fileptr) - (unsigned long)(buf->string));

	/* Proceed with search. */
	while (pos >= 0) {
		if (strncmp(str, buf->string + pos, searchlen) == 0) {
			/* String found. Seek here and return. */
			CSB_SEEK_NORESET(buf, (size_t)pos);
			return((size_t)TRUE);
		}
		pos--;
	}

	/* Nothing found; return false. */
	return(FALSE);
}
