#include <stdio.h>
#include <stdlib.h>
#include <src/csb.h>

int main(void) {
	csb_buf *buf = csb_new_withstring("0123456789|0123456789");
	int retval = 0;

	if (buf == NULL) {
		return (1);
	}

	csb_seek(buf, 9);
	printf("buffer contains: %s, position %d\n", csb_cstring(buf), (int)csb_tellpos(buf));
	(void)csb_trunc(buf);
	printf("buffer contains: %s, position %d\n", csb_cstring(buf), (int)csb_tellpos(buf));

	if (csb_length(buf) != 10) {
		retval = 1;
	}

	csb_destroy(buf);
	return (retval);
}
