#include <stdio.h>
#include <stdlib.h>
#include <src/csb.h>

int main(void) {
	csb_buf *buf = csb_new_withstring("0123456789");
	int retval = 0;
	char xyz[20];

	if (buf == NULL) {
		return (1);
	}

	printf("buffer contains: %s, position %d, length %d\n", csb_cstring(buf), (int)csb_tellpos(buf), (int)csb_length(buf));
	csb_rewind(buf);
	printf("ungetc 9\n");
	csb_ungetc(buf, '9');
	printf("ungetc 8\n");
	csb_ungetc(buf, '8');
	retval = csb_read(buf, xyz, 12);
	xyz[12] = '\0';

	if (retval != 12) {
		retval = 1;
		printf("ERROR READING\n");
	} else {
		retval = 0;
		printf("read: %s\n", xyz);
	}

	csb_destroy(buf);
	return (retval);
}
