dnl -*- autoconf -*-
dnl $Id: acinclude.m4,v 1.2 2004/09/24 13:51:43 martin Exp $
dnl Additional autoconf macros (self written ones)

dnl Copyright 2003 by Martin Kammerhofer <mkamm@gmx.net>
dnl AC_PROG_PERL([minimum-version])
AC_DEFUN([AC_PROG_PERL],
[AC_REQUIRE([AC_SYS_INTERPRETER])
AC_PATH_PROG(PERL, perl, /usr/bin/perl)
AC_ARG_VAR(PERL, [Path to Perl executable])
AC_MSG_CHECKING(for working Perl)
if "$PERL" -we '1' 2>&5; then
	AC_MSG_RESULT(yes)
else
	AC_MSG_RESULT(no)
	AC_MSG_ERROR([[
***
*** No Perl executable found in PATH!
***
]])
fi
if test -n '$1'; then
  AC_MSG_CHECKING([for Perl version >= $1])
  if "$PERL" -we 'require $1; 1' 2>&5; then
	AC_MSG_RESULT(yes)
  else
	AC_MSG_RESULT(no)
	AC_MSG_ERROR([[
***
*** No suitable Perl found in PATH!
*** Maybe prepend Perl's directory?
*** You may also set environment variable PERL.
***
]])
  fi
fi
])

dnl Copyright 2003 by Martin Kammerhofer <mkamm@gmx.net>
dnl AC_PERLLIB(library, [version])
AC_DEFUN([AC_PERLLIB],
[AC_REQUIRE([AC_PROG_PERL])
 AC_MSG_CHECKING([for Perl module $1 $2])
if "$PERL" -we "require 5; use $1 $2; 1" 2>&5; then
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT(no)
  AC_MSG_ERROR([[
***
*** Get and install the Perl module $1 from the CPAN!
*** Use ``$PERL -MCPAN -e shell'' and type ``h'' !
*** (Maybe you have to set environment variable PERLLIB,
*** see ``perldoc perlrun'' for instructions!)
***
]])
fi
])

dnl Copyright 2003 by Martin Kammerhofer <mkamm@gmx.net>
dnl AC_PERLLIBS(library...)
AC_DEFUN([AC_PERLLIBS],
[AC_REQUIRE([AC_PROG_PERL])
for uselib in $1; do
  AC_PERLLIB([$uselib])
done
])

dnl EOF $RCSfile: acinclude.m4,v $
