/*******************************************************************************
 *                                                                             *
 *  CYRILLIC SUPPORT LIBRARY (C) 2001-2003 Pavel Novikov (pavel@ext.by)        *
 *                                                                             *
 *******************************************************************************

  This is a library core.

*/

/*******************************************************************************
 *                                                                             *
 *  TODO                                                                       *
 *                                                                             *
 *******************************************************************************

  a) unicode support for all library capabilities
  b) implement size limits of the text that can be analyzed
  c) replace "encoding" with the correct wording like "charset"

  *) think of replacing 0xFF in stats tables to 0x00 because there is no sense
  *) think of speeding up by using special tables to avoid double conversion
  *) think of implementing thread-safe functions for the "high level" processing

*/

/* includes */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "cyrillic.h"
#include "cyrillic_export.h"

/* character table map - windows-1251 */
static char _CYR_TABLE_WIN_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xFF,0xF6,0xF7,0xA3,0xFD,0xA5,0xA6,0xA7,0xF0,0xA9,0xF2,0xAB,0xAC,0xAD,0xAE,0xF4,
  0xF8,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xFA,0xF1,0xFC,0xF3,0xBB,0xBC,0xBD,0xBE,0xF5,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF

};

/* character table map - koi8-r */
static char _CYR_TABLE_KOI_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xC4,0xB3,0xDA,0xBF,0xC0,0xD9,0xC3,0xB4,0xC2,0xC1,0xC5,0xDF,0xDC,0xDB,0xDD,0xDE,
  0xB0,0xB1,0xB2,0x93,0xFE,0xF9,0xFB,0x97,0x98,0x99,0xFF,0x9B,0xF8,0x9D,0xFA,0x9F,
  0xCD,0xBA,0xD5,0xF1,0xD6,0xC9,0xB8,0xB7,0xBB,0xD4,0xD3,0xC8,0xBE,0xBD,0xBC,0xC6,
  0xC7,0xCC,0xB5,0xF0,0xB6,0xB9,0xD1,0xD2,0xCB,0xCF,0xD0,0xCA,0xD8,0xD7,0xCE,0xBF,
  0xEE,0xA0,0xA1,0xE6,0xA4,0xA5,0xE4,0xA3,0xE5,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,
  0xAF,0xEF,0xE0,0xE1,0xE2,0xE3,0xA6,0xA2,0xEC,0xEB,0xA7,0xE8,0xED,0xE9,0xE7,0xEA,
  0x9E,0x80,0x81,0x96,0x84,0x85,0x94,0x83,0x95,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,
  0x8F,0x9F,0x90,0x91,0x92,0x93,0x86,0x82,0x9C,0x9B,0x87,0x98,0x9D,0x99,0x97,0x9A

};

/* character table map - koi8-u */
static char _CYR_TABLE_KOU_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xC4,0xB3,0xDA,0xBF,0xC0,0xD9,0xC3,0xB4,0xC2,0xC1,0xC5,0xDF,0xDC,0xDB,0xDD,0xDE,
  0xB0,0xB1,0xB2,0x93,0xFE,0xF9,0xFB,0x97,0x98,0x99,0xFF,0x9B,0xF8,0x9D,0xFA,0x9F,
  0xCD,0xBA,0xD5,0xF1,0xF3,0xC9,0xA6,0xF5,0xBB,0xD4,0xD3,0xC8,0xBE,0xAD,0xBC,0xC6,
  0xC7,0xCC,0xB5,0xF0,0xF2,0xB9,0xB6,0xF4,0xCB,0xCF,0xD0,0xCA,0xD8,0xBD,0xCE,0xBF,
  0xEE,0xA0,0xA1,0xE6,0xA4,0xA5,0xE4,0xA3,0xE5,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,
  0xAF,0xEF,0xE0,0xE1,0xE2,0xE3,0xA6,0xA2,0xEC,0xEB,0xA7,0xE8,0xED,0xE9,0xE7,0xEA,
  0x9E,0x80,0x81,0x96,0x84,0x85,0x94,0x83,0x95,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,
  0x8F,0x9F,0x90,0x91,0x92,0x93,0x86,0x82,0x9C,0x9B,0x87,0x98,0x9D,0x99,0x97,0x9A

};

/* character table map - iso-8859-5 */
static char _CYR_TABLE_ISO_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xFF,0xF0,0xA2,0xA3,0xF2,0xA5,0xA6,0xF4,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xF6,0xAF,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
  0xFC,0xF1,0xF2,0xF3,0xF3,0xF5,0xF6,0xF5,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xF7,0xFF

};

/* character table map - x-mac-cyrillic */
static char _CYR_TABLE_MAC_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xA0,0xF8,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xF2,0xF3,0xF4,0xF5,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xFB,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xFF,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xF6,0xF7,0xDA,0xDB,0xFC,0xF0,0xF1,0xEF,
  0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xFD

};

/* character table map - ibm866 */
static char _CYR_TABLE_DOS_DOS[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
  0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF

};

/* character table map (reverce) - windows-1251 */
static char _CYR_TABLE_DOS_WIN[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,
  0xA8,0xB8,0xAA,0xBA,0xAF,0xBF,0xA1,0xA2,0xB0,0xF9,0xB7,0xFB,0xB9,0xA4,0xFE,0xA0

};

/* character table map (reverce) - koi8-r */
static char _CYR_TABLE_DOS_KOI[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xE1,0xE2,0xF7,0xE7,0xE4,0xE5,0xF6,0xFA,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,
  0xF2,0xF3,0xF4,0xF5,0xE6,0xE8,0xE3,0xFE,0xFB,0xFD,0xFF,0xF9,0xF8,0xFC,0xE0,0xF1,
  0xC1,0xC2,0xD7,0xC7,0xC4,0xC5,0xD6,0xDA,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,
  0x90,0x91,0x92,0x81,0x87,0xB2,0xB4,0xA7,0xA6,0xB5,0xA1,0xA8,0xAE,0xAD,0xAC,0x83,
  0x84,0x89,0x88,0x86,0x80,0x8A,0xAF,0xB0,0xAB,0xA5,0xBB,0xB8,0xB1,0xA0,0xBE,0xB9,
  0xBA,0xB6,0xB7,0xAA,0xA9,0xA2,0xA4,0xBD,0xBC,0x85,0x82,0x8D,0x8C,0x8E,0x8F,0x8B,
  0xD2,0xD3,0xD4,0xD5,0xC6,0xC8,0xC3,0xDE,0xDB,0xDD,0xDF,0xD9,0xD8,0xDC,0xC0,0xD1,
  0xB3,0xA3,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0x9C,0x95,0x9E,0x96,0xFC,0xFD,0x94,0x9A

};

/* character table map (reverce) - koi8-u */
static char _CYR_TABLE_DOS_KOU[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xE1,0xE2,0xF7,0xE7,0xE4,0xE5,0xF6,0xFA,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,
  0xF2,0xF3,0xF4,0xF5,0xE6,0xE8,0xE3,0xFE,0xFB,0xFD,0xFF,0xF9,0xF8,0xFC,0xE0,0xF1,
  0xC1,0xC2,0xD7,0xC7,0xC4,0xC5,0xD6,0xDA,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,
  0x90,0x91,0x92,0x81,0x87,0xB2,0xB6,0xB7,0xB8,0xB5,0xA1,0xA8,0xAE,0xBD,0xAC,0x83,
  0x84,0x89,0x88,0x86,0x80,0x8A,0xAF,0xB0,0xAB,0xA5,0xBB,0xB8,0xB1,0xA0,0xBE,0xB9,
  0xBA,0xD1,0xD2,0xAA,0xA9,0xA2,0xD6,0xD7,0xBC,0x85,0x82,0x8D,0x8C,0x8E,0x8F,0x8B,
  0xD2,0xD3,0xD4,0xD5,0xC6,0xC8,0xC3,0xDE,0xDB,0xDD,0xDF,0xD9,0xD8,0xDC,0xC0,0xD1,
  0xB3,0xA3,0xB4,0xA4,0xB7,0xA7,0xF6,0xF7,0x9C,0x95,0x9E,0x96,0xFC,0xFD,0x94,0x9A

};

/* character table map (reverce) - iso-8859-5 */
static char _CYR_TABLE_DOS_ISO[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
  0xA1,0xF1,0xA4,0xF4,0xA7,0xF7,0xAE,0xFE,0xF8,0xF9,0xFA,0xFB,0xF0,0xFD,0xFE,0xA0

};

/* character table map (reverce) - x-mac-cyrillic */
static char _CYR_TABLE_DOS_MAC[]=
{

  /* hex code array */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
  0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
  0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
  0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
  0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
  0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
  0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,
  0xDD,0xDE,0xB8,0xB9,0xBA,0xBB,0xD8,0xD9,0xA1,0xF9,0xFA,0xC3,0xDC,0xFF,0xFE,0xCA

};

/* character table map - windows-1251 */
static char _CYR_STATS_WIN[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xC0,0x27,0x68,0x26,0x48,0xBC,0x16,0x2C,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,0x46,
  0x65,0x7A,0x8E,0x42,0x04,0x14,0x08,0x22,0x15,0x08,0x00,0x2C,0x28,0x09,0x0C,0x38,
  0xC7,0x25,0x68,0x24,0x44,0xCA,0x17,0x2B,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,0x44,
  0x73,0x77,0x94,0x42,0x05,0x13,0x0B,0x23,0x13,0x09,0x00,0x2F,0x30,0x06,0x0F,0x35

};

/* character table map - koi8-r */
static char _CYR_STATS_KOI[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x04,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x0F,0xC7,0x25,0x0B,0x44,0xCA,0x05,0x24,0x13,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,
  0x44,0x35,0x73,0x77,0x94,0x42,0x17,0x68,0x30,0x2F,0x2B,0x13,0x06,0x09,0x23,0x00,
  0x0C,0xC0,0x27,0x08,0x48,0xBC,0x04,0x26,0x14,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,
  0x46,0x38,0x65,0x7A,0x8E,0x42,0x16,0x68,0x28,0x2C,0x2C,0x15,0x09,0x08,0x22,0x00

};

/* character table map - koi8-u */
static char _CYR_STATS_KOU[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x04,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x0F,0xC7,0x25,0x0B,0x44,0xCA,0x05,0x24,0x13,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,
  0x44,0x35,0x73,0x77,0x94,0x42,0x17,0x68,0x30,0x2F,0x2B,0x13,0x06,0x09,0x23,0x00,
  0x0C,0xC0,0x27,0x08,0x48,0xBC,0x04,0x26,0x14,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,
  0x46,0x38,0x65,0x7A,0x8E,0x42,0x16,0x68,0x28,0x2C,0x2C,0x15,0x09,0x08,0x22,0x00

};

/* character table map - iso-8859-5 */
static char _CYR_STATS_ISO[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xC0,0x27,0x68,0x26,0x48,0xBC,0x16,0x2C,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,0x46,
  0x65,0x7A,0x8E,0x42,0x04,0x14,0x08,0x22,0x15,0x08,0x00,0x2C,0x28,0x09,0x0C,0x38,
  0xC7,0x25,0x68,0x24,0x44,0xCA,0x17,0x2B,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,0x44,
  0x73,0x77,0x94,0x42,0x05,0x13,0x0B,0x23,0x13,0x09,0x00,0x2F,0x30,0x06,0x0F,0x35,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

};

/* character table map - x-mac-cyrillic */
static char _CYR_STATS_MAC[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xC0,0x27,0x68,0x26,0x48,0xBC,0x16,0x2C,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,0x46,
  0x65,0x7A,0x8E,0x42,0x04,0x14,0x08,0x22,0x15,0x08,0x00,0x2C,0x28,0x09,0x0C,0x38,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x35,
  0xC7,0x25,0x68,0x24,0x44,0xCA,0x17,0x2B,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,0x44,
  0x73,0x77,0x94,0x42,0x05,0x13,0x0B,0x23,0x13,0x09,0x00,0x2F,0x30,0x06,0x0F,0x00

};

/* character table map - ibm866 */
static char _CYR_STATS_DOS[]=
{

  /* hex code array */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xC0,0x27,0x68,0x26,0x48,0xBC,0x16,0x2C,0x98,0x18,0x54,0x72,0x4C,0x9B,0xFA,0x46,
  0x65,0x7A,0x8E,0x42,0x04,0x14,0x08,0x22,0x15,0x08,0x00,0x2C,0x28,0x09,0x0C,0x38,
  0xC7,0x25,0x68,0x24,0x44,0xCA,0x17,0x2B,0xAD,0x1C,0x4F,0x77,0x4C,0x9B,0xFE,0x44,
  0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x73,0x77,0x94,0x42,0x05,0x13,0x0B,0x23,0x13,0x09,0x00,0x2F,0x30,0x06,0x0F,0x35,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

};

static unsigned long _CYR_ENCODING_STATS[CYR_CHARSET_SIZE];

/* converting encoding subroutine for buffer */
char *_cyr_convert(char *buffer,unsigned long size,const char *table)
{

  /* counter */
  unsigned long position=0;

  /* check if buffer sucks */
  if(!buffer){return(buffer);}

  /* swapping characters */
  for(position=0;position<size;position++)
  {

    /* replacement process */
    *(buffer+position)=*(table+(unsigned char)*(buffer+position));

  }

  /* returning the pointer to the buffer */
  return(buffer);

}

/* converting encoding subroutine for single char */
unsigned int _cyr_convert_char(unsigned int c,const char *table)
{

  /* replacement process */
  return((unsigned char)*(table+c));

}

/* translating the source encoding */
int cyr_translate_src_encoding(const char *table)
{

  /* check */
  if(!table){return(CYR_TABLE_UNKNOWN);}

  /* comparsion */
  if(strncasecmp(table,CYR_TABLE_WIN,strlen(CYR_TABLE_WIN))==0){return(CYR_TABLE_WIN_DOS);}
  else if(strncasecmp(table,CYR_TABLE_KOI,strlen(CYR_TABLE_KOI))==0){return(CYR_TABLE_KOI_DOS);}
  else if(strncasecmp(table,CYR_TABLE_KOU,strlen(CYR_TABLE_KOU))==0){return(CYR_TABLE_KOU_DOS);}
  else if(strncasecmp(table,CYR_TABLE_ISO,strlen(CYR_TABLE_ISO))==0){return(CYR_TABLE_ISO_DOS);}
  else if(strncasecmp(table,CYR_TABLE_MAC,strlen(CYR_TABLE_MAC))==0){return(CYR_TABLE_MAC_DOS);}
  else if(strncasecmp(table,CYR_TABLE_DOS,strlen(CYR_TABLE_DOS))==0){return(CYR_TABLE_DOS_DOS);}
  else{return(CYR_TABLE_UNKNOWN);}

}

/* translating the destination encoding */
int cyr_translate_dst_encoding(const char *table)
{

  /* check */
  if(!table){return(CYR_TABLE_UNKNOWN);}

  /* comparsion */
  if(strncasecmp(table,CYR_TABLE_WIN,strlen(CYR_TABLE_WIN))==0){return(CYR_TABLE_DOS_WIN);}
  else if(strncasecmp(table,CYR_TABLE_KOI,strlen(CYR_TABLE_KOI))==0){return(CYR_TABLE_DOS_KOI);}
  else if(strncasecmp(table,CYR_TABLE_KOU,strlen(CYR_TABLE_KOU))==0){return(CYR_TABLE_DOS_KOU);}
  else if(strncasecmp(table,CYR_TABLE_ISO,strlen(CYR_TABLE_ISO))==0){return(CYR_TABLE_DOS_ISO);}
  else if(strncasecmp(table,CYR_TABLE_MAC,strlen(CYR_TABLE_MAC))==0){return(CYR_TABLE_DOS_MAC);}
  else if(strncasecmp(table,CYR_TABLE_DOS,strlen(CYR_TABLE_DOS))==0){return(CYR_TABLE_DOS_DOS);}
  else{return(CYR_TABLE_UNKNOWN);}                                    

}

/* converting encoding subroutine */
char *cyr_convert(char *buffer,unsigned long size,int table)
{

  /* check if buffer sucks */
  if(!buffer){return(buffer);}

  /* choosing the correct table */
  switch(table)
  {

    /* proxying - conversion */
    case CYR_TABLE_WIN_DOS:{return(_cyr_convert(buffer,size,_CYR_TABLE_WIN_DOS));}
    case CYR_TABLE_KOI_DOS:{return(_cyr_convert(buffer,size,_CYR_TABLE_KOI_DOS));}
    case CYR_TABLE_KOU_DOS:{return(_cyr_convert(buffer,size,_CYR_TABLE_KOU_DOS));}
    case CYR_TABLE_ISO_DOS:{return(_cyr_convert(buffer,size,_CYR_TABLE_ISO_DOS));}
    case CYR_TABLE_MAC_DOS:{return(_cyr_convert(buffer,size,_CYR_TABLE_MAC_DOS));}
    case CYR_TABLE_DOS_WIN:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_WIN));}
    case CYR_TABLE_DOS_KOI:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_KOI));}
    case CYR_TABLE_DOS_KOU:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_KOU));}
    case CYR_TABLE_DOS_ISO:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_ISO));}
    case CYR_TABLE_DOS_MAC:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_MAC));}

    /* proxying - dummy conversion - shouldn't it be removed later? */
    default:{return(_cyr_convert(buffer,size,_CYR_TABLE_DOS_DOS));}

  }

}

/* converting encoding subroutine */
unsigned int cyr_convert_char(unsigned int c,int table)
{

  /* choosing the correct table */
  switch(table)
  {

    /* proxying - conversion */
    case CYR_TABLE_WIN_DOS:{return(_cyr_convert_char(c,_CYR_TABLE_WIN_DOS));}
    case CYR_TABLE_KOI_DOS:{return(_cyr_convert_char(c,_CYR_TABLE_KOI_DOS));}
    case CYR_TABLE_KOU_DOS:{return(_cyr_convert_char(c,_CYR_TABLE_KOU_DOS));}
    case CYR_TABLE_ISO_DOS:{return(_cyr_convert_char(c,_CYR_TABLE_ISO_DOS));}
    case CYR_TABLE_MAC_DOS:{return(_cyr_convert_char(c,_CYR_TABLE_MAC_DOS));}
    case CYR_TABLE_DOS_WIN:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_WIN));}
    case CYR_TABLE_DOS_KOI:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_KOI));}
    case CYR_TABLE_DOS_KOU:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_KOU));}
    case CYR_TABLE_DOS_ISO:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_ISO));}
    case CYR_TABLE_DOS_MAC:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_MAC));}

    /* proxying - dummy conversion - shouldn't it be removed later? */
    default:{return(_cyr_convert_char(c,_CYR_TABLE_DOS_DOS));}

  }

}

/* converting encoding subroutine - by name */
char *cyr_convert_dual(char *buffer,unsigned long size,const char *table_src,const char *table_dst)
{

  /* initialize default tables */
  int table_src_translated=CYR_TABLE_UNKNOWN;
  int table_dst_translated=CYR_TABLE_UNKNOWN;

  /* check if buffer sucks */
  if(!buffer){return(buffer);}

  /* translate optiman tables tables */
  table_src_translated=cyr_translate_src_encoding(table_src);
  table_dst_translated=cyr_translate_dst_encoding(table_dst);

  /* always detect */
  if(_cyr_det_encoding==_CYR_DET_ENCODING_AUTO)
  {

    /* detecting the table */
    table_src_translated=_cyr_detect_buffer_encoding(buffer,size);

  }

  /* detect only if unknown */
  if((_cyr_det_encoding==_CYR_DET_ENCODING_SOFT)&&(table_src_translated==CYR_TABLE_UNKNOWN))
  {

    /* detecting the table */
    table_src_translated=_cyr_detect_buffer_encoding(buffer,size);

  }

  /* do not detect in all other cases */
  if(table_src_translated==CYR_TABLE_UNKNOWN)
  {

    /* detecting the table */
    table_src_translated=cyr_translate_src_encoding(cyr_mime_encoding?cyr_mime_encoding:cyr_src_encoding);

  }

  /* skip unknown tables */
  if((table_src_translated==CYR_TABLE_UNKNOWN)||(table_dst_translated==CYR_TABLE_UNKNOWN)){return(buffer);}

  /* encode data */
  cyr_convert(buffer,size,table_src_translated);
  cyr_convert(buffer,size,table_dst_translated);

  /* returning the pointer to the buffer */
  return(buffer);

}

/* converting encoding subroutine - by name (using stored encoding) */
char *cyr_convert_dualSE(char *buffer,unsigned long size,const char *table_src)
{

  /* redirecting the request */
  return(cyr_convert_dual(buffer,size,table_src,cyr_dst_encoding));
        
}

/* converting encoding subroutine - by name, with memory allocation for const chars */
const char *cyr_convert_dualA(const char *buffer,unsigned long size,const char *table_src,const char *table_dst)
{

  /* will be used as pointer to return */
  char *_cyr_buffer;

  /* check if buffer sucks */
  if(!buffer){return(buffer);}

  /* allocating the memory and copying the data */
  _cyr_buffer=malloc(size);
  if(_cyr_buffer)
  {
    strncpy(_cyr_buffer,buffer,size);
  }

  /* returning the pointer to the converted data */
  return(cyr_convert_dual(_cyr_buffer,size,table_src,table_dst));

}

/* converting encoding subroutine - by name, with memory allocation for const chars (using stored encoding) */  
const char *cyr_convert_dualASE(const char *buffer,unsigned long size,const char *table_src)
{

  /* redirecting the request */
  return(cyr_convert_dualA(buffer,size,table_src,cyr_dst_encoding));

}

/* needed for src charset */
const char *cyr_getrfc2047charset(const char *buffer)
{
                
  if(!buffer){return(buffer);}
         
  /* detected */
  if((strlen(buffer)>1)&&(buffer[0]=='=')&&(buffer[1]=='?'))
  {
                
    /* parsing */
    return(buffer+2);
                        
  }

  /* trying once more */
  else if((strlen(buffer)>2)&&(buffer[0]=='"')&&(buffer[1]=='=')&&(buffer[2]=='?'))
  {

    /* parsing */
    return(buffer+3);

  }
                        
  /* freeing the shit */
  return(buffer);
                
}

/* multiply statistics matrix by score matrix & return the result */
unsigned long _cyr_score_stats(const char *table)
{

  /* counter */
  unsigned long position=0;

  /* score */
  unsigned long score=0;

  /* process matrixes */
  for(position=0;position<CYR_CHARSET_SIZE;position++)
  {

    /* update stats */
    score+=_CYR_ENCODING_STATS[position]*(unsigned char)*(table+position);

  }

  /* returning */
  return(score);

}

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
int _cyr_detect_encoding()
{

  /* score definitions */
  unsigned long score_kou=0;
  unsigned long score_koi=0;
  unsigned long score_win=0;
  unsigned long score_dos=0;
  unsigned long score_iso=0;
  unsigned long score_mac=0;
  unsigned long score_max=0;
  unsigned long score_out=0;

  /* defult encoding */
  int encoding=CYR_TABLE_UNKNOWN;

  /* scoring */
  score_kou=_cyr_score_stats(_CYR_STATS_KOU);
  score_koi=_cyr_score_stats(_CYR_STATS_KOI);
  score_win=_cyr_score_stats(_CYR_STATS_WIN);
  score_dos=_cyr_score_stats(_CYR_STATS_DOS);
  score_iso=_cyr_score_stats(_CYR_STATS_ISO);
  score_mac=_cyr_score_stats(_CYR_STATS_MAC);

  /* analyze */
  if(score_max<=score_kou){encoding=CYR_TABLE_KOU_DOS;score_max=score_kou;}
  if(score_max<=score_koi){encoding=CYR_TABLE_KOI_DOS;score_max=score_koi;}
  if(score_max<=score_win){encoding=CYR_TABLE_WIN_DOS;score_max=score_win;}
  if(score_max<=score_dos){encoding=CYR_TABLE_DOS_DOS;score_max=score_dos;}
  if(score_max<=score_iso){encoding=CYR_TABLE_ISO_DOS;score_max=score_iso;}
  if(score_max<=score_mac){encoding=CYR_TABLE_MAC_DOS;score_max=score_mac;}

  /* verify */
  if(score_max==score_kou){score_out++;}
  if(score_max==score_koi){score_out++;}
  if(score_max==score_win){score_out++;}
  if(score_max==score_dos){score_out++;}
  if(score_max==score_iso){score_out++;}
  if(score_max==score_mac){score_out++;}

  /* returning */
  return((score_out<CYR_SCORE_OUT_MAX)?encoding:CYR_TABLE_UNKNOWN);

}

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
int _cyr_detect_buffer_encoding(const char *buffer,unsigned long size)
{

  /* processing the macros */
  cyr_flush_encoding_stats();
  cyr_collect_encoding_stats(buffer,size);

  /* finally redirect */
  return(_cyr_detect_encoding());

}

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
const char *cyr_detect_encoding()
{

  /* score definitions */
  unsigned long score_kou=0;
  unsigned long score_koi=0;
  unsigned long score_win=0;
  unsigned long score_dos=0;
  unsigned long score_iso=0;
  unsigned long score_mac=0;
  unsigned long score_max=0;
  unsigned long score_out=0;

  /* defult encoding */
  const char *encoding=NULL;

  /* scoring */
  score_kou=_cyr_score_stats(_CYR_STATS_KOU);
  score_koi=_cyr_score_stats(_CYR_STATS_KOI);
  score_win=_cyr_score_stats(_CYR_STATS_WIN);
  score_dos=_cyr_score_stats(_CYR_STATS_DOS);
  score_iso=_cyr_score_stats(_CYR_STATS_ISO);
  score_mac=_cyr_score_stats(_CYR_STATS_MAC);

  /* analyze */
  if(score_max<=score_kou){encoding=CYR_TABLE_KOU;score_max=score_kou;}
  if(score_max<=score_koi){encoding=CYR_TABLE_KOI;score_max=score_koi;}
  if(score_max<=score_win){encoding=CYR_TABLE_WIN;score_max=score_win;}
  if(score_max<=score_dos){encoding=CYR_TABLE_DOS;score_max=score_dos;}
  if(score_max<=score_iso){encoding=CYR_TABLE_ISO;score_max=score_iso;}
  if(score_max<=score_mac){encoding=CYR_TABLE_MAC;score_max=score_mac;}

  /* verify */
  if(score_max==score_kou){score_out++;}
  if(score_max==score_koi){score_out++;}
  if(score_max==score_win){score_out++;}
  if(score_max==score_dos){score_out++;}
  if(score_max==score_iso){score_out++;}
  if(score_max==score_mac){score_out++;}

  /* returning */
  return((score_out<CYR_SCORE_OUT_MAX)?encoding:NULL);

}

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
const char *cyr_detect_buffer_encoding(const char *buffer,unsigned long size)
{

  /* processing the macros */
  cyr_flush_encoding_stats();
  cyr_collect_encoding_stats(buffer,size);

  /* finally redirect */
  return(cyr_detect_encoding());

}

/* flushing stats */
void cyr_flush_encoding_stats()
{

  /* counter */
  unsigned long position=0;

  /* process characters */
  for(position=0;position<CYR_CHARSET_SIZE;position++)
  {

    /* update stats */
    _CYR_ENCODING_STATS[position]=0;

  }

  /* returning */
  return;

}

/* collecting stats from the buffer */
void cyr_collect_encoding_stats(const char *buffer,unsigned long size)
{

  /* counter */
  unsigned long position=0;

  /* check if buffer sucks */
  if(!buffer){return;}

  /* process characters */
  for(position=0;position<size;position++)
  {

    /* update stats */
    _CYR_ENCODING_STATS[(unsigned char)*(buffer+position)]++;

  }

  /* returning */
  return;

}
