/*******************************************************************************
 *                                                                             *
 *  CYRILLIC SUPPORT LIBRARY (C) 2001-2003 Pavel Novikov (pavel@ext.by)        *
 *                                                                             *
 *******************************************************************************

  This is a library core.

*/

/* do not include twice */
#ifndef cyrillic_h
#define cyrillic_h

/* some constants  */
#define CYR_CHARSET_SIZE 256
#define CYR_SCORE_OUT_MAX 3

/* character table conversion */
#define CYR_TABLE_WIN_DOS 0x00
#define CYR_TABLE_KOI_DOS 0x01
#define CYR_TABLE_KOU_DOS 0x02
#define CYR_TABLE_ISO_DOS 0x03
#define CYR_TABLE_MAC_DOS 0x04
#define CYR_TABLE_DOS_DOS 0x05
#define CYR_TABLE_DOS_WIN 0x06
#define CYR_TABLE_DOS_KOI 0x07
#define CYR_TABLE_DOS_KOU 0x08
#define CYR_TABLE_DOS_ISO 0x09
#define CYR_TABLE_DOS_MAC 0x0a
#define CYR_TABLE_UNKNOWN 0x0b

/* string names for encodings */
#define CYR_TABLE_WIN "windows-1251"
#define CYR_TABLE_KOI "koi8-r"
#define CYR_TABLE_KOU "koi8-u"
#define CYR_TABLE_ISO "iso-8859-5"
#define CYR_TABLE_MAC "x-mac-cyrillic"
#define CYR_TABLE_DOS "ibm866"

/* converting encoding subroutine for buffer */
char *_cyr_convert(char *buffer,unsigned long size,const char *table);

/* converting encoding subroutine for single char */
unsigned int _cyr_convert_char(unsigned int c,const char *table);

/* translating the source encoding */
int cyr_translate_src_encoding(const char *table);

/* translating the destination encoding */
int cyr_translate_dst_encoding(const char *table);

/* converting encoding subroutine */
char *cyr_convert(char *buffer,unsigned long size,int table);

/* converting encoding subroutine */
unsigned int cyr_convert_char(unsigned int c,int table);

/* converting encoding subroutine - by name */
char *cyr_convert_dual(char *buffer,unsigned long size,const char *table_src,const char *table_dst);

/* converting encoding subroutine - by name (using stored encoding) */
char *cyr_convert_dualSE(char *buffer,unsigned long size,const char *table_src);

/* converting encoding subroutine - by name, with memory allocation for const chars */
const char *cyr_convert_dualA(const char *buffer,unsigned long size,const char *table_src,const char *table_dst);

/* converting encoding subroutine - by name, with memory allocation for const chars (using stored encoding) */
const char *cyr_convert_dualASE(const char *buffer,unsigned long size,const char *table_src);

/* needed for src charset */
const char *cyr_getrfc2047charset(const char *buffer);

/* multiply statistics matrix by score matrix & return the result */
unsigned long _cyr_score_stats(const char *table);

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
int _cyr_detect_encoding();

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
int _cyr_detect_buffer_encoding(const char *buffer,unsigned long size);

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
const char *cyr_detect_encoding();

/* detection of the code table via stats - the priority is following: kou, koi, win, dos, iso, mac */
const char *cyr_detect_buffer_encoding(const char *buffer,unsigned long size);

/* flushing stats */
void cyr_flush_encoding_stats();

/* collecting stats from the buffer */
void cyr_collect_encoding_stats(const char *buffer,unsigned long size);

/* do not include twice */
#endif
