/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Subnet;
import DaNAMiCS.Transition;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Arc
extends PetriUnit {
    public int weight;
    public int type = 0;
    public PetriUnit from;
    public PetriUnit to;
    public Place p;
    public Transition t;
    public Point[] points;
    public boolean toPlace;
    public boolean[] selected;
    public int numpoints;
    public static Subnet Parent = null;
    int handleSpot = -1;
    JDialog ADialog;
    JTextField ADPWeightval;
    JCheckBox splnCheck;
    JCheckBox inhCheck;

    Arc(PetriUnit petriUnit, int n, PetriUnit petriUnit2, Place place, Transition transition, int n2) {
        this.type = n2;
        this.from = petriUnit;
        this.to = petriUnit2;
        this.p = place;
        this.t = transition;
        this.weight = n;
        this.numpoints = 0;
        this.points = new Point[10];
        this.selected = new boolean[10];
        this.toPlace = petriUnit2 == place;
        int n3 = 0;
        while (n3 < 10) {
            this.selected[n3] = false;
            ++n3;
        }
        this.addHandle();
        this.setBound();
    }

    public void ADOKButtonAction(ActionEvent actionEvent) {
        try {
            if (this.ADPWeightval.getText().equals("")) {
                this.weight = this.inhCheck.isSelected() ? -1 : 1;
                this.type = this.splnCheck.isSelected() ? 0 : 1;
                this.ADialog.dispose();
                return;
            }
            Integer n = new Integer(this.ADPWeightval.getText());
            this.weight = n;
            if (this.weight < 0) {
                this.weight = -1;
            }
            if (this.inhCheck.isSelected()) {
                this.weight = -1;
            }
            this.type = this.splnCheck.isSelected() ? 0 : 1;
            this.ADialog.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane jOptionPane = new JOptionPane("Invalid Number!", 0);
            JDialog jDialog = jOptionPane.createDialog(DFrame.MyFrame, "Error!");
            ((Component)jDialog).setLocation(this.ADialog.getLocation().x, this.ADialog.getLocation().y);
            jDialog.show();
        }
    }

    void addHandle() {
        int n;
        if (this.numpoints < 1) {
            this.numpoints = 1;
            this.points[0] = new Point();
            if (this.type == 0) {
                this.points[0].x = (this.from.x + this.to.x) / 2 - (this.from.y - this.to.y) / 10;
                this.points[0].y = (this.from.y + this.to.y) / 2 + (this.from.x - this.to.x) / 10;
            } else {
                this.points[0].x = (this.from.x + this.to.x) / 2;
                this.points[0].y = (this.from.y + this.to.y) / 2;
            }
            return;
        }
        if (this.points.length < this.numpoints + 3) {
            Point[] pointArray = this.points;
            this.points = new Point[pointArray.length + 10];
            this.selected = new boolean[pointArray.length + 10];
            n = 0;
            while (n < this.numpoints) {
                this.points[n] = pointArray[n];
                this.selected[n] = false;
                ++n;
            }
        }
        if (this.handleSpot > -1 && this.numpoints > 0) {
            int n2;
            int n3;
            int n4;
            ++this.numpoints;
            int n5 = this.numpoints;
            while (n5 > this.handleSpot) {
                this.points[n5] = this.points[n5 - 1];
                --n5;
            }
            if (n5 > 0) {
                n = this.points[n5 - 1].x;
                n4 = this.points[n5 - 1].y;
            } else {
                n = this.from.x;
                n4 = this.from.y;
            }
            if (n5 < this.numpoints - 1) {
                n3 = this.points[n5 + 1].x;
                n2 = this.points[n5 + 1].y;
            } else {
                n3 = this.to.x;
                n2 = this.to.y;
            }
            this.points[n5] = new Point();
            this.points[n5].x = (n + n3) / 2;
            this.points[n5].y = (n4 + n2) / 2;
        }
    }

    public boolean canFireFrom() {
        if (this.weight < 0) {
            return this.p.tokens == 0;
        }
        if (this.weight <= this.p.tokens) {
            return true;
        }
        return this.p.tokens < 0;
    }

    public boolean canFireTo() {
        if (this.p.limit < 0) {
            return true;
        }
        return this.p.limit >= this.p.tokens + this.weight;
    }

    public Arc copyArc(Arc arc) {
        Arc arc2 = new Arc(arc.from, arc.weight, arc.to, arc.p, arc.t, arc.type);
        arc2.toPlace = this.toPlace;
        return arc2;
    }

    public Point[] copyPoints() {
        Point[] pointArray = new Point[this.points.length];
        int n = 0;
        while (n < this.points.length) {
            if (this.points[n] != null) {
                pointArray[n] = new Point();
                pointArray[n].x = this.points[n].x;
                pointArray[n].y = this.points[n].y;
            }
            ++n;
        }
        return pointArray;
    }

    public void deepCopy2() {
        this.from = this.from.copy;
        this.to = this.to.copy;
        this.p = (Place)this.p.copy;
        this.t = (Transition)this.t.copy;
    }

    public void delete() {
    }

    /*
     * Unable to fully structure code
     */
    boolean deleteSelected() {
        var1_1 = 0;
        ** GOTO lbl10
        {
            if (this.numpoints == 1) {
                return true;
            }
            this.handleSpot = var1_1;
            this.removeHandle();
            do {
                if (this.selected[var1_1]) continue block0;
                ++var1_1;
lbl10:
                // 2 sources

            } while (var1_1 < this.numpoints);
        }
        return false;
    }

    public void dialog() {
        int n;
        Object object;
        int n2;
        Object object2;
        this.ADialog = new JDialog(DFrame.MyFrame, "Arc Attributes", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2));
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel("Arc Source:");
        String string = new String();
        String string2 = new String();
        PetriUnitList petriUnitList = this.t.ArcsIn;
        boolean bl = false;
        while (petriUnitList != null) {
            if ((Arc)petriUnitList.p == this) {
                bl = true;
            }
            petriUnitList = petriUnitList.next;
        }
        if (bl) {
            object2 = this.p.getHeritage();
            n2 = 0;
            while (n2 < ((String[])object2).length) {
                string = string.concat(object2[n2]);
                if (n2 != ((String[])object2).length - 1) {
                    string = string.concat("::");
                }
                ++n2;
            }
            object = this.t.getHeritage();
            n = 0;
            while (n < ((String[])object).length) {
                string2 = string2.concat(object[n]);
                if (n != ((String[])object).length - 1) {
                    string2 = string2.concat("::");
                }
                ++n;
            }
        } else {
            object2 = this.t.getHeritage();
            n2 = 0;
            while (n2 < ((String[])object2).length) {
                string = string.concat(object2[n2]);
                if (n2 != ((String[])object2).length - 1) {
                    string = string.concat("::");
                }
                ++n2;
            }
            object = this.p.getHeritage();
            n = 0;
            while (n < ((String[])object).length) {
                string2 = string2.concat(object[n]);
                if (n != ((String[])object).length - 1) {
                    string2 = string2.concat("::");
                }
                ++n;
            }
        }
        object2 = new JLabel(string);
        JLabel jLabel2 = new JLabel("Arc Destination:");
        object = new JLabel(string2);
        JLabel jLabel3 = new JLabel("Weight:");
        this.ADPWeightval = new JTextField();
        Integer n3 = new Integer(this.weight);
        this.ADPWeightval.setText(n3.toString());
        this.ADPWeightval.setColumns(10);
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Arc.this.ADOKButtonAction(actionEvent);
            }
        });
        this.ADPWeightval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Arc.this.ADOKButtonAction(actionEvent);
            }
        });
        this.splnCheck = new JCheckBox("Spline", this.type == 0);
        this.inhCheck = new JCheckBox("Inhibitor", this.weight == -1);
        if (this.to.getType() == 2) {
            this.inhCheck.setEnabled(false);
        } else {
            PetriUnitList petriUnitList2 = this.t.ArcsOut;
            while (petriUnitList2 != null) {
                if (petriUnitList2.p == this) {
                    this.inhCheck.setEnabled(false);
                    break;
                }
                petriUnitList2 = petriUnitList2.next;
            }
        }
        if (this.weight == -1) {
            this.ADPWeightval.setText("");
            this.ADPWeightval.setEnabled(false);
        }
        this.inhCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Arc.this.ADPWeightval.setEnabled(Arc.this.ADPWeightval.isEnabled() ^ true);
                Arc.this.ADPWeightval.setText("");
                Arc.this.ADPWeightval.repaint();
            }
        });
        this.ADialog.getContentPane().add((Component)jPanel, "Center");
        jPanel.add(jLabel);
        jPanel.add((Component)object2);
        jPanel.add(jLabel2);
        jPanel.add((Component)object);
        jPanel.add(jLabel3);
        jPanel.add(this.ADPWeightval);
        jPanel.add(this.splnCheck);
        jPanel.add(this.inhCheck);
        this.ADialog.getContentPane().add((Component)jButton, "South");
        this.ADialog.pack();
        ((Component)this.ADialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.ADialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.ADialog.getBounds().height / 2);
        this.ADialog.show();
    }

    public void fireFrom() {
        if (this.weight <= 0) {
            return;
        }
        if (this.p.tokens < 0) {
            return;
        }
        this.p.tokens -= this.weight;
    }

    public void fireTo() {
        if (this.p.tokens >= 0) {
            this.p.tokens += this.weight;
        }
    }

    PetriUnitList getSelected(Rectangle rectangle, PetriUnitList petriUnitList) {
        int n = 0;
        while (n < this.numpoints) {
            if (rectangle.contains(this.points[n])) {
                petriUnitList = new PetriUnitList(this, petriUnitList);
                petriUnitList.extra = n;
            }
            ++n;
        }
        return petriUnitList;
    }

    public int getType() {
        return 1;
    }

    boolean in(int n, int n2) {
        this.handleSpot = 0;
        while (this.handleSpot < this.numpoints) {
            if (this.points[this.handleSpot].x - n > -4 && this.points[this.handleSpot].x - n < 4 && this.points[this.handleSpot].y - n2 > -4 && this.points[this.handleSpot].y - n2 < 4) {
                return true;
            }
            ++this.handleSpot;
        }
        this.handleSpot = -1;
        return false;
    }

    boolean isSelected() {
        return this.selected[this.handleSpot];
    }

    void move(int n, int n2) {
        if (this.handleSpot > -1) {
            this.points[this.handleSpot].x += n;
            this.points[this.handleSpot].y += n2;
        }
    }

    boolean moveSelected(int n, int n2) {
        int n3 = 0;
        while (n3 < this.numpoints) {
            if (this.selected[n3]) {
                this.points[n3].x += n;
                this.points[n3].y += n2;
            }
            ++n3;
        }
        return false;
    }

    void paint(Draw draw) {
        int n;
        int n2;
        if (this.numpoints < 1) {
            return;
        }
        if (this.from == Parent || this.to == Parent) {
            return;
        }
        int n3 = 0;
        while (n3 < this.numpoints) {
            draw.g.setColor(PetriUnit.selectedColor);
            if (this.selected[n3]) {
                draw.g.fillRect((int)((float)this.points[n3].x * PetriUnit.scale) - PetriUnit.four, (int)((float)this.points[n3].y * PetriUnit.scale) - PetriUnit.four, PetriUnit.eight + 1, PetriUnit.eight + 1);
            }
            ++n3;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n4 = (int)((float)this.from.getCenterX() * PetriUnit.scale);
        int n5 = (int)((float)this.from.getCenterY() * PetriUnit.scale);
        int n6 = n4;
        int n7 = n5;
        int n8 = (int)((float)this.points[0].x * PetriUnit.scale);
        int n9 = (int)((float)this.points[0].y * PetriUnit.scale);
        int n10 = this.points[this.numpoints - 1].x - this.to.getCenterX();
        int n11 = this.points[this.numpoints - 1].y - this.to.getCenterY();
        draw.resetPoints();
        draw.addPoint(n4, n5);
        if (this.weight == -1) {
            draw.g.setColor(Color.red);
        } else {
            draw.g.setColor(Color.black);
        }
        if (draw.drawHandles) {
            draw.g.fillRect(n8 - PetriUnit.two, n9 - PetriUnit.two, PetriUnit.four, PetriUnit.four);
        }
        if (this.weight > 1 && (double)PetriUnit.scale >= 0.7) {
            Integer n12 = new Integer(this.weight);
            draw.g.drawString(n12.toString(), n8, n9 - PetriUnit.ten);
        }
        int n13 = 1;
        while (n13 <= this.numpoints + 1) {
            if (n13 < this.numpoints) {
                n2 = (int)((float)this.points[n13].x * draw.scale);
                n = (int)((float)this.points[n13].y * draw.scale);
                if (draw.drawHandles) {
                    draw.g.fillRect(n2 - PetriUnit.two, n - PetriUnit.two, PetriUnit.four, PetriUnit.four);
                }
            } else if (n13 == this.numpoints) {
                n2 = this.to.xEdge(n10, n11);
                n = this.to.yEdge(n10, n11);
            } else {
                n2 = n8;
                n = n9;
            }
            if (this.type == 0) {
                f = -n4 + 3 * n6 - 3 * n8 + n2;
                f2 = 2 * n4 - 5 * n6 + 4 * n8 - n2;
                f3 = -n4 + n8;
                f4 = n6;
                f5 = -n5 + 3 * n7 - 3 * n9 + n;
                f6 = 2 * n5 - 5 * n7 + 4 * n9 - n;
                f7 = -n5 + n9;
                f8 = n7;
                f /= 2.0f;
                f2 /= 2.0f;
                f3 /= 2.0f;
                f5 /= 2.0f;
                f6 /= 2.0f;
                f7 /= 2.0f;
                int n14 = Math.abs(n6 - n8) + Math.abs(n7 - n9);
                if (n14 < 10) {
                    n14 = 10;
                }
                if (n14 > 30) {
                    n14 = 30;
                }
                n14 = 10;
                draw.catmullRom(f, f2, f3, f4, f5, f6, f7, f8, n14);
            } else {
                draw.addPoint(n6, n7);
            }
            n4 = n6;
            n6 = n8;
            n8 = n2;
            n5 = n7;
            n7 = n9;
            n9 = n;
            ++n13;
        }
        draw.addPoint(n6, n7);
        draw.drawPoints();
        if (this.weight == -1) {
            draw.background = Color.lightGray;
            draw.edge = Color.red;
            draw.circle(n6, n7, PetriUnit.five);
            draw.edge = Color.black;
        } else {
            float f9;
            float f10;
            float f11;
            n2 = n6;
            n = n7;
            if (this.type == 0) {
                f11 = 0.75f;
                float f12 = f * f11 * f11 * f11 + f2 * f11 * f11 + f3 * f11 + f4;
                float f13 = f5 * f11 * f11 * f11 + f6 * f11 * f11 + f7 * f11 + f8;
                f10 = (float)n2 - f12;
                f9 = (float)n - f13;
            } else {
                f10 = n6 - n4;
                f9 = n7 - n5;
            }
            f11 = f10 * f10 + f9 * f9;
            f11 = (float)PetriUnit.five / (float)Math.sqrt(f11);
            n4 = (int)(f11 * (-f10 - f9)) + n2;
            n5 = (int)(f11 * (f10 - f9)) + n;
            n6 = (int)(f11 * (-f10 + f9)) + n2;
            n7 = (int)(f11 * (-f9 - f10)) + n;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            nArray[0] = n2;
            nArray2[0] = n;
            nArray[1] = n4;
            nArray2[1] = n5;
            nArray[2] = n6;
            nArray2[2] = n7;
            draw.g.fillPolygon(nArray, nArray2, 3);
        }
    }

    void print() {
        this.from.printname();
        this.to.printname();
    }

    boolean removeArc(PetriUnit petriUnit) {
        if (this.from == petriUnit) {
            return true;
        }
        return this.to == petriUnit;
    }

    void removeHandle() {
        if (this.handleSpot > -1 && this.numpoints > 1) {
            --this.numpoints;
            while (this.handleSpot < this.numpoints) {
                this.points[this.handleSpot] = this.points[this.handleSpot + 1];
                this.selected[this.handleSpot] = this.selected[this.handleSpot + 1];
                ++this.handleSpot;
            }
        }
    }

    boolean removeSelected(Rectangle rectangle, int n) {
        return rectangle.contains(this.points[n]);
    }

    void resetHandle() {
        if (this.numpoints == 1) {
            if (this.selected[0]) {
                return;
            }
            if (this.type == 0) {
                this.points[0].x = (this.from.x + this.to.x) / 2 - (this.from.y - this.to.y) / 10;
                this.points[0].y = (this.from.y + this.to.y) / 2 + (this.from.x - this.to.x) / 10;
            } else {
                this.points[0].x = (this.from.x + this.to.x) / 2;
                this.points[0].y = (this.from.y + this.to.y) / 2;
            }
        }
    }

    void setBound() {
        if (this.bound == null) {
            this.bound = new Rectangle();
        }
        if (this.bound == null) {
            System.out.println("We appear to have run out of memory.");
        }
        if (this.from.bound == null || this.to.bound == null) {
            System.out.println("We appear to have run out of memory oops.");
        }
        this.bound.setSize(1, 1);
        this.bound.setLocation(this.from.x, this.from.y);
        this.bound.add(this.from.bound);
        this.bound.add(this.to.bound);
        if (this.type == 1) {
            int n = 0;
            while (n < this.numpoints) {
                this.bound.add(this.points[n]);
                ++n;
            }
            this.bound.x -= 10;
            this.bound.y -= 10;
            this.bound.width += 20;
            this.bound.height += 20;
            return;
        }
        int n = this.points[0].x - this.from.getCenterX();
        int n2 = this.points[0].y - this.from.getCenterY();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.from.getCenterX();
        int n12 = this.from.getCenterY();
        int n13 = this.from.xEdge(n, n2);
        int n14 = this.from.yEdge(n, n2);
        int n15 = this.points[0].x;
        int n16 = this.points[0].y;
        n = this.points[this.numpoints - 1].x - this.to.getCenterX();
        n2 = this.points[this.numpoints - 1].y - this.to.getCenterY();
        int n17 = 1;
        while (n17 <= this.numpoints + 1) {
            float f;
            int n18;
            int n19;
            if (n17 < this.numpoints) {
                n19 = this.points[n17].x;
                n18 = this.points[n17].y;
            } else if (n17 == this.numpoints) {
                n19 = this.to.xEdge(n, n2);
                n18 = this.to.yEdge(n, n2);
            } else {
                n19 = this.to.getCenterX();
                n18 = this.to.getCenterY();
            }
            n3 = -n11 + 3 * n13 - 3 * n15 + n19;
            n4 = 2 * n11 - 5 * n13 + 4 * n15 - n19;
            n5 = -n11 + n15;
            n6 = n13;
            n7 = -n12 + 3 * n14 - 3 * n16 + n18;
            n8 = 2 * n12 - 5 * n14 + 4 * n16 - n18;
            n9 = -n12 + n16;
            n10 = n14;
            n3 /= 2;
            n4 /= 2;
            n5 /= 2;
            n7 /= 2;
            n8 /= 2;
            n9 /= 2;
            int n20 = Math.abs(n13 - n15) + Math.abs(n14 - n16);
            n20 /= 8;
            n20 = (int)((float)n20 * PetriUnit.scale);
            if (n20 < 2) {
                n20 = 2;
            }
            if (n20 > 20) {
                n20 = 20;
            }
            n20 = 10;
            this.bound.add(n13, n14);
            float f2 = f = 1.0f / (float)n20;
            while ((double)f2 <= 0.99) {
                int n21 = (int)((float)n6 + (float)n5 * f2);
                int n22 = (int)((float)n10 + (float)n9 * f2);
                float f3 = f2 * f2;
                n21 += (int)((float)n4 * f3);
                n22 += (int)((float)n8 * f3);
                this.bound.add(n21 += (int)((float)n3 * (f3 *= f2)), n22 += (int)((float)n7 * f3));
                f2 += f;
            }
            n11 = n13;
            n13 = n15;
            n15 = n19;
            n12 = n14;
            n14 = n16;
            n16 = n18;
            ++n17;
        }
        this.bound.x -= 10;
        this.bound.y -= 10;
        this.bound.width += 20;
        this.bound.height += 20;
    }

    public void setSelect(boolean bl) {
        int n = 0;
        while (n < this.numpoints) {
            this.selected[n] = bl;
            ++n;
        }
    }

    public void setSelect(boolean bl, Rectangle rectangle) {
        int n = 0;
        while (n < this.numpoints) {
            if (rectangle.contains(this.points[n])) {
                this.selected[n] = bl;
            }
            ++n;
        }
    }

    public void toggleSelect(Rectangle rectangle) {
        int n = 0;
        while (n < this.numpoints) {
            if (rectangle.contains(this.points[n])) {
                this.selected[n] = this.selected[n] ^ true;
            }
            ++n;
        }
    }

    public void unFireFrom() {
        if (this.weight <= 0) {
            return;
        }
        if (this.p.tokens < 0) {
            return;
        }
        this.p.tokens += this.weight;
    }

    public void unFireTo() {
        this.p.tokens -= this.weight;
    }
}

