/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import BDDPack.BDDPetri;
import DaNAMiCS.Petri;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class BDDClient {
    private int port;
    private String location;
    private Socket client;
    private BufferedOutputStream petriOut = null;
    private Petri localPetri;
    private BDDPetri sendPetri;

    public BDDClient(String string, String string2, Petri petri) {
        this.location = string;
        this.port = new Integer(string2);
        this.localPetri = petri;
        this.connectToServer();
    }

    public void connectToServer() {
        try {
            try {
                this.client = new Socket(InetAddress.getByName(this.location), this.port);
                this.petriOut = new BufferedOutputStream(this.client.getOutputStream());
                this.performTransaction();
            }
            catch (IOException iOException) {
                System.out.println("IOException thrown in connect.");
                iOException.printStackTrace();
            }
            Object var2_4 = null;
            System.out.println("Closing");
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            System.out.println("Closing");
            try {
                this.petriOut.close();
                this.client.close();
            }
            catch (IOException iOException) {
                System.out.println("Fatal error in closing network connections.");
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.petriOut.close();
            this.client.close();
        }
        catch (IOException iOException) {
            System.out.println("Fatal error in closing network connections.");
            iOException.printStackTrace();
        }
    }

    public void performTransaction() {
        System.out.println("Printing Local BDDPetri");
        this.sendPetri = new BDDPetri(this.localPetri);
        this.sendPetri.print();
        byte[] byArray = this.sendPetri.toByteArray();
        this.printByteArray(byArray);
        System.out.println("Sending BDDPetri to BDDServer");
        try {
            int n = byArray.length / 4096 + 1;
            int n2 = byArray.length;
            String string = "\\begin{connectionDescription}\\numberOfPackets" + (n + 1) + "\\messageLength" + n2 + "\\end{connectionDescription}";
            this.petriOut.write(string.getBytes(), 0, string.getBytes().length);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (n3 + 4096 >= byArray.length) {
                    this.petriOut.write(byArray, n3, byArray.length);
                } else {
                    this.petriOut.write(byArray, n3, 4096);
                }
                n3 += 4096;
                ++n4;
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to write object");
            iOException.printStackTrace();
        }
    }

    public void printByteArray(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            System.out.print((char)byArray[n]);
            ++n;
        }
        System.out.flush();
    }
}

