/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import BDDPack.BDDPetri;
import DaNAMiCS.BDDUDPPackets;
import DaNAMiCS.BDDUDPReceiver;
import DaNAMiCS.BDDUDPSender;
import DaNAMiCS.Petri;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class BDDClientUDP {
    private int port;
    private String location;
    private Petri localPetri;
    private BDDPetri sendPetri;
    private DatagramSocket sds;
    private DatagramSocket rds;
    private DatagramPacket dp;

    public BDDClientUDP(String string, String string2, Petri petri) {
        this.location = string;
        this.port = new Integer(string2);
        this.localPetri = petri;
        this.connectToServer();
    }

    public void connectToServer() {
        try {
            this.sds = new DatagramSocket();
            this.rds = new DatagramSocket(4017, InetAddress.getLocalHost());
            this.performTransaction();
        }
        catch (IOException iOException) {
            System.out.println("IOException thrown in connect.");
            iOException.printStackTrace();
        }
    }

    public void performTransaction() {
        System.out.println("Printing Local BDDPetri");
        this.sendPetri = new BDDPetri(this.localPetri);
        this.sendPetri.print();
        System.out.println("Sending BDDPetri to C++ BDDServer");
        try {
            byte[] byArray = this.sendPetri.toByteArray();
            this.printByteArray(byArray);
            byte[][] byArray2 = this.splitPackets(byArray);
            System.out.println("PRINTING PACKETS");
            int n = 0;
            while (n < byArray2.length) {
                System.out.println("\n\nPacket: " + new Integer(n) + "\n");
                this.printByteArray(byArray2[n]);
                ++n;
            }
            String string = "\\begin{AllPacketInformation}\\totalPackets" + byArray2.length + "\\totalSize" + byArray.length + "\\end{AllPacketInformation}";
            byte[] byArray3 = string.getBytes();
            BDDUDPPackets bDDUDPPackets = new BDDUDPPackets(byArray3, byArray2, this.sds, this.rds, this.location, this.port);
            new BDDUDPSender(bDDUDPPackets).start();
            new BDDUDPReceiver(bDDUDPPackets).start();
        }
        catch (Exception exception) {
            System.out.println("Unable to send BDDPetri");
            exception.printStackTrace();
        }
    }

    public void printByteArray(byte[] byArray) {
        System.out.println(new String(byArray));
    }

    public byte[][] splitPackets(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = n3 / 2048 + 1;
        int n5 = n4 + 1;
        byte[][] byArray2 = null;
        int[] nArray = null;
        while (n5 > n4) {
            n5 = n3 / 2048 + 1;
            n3 = byArray.length;
            byArray2 = new byte[n5][2048];
            nArray = new int[n5];
            n2 = 0;
            while (n2 < n5) {
                String string = "\\begin{PacketInformation}\\thisPacket" + n2 + "\\end{PacketInformation}";
                byte[] byArray3 = string.getBytes();
                n = 0;
                while (n < byArray3.length) {
                    byArray2[n2][n] = byArray3[n];
                    nArray[n2] = byArray3.length;
                    ++n;
                }
                n3 += byArray3.length;
                ++n2;
            }
            n4 = n5;
            n5 = n3 / 2048 + 1;
        }
        n4 = n5;
        n2 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < nArray.length) {
            n6 += nArray[n7];
            ++n7;
        }
        n = 0;
        while (n < n4) {
            int n8 = 0;
            while (n8 < 2048 - nArray[n]) {
                byArray2[n][n8 + nArray[n]] = byArray[n2];
                if (++n2 >= n3 - n6) {
                    byArray2[n][n8 + 1 + nArray[n]] = 0;
                    return byArray2;
                }
                ++n8;
            }
            ++n;
        }
        return byArray2;
    }
}

