/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.CPetri;
import DaNAMiCS.CPetriUnit;
import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.GridBagExtra;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Subnet;
import DaNAMiCS.TextPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CPlace
extends Place
implements CPetriUnit {
    public static int COLOURS = CPetri.COLOURS;
    int[] tokens = new int[COLOURS];
    int[] initTokens;
    int[] limit;
    PetriUnitList unfoldedPlace = null;
    JTextField PName;
    JTextField CapR;
    JTextField CapG;
    JTextField CapB;
    JTextField TokR;
    JTextField TokG;
    JTextField TokB;
    JCheckBox limR;
    JCheckBox limG;
    JCheckBox limB;
    JCheckBox chkIp;
    JDialog CDialog;

    public CPlace(int n, int n2, String string, int n3, int n4, boolean bl, Subnet subnet) {
        super(n, n2, string, n3, n4, bl, subnet);
        this.initTokens = new int[COLOURS];
        this.limit = new int[COLOURS];
        int n5 = 0;
        while (n5 < COLOURS) {
            this.limit[n5] = -1;
            ++n5;
        }
    }

    public CPlace(int n, int n2, String string, int n3, Subnet subnet) {
        super(n, n2, string, n3, subnet);
        this.initTokens = new int[COLOURS];
        this.limit = new int[COLOURS];
        int n4 = 0;
        while (n4 < COLOURS) {
            this.limit[n4] = -1;
            ++n4;
        }
    }

    public CPlace(int n, int n2, String string, int[] nArray, int[] nArray2, boolean bl, Subnet subnet) {
        super(n, n2, string, 0, -1, bl, subnet);
        this.initTokens = nArray;
        this.limit = nArray2;
        int n3 = 0;
        while (n3 < COLOURS) {
            this.tokens[n3] = this.initTokens[n3];
            ++n3;
        }
    }

    public int[] copyInit() {
        int[] nArray = new int[this.tokens.length];
        int n = 0;
        while (n < this.tokens.length) {
            nArray[n] = this.tokens[n];
            ++n;
        }
        return nArray;
    }

    public int[] copyLim() {
        int[] nArray = new int[this.limit.length];
        int n = 0;
        while (n < this.limit.length) {
            nArray[n] = this.limit[n];
            ++n;
        }
        return nArray;
    }

    public CPlace copyPlace(CPlace cPlace) {
        CPlace cPlace2 = new CPlace(cPlace.x, cPlace.y, cPlace.name, cPlace.copyInit(), cPlace.copyLim(), cPlace.iPs, cPlace.Parent);
        cPlace2.tokens = cPlace.copyInit();
        return cPlace2;
    }

    public PetriUnit deepCopy1() {
        try {
            this.copy = (PetriUnit)this.clone();
            ((CPlace)this.copy).tokens = new int[COLOURS];
            ((CPlace)this.copy).initTokens = new int[COLOURS];
            ((CPlace)this.copy).limit = new int[COLOURS];
            int n = 0;
            while (n < COLOURS) {
                ((CPlace)this.copy).tokens[n] = this.tokens[n];
                ((CPlace)this.copy).initTokens[n] = this.initTokens[n];
                ((CPlace)this.copy).limit[n] = this.limit[n];
                ++n;
            }
            return this.copy;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void dialog() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.CDialog = new JDialog(DFrame.MyFrame, "Coloured Place", true);
        this.CDialog.getContentPane().setLayout(gridBagLayout);
        this.PName = new JTextField(9);
        this.PName.setText(this.name);
        this.CapR = new JTextField(3);
        if (this.limit[0] != -1) {
            this.CapR.setText(String.valueOf(this.limit[0]));
        }
        this.CapG = new JTextField(3);
        if (this.limit[1] != -1) {
            this.CapG.setText(String.valueOf(this.limit[1]));
        }
        this.CapB = new JTextField(3);
        if (this.limit[2] != -1) {
            this.CapB.setText(String.valueOf(this.limit[2]));
        }
        this.TokR = new JTextField(3);
        this.TokR.setText(String.valueOf(this.tokens[0]));
        this.TokG = new JTextField(3);
        this.TokG.setText(String.valueOf(this.tokens[1]));
        this.TokB = new JTextField(3);
        this.TokB.setText(String.valueOf(this.tokens[2]));
        this.limR = new JCheckBox();
        this.limR.setSelected(this.limit[0] != -1);
        this.limG = new JCheckBox();
        this.limG.setSelected(this.limit[1] != -1);
        this.limB = new JCheckBox();
        this.limB.setSelected(this.limit[2] != -1);
        this.chkIp = new JCheckBox("Interaction Pt.");
        this.chkIp.setSelected(this.iPs);
        JLabel jLabel = new JLabel("Place name:");
        JLabel jLabel2 = new JLabel("Tokens");
        JLabel jLabel3 = new JLabel("Capacity");
        JLabel jLabel4 = new JLabel("Limited");
        JLabel jLabel5 = new JLabel("R");
        JLabel jLabel6 = new JLabel("G");
        JLabel jLabel7 = new JLabel("B");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPlace.this.goButtonAction(actionEvent);
            }
        });
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel, gridBagLayout, 0.0, 0.0, 2, 1, -1, -1, 1, 10, new Insets(5, 0, 0, 3));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.PName, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(5, 3, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jPanel, gridBagLayout, 0.0, 0.0, 2, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel5, gridBagLayout, 0.0, 0.0, 1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel6, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel7, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel2, gridBagLayout, 0.0, 0.0, 2, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.TokR, gridBagLayout, 0.0, 0.0, 1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.TokG, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.TokB, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 3, 17, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel3, gridBagLayout, 0.0, 0.0, 2, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.CapR, gridBagLayout, 0.0, 0.0, 1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.CapG, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.CapB, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 3, 17, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel4, gridBagLayout, 0.0, 0.0, 2, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.limR, gridBagLayout, 0.0, 0.0, 1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.limG, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.limB, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.chkIp, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)new TextPosition(this), gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jButton, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        if (this.limit[0] == -1) {
            this.CapR.setEnabled(false);
            this.CapR.setText("");
        }
        this.limR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPlace.this.CapR.setEnabled(CPlace.this.CapR.isEnabled() ^ true);
                CPlace.this.CapR.repaint();
            }
        });
        if (this.limit[1] == -1) {
            this.CapG.setEnabled(false);
            this.CapG.setText("");
        }
        this.limG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPlace.this.CapG.setEnabled(CPlace.this.CapG.isEnabled() ^ true);
                CPlace.this.CapG.repaint();
            }
        });
        if (this.limit[2] == -1) {
            this.CapB.setEnabled(false);
            this.CapB.setText("");
        }
        this.limB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPlace.this.CapB.setEnabled(CPlace.this.CapB.isEnabled() ^ true);
                CPlace.this.CapB.repaint();
            }
        });
        ((Component)this.CDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.CDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.CDialog.getBounds().height / 2);
        ((Component)this.CDialog).setSize(180, 280);
        this.CDialog.show();
    }

    public void goButtonAction(ActionEvent actionEvent) {
        try {
            this.setName(this.PName.getText());
            this.iPs = this.chkIp.isSelected();
            Integer n = new Integer(this.TokR.getText());
            this.tokens[0] = n;
            this.initTokens[0] = n;
            n = new Integer(this.TokG.getText());
            this.tokens[1] = n;
            this.initTokens[1] = n;
            n = new Integer(this.TokB.getText());
            this.tokens[2] = n;
            this.initTokens[2] = n;
            if (!this.CapR.getText().equals("")) {
                n = new Integer(this.CapR.getText());
                this.limit[0] = n;
            } else {
                this.limit[0] = -1;
            }
            if (this.limit[0] < 0) {
                this.limit[0] = -1;
            }
            if (!this.CapG.getText().equals("")) {
                n = new Integer(this.CapG.getText());
                this.limit[1] = n;
            } else {
                this.limit[1] = -1;
            }
            if (this.limit[1] < 0) {
                this.limit[1] = -1;
            }
            if (!this.CapB.getText().equals("")) {
                n = new Integer(this.CapB.getText());
                this.limit[2] = n;
            } else {
                this.limit[2] = -1;
            }
            if (this.limit[2] < 0) {
                this.limit[2] = -1;
            }
            this.CDialog.dispose();
            DFrame.c.bound = this.bound;
            DFrame.c.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane jOptionPane = new JOptionPane("Invalid Number!", 0);
            JDialog jDialog = jOptionPane.createDialog(DFrame.MyFrame, "Error!");
            ((Component)jDialog).setLocation(this.CDialog.getLocation().x, this.CDialog.getLocation().y);
            jDialog.show();
        }
    }

    void paint(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * PetriUnit.scale);
        int n2 = (int)((float)this.y * PetriUnit.scale);
        int n3 = n2 + PetriUnit.four;
        int n4 = n2 - PetriUnit.four;
        int n5 = n + PetriUnit.four;
        int n6 = n - PetriUnit.four;
        if (this.selected) {
            draw.background = PetriUnit.selectedColor;
            draw.edge = PetriUnit.selectedColor;
            draw.circle(n, n2, PetriUnit.ten + PetriUnit.two);
            draw.edge = Color.black;
        }
        draw.edge = this.iPs ? Color.cyan : Color.black;
        draw.background = Color.white;
        draw.circle(n, n2, PetriUnit.ten);
        draw.edge = Color.black;
        graphics.setColor(Color.black);
        draw.background = Color.black;
        switch (this.tokens[0] + this.tokens[1] + this.tokens[2]) {
            case 1: {
                this.setColor(draw, 1);
                draw.circle(n, n2, PetriUnit.two);
                break;
            }
            case 2: {
                this.setColor(draw, 1);
                draw.circle(n5, n2, PetriUnit.two);
                this.setColor(draw, 2);
                draw.circle(n6, n2, PetriUnit.two);
                break;
            }
            case 3: {
                this.setColor(draw, 1);
                draw.circle(n, n4, PetriUnit.two);
                this.setColor(draw, 2);
                draw.circle(n5, n3, PetriUnit.two);
                this.setColor(draw, 3);
                draw.circle(n6, n3, PetriUnit.two);
                break;
            }
            case 4: {
                this.setColor(draw, 1);
                draw.circle(n5, n3, PetriUnit.two);
                this.setColor(draw, 2);
                draw.circle(n5, n4, PetriUnit.two);
                this.setColor(draw, 3);
                draw.circle(n6, n3, PetriUnit.two);
                this.setColor(draw, 4);
                draw.circle(n6, n4, PetriUnit.two);
                break;
            }
            case 5: {
                this.setColor(draw, 1);
                draw.circle(n5, n3, PetriUnit.two);
                this.setColor(draw, 2);
                draw.circle(n5, n4, PetriUnit.two);
                this.setColor(draw, 3);
                draw.circle(n6, n3, PetriUnit.two);
                this.setColor(draw, 4);
                draw.circle(n6, n4, PetriUnit.two);
                this.setColor(draw, 5);
                draw.circle(n, n2, PetriUnit.two);
                break;
            }
            default: {
                int n7;
                int n8;
                int n9;
                String string;
                if ((double)PetriUnit.scale < 0.7) {
                    return;
                }
                graphics.setFont(new Font("Serif", 0, (int)(draw.scale * 8.0f)));
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n10 = fontMetrics.getMaxAdvance();
                int n11 = fontMetrics.getMaxDescent();
                if (this.tokens[0] != 0) {
                    draw.g.setColor(Color.red);
                    string = this.tokens[0] < 100 ? Integer.toString(this.tokens[0]) : "*";
                    n9 = fontMetrics.stringWidth(string);
                    n8 = n - PetriUnit.five - n9 / 2;
                    n7 = n2 - (n11 - n10) / 3 - PetriUnit.five;
                    if (this.tokens[0] > 99) {
                        n7 = n2 - (n11 - n10) / 2;
                    }
                    graphics.drawString(string, n8, n7);
                }
                if (this.tokens[1] != 0) {
                    draw.g.setColor(Color.green);
                    string = this.tokens[1] < 100 ? Integer.toString(this.tokens[1]) : "*";
                    n9 = fontMetrics.stringWidth(string);
                    n8 = n + PetriUnit.five - n9 / 2;
                    n7 = n2 - (n11 - n10) / 3;
                    if (this.tokens[1] > 99) {
                        n7 = n2 - (n11 - n10) / 2;
                    }
                    graphics.drawString(string, n8, n7);
                }
                if (this.tokens[2] != 0) {
                    draw.g.setColor(Color.blue);
                    string = this.tokens[2] < 100 ? Integer.toString(this.tokens[2]) : "*";
                    n9 = fontMetrics.stringWidth(string);
                    n8 = n - PetriUnit.five - n9 / 2;
                    n7 = n2 - (n11 - n10) / 3 + PetriUnit.five;
                    if (this.tokens[2] > 99) {
                        n7 = n2 - (n11 - n10) / 2;
                    }
                    graphics.drawString(string, n8, n7);
                }
                graphics.setFont(new Font("Serif", 0, (int)(draw.scale * 12.0f)));
                draw.g.setColor(Color.black);
            }
            case 0: 
        }
        this.paintName(draw);
    }

    public void resetTokens() {
        int n = 0;
        while (n < COLOURS) {
            this.tokens[n] = this.initTokens[n];
            ++n;
        }
    }

    void setColor(Draw draw, int n) {
        draw.background = n <= this.tokens[0] ? Color.red : (n <= this.tokens[1] + this.tokens[0] ? Color.green : Color.blue);
    }

    public PetriUnitList unfold(PetriUnitList petriUnitList) {
        int n = COLOURS - 1;
        while (n >= 0) {
            petriUnitList = new PetriUnitList(new Place(this.x + 30 * n, this.y + 30 * n, String.valueOf(this.name) + (char)(n + 97), this.initTokens[n], this.limit[n], false, null), petriUnitList);
            --n;
        }
        this.unfoldedPlace = petriUnitList;
        return petriUnitList;
    }
}

