/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.CArc;
import DaNAMiCS.CPetri;
import DaNAMiCS.CPetriUnit;
import DaNAMiCS.CPlace;
import DaNAMiCS.DFrame;
import DaNAMiCS.DisplayMode;
import DaNAMiCS.GridBagExtra;
import DaNAMiCS.Mode;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Subnet;
import DaNAMiCS.TextPosition;
import DaNAMiCS.Transition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

class CTransition
extends Transition
implements CPetriUnit {
    public static int COLOURS = CPetri.COLOURS;
    Mode[] modes = null;
    int numModes = 0;
    int enabledCount = 0;
    int firedMode = 0;
    JPanel HoldPanel;
    JScrollPane ModeScroll;
    JPanel[] MPanel;
    JButton[] killBut;
    JComboBox[][] AIBoxes;
    String[][] AIModeString;
    JComboBox[][] AOBoxes;
    String[][] AOModeString;
    JTextField[] ModeWeights = new JTextField[100];
    JTextField tName;
    JCheckBox checkImm;
    JCheckBox checkVert;
    JCheckBox checkIP;
    JDialog CDialog;
    GridBagExtra geebh;
    GridBagLayout gblh;
    JComboBox ModesBox;
    JDialog FDialog;
    JComponent[] modeString;

    public CTransition(int n, int n2, String string, double d, boolean bl, boolean bl2, boolean bl3, Subnet subnet) {
        super(n, n2, string, d, bl, bl2, bl3, subnet);
    }

    public CTransition(int n, int n2, String string, double d, boolean bl, boolean bl2, boolean bl3, Subnet subnet, int n3, Mode[] modeArray) {
        super(n, n2, string, d, bl, bl2, bl3, subnet);
        this.modes = modeArray;
        this.numModes = n3;
    }

    public CTransition(int n, int n2, String string, boolean bl, Subnet subnet) {
        super(n, n2, string, bl, subnet);
        this.addMode();
        this.addMode();
        this.addMode();
    }

    Arc AddArcIn(Place place, int n, int n2) {
        CArc cArc = new CArc(place, n, this, place, this, n2);
        this.ArcsIn = new PetriUnitList(cArc, this.ArcsIn);
        this.setBound();
        int n3 = 0;
        if (this.ArcsIn != null) {
            n3 += this.ArcsIn.length();
        }
        if (this.ArcsOut != null) {
            n3 += this.ArcsOut.length();
        }
        int n4 = cArc.numModes;
        int n5 = 0;
        while (n5 < this.numModes) {
            this.modes[n5].insertMode(n3, n5 % n4);
            ++n5;
        }
        return cArc;
    }

    Arc AddArcOut(Place place, int n, int n2) {
        CArc cArc = new CArc(this, n, place, place, this, n2);
        this.ArcsOut = new PetriUnitList(cArc, this.ArcsOut);
        this.setBound();
        int n3 = 0;
        if (this.ArcsIn != null) {
            n3 += this.ArcsIn.length();
        }
        if (this.ArcsOut != null) {
            n3 += this.ArcsOut.length();
        }
        int n4 = cArc.numModes;
        int n5 = 0;
        while (n5 < this.numModes) {
            this.modes[n5].insertMode(n3, n5 % n4);
            ++n5;
        }
        return cArc;
    }

    public void addButtAction(ActionEvent actionEvent) {
        this.addMode();
        this.MPanel[this.numModes - 1] = this.setupRow(this.numModes - 1);
        GridBagExtra.addGridBagComponent(this.HoldPanel, (Component)this.MPanel[this.numModes - 1], this.gblh, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(0, 0, 0, 0));
        this.reDrawPanel();
        this.HoldPanel.repaint();
        this.HoldPanel.validate();
        this.ModeScroll.validate();
        this.ModeScroll.getViewport().setView(this.HoldPanel);
        this.ModeScroll.setPreferredSize(new Dimension(300, 100));
        this.ModeScroll.repaint();
        this.CDialog.validate();
    }

    public void addMode() {
        if (this.modes == null) {
            this.modes = new Mode[10];
            this.numModes = 0;
        } else if (this.modes.length >= this.numModes) {
            Mode[] modeArray = this.modes;
            this.modes = new Mode[this.modes.length + 10];
            int n = 0;
            while (n < this.numModes) {
                this.modes[n] = modeArray[n];
                ++n;
            }
        }
        int n = 0;
        if (this.ArcsIn != null) {
            n += this.ArcsIn.length();
        }
        if (this.ArcsOut != null) {
            n += this.ArcsOut.length();
        }
        this.modes[this.numModes] = new Mode(n);
        ++this.numModes;
    }

    public Mode[] copyMod() {
        Mode[] modeArray = new Mode[this.modes.length];
        int n = 0;
        while (n < this.modes.length) {
            if (this.modes[n] != null) {
                modeArray[n] = new Mode(this.modes[n].modes.length);
                int n2 = 0;
                while (n2 < this.modes[n].modes.length) {
                    modeArray[n].modes[n2] = this.modes[n].modes[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return modeArray;
    }

    public CTransition copyTransition(CTransition cTransition) {
        return new CTransition(cTransition.x, cTransition.y, cTransition.name, cTransition.Rate, cTransition.Type, cTransition.Orientation, cTransition.iPs, cTransition.Parent, cTransition.numModes, cTransition.copyMod());
    }

    public PetriUnit deepCopy1() {
        try {
            this.copy = (PetriUnit)this.clone();
            ((CTransition)this.copy).modes = new Mode[this.numModes];
            int n = 0;
            while (n < this.modes.length) {
                ((CTransition)this.copy).modes[n] = new Mode(this.modes[n].modes.length);
                int n2 = 0;
                while (n2 < ((CTransition)this.copy).modes[n].modes.length) {
                    ((CTransition)this.copy).modes[n].modes[n2] = this.modes[n].modes[n2];
                    ++n2;
                }
                ++n;
            }
            return this.copy;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void destroyThisPanel(ActionEvent actionEvent) {
        if (this.numModes > 1) {
            int n = new Integer(actionEvent.getActionCommand());
            this.removeMode(n);
            this.shrinkAll(n);
            this.resetAll();
            this.reDrawPanel();
        }
    }

    public void dialog() {
        this.MPanel = new JPanel[100];
        this.killBut = new JButton[100];
        if (this.ArcsIn != null) {
            this.AIBoxes = new JComboBox[100][this.ArcsIn.length()];
            this.AIModeString = new String[this.ArcsIn.length()][100];
        } else {
            this.AIBoxes = new JComboBox[100][0];
            this.AIModeString = new String[0][100];
        }
        if (this.ArcsOut != null) {
            this.AOBoxes = new JComboBox[100][this.ArcsOut.length()];
            this.AOModeString = new String[this.ArcsOut.length()][100];
        } else {
            this.AOBoxes = new JComboBox[100][0];
            this.AOModeString = new String[0][100];
        }
        this.HoldPanel = new JPanel();
        this.gblh = new GridBagLayout();
        this.geebh = new GridBagExtra();
        this.HoldPanel.setLayout(this.gblh);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.CDialog = new JDialog(DFrame.MyFrame, "Coloured Transition", true);
        this.CDialog.getContentPane().setLayout(gridBagLayout);
        this.setupStrings();
        int n = 0;
        while (n < this.numModes) {
            this.MPanel[n] = this.setupRow(n);
            GridBagExtra.addGridBagComponent(this.HoldPanel, (Component)this.MPanel[n], this.gblh, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(0, 0, 0, 0));
            ++n;
        }
        this.ModeScroll = new JScrollPane(this.HoldPanel);
        this.ModeScroll.setPreferredSize(new Dimension(300, 100));
        JButton jButton = new JButton("Add Mode");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CTransition.this.addButtAction(actionEvent);
            }
        });
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CTransition.this.okButAction(actionEvent);
            }
        });
        this.tName = new JTextField(15);
        this.tName.setText(this.name);
        JLabel jLabel = new JLabel("Transition name:");
        this.checkImm = new JCheckBox("Immediate", this.Type);
        this.checkVert = new JCheckBox("Vertical", this.Orientation);
        this.checkIP = new JCheckBox("Interaction Pt.", this.iPs);
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jLabel, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.tName, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 5, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.checkImm, gridBagLayout, 0.0, 0.0, 1, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.checkVert, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 5, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.checkIP, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 5, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)this.ModeScroll, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jButton, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)new TextPosition(this), gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.CDialog.getContentPane(), (Component)jButton2, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        ((Component)this.CDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.CDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.CDialog.getBounds().height / 2);
        ((Component)this.CDialog).setSize(360, 320);
        this.CDialog.setResizable(false);
        this.CDialog.show();
    }

    public void fire() {
        if (this.enabledCount <= 0) {
            return;
        }
        if (this.enabledCount == 1) {
            int n = 0;
            while (n < this.numModes) {
                if (this.modes[n].enabled) {
                    this.fire(n);
                    return;
                }
                ++n;
            }
        }
        this.fireDialog();
    }

    public void fire(int n) {
        this.firedMode = n;
        int n2 = 0;
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            ((CArc)petriUnitList.p).fireFrom(this.modes[n].modes[n2]);
            petriUnitList = petriUnitList.next;
            ++n2;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            ((CArc)petriUnitList.p).fireTo(this.modes[n].modes[n2]);
            petriUnitList = petriUnitList.next;
            ++n2;
        }
    }

    public void fireDialog() {
        this.FDialog = new JDialog(DFrame.MyFrame, "Fire Mode", true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.FDialog.getContentPane().setLayout(gridBagLayout);
        this.getModes();
        this.ModesBox = new JComboBox<JComponent>(this.modeString);
        this.ModesBox.setSelectedIndex(0);
        this.ModesBox.setPreferredSize(new Dimension(200, 30));
        JButton jButton = new JButton("Fire");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CTransition.this.gofButAction(actionEvent);
            }
        });
        GridBagExtra.addGridBagComponent(this.FDialog.getContentPane(), (Component)this.ModesBox, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        GridBagExtra.addGridBagComponent(this.FDialog.getContentPane(), (Component)jButton, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(2, 0, 0, 0));
        ((Component)this.FDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.FDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.FDialog.getBounds().height / 2);
        ((Component)this.FDialog).setSize(250, 200);
        this.FDialog.setResizable(true);
        this.ModesBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object == null) {
                    return new JLabel("<default>");
                }
                return (DisplayMode)object;
            }
        });
        this.FDialog.show();
    }

    public void getModes() {
        this.modeString = new DisplayMode[this.enabledCount];
        int n = 0;
        int n2 = 0;
        while (n < this.numModes) {
            if (this.modes[n].enabled) {
                this.modeString[n2] = new DisplayMode(this.modes[n], n);
                ++n2;
            }
            ++n;
        }
        DisplayMode.arcsInLength = this.ArcsIn.length();
        DisplayMode.t = this;
    }

    public String getThisMode(int n) {
        String string = new String();
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            string = string.concat(String.valueOf(((CArc)petriUnitList.p).p.name) + " (" + ((CArc)petriUnitList.p).modes[n][0] + " " + ((CArc)petriUnitList.p).modes[n][1] + " " + ((CArc)petriUnitList.p).modes[n][2] + ") ");
            petriUnitList = petriUnitList.next;
        }
        string = string.concat("  >>  ");
        PetriUnitList petriUnitList2 = this.ArcsOut;
        while (petriUnitList2 != null) {
            string = string.concat("(" + ((CArc)petriUnitList2.p).modes[n][0] + " " + ((CArc)petriUnitList2.p).modes[n][1] + " " + ((CArc)petriUnitList2.p).modes[n][2] + ") ");
            petriUnitList2 = petriUnitList2.next;
        }
        return string;
    }

    public void gofButAction(ActionEvent actionEvent) {
        this.fire(((DisplayMode)this.ModesBox.getItemAt((int)this.ModesBox.getSelectedIndex())).pos);
        this.FDialog.dispose();
    }

    public boolean isEnabled(int n) {
        return this.modes[n].enabled;
    }

    public void okButAction(ActionEvent actionEvent) {
        this.name = this.tName.getText();
        this.Orientation = this.checkVert.isSelected();
        this.Type = this.checkImm.isSelected();
        this.iPs = this.checkIP.isSelected();
        int n = 0;
        if (this.ArcsIn != null) {
            n += this.ArcsIn.length();
        }
        int n2 = 0;
        if (this.ArcsOut != null) {
            n2 += this.ArcsOut.length();
        }
        int n3 = n + n2;
        int n4 = 0;
        while (n4 < this.numModes) {
            int n5 = 0;
            while (n5 < n3) {
                this.modes[n4].modes[n5] = n5 < n ? this.AIBoxes[n4][n5].getSelectedIndex() : this.AOBoxes[n4][n5 - n].getSelectedIndex();
                ++n5;
            }
            try {
                this.modes[n4].rate = new Double(this.ModeWeights[n4].getText());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            ++n4;
        }
        this.CDialog.dispose();
        DFrame.c.bound = this.bound;
        DFrame.c.repaint();
    }

    public void reDrawPanel() {
        this.HoldPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.HoldPanel.setLayout(gridBagLayout);
        int n = 0;
        while (n < this.numModes) {
            if (this.MPanel[n] != null) {
                GridBagExtra.addGridBagComponent(this.HoldPanel, (Component)this.MPanel[n], gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 1, 10, new Insets(0, 0, 0, 0));
            }
            ++n;
        }
        this.HoldPanel.repaint();
        this.ModeScroll.setPreferredSize(new Dimension(300, 100));
        this.ModeScroll.getViewport().setView(this.HoldPanel);
        this.ModeScroll.repaint();
        this.CDialog.validate();
    }

    public void removeMode(int n) {
        --this.numModes;
        int n2 = n;
        while (n2 < this.numModes) {
            this.modes[n2] = this.modes[n2 + 1];
            ++n2;
        }
    }

    public void resetAll() {
        int n = 0;
        while (n < this.numModes) {
            this.killBut[n].setActionCommand(new Integer(n).toString());
            ++n;
        }
    }

    public void setEnabled() {
        this.enabledCount = 0;
        int n = 0;
        while (n < this.numModes) {
            this.enabledCount += this.modes[n].setEnabled(this);
            ++n;
        }
        this.Enabled = this.enabledCount > 0;
    }

    public JPanel setupRow(int n) {
        JComponent jComponent;
        JLabel jLabel;
        int n2 = 0;
        int n3 = 1;
        if (this.ArcsIn != null) {
            n3 += this.ArcsIn.length() * 2;
        }
        if (this.ArcsOut != null) {
            n3 += this.ArcsOut.length() * 2;
        }
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        jPanel.setLayout(gridBagLayout);
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            this.AIBoxes[n][n2] = new JComboBox<String>(this.AIModeString[n2]);
            this.AIBoxes[n][n2].setPreferredSize(new Dimension(60, 20));
            this.AIBoxes[n][n2].setSelectedIndex(this.modes[n].modes[n2]);
            jLabel = new JLabel(((CArc)petriUnitList.p).p.name);
            GridBagExtra.addGridBagComponent(jPanel, (Component)jLabel, gridBagLayout, 0.0, 0.0, n3, 1, -1, -1, 1, 10, new Insets(2, 1, 0, 0));
            GridBagExtra.addGridBagComponent(jPanel, (Component)this.AIBoxes[n][n2], gridBagLayout, 0.0, 0.0, n3 - 1, 1, -1, -1, 1, 10, new Insets(2, 1, 0, 0));
            n3 -= 2;
            ++n2;
            petriUnitList = petriUnitList.next;
        }
        jLabel = new JLabel(new ImageIcon("Images/arrbut.gif"));
        GridBagExtra.addGridBagComponent(jPanel, (Component)jLabel, gridBagLayout, 0.0, 0.0, n3 - n2, 1, -1, -1, 1, 10, new Insets(2, 3, 0, 3));
        n2 = 0;
        --n3;
        int n4 = 0;
        if (this.ArcsIn != null) {
            n4 += this.ArcsIn.length();
        }
        PetriUnitList petriUnitList2 = this.ArcsOut;
        while (petriUnitList2 != null) {
            this.AOBoxes[n][n2] = new JComboBox<String>(this.AOModeString[n2]);
            this.AOBoxes[n][n2].setPreferredSize(new Dimension(60, 20));
            this.AOBoxes[n][n2].setSelectedIndex(this.modes[n].modes[n2 + n4]);
            jComponent = new JLabel(((CArc)petriUnitList2.p).p.name);
            GridBagExtra.addGridBagComponent(jPanel, (Component)jComponent, gridBagLayout, 0.0, 0.0, n3, 1, -1, -1, 1, 10, new Insets(2, 1, 0, 0));
            GridBagExtra.addGridBagComponent(jPanel, (Component)this.AOBoxes[n][n2], gridBagLayout, 0.0, 0.0, n3 - 1, 1, -1, -1, 1, 10, new Insets(2, 1, 0, 0));
            n3 -= 2;
            ++n2;
            petriUnitList2 = petriUnitList2.next;
        }
        this.ModeWeights[n] = new JTextField(3);
        this.ModeWeights[n].setToolTipText("Set this modes firing weight");
        this.ModeWeights[n].setText(String.valueOf(this.modes[n].rate));
        jComponent = new JButton(new ImageIcon("Images/kbut.gif"));
        jComponent.setActionCommand(new Integer(n).toString());
        jComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CTransition.this.destroyThisPanel(actionEvent);
            }
        });
        jComponent.setPreferredSize(new Dimension(15, 15));
        this.killBut[n] = jComponent;
        GridBagExtra.addGridBagComponent(jPanel, (Component)this.ModeWeights[n], gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 1, 10, new Insets(2, 1, 0, 0));
        GridBagExtra.addGridBagComponent(jPanel, (Component)jComponent, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 0, 10, new Insets(2, 1, 0, 0));
        return jPanel;
    }

    public void setupStrings() {
        int n = 0;
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            int n2 = 0;
            while (n2 < ((CArc)petriUnitList.p).numModes) {
                this.AIModeString[n][n2] = new String(String.valueOf(((CArc)petriUnitList.p).modes[n2][0]) + " " + ((CArc)petriUnitList.p).modes[n2][1] + " " + ((CArc)petriUnitList.p).modes[n2][2]);
                ++n2;
            }
            ++n;
            petriUnitList = petriUnitList.next;
        }
        n = 0;
        PetriUnitList petriUnitList2 = this.ArcsOut;
        while (petriUnitList2 != null) {
            int n3 = 0;
            while (n3 < ((CArc)petriUnitList2.p).numModes) {
                this.AOModeString[n][n3] = new String(String.valueOf(((CArc)petriUnitList2.p).modes[n3][0]) + " " + ((CArc)petriUnitList2.p).modes[n3][1] + " " + ((CArc)petriUnitList2.p).modes[n3][2]);
                ++n3;
            }
            ++n;
            petriUnitList2 = petriUnitList2.next;
        }
    }

    public void shrinkAll(int n) {
        int n2 = n;
        while (n2 < this.numModes + 1) {
            this.MPanel[n2] = this.MPanel[n2 + 1];
            this.AIBoxes[n2] = this.AIBoxes[n2 + 1];
            this.AOBoxes[n2] = this.AOBoxes[n2 + 1];
            this.killBut[n2] = this.killBut[n2 + 1];
            ++n2;
        }
    }

    public void unFire() {
        this.unFire(DFrame.c.FiredTransitions.extra);
    }

    public void unFire(int n) {
        int n2 = 0;
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            ((CArc)petriUnitList.p).unFireFrom(this.modes[n].modes[n2]);
            petriUnitList = petriUnitList.next;
            ++n2;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            ((CArc)petriUnitList.p).unFireTo(this.modes[n].modes[n2]);
            petriUnitList = petriUnitList.next;
            ++n2;
        }
    }

    public PetriUnitList unfold(PetriUnitList petriUnitList) {
        int n = 0;
        while (n < this.numModes) {
            int n2;
            Place place;
            int n3;
            PetriUnitList petriUnitList2;
            Transition transition = new Transition(this.x + 30 * n, this.y + 30 * n, String.valueOf(this.name) + (char)(n + 97), this.modes[n].rate, this.Type, this.Orientation, false, null);
            int n4 = 0;
            PetriUnitList petriUnitList3 = null;
            petriUnitList3 = this.ArcsIn;
            while (petriUnitList3 != null) {
                petriUnitList2 = ((CPlace)((CArc)petriUnitList3.p).p).unfoldedPlace;
                n3 = 0;
                while (n3 < COLOURS) {
                    place = (Place)petriUnitList2.p;
                    n2 = ((CArc)petriUnitList3.p).modes[this.modes[n].modes[n4]][n3];
                    if (n2 != 0) {
                        transition.AddArcIn(place, n2, ((CArc)petriUnitList3.p).type);
                    }
                    ++n3;
                    petriUnitList2 = petriUnitList2.next;
                }
                petriUnitList3 = petriUnitList3.next;
                ++n4;
            }
            petriUnitList3 = this.ArcsOut;
            while (petriUnitList3 != null) {
                petriUnitList2 = ((CPlace)((CArc)petriUnitList3.p).p).unfoldedPlace;
                n3 = 0;
                while (n3 < COLOURS) {
                    place = (Place)petriUnitList2.p;
                    n2 = ((CArc)petriUnitList3.p).modes[this.modes[n].modes[n4]][n3];
                    if (n2 != 0) {
                        transition.AddArcOut(place, n2, ((CArc)petriUnitList3.p).type);
                    }
                    ++n3;
                    petriUnitList2 = petriUnitList2.next;
                }
                petriUnitList3 = petriUnitList3.next;
                ++n4;
            }
            petriUnitList = new PetriUnitList(transition, petriUnitList);
            ++n;
        }
        return petriUnitList;
    }
}

