/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.Graph;
import DaNAMiCS.Marking;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Transition;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextArea;

public class Cover {
    Petri p;
    PetriUnitList marks;
    PetriUnitList trans;
    Marking InitialMarking;
    boolean[] FinalEnabledTransitions;
    PetriUnitList[] UnboundedSequence;
    boolean[] possUnboundedPlaces;
    Graph G;
    int numplaces;
    int numtrans;
    boolean inhibitors = false;
    boolean deadlocked;
    boolean bounded;
    boolean[] inhibPlaces;
    boolean hasNoInhib = true;
    boolean hasNoImed = true;
    boolean[] limitedPlaces;
    PetriUnitList deadTranses = null;
    int critDepth = 0;
    int[] remember = null;

    public Cover(Petri petri) {
        Object object;
        this.p = petri;
        this.deadlocked = false;
        this.bounded = true;
        this.marks = null;
        this.numplaces = 0;
        this.numtrans = 0;
        PetriUnitList petriUnitList = this.p.Places;
        while (petriUnitList != null) {
            this.marks = new PetriUnitList(petriUnitList.p, this.marks);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.marks = this.p.getAllSubPlaces(this.marks);
        while (petriUnitList != null) {
            ++this.numplaces;
            petriUnitList = petriUnitList.next;
        }
        this.inhibPlaces = new boolean[this.numplaces];
        this.limitedPlaces = new boolean[this.numplaces];
        this.critDepth = this.numplaces * 50;
        int n = 0;
        petriUnitList = this.marks;
        while (petriUnitList != null) {
            object = (Place)petriUnitList.p;
            PetriUnitList petriUnitList2 = ((Place)object).arcs;
            while (petriUnitList2 != null) {
                if (((Arc)petriUnitList2.p).weight == -1) {
                    this.inhibPlaces[n] = true;
                    this.hasNoInhib = false;
                    break;
                }
                petriUnitList2 = petriUnitList2.next;
            }
            if (((Place)petriUnitList.p).limit != -1) {
                this.limitedPlaces[n] = true;
            }
            petriUnitList = petriUnitList.next;
            ++n;
        }
        petriUnitList = this.p.Transitions;
        while (petriUnitList != null) {
            this.trans = new PetriUnitList(petriUnitList.p, this.trans);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.trans = this.p.getAllSubTrans(this.trans);
        while (petriUnitList != null) {
            if (((Transition)petriUnitList.p).Type) {
                this.hasNoImed = false;
            }
            object = ((Transition)petriUnitList.p).ArcsIn;
            while (object != null) {
                if (((Arc)((PetriUnitList)object).p).weight == -1) {
                    this.inhibitors = true;
                }
                object = ((PetriUnitList)object).next;
            }
            object = ((Transition)petriUnitList.p).ArcsOut;
            while (object != null) {
                if (((Arc)((PetriUnitList)object).p).weight == -1) {
                    this.inhibitors = true;
                }
                object = ((PetriUnitList)object).next;
            }
            ++this.numtrans;
            petriUnitList = petriUnitList.next;
        }
        this.FinalEnabledTransitions = new boolean[this.numtrans];
        int n2 = 0;
        while (n2 < this.numtrans) {
            this.FinalEnabledTransitions[n2] = false;
            ++n2;
        }
        this.hasNoInhib = this.inhibitors ^ true;
        this.remember = new int[this.numplaces];
        this.UnboundedSequence = new PetriUnitList[this.numplaces];
        this.possUnboundedPlaces = new boolean[this.numplaces];
        int n3 = 0;
        while (n3 < this.UnboundedSequence.length) {
            this.UnboundedSequence[n3] = null;
            this.possUnboundedPlaces[n3] = false;
            ++n3;
        }
    }

    public boolean canBeCovered(Marking marking, Marking marking2) {
        int n = 0;
        while (n < marking.n.length) {
            if (marking.n[n] < marking2.n[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkLimited(Marking marking, Marking marking2) {
        int n = 0;
        while (n < marking.n.length) {
            if (this.limitedPlaces[n] && marking.n[n] != marking2.n[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public PetriUnitList constructCover() {
        try {
            return this.constructCoverHelper();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.G = null;
            System.gc();
            return null;
        }
    }

    public PetriUnitList constructCoverHelper() {
        int n = 0;
        this.InitialMarking = new Marking();
        this.InitialMarking.set(this.numplaces, this.marks, this.p, null, null);
        this.InitialMarking.setUniqueNumber(1);
        this.G = new Graph(this.InitialMarking, this);
        Marking marking = new Marking();
        Marking marking2 = this.InitialMarking;
        while (marking2 != null) {
            Marking marking3;
            marking2.setMarking(this.marks);
            PetriUnitList petriUnitList = this.p.retrieveEnabled(this.trans);
            if (petriUnitList == null) {
                this.deadlocked = true;
                this.deadTranses = null;
                marking3 = marking2;
                while (marking3.inFromTrans != null) {
                    this.deadTranses = new PetriUnitList(marking3.inFromTrans, this.deadTranses);
                    marking3 = marking3.Father;
                }
            }
            while (petriUnitList != null) {
                marking2.setMarking(this.marks);
                ((Transition)petriUnitList.p).fire();
                marking.set(this.numplaces, this.marks, this.p, marking2, (Transition)petriUnitList.p);
                marking3 = (Marking)this.G.MarkingsIn.get(marking.toString());
                ++n;
                if (marking3 == null) {
                    this.G.addVertex(marking);
                }
                Marking marking4 = marking.Father;
                while (marking4 != null) {
                    if (marking.Vanishing == marking4.Vanishing && this.canBeCovered(marking, marking4) && (this.hasNoImed || this.noLatentImmediateTransitions(marking, marking4)) && (this.hasNoInhib || this.diffInhibPlaces(marking, marking4))) {
                        int n2 = 0;
                        while (n2 < marking.n.length) {
                            if (this.checkLimited(marking, marking4) && marking.n[n2] > marking4.n[n2]) {
                                if (marking.possiblyUnbounded) {
                                    marking.n[n2] = -2;
                                    this.possUnboundedPlaces[n2] = true;
                                } else {
                                    marking.n[n2] = -1;
                                    this.setRecurringSequence(n2, marking, marking4);
                                }
                                this.bounded = false;
                                ++n;
                                marking3 = (Marking)this.G.MarkingsIn.get(marking.toString());
                                if (marking3 == null) {
                                    this.G.addVertex(marking);
                                }
                            }
                            ++n2;
                        }
                    }
                    marking4 = marking4.Father;
                }
                if (this.G.M == marking) {
                    marking3 = marking;
                    marking = new Marking();
                }
                marking2.addArc(marking3, (Transition)petriUnitList.p);
                ((Transition)petriUnitList.p).unFire();
                petriUnitList = petriUnitList.next;
            }
            marking2 = marking2.next;
        }
        this.InitialMarking.setMarking(this.marks);
        System.out.println("Unique Markings: " + (this.G.numMarkings - 1));
        System.out.println(" - End Of Graph Construction - ");
        this.G.numFirings = n;
        return this.deadTranses;
    }

    public boolean diffInhibPlaces(Marking marking, Marking marking2) {
        if (this.diffInhibPlacesHelper(marking, marking2)) {
            return true;
        }
        if (marking.depth > this.critDepth) {
            marking.possiblyUnbounded = true;
            return true;
        }
        return false;
    }

    public boolean diffInhibPlacesHelper(Marking marking, Marking marking2) {
        int n = 0;
        while (n < this.numplaces) {
            if (this.inhibPlaces[n] && marking.n[n] != marking2.n[n]) {
                Marking marking3 = marking.Father;
                while (marking3 != marking2) {
                    if (marking3.n[n] == 0) {
                        return false;
                    }
                    marking3 = marking3.Father;
                }
                if (marking3.n[n] == 0) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public boolean doFinal() {
        System.out.println("Final Components Detection");
        if (this.G == null) {
            return false;
        }
        this.G.checkIntegrity();
        System.out.println("After Integrity Check");
        this.G.detectFinalComponents();
        this.G.printFinal();
        System.out.println("Performing Liveness Check...");
        boolean bl = this.finalEnabled();
        System.out.println("All done!");
        return bl;
    }

    public void doStrongComponents() {
        System.out.println("Strong Components..........");
        if (this.G != null) {
            this.G.strongComponents();
        }
        System.out.println("End of Strong Components...");
    }

    public boolean finalEnabled() {
        boolean bl = true;
        int n = 0;
        while (n < this.G.totalComponents) {
            if (this.G.finalComponents[n]) {
                int n2;
                Marking marking = this.G.first;
                while (marking != null) {
                    if (marking.componentMemberNumber == n) {
                        Transition transition;
                        marking.setMarking(this.marks);
                        PetriUnitList petriUnitList = this.trans;
                        n2 = 0;
                        boolean bl2 = false;
                        while (petriUnitList != null) {
                            transition = (Transition)petriUnitList.p;
                            transition.setEnabled();
                            if (transition.isEnabled() && transition.Type) {
                                bl2 = true;
                            }
                            petriUnitList = petriUnitList.next;
                        }
                        petriUnitList = this.trans;
                        while (petriUnitList != null) {
                            transition = (Transition)petriUnitList.p;
                            if (bl2) {
                                if (!transition.Type) {
                                    transition.Enabled = false;
                                } else if (transition.isEnabled()) {
                                    this.FinalEnabledTransitions[n2] = true;
                                }
                            } else if (transition.isEnabled()) {
                                this.FinalEnabledTransitions[n2] = true;
                            }
                            ++n2;
                            petriUnitList = petriUnitList.next;
                        }
                    }
                    marking = marking.next;
                }
                boolean bl3 = true;
                n2 = 0;
                while (n2 < this.numtrans) {
                    if (!this.FinalEnabledTransitions[n2]) {
                        bl3 = false;
                        bl = false;
                    }
                    ++n2;
                }
                if (!bl3) {
                    System.out.println("Final Component " + n + " is not live.");
                } else {
                    System.out.println("Final Component " + n + " is live.");
                }
            }
            ++n;
        }
        return bl;
    }

    public PetriUnitList getEnabledInComponent(int n) {
        PetriUnitList petriUnitList = null;
        Marking marking = this.G.first;
        while (marking != null) {
            if (marking.componentMemberNumber == n) {
                Transition transition;
                marking.setMarking(this.marks);
                PetriUnitList petriUnitList2 = this.trans;
                boolean bl = false;
                while (petriUnitList2 != null) {
                    transition = (Transition)petriUnitList2.p;
                    transition.setEnabled();
                    if (transition.isEnabled() && transition.Type) {
                        bl = true;
                    }
                    petriUnitList2 = petriUnitList2.next;
                }
                petriUnitList2 = this.trans;
                while (petriUnitList2 != null) {
                    transition = (Transition)petriUnitList2.p;
                    if (bl) {
                        if (!transition.Type) {
                            transition.Enabled = false;
                            transition.chosen = false;
                        } else if (transition.isEnabled()) {
                            transition.chosen = true;
                            petriUnitList = new PetriUnitList(transition, petriUnitList);
                        }
                    } else if (transition.isEnabled()) {
                        transition.chosen = true;
                        petriUnitList = new PetriUnitList(transition, petriUnitList);
                    } else {
                        transition.chosen = false;
                    }
                    petriUnitList2 = petriUnitList2.next;
                }
            }
            marking = marking.next;
        }
        return petriUnitList;
    }

    public PetriUnitList getPossiblyUnbounded() {
        PetriUnitList petriUnitList = null;
        PetriUnitList petriUnitList2 = this.marks;
        int n = 0;
        while (n < this.numplaces) {
            if (this.possUnboundedPlaces[n]) {
                petriUnitList = new PetriUnitList((Place)petriUnitList2.p, petriUnitList);
            }
            ++n;
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    public PetriUnitList getUnbounded() {
        PetriUnitList petriUnitList = null;
        PetriUnitList petriUnitList2 = this.marks;
        int n = 0;
        while (petriUnitList2 != null) {
            if (this.UnboundedSequence[n] != null) {
                petriUnitList = new PetriUnitList((Place)petriUnitList2.p, petriUnitList);
            }
            ++n;
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    public Vector insertUnique(Vector vector, Marking marking) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            if (marking.same((Marking)vector.elementAt(n))) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            vector.addElement(marking);
        }
        return vector;
    }

    public boolean noLatentImmediateTransitions(Marking marking, Marking marking2) {
        if (marking.Vanishing) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.numplaces) {
            this.remember[n] = marking.n[n];
            if (marking.n[n] > marking2.n[n]) {
                marking.n[n] = -1;
                if (!this.limitedPlaces[n]) {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < this.numplaces) {
                marking.n[n2] = this.remember[n2];
                ++n2;
            }
            return true;
        }
        marking.setMarking(this.marks);
        PetriUnitList petriUnitList = this.p.Transitions;
        while (petriUnitList != null) {
            ((Transition)petriUnitList.p).setEnabled();
            if (((Transition)petriUnitList.p).isEnabled() && ((Transition)petriUnitList.p).Type) {
                int n3 = 0;
                while (n3 < this.numplaces) {
                    marking.n[n3] = this.remember[n3];
                    ++n3;
                }
                return false;
            }
            petriUnitList = petriUnitList.next;
        }
        int n4 = 0;
        while (n4 < this.numplaces) {
            marking.n[n4] = this.remember[n4];
            ++n4;
        }
        return true;
    }

    public void performPersistent(JTextArea jTextArea) {
        Marking marking = this.G.first;
        PetriUnitList petriUnitList = null;
        PetriUnitList petriUnitList2 = null;
        boolean bl = true;
        while (marking != null) {
            marking.setMarking(this.marks);
            PetriUnitList petriUnitList3 = petriUnitList = this.p.retrieveEnabled(this.trans);
            while (petriUnitList3 != null) {
                marking.setMarking(this.marks);
                ((Transition)petriUnitList3.p).fire();
                petriUnitList2 = this.p.retrieveEnabled(this.trans);
                if (!petriUnitList.equalForPers(petriUnitList, petriUnitList2, petriUnitList3.p)) {
                    if (bl) {
                        jTextArea.append("The net is not persistent,");
                        bl = false;
                    }
                    jTextArea.append("\nIn marking ");
                    marking.printShort(jTextArea);
                    jTextArea.append(", firing ");
                    String[] stringArray = petriUnitList3.p.getHeritage();
                    String string = new String();
                    int n = 0;
                    while (n < stringArray.length) {
                        string = string.concat(stringArray[n]);
                        if (n != stringArray.length - 1) {
                            string = string.concat("::");
                        }
                        ++n;
                    }
                    jTextArea.append(string);
                    jTextArea.append(" disables:\n");
                    PetriUnitList petriUnitList4 = petriUnitList.notIn(petriUnitList, petriUnitList2, petriUnitList3.p);
                    while (petriUnitList4 != null) {
                        stringArray = petriUnitList4.p.getHeritage();
                        string = new String();
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            string = string.concat(stringArray[n2]);
                            if (n2 != stringArray.length - 1) {
                                string = string.concat("::");
                            }
                            ++n2;
                        }
                        jTextArea.append(string);
                        if (petriUnitList4.next != null) {
                            jTextArea.append("; ");
                        }
                        petriUnitList4 = petriUnitList4.next;
                    }
                }
                petriUnitList3 = petriUnitList3.next;
            }
            marking = marking.next;
        }
        if (bl) {
            jTextArea.append("The net is Persistent.");
        }
    }

    public void performSafeness(JTextArea jTextArea) {
        Marking marking = this.G.first;
        while (marking != null) {
            int n = 0;
            while (n < marking.n.length) {
                if (marking.n[n] > 1 || marking.n[n] < 0) {
                    jTextArea.append("The net is not Safe.\n");
                    return;
                }
                ++n;
            }
            marking = marking.next;
        }
        jTextArea.append("The net is Safe.\n");
    }

    public void printCover(JTextArea jTextArea) {
        Object object;
        int n = 0;
        Marking marking = this.G.first;
        while (marking != null) {
            ++n;
            jTextArea.append("[" + marking.componentMemberNumber + "]{");
            int n2 = 0;
            while (n2 < marking.n.length) {
                jTextArea.append(String.valueOf(marking.n[n2]));
                if (n2 != marking.n.length - 1) {
                    jTextArea.append(",");
                }
                ++n2;
            }
            jTextArea.append("} ");
            object = marking.arcList;
            while (object != null) {
                jTextArea.append("[" + object.m.componentMemberNumber + "]{");
                int n3 = 0;
                while (n3 < object.m.n.length) {
                    jTextArea.append(String.valueOf(object.m.n[n3]));
                    if (n3 != object.m.n.length - 1) {
                        jTextArea.append(",");
                    }
                    ++n3;
                }
                jTextArea.append("} ");
                object = object.next;
            }
            jTextArea.append("\n");
            marking = marking.next;
        }
        jTextArea.append("Number of nodes in the coverability graph: " + n + "\n");
        PetriUnitList petriUnitList = this.marks;
        jTextArea.append("Ordering:\n");
        while (petriUnitList != null) {
            object = petriUnitList.p.getHeritage();
            String string = new String();
            int n4 = 0;
            while (n4 < ((String[])object).length) {
                string = string.concat(object[n4]);
                if (n4 != ((String[])object).length - 1) {
                    string = string.concat("::");
                }
                ++n4;
            }
            if (petriUnitList.next != null) {
                jTextArea.append(String.valueOf(string) + "; ");
            } else {
                jTextArea.append(string);
            }
            petriUnitList = petriUnitList.next;
        }
    }

    public void resetInitial() {
        this.InitialMarking.setMarking(this.marks);
    }

    public void saveCoverabilityGraphToFile(String string) {
        System.out.println("Printing Descriptions");
        this.G.printDescriptionsToFile(this.p, String.valueOf(string) + ".lab");
        System.out.println("Printing Transitions");
        this.G.printTransitionsToFile(this.p, String.valueOf(string) + ".tra");
        System.out.println("All done.");
    }

    public void setRecurringSequence(int n, Marking marking, Marking marking2) {
        if (this.UnboundedSequence[n] == null) {
            PetriUnit petriUnit = null;
            Marking marking3 = marking;
            while (!marking3.equals(marking2)) {
                this.UnboundedSequence[n] = new PetriUnitList(marking3.inFromTrans, this.UnboundedSequence[n]);
                marking3 = marking3.Father;
            }
            this.UnboundedSequence[n] = new PetriUnitList(petriUnit, this.UnboundedSequence[n]);
            while (marking3 != null) {
                if (marking3.inFromTrans != null) {
                    this.UnboundedSequence[n] = new PetriUnitList(marking3.inFromTrans, this.UnboundedSequence[n]);
                }
                marking3 = marking3.Father;
            }
        }
    }

    public boolean uniqueIn(Marking marking, Hashtable hashtable) {
        Marking marking2 = null;
        marking2 = (Marking)hashtable.get(marking.toString());
        return marking2 == null;
    }
}

