/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.ArcList;
import DaNAMiCS.Cover;
import DaNAMiCS.Marking;
import DaNAMiCS.Petri;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class Graph {
    int totalComponents = 0;
    boolean[] finalComponents;
    int numFinal = 0;
    int dfn = 0;
    Stack ComponentStack = new Stack();
    Hashtable MarkingsIn = new Hashtable(10000);
    Marking first;
    Marking lastelement;
    int numMarkings;
    int numFirings;
    Cover cov;
    Marking M = null;

    Graph(Marking marking, Cover cover) {
        this.MarkingsIn.put(marking.toString(), marking);
        this.first = marking;
        this.lastelement = marking;
        this.numMarkings = 2;
        this.numFirings = 0;
        this.cov = cover;
    }

    public void addVertex(Marking marking) {
        if (this.M == marking) {
            this.MarkingsIn.put(marking.toString(), marking);
            return;
        }
        marking.setUniqueNumber(this.numMarkings);
        this.MarkingsIn.put(marking.toString(), marking);
        this.M = marking;
        this.lastelement.next = marking;
        this.lastelement = marking;
        ++this.numMarkings;
        if (this.numMarkings % 1000 == 0) {
            System.out.println(String.valueOf(this.numMarkings) + " states found.");
        }
    }

    public void checkIntegrity() {
    }

    public void detectFinalComponents() {
        this.finalComponents = new boolean[this.totalComponents];
        this.numFinal = this.totalComponents;
        int n = 0;
        while (n < this.finalComponents.length) {
            this.finalComponents[n] = true;
            ++n;
        }
        Marking marking = this.first;
        while (marking != null) {
            ArcList arcList = marking.arcList;
            while (arcList != null) {
                if (marking.componentMemberNumber != arcList.m.componentMemberNumber) {
                    this.finalComponents[marking.componentMemberNumber] = false;
                    --this.numFinal;
                }
                arcList = arcList.next;
            }
            marking = marking.next;
        }
    }

    public Marking find(Marking marking) {
        return (Marking)this.MarkingsIn.get(marking.toString());
    }

    public int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public void printDescriptionsToFile(Petri petri, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            Hashtable hashtable = new Hashtable();
            Marking marking = this.first;
            while (marking != null) {
                marking.addPropositionsToHash(hashtable, this.cov.marks);
                marking = marking.next;
            }
            printWriter.println("#DECLARATION");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                printWriter.print(String.valueOf(String.valueOf(enumeration.nextElement())) + " ");
            }
            printWriter.println();
            printWriter.println("#END");
            Marking marking2 = this.first;
            while (marking2 != null) {
                printWriter.println(String.valueOf(marking2.getUniqueNumber()) + " " + marking2.toProposition(this.cov.marks));
                marking2 = marking2.next;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error writing graph descriptions!");
        }
    }

    public void printFinal() {
        int n = 0;
        while (n < this.totalComponents) {
            if (this.finalComponents[n]) {
                System.out.println("Component " + n + " is final");
            } else {
                System.out.println("Component " + n + " is not final");
            }
            ++n;
        }
    }

    public void printGraph() {
        int n = 0;
        Marking marking = this.first;
        while (marking != null) {
            marking.print();
            ArcList arcList = marking.arcList;
            while (arcList != null) {
                arcList.m.print();
                arcList = arcList.next;
            }
            System.out.println("\n---------------------------");
            ++n;
            marking = marking.next;
        }
        System.out.println("Number of Vertices Created: " + n);
    }

    public void printTransitionsToFile(Petri petri, String string) {
        try {
            String string2 = " ";
            String string3 = "M";
            String string4 = "I";
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            printWriter.println("STATES " + (this.numMarkings - 1));
            printWriter.println("TRANSITIONS " + this.numFirings);
            long l = 0L;
            Marking marking = this.first;
            while (marking != null) {
                l = marking.getUniqueNumber();
                ArcList arcList = marking.arcList;
                while (arcList != null) {
                    printWriter.println(String.valueOf(arcList.t.name) + string2 + l + string2 + arcList.m.getUniqueNumber() + string2 + arcList.t.Rate + string2 + (arcList.t.Type ? string4 : string3));
                    arcList = arcList.next;
                }
                marking = marking.next;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error writing graph transitions!");
        }
    }

    public void sCompDFS(Marking marking) {
        ++this.dfn;
        marking.dfsNumber = this.dfn;
        marking.low = this.dfn;
        marking.removed = false;
        ArcList arcList = marking.arcList;
        while (arcList != null) {
            Marking marking2 = arcList.m;
            if (marking2.dfsNumber == 0) {
                this.sCompDFS(marking2);
                marking.low = this.min(marking.low, marking2.low);
            } else if (!marking2.removed) {
                marking.low = this.min(marking2.dfsNumber, marking.low);
            }
            arcList = arcList.next;
        }
        if (marking.low == marking.dfsNumber) {
            System.out.println("New Strong Component");
            marking.removed = true;
            marking.componentMemberNumber = this.totalComponents;
            while (!this.ComponentStack.empty() && ((Marking)this.ComponentStack.peek()).dfsNumber > marking.dfsNumber) {
                ((Marking)this.ComponentStack.peek()).removed = true;
                ((Marking)this.ComponentStack.peek()).componentMemberNumber = this.totalComponents;
                this.ComponentStack.pop();
            }
            ++this.totalComponents;
        } else {
            this.ComponentStack.push(marking);
        }
    }

    public void strongComponents() {
        Marking marking = this.first;
        while (marking != null) {
            if (marking.dfsNumber == 0) {
                this.sCompDFS(marking);
            }
            marking = marking.next;
        }
    }
}

