/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpPanel
extends JPanel
implements HyperlinkListener {
    JEditorPane html;
    JScrollPane scroller;

    public HelpPanel(String string) {
        try {
            URL uRL = new URL(string);
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            this.setLayout(new GridLayout(1, 1));
            this.scroller = new JScrollPane(this.html);
            this.scroller.setPreferredSize(new Dimension(400, 400));
            this.add(this.scroller);
        }
        catch (Exception exception) {
            System.out.println("Exception occured!!!!!!!!!");
            System.out.println(exception.getMessage());
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
        this.repaint();
    }

    public void linkActivated(URL uRL) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
        this.repaint();
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (this.url == null) {
                HelpPanel.this.html.setCursor(this.cursor);
                Container container = HelpPanel.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = HelpPanel.this.html.getDocument();
            try {
                try {
                    HelpPanel.this.html.setPage(this.url);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
                Object var3_6 = null;
                this.url = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                Container container = HelpPanel.this.html.getParent();
                container.repaint();
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
            Container container = HelpPanel.this.html.getParent();
            container.repaint();
        }
    }
}

