/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Transition;
import java.util.Vector;
import javax.swing.JTextArea;

public class Invariant {
    int[][] IncidenceMatrix;
    int[][] ExtendedMatrix;
    int[] NewColumn;
    boolean[] deleted;
    boolean rforp;
    Vector[] PPlus;
    Vector[] PMinus;
    int NumTransitions = 0;
    int NumPlaces = 0;
    int NumExRows = 0;
    PetriUnitList Places;
    PetriUnitList Transitions;
    int minh = 0;
    int maxh = 0;
    int matsize = 0;

    public Invariant(Petri petri) {
        PetriUnitList petriUnitList = petri.Transitions;
        this.Transitions = null;
        this.Places = null;
        this.rforp = false;
        while (petriUnitList != null) {
            this.Transitions = new PetriUnitList(petriUnitList.p, this.Transitions);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = petri.Places;
        while (petriUnitList != null) {
            this.Places = new PetriUnitList(petriUnitList.p, this.Places);
            petriUnitList = petriUnitList.next;
        }
        this.Transitions = petri.getAllSubTrans(this.Transitions);
        this.Places = petri.getAllSubPlaces(this.Places);
        petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            petriUnitList.p.UniqueNumber = this.NumTransitions++;
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Places;
        while (petriUnitList != null) {
            petriUnitList.p.UniqueNumber = this.NumPlaces++;
            petriUnitList = petriUnitList.next;
        }
        this.IncidenceMatrix = new int[this.NumPlaces][this.NumTransitions];
        int n = 0;
        while (n < this.NumPlaces) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                this.IncidenceMatrix[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            Object object;
            PetriUnitList petriUnitList2 = ((Transition)petriUnitList.p).ArcsIn;
            while (petriUnitList2 != null) {
                if (((Arc)petriUnitList2.p).weight != -1) {
                    object = ((Arc)petriUnitList2.p).p;
                    int[] nArray = this.IncidenceMatrix[((PetriUnit)object).UniqueNumber];
                    int n3 = ((Transition)petriUnitList.p).UniqueNumber;
                    nArray[n3] = nArray[n3] - ((Arc)petriUnitList2.p).weight;
                }
                petriUnitList2 = petriUnitList2.next;
            }
            object = ((Transition)petriUnitList.p).ArcsOut;
            while (object != null) {
                if (((Arc)((PetriUnitList)object).p).weight != -1) {
                    Place place = ((Arc)((PetriUnitList)object).p).p;
                    int[] nArray = this.IncidenceMatrix[place.UniqueNumber];
                    int n4 = ((Transition)petriUnitList.p).UniqueNumber;
                    nArray[n4] = nArray[n4] + ((Arc)((PetriUnitList)object).p).weight;
                }
                object = ((PetriUnitList)object).next;
            }
            petriUnitList = petriUnitList.next;
        }
        this.printInc();
    }

    public Vector GaussReduce(int[][] nArray) {
        int n;
        Vector vector;
        if (nArray == null) {
            return null;
        }
        int n2 = nArray[0].length;
        int n3 = nArray.length;
        Vector vector2 = new Vector(n2);
        int n4 = 0;
        while (n4 < n2) {
            vector = new Vector(n3);
            Vector<Integer> vector3 = new Vector<Integer>(n3);
            n = 0;
            while (n < n3) {
                vector.addElement(new Integer(nArray[n][n4]));
                vector3.addElement(new Integer(-nArray[n][n4]));
                ++n;
            }
            vector2.addElement(vector);
            vector2.addElement(vector3);
            ++n4;
        }
        n2 *= 2;
        n = 0;
        while (n < n3) {
            n4 = 0;
            while (n4 < n2) {
                vector = (Vector)vector2.elementAt(n4);
                if ((Integer)vector.elementAt(n) < 0) {
                    int n5 = 0;
                    while (n5 < n2) {
                        Vector vector4 = (Vector)vector2.elementAt(n5);
                        if ((Integer)vector4.elementAt(n) > 0) {
                            int n6 = -((Integer)vector.elementAt(n)).intValue();
                            int n7 = (Integer)vector4.elementAt(n);
                            Vector<Integer> vector5 = new Vector<Integer>(n3);
                            boolean bl = true;
                            boolean bl2 = false;
                            int n8 = 0;
                            while (n8 < n3) {
                                int n9 = n6 * (Integer)vector4.elementAt(n8) + n7 * (Integer)vector.elementAt(n8);
                                vector5.addElement(new Integer(n9));
                                if (n9 != 0) {
                                    bl2 = true;
                                }
                                ++n8;
                            }
                            if (bl2) {
                                vector2.addElement(vector5);
                            }
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < vector2.size()) {
                vector = (Vector)vector2.elementAt(n4);
                if ((Integer)vector.elementAt(n) < 0) {
                    vector2.removeElementAt(n4);
                    --n4;
                }
                ++n4;
            }
            n2 = vector2.size();
            ++n;
        }
        return vector2;
    }

    public boolean Pcovered(JTextArea jTextArea) {
        boolean bl = true;
        PetriUnitList petriUnitList = this.Places;
        int n = this.NumPlaces;
        while (n < this.NumExRows) {
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                if (this.ExtendedMatrix[n][n2] > 0) {
                    bl2 = true;
                }
                ++n2;
            }
            if (!bl2) {
                String[] stringArray = petriUnitList.p.getHeritage();
                String string = new String();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string = string.concat(stringArray[n3]);
                    if (n3 != stringArray.length - 1) {
                        string = string.concat("::");
                    }
                    ++n3;
                }
                jTextArea.append(String.valueOf(string) + " is not covered.\n");
                bl = false;
            }
            petriUnitList = petriUnitList.next;
            ++n;
        }
        return bl;
    }

    public boolean Tcovered(JTextArea jTextArea) {
        boolean bl = true;
        PetriUnitList petriUnitList = this.Transitions;
        int n = this.NumPlaces;
        while (n < this.NumExRows) {
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                if (this.ExtendedMatrix[n][n2] > 0) {
                    bl2 = true;
                }
                ++n2;
            }
            if (!bl2) {
                String[] stringArray = petriUnitList.p.getHeritage();
                String string = new String();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string = string.concat(stringArray[n3]);
                    if (n3 != stringArray.length - 1) {
                        string = string.concat("::");
                    }
                    ++n3;
                }
                jTextArea.append(String.valueOf(string) + " is not covered.\n");
                bl = false;
            }
            petriUnitList = petriUnitList.next;
            ++n;
        }
        return bl;
    }

    public void appendColumn() {
        int n;
        int n2 = 0;
        while (n2 < this.NumTransitions) {
            block7: {
                n = this.NumPlaces;
                while (n < this.NumExRows) {
                    if (this.ExtendedMatrix[n][n2] == this.NewColumn[n]) {
                        ++n;
                        continue;
                    }
                    break block7;
                }
                return;
            }
            ++n2;
        }
        if (this.matsize < this.NumTransitions + 1) {
            this.matsize = this.NumTransitions + 250;
            int[][] nArray = new int[this.NumExRows][this.matsize];
            n = 0;
            while (n < this.NumExRows) {
                n2 = 0;
                while (n2 < this.NumTransitions) {
                    nArray[n][n2] = this.ExtendedMatrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            this.ExtendedMatrix = nArray;
        }
        n = this.NumPlaces;
        while (n < this.NumExRows) {
            this.ExtendedMatrix[n][this.NumTransitions] = this.NewColumn[n];
            ++n;
        }
        ++this.NumTransitions;
    }

    public void calcPInvariants(JTextArea jTextArea, JTextArea jTextArea2) {
        this.transposeIncidenceMatrix();
        this.rforp = true;
        this.initExtMat();
        this.reduceExtended();
        this.generateMinimum();
        if (this.Pcovered(jTextArea)) {
            jTextArea.append("The net is covered by P-Invariants.");
        } else {
            jTextArea.append("The net is not covered by P-Invariants");
        }
        this.printGUIB(jTextArea2);
        PetriUnitList petriUnitList = this.Places;
        jTextArea2.append("Places:\n");
        while (petriUnitList != null) {
            String[] stringArray = petriUnitList.p.getHeritage();
            String string = new String();
            int n = 0;
            while (n < stringArray.length) {
                string = string.concat(stringArray[n]);
                if (n != stringArray.length - 1) {
                    string = string.concat("::");
                }
                ++n;
            }
            if (petriUnitList.next != null) {
                jTextArea2.append(String.valueOf(string) + "; ");
            } else {
                jTextArea2.append(string);
            }
            petriUnitList = petriUnitList.next;
        }
    }

    public void calcPVectors() {
        int n;
        this.PPlus = new Vector[this.NumPlaces];
        this.PMinus = new Vector[this.NumPlaces];
        int n2 = 0;
        while (n2 < this.NumPlaces) {
            this.PPlus[n2] = new Vector(this.NumTransitions);
            this.PMinus[n2] = new Vector(this.NumTransitions);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.NumPlaces) {
            int[] nArray = this.ExtendedMatrix[n3];
            n = 0;
            while (n < this.NumTransitions) {
                if (!this.deleted[n]) {
                    if (nArray[n] > 0) {
                        this.PPlus[n3].addElement(new Integer(n));
                    }
                    if (nArray[n] < 0) {
                        this.PMinus[n3].addElement(new Integer(n));
                    }
                }
                ++n;
            }
            ++n3;
        }
        System.out.println("--- PPlus ---");
        n = 0;
        while (n < this.NumPlaces) {
            System.out.println(this.PPlus[n]);
            ++n;
        }
        System.out.println("--- PMinus ---");
        int n4 = 0;
        while (n4 < this.NumPlaces) {
            System.out.println(this.PMinus[n4]);
            ++n4;
        }
    }

    public void calcPVectorsForB() {
        int n;
        this.PPlus = new Vector[this.NumExRows - this.NumPlaces];
        this.PMinus = new Vector[this.NumExRows - this.NumPlaces];
        int n2 = this.NumPlaces;
        while (n2 < this.NumExRows) {
            this.PPlus[n2 - this.NumPlaces] = new Vector(this.NumTransitions);
            this.PMinus[n2 - this.NumPlaces] = new Vector(this.NumTransitions);
            ++n2;
        }
        int n3 = this.NumPlaces;
        while (n3 < this.NumExRows) {
            int[] nArray = this.ExtendedMatrix[n3];
            n = 0;
            while (n < this.NumTransitions) {
                if (nArray[n] > 0) {
                    this.PPlus[n3 - this.NumPlaces].addElement(new Integer(n));
                }
                if (nArray[n] < 0) {
                    this.PMinus[n3 - this.NumPlaces].addElement(new Integer(n));
                }
                ++n;
            }
            ++n3;
        }
        System.out.println("--- PPlus ---");
        n = this.NumPlaces;
        while (n < this.NumExRows) {
            System.out.println(this.PPlus[n - this.NumPlaces]);
            ++n;
        }
        System.out.println("--- PMinus ---");
        int n4 = this.NumPlaces;
        while (n4 < this.NumExRows) {
            System.out.println(this.PMinus[n4 - this.NumPlaces]);
            ++n4;
        }
    }

    public void calcTInvariants(JTextArea jTextArea, JTextArea jTextArea2) {
        this.printInc();
        if (this.rforp) {
            this.transposeIncidenceMatrix();
            this.rforp = false;
        }
        this.initExtMat();
        this.reduceExtended();
        this.generateMinimum();
        if (this.Tcovered(jTextArea)) {
            jTextArea.append("The net is covered by T-Invariants.");
        } else {
            jTextArea.append("The net is not covered by T-Invariants");
        }
        this.printGUIB(jTextArea2);
        PetriUnitList petriUnitList = this.Transitions;
        jTextArea2.append("Transitions:\n");
        while (petriUnitList != null) {
            String[] stringArray = petriUnitList.p.getHeritage();
            String string = new String();
            int n = 0;
            while (n < stringArray.length) {
                string = string.concat(stringArray[n]);
                if (n != stringArray.length - 1) {
                    string = string.concat("::");
                }
                ++n;
            }
            if (petriUnitList.next != null) {
                jTextArea2.append(String.valueOf(string) + "; ");
            } else {
                jTextArea2.append(string);
            }
            petriUnitList = petriUnitList.next;
        }
    }

    public void clean() {
        int n = 0;
        while (n < this.NumTransitions) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.NumPlaces;
            while (n4 < this.NumExRows) {
                if (this.ExtendedMatrix[n4][n] > 0) {
                    ++n2;
                } else if (this.ExtendedMatrix[n4][n] < 0) {
                    ++n3;
                }
                ++n4;
            }
            if (!(n2 > 0 && n3 > 0 || n2 == 0 && n3 == 0)) {
                int n5;
                if (n3 > 0) {
                    n5 = this.NumPlaces;
                    while (n5 < this.NumExRows) {
                        this.ExtendedMatrix[n5][n] = -this.ExtendedMatrix[n5][n];
                        ++n5;
                    }
                }
                n5 = this.NumPlaces;
                while (n5 < this.NumExRows) {
                    if (this.ExtendedMatrix[n5][n] != 0) {
                        int n6 = 0;
                        while (n6 < this.NumTransitions) {
                            if (this.ExtendedMatrix[n5][n6] < 0) {
                                int n7 = this.NumPlaces;
                                while (n7 < this.NumExRows) {
                                    int[] nArray = this.ExtendedMatrix[n7];
                                    int n8 = n6;
                                    nArray[n8] = nArray[n8] + this.ExtendedMatrix[n7][n];
                                    ++n7;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    public void cleanupMatrix() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.NumTransitions) {
            block7: {
                block6: {
                    try {
                        if (!this.deleted[n3]) break block6;
                        break block7;
                    }
                    catch (Exception exception) {}
                }
                n = 0;
                while (n < this.NumExRows) {
                    this.ExtendedMatrix[n][n2] = this.ExtendedMatrix[n][n3];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        this.NumTransitions = n2;
        if (this.deleted.length < this.NumTransitions) {
            this.deleted = new boolean[this.NumTransitions];
        }
        n = 0;
        while (n < this.NumTransitions) {
            this.deleted[n] = false;
            ++n;
        }
    }

    public int divideByGCD() {
        int n;
        int n2 = 0;
        int n3 = this.NumPlaces;
        while (n3 < this.NumExRows) {
            n = this.gcd(n2, Math.abs(this.NewColumn[n3]));
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 0;
        }
        n = this.NumPlaces;
        while (n < this.NumExRows) {
            int n4 = n++;
            this.NewColumn[n4] = this.NewColumn[n4] / n2;
        }
        return 1;
    }

    public boolean existsNonZero() {
        int n = 0;
        while (n < this.NumPlaces) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                if (!(this.deleted[n2] || this.ExtendedMatrix[n][n2] <= 0 && this.ExtendedMatrix[n][n2] >= 0)) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public void findLinearCombos() {
        int n = 0;
        while (n < this.NumTransitions) {
            if (!this.deleted[n]) {
                int n2 = n + 1;
                while (n2 < this.NumTransitions) {
                    if (!this.deleted[n2]) {
                        int n3 = n2 + 1;
                        while (n3 < this.NumTransitions) {
                            block12: {
                                if (!this.deleted[n3]) {
                                    int n4 = 0;
                                    while (n4 < this.NumExRows) {
                                        if (this.ExtendedMatrix[n4][n3] == 0 && this.ExtendedMatrix[n4][n] != 0 && this.ExtendedMatrix[n4][n2] != 0) break;
                                        ++n4;
                                    }
                                    if (n4 < this.NumExRows) {
                                        int n5;
                                        int n6 = this.ExtendedMatrix[n4][n2];
                                        int n7 = -this.ExtendedMatrix[n4][n];
                                        n4 = 0;
                                        while (n4 < this.NumExRows) {
                                            if (this.ExtendedMatrix[n4][n3] != 0) break;
                                            ++n4;
                                        }
                                        if (n4 < this.NumExRows && (n5 = n6 * this.ExtendedMatrix[n4][n] + n7 * this.ExtendedMatrix[n4][n2]) != 0) {
                                            int n8 = n5 / this.ExtendedMatrix[n4][n3];
                                            n4 = 0;
                                            while (n4 < this.NumExRows) {
                                                if (n8 * this.ExtendedMatrix[n4][n3] == n6 * this.ExtendedMatrix[n4][n] + n7 * this.ExtendedMatrix[n4][n2]) {
                                                    ++n4;
                                                    continue;
                                                }
                                                break block12;
                                            }
                                            this.deleted[n3] = true;
                                        }
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void findNonMinimalSupport() {
        int n;
        System.out.println("Finding Non-Minimal support");
        boolean bl = false;
        if (this.deleted.length < this.NumTransitions) {
            boolean[] blArray = new boolean[this.NumTransitions + 100];
            n = 0;
            while (n < this.deleted.length) {
                blArray[n] = this.deleted[n];
                ++n;
            }
            while (n < blArray.length) {
                blArray[n] = false;
                ++n;
            }
            this.deleted = blArray;
        }
        int n2 = 0;
        while (n2 < this.NumTransitions) {
            if (!this.deleted[n2]) {
                n = 0;
                while (n < this.NumTransitions) {
                    if (!this.deleted[n]) {
                        bl = false;
                        if (n != n2) {
                            int n3 = this.NumPlaces;
                            while (n3 < this.NumExRows) {
                                if (this.ExtendedMatrix[n3][n] > 0 && this.ExtendedMatrix[n3][n2] == 0) {
                                    bl = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!bl) {
                                this.deleted[n2] = true;
                                System.out.println("Deleting: " + n2);
                                break;
                            }
                        }
                    }
                    ++n;
                }
            }
            ++n2;
        }
        this.cleanupMatrix();
    }

    public int gcd(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        return this.gcd(n2, n % n2);
    }

    public void generateEquations(JTextArea jTextArea) {
        int n = 0;
        boolean bl = true;
        PetriUnitList petriUnitList = this.Places;
        int n2 = 0;
        while (n2 < this.NumTransitions) {
            int n3 = this.NumPlaces;
            while (n3 < this.NumExRows) {
                n += this.ExtendedMatrix[n3][n2] * ((Place)petriUnitList.p).tokens;
                if (this.ExtendedMatrix[n3][n2] != 0) {
                    if (!bl) {
                        jTextArea.append(" + ");
                    }
                    bl = false;
                    String[] stringArray = petriUnitList.p.getHeritage();
                    String string = new String();
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        string = string.concat(stringArray[n4]);
                        if (n4 != stringArray.length - 1) {
                            string = string.concat("::");
                        }
                        ++n4;
                    }
                    String string2 = new String();
                    string2 = this.ExtendedMatrix[n3][n2] != 1 ? new String(String.valueOf(this.ExtendedMatrix[n3][n2]) + "*") : new String("");
                    jTextArea.append(String.valueOf(string2) + string);
                }
                petriUnitList = petriUnitList.next;
                ++n3;
            }
            bl = true;
            jTextArea.append(" = " + n + "\n");
            n = 0;
            petriUnitList = this.Places;
            ++n2;
        }
    }

    public void generateMinimum() {
        int n;
        int n2 = 0;
        while (n2 < this.NumTransitions) {
            n = this.NumPlaces;
            while (n < this.NumExRows) {
                this.ExtendedMatrix[n - this.NumPlaces][n2] = this.ExtendedMatrix[n][n2];
                ++n;
            }
            ++n2;
        }
        this.NumExRows -= this.NumPlaces;
        this.NumPlaces = 0;
        this.NewColumn = new int[this.NumExRows];
        System.out.println("Performing Phase 2");
        this.printB();
        this.minh = this.NumPlaces;
        this.maxh = this.NumExRows;
        n = this.negativeInB();
        int n3 = this.NumTransitions * 4;
        while (n > -1) {
            int[] nArray = this.ExtendedMatrix[n];
            int[] nArray2 = new int[this.NumTransitions];
            int[] nArray3 = new int[this.NumTransitions];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.NumTransitions) {
                if (nArray[n6] > 0) {
                    nArray3[n5++] = n6;
                } else if (nArray[n6] < 0) {
                    nArray2[n4++] = n6;
                }
                ++n6;
            }
            System.out.print(".");
            System.out.flush();
            if (n4 == 0) continue;
            int n7 = 0;
            while (n7 < n4) {
                this.deleted[nArray2[n7]] = true;
                ++n7;
            }
            int n8 = 0;
            while (n8 < n5) {
                int n9 = nArray3[n8];
                int n10 = nArray[n9];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = nArray2[n11];
                    int n13 = -nArray[n12];
                    int n14 = 0;
                    while (n14 < this.NumExRows) {
                        this.NewColumn[n14] = n10 * this.ExtendedMatrix[n14][n12] + n13 * this.ExtendedMatrix[n14][n9];
                        ++n14;
                    }
                    this.divideByGCD();
                    this.appendColumn();
                    ++n11;
                }
                ++n8;
            }
            if (this.NumTransitions > n3) {
                this.findNonMinimalSupport();
            } else {
                this.cleanupMatrix();
            }
            n = this.negativeInB();
        }
        this.findNonMinimalSupport();
        System.out.println("Phase 2 Done");
        this.printB();
    }

    public void initExtMat() {
        int n;
        int n2 = this.NumTransitions + this.NumPlaces;
        int n3 = this.NumTransitions;
        this.ExtendedMatrix = new int[n2][n3];
        this.NumExRows = n2;
        int n4 = 0;
        while (n4 < this.NumPlaces) {
            n = 0;
            while (n < this.NumTransitions) {
                this.ExtendedMatrix[n4][n] = this.IncidenceMatrix[n4][n];
                ++n;
            }
            ++n4;
        }
        n = this.NumPlaces;
        while (n < n2) {
            this.ExtendedMatrix[n][n - this.NumPlaces] = 1;
            ++n;
        }
    }

    boolean isLinearCombination() {
        int n = this.deleted.length;
        int n2 = 0;
        while (n2 < this.NumTransitions) {
            if (n2 >= n || !this.deleted[n2]) {
                int n3 = n2 + 1;
                while (n3 < this.NumTransitions) {
                    block10: {
                        if (n3 >= n || !this.deleted[n3]) {
                            int n4 = 0;
                            while (n4 < this.NumExRows) {
                                if (this.NewColumn[n4] == 0 && this.ExtendedMatrix[n4][n2] != 0 && this.ExtendedMatrix[n4][n3] != 0) break;
                                ++n4;
                            }
                            if (n4 < this.NumExRows) {
                                int n5;
                                int n6 = this.ExtendedMatrix[n4][n3];
                                int n7 = -this.ExtendedMatrix[n4][n2];
                                n4 = 0;
                                while (n4 < this.NumExRows) {
                                    if (this.NewColumn[n4] != 0) break;
                                    ++n4;
                                }
                                if (n4 < this.NumExRows && (n5 = n6 * this.ExtendedMatrix[n4][n2] + n7 * this.ExtendedMatrix[n4][n3]) != 0) {
                                    int n8 = n5 / this.NewColumn[n4];
                                    n4 = 0;
                                    while (n4 < this.NumExRows) {
                                        if (n8 * this.NewColumn[n4] == n6 * this.ExtendedMatrix[n4][n2] + n7 * this.ExtendedMatrix[n4][n3]) {
                                            ++n4;
                                            continue;
                                        }
                                        break block10;
                                    }
                                    return true;
                                }
                            }
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return false;
    }

    public int negativeInB() {
        int n = -1;
        int n2 = -1;
        int n3 = this.NumTransitions * this.NumTransitions;
        n = this.minh;
        while (n < this.maxh) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.NumTransitions) {
                if (this.ExtendedMatrix[n][n6] < 0) {
                    ++n4;
                } else if (this.ExtendedMatrix[n][n6] > 0) {
                    ++n5;
                }
                ++n6;
            }
            if (n4 == 0) {
                if (n == this.minh) {
                    ++this.minh;
                }
                if (n == this.maxh - 1) {
                    this.maxh = n;
                }
            } else {
                if (n5 < 2) {
                    return n;
                }
                if (n5 > 5) {
                    n5 = 5;
                }
                if (n4 * n5 < n3) {
                    n3 = n4 * n5;
                    n2 = n;
                }
            }
            ++n;
        }
        return n2;
    }

    public void printB() {
        System.out.println("Printing B...");
        int n = this.NumPlaces;
        while (n < this.NumExRows) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                System.out.print(String.valueOf(this.ExtendedMatrix[n][n2]) + " ");
                ++n2;
            }
            System.out.println("");
            ++n;
        }
        System.out.println("---_End_of_B_---");
    }

    public void printExtMat() {
        System.out.println("-----------------------------------------");
        int n = 0;
        while (n < this.NumExRows) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                System.out.print(String.valueOf(this.ExtendedMatrix[n][n2]) + " ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public void printGUIB(JTextArea jTextArea) {
        int n = this.NumPlaces;
        while (n < this.NumExRows) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                if (this.ExtendedMatrix[n][n2] >= 0) {
                    jTextArea.append(" ");
                    if (this.ExtendedMatrix[n][n2] < 10) {
                        jTextArea.append(" ");
                    }
                }
                if (this.ExtendedMatrix[n][n2] > -9 && this.ExtendedMatrix[n][n2] < 0) {
                    jTextArea.append(" ");
                }
                jTextArea.append(String.valueOf(this.ExtendedMatrix[n][n2]) + " ");
                ++n2;
            }
            jTextArea.append("\n");
            ++n;
        }
    }

    public void printInc() {
        System.out.println(this.NumTransitions);
        System.out.println(this.NumPlaces);
        int n = 0;
        while (n < this.NumPlaces) {
            int n2 = 0;
            while (n2 < this.NumTransitions) {
                if (!this.rforp) {
                    System.out.print(String.valueOf(this.IncidenceMatrix[n][n2]) + " ");
                }
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public void printIncidenceMatrix(JTextArea jTextArea) {
        int n;
        String string;
        String[] stringArray;
        int n2 = 0;
        while (n2 < this.NumPlaces) {
            int n3 = 0;
            while (n3 < this.NumTransitions) {
                if (!this.rforp) {
                    if (this.IncidenceMatrix[n2][n3] >= 0) {
                        jTextArea.append(" ");
                        if (this.IncidenceMatrix[n2][n3] < 10) {
                            jTextArea.append(" ");
                        }
                    }
                    if (this.IncidenceMatrix[n2][n3] > -9 && this.IncidenceMatrix[n2][n3] < 0) {
                        jTextArea.append(" ");
                    }
                    jTextArea.append(String.valueOf(this.IncidenceMatrix[n2][n3]) + " ");
                }
                ++n3;
            }
            jTextArea.append("\n");
            ++n2;
        }
        PetriUnitList petriUnitList = this.Places;
        jTextArea.append("Places:\n");
        while (petriUnitList != null) {
            stringArray = petriUnitList.p.getHeritage();
            string = new String();
            n = 0;
            while (n < stringArray.length) {
                string = string.concat(stringArray[n]);
                if (n != stringArray.length - 1) {
                    string = string.concat("::");
                }
                ++n;
            }
            if (petriUnitList.next != null) {
                jTextArea.append(String.valueOf(string) + "; ");
            } else {
                jTextArea.append(string);
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Transitions;
        jTextArea.append("\nTransitions:\n");
        while (petriUnitList != null) {
            stringArray = petriUnitList.p.getHeritage();
            string = new String();
            n = 0;
            while (n < stringArray.length) {
                string = string.concat(stringArray[n]);
                if (n != stringArray.length - 1) {
                    string = string.concat("::");
                }
                ++n;
            }
            if (petriUnitList.next != null) {
                jTextArea.append(String.valueOf(string) + "; ");
            } else {
                jTextArea.append(string);
            }
            petriUnitList = petriUnitList.next;
        }
    }

    public void reduceExtended() {
        boolean bl = false;
        this.deleted = new boolean[this.NumTransitions];
        int n = 0;
        while (n < this.NumTransitions) {
            this.deleted[n] = false;
            ++n;
        }
        while (this.existsNonZero()) {
            int n2;
            int n3;
            this.calcPVectors();
            bl = false;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.NumPlaces) {
                if (this.PPlus[n5].size() == 0 ^ this.PMinus[n5].size() == 0) {
                    bl = true;
                    System.out.println("Yippee!!!!");
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            if (bl) {
                n3 = 0;
                while (n3 < this.PPlus[n4].size()) {
                    this.deleted[((Integer)this.PPlus[n4].elementAt((int)n3)).intValue()] = true;
                    ++n3;
                }
                n2 = 0;
                while (n2 < this.PMinus[n4].size()) {
                    this.deleted[((Integer)this.PMinus[n4].elementAt((int)n2)).intValue()] = true;
                    ++n2;
                }
            } else {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                n3 = -1;
                n2 = 0;
                boolean bl2 = false;
                int n12 = 0;
                while (n12 < this.NumPlaces) {
                    if (this.PPlus[n12].size() == 1) {
                        n3 = (Integer)this.PPlus[n12].firstElement();
                        n2 = n12;
                        bl2 = true;
                        break;
                    }
                    if (this.PMinus[n12].size() == 1) {
                        n3 = (Integer)this.PMinus[n12].firstElement();
                        n2 = n12;
                        break;
                    }
                    ++n12;
                }
                if (n3 > -1) {
                    if (bl2) {
                        n11 = Math.abs(this.ExtendedMatrix[n2][n3]);
                        n10 = 0;
                        n9 = 0;
                        while (n9 < this.PMinus[n2].size()) {
                            n8 = Math.abs(this.ExtendedMatrix[n2][(Integer)this.PMinus[n2].elementAt(n9)]);
                            n10 = (Integer)this.PMinus[n2].elementAt(n9);
                            n7 = 0;
                            while (n7 < this.NumExRows) {
                                int n13 = n8 * this.ExtendedMatrix[n7][n3];
                                n6 = n11 * this.ExtendedMatrix[n7][n10];
                                this.ExtendedMatrix[n7][n10] = n13 + n6;
                                ++n7;
                            }
                            ++n9;
                        }
                    } else {
                        n11 = Math.abs(this.ExtendedMatrix[n2][n3]);
                        n10 = 0;
                        n9 = 0;
                        while (n9 < this.PPlus[n2].size()) {
                            n8 = Math.abs(this.ExtendedMatrix[n2][(Integer)this.PPlus[n2].elementAt(n9)]);
                            n10 = (Integer)this.PPlus[n2].elementAt(n9);
                            n7 = 0;
                            while (n7 < this.NumExRows) {
                                int n14 = n8 * this.ExtendedMatrix[n7][n3];
                                n6 = n11 * this.ExtendedMatrix[n7][n10];
                                this.ExtendedMatrix[n7][n10] = n14 + n6;
                                ++n7;
                            }
                            ++n9;
                        }
                    }
                    this.deleted[n3] = true;
                } else {
                    n11 = -1;
                    n10 = 0;
                    while (n10 < this.NumPlaces) {
                        n9 = 0;
                        while (n9 < this.NumTransitions) {
                            if (!this.deleted[n9] && this.ExtendedMatrix[n10][n9] != 0) {
                                n11 = n10;
                            }
                            ++n9;
                        }
                        if (n11 > -1) break;
                        ++n10;
                    }
                    n9 = 0;
                    while (n9 < this.NumTransitions) {
                        if (!this.deleted[n9] && this.ExtendedMatrix[n11][n9] != 0) {
                            n3 = n9;
                            break;
                        }
                        ++n9;
                    }
                    int[] nArray = this.ExtendedMatrix[n11];
                    n6 = 0;
                    while (n6 < this.NumTransitions) {
                        if (!this.deleted[n6] && n6 != n3 && nArray[n6] != 0) {
                            if (this.signInt(nArray[n6]) != this.signInt(nArray[n3])) {
                                n8 = Math.abs(nArray[n6]);
                                n7 = Math.abs(nArray[n3]);
                            } else {
                                n8 = -Math.abs(nArray[n6]);
                                n7 = Math.abs(nArray[n3]);
                            }
                            int n15 = 0;
                            while (n15 < this.NumExRows) {
                                this.ExtendedMatrix[n15][n6] = n8 * this.ExtendedMatrix[n15][n3] + n7 * this.ExtendedMatrix[n15][n6];
                                ++n15;
                            }
                        }
                        ++n6;
                    }
                    this.deleted[n3] = true;
                }
            }
            System.out.println("Deleted");
            n3 = 0;
            while (n3 < this.NumTransitions) {
                System.out.print(String.valueOf(n3) + " " + this.deleted[n3] + " ");
                ++n3;
            }
            System.out.println();
            this.cleanupMatrix();
            System.out.println("Extended after cleanup");
        }
    }

    public int signInt(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public void transposeIncidenceMatrix() {
        int n;
        int[][] nArray = new int[this.NumTransitions][this.NumPlaces];
        int n2 = 0;
        while (n2 < this.NumPlaces) {
            n = 0;
            while (n < this.NumTransitions) {
                nArray[n][n2] = this.IncidenceMatrix[n2][n];
                ++n;
            }
            ++n2;
        }
        this.IncidenceMatrix = nArray;
        n = this.NumTransitions;
        this.NumTransitions = this.NumPlaces;
        this.NumPlaces = n;
        this.printInc();
    }
}

