/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.Comment;
import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.HighLight;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.PrintDraw;
import DaNAMiCS.SubDial;
import DaNAMiCS.Subnet;
import DaNAMiCS.Transition;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class Petri
implements Cloneable {
    public PetriUnitList Places = null;
    public PetriUnitList Transitions = null;
    public PetriUnitList Subnets = null;
    public PetriUnitList ArcFromSubnet = null;
    public PetriUnitList Comments = null;
    public PetriUnitList HighLights = null;
    public Subnet Parent;
    public Draw d;
    public String FileName = null;
    int LowestPlace = 0;
    int LowestTransition = 0;
    int LowestSubnet = 0;
    int Level;
    boolean TopLevelPetri = false;
    public boolean changed = false;
    PetriUnitList ReversedPlaces = null;
    PetriUnitList ReversedTransitions = null;
    PetriUnitList ReversedSubnets = null;
    public static Petri lPetri = null;
    public Petri petriParent = null;
    public float printScale = 1.0f;
    public boolean printToFit = true;
    public Rectangle printRect = null;

    Petri(Subnet subnet) {
        this.Parent = subnet;
        this.d = new Draw();
    }

    Petri(Subnet subnet, boolean bl) {
        this.Parent = subnet;
        this.d = new Draw();
        this.TopLevelPetri = bl;
    }

    void AddArc(int n, int n2, int n3, int n4, int n5, int n6) {
        PetriUnit petriUnit = this.Find(n, n2);
        PetriUnit petriUnit2 = this.Find(n3, n4);
        if (petriUnit == null || petriUnit2 == null) {
            return;
        }
        PetriUnit petriUnit3 = petriUnit;
        PetriUnit petriUnit4 = petriUnit2;
        SubDial subDial = new SubDial(this, petriUnit, petriUnit2);
        if (petriUnit.getType() == 4) {
            subDial.doFrom();
            if (!subDial.canceled) {
                if (petriUnit2.getType() != 4) {
                    Arc arc = this.addArcByName(subDial.SubnetFrom, subDial.From.name, null, petriUnit2.name, n5, n6);
                    arc.from = petriUnit3;
                    arc.resetHandle();
                    arc.setBound();
                    return;
                }
            } else {
                return;
            }
        }
        if (petriUnit2.getType() == 4) {
            subDial.doTo();
            if (!subDial.canceled) {
                if (petriUnit.getType() != 4) {
                    Arc arc = this.addArcByName(null, petriUnit.name, subDial.SubnetTo, subDial.To.name, n5, n6);
                    arc.to = petriUnit4;
                    arc.resetHandle();
                    arc.setBound();
                    return;
                }
                Arc arc = this.addArcByName(subDial.SubnetFrom, subDial.From.name, subDial.SubnetTo, subDial.To.name, n5, n6);
                arc.to = petriUnit4;
                arc.from = petriUnit3;
                arc.resetHandle();
                arc.setBound();
                return;
            }
            return;
        }
        if (n5 == -1 && petriUnit.getType() == 3) {
            PetriUnit petriUnit5 = petriUnit;
            petriUnit = petriUnit2;
            petriUnit2 = petriUnit5;
        }
        if (petriUnit.getType() == 2 && petriUnit2.getType() == 3) {
            this.AddArcIn((Place)petriUnit, (Transition)petriUnit2, n5, n6);
            return;
        }
        if (petriUnit.getType() == 3 && petriUnit2.getType() == 2) {
            this.AddArcOut((Place)petriUnit2, (Transition)petriUnit, n5, n6);
        }
    }

    void AddArcFromSubnet(Arc arc) {
        this.ArcFromSubnet = new PetriUnitList(arc, this.ArcFromSubnet);
    }

    Arc AddArcIn(Place place, Transition transition, int n, int n2) {
        PetriUnitList petriUnitList = transition.ArcsIn;
        while (petriUnitList != null) {
            if (((Arc)petriUnitList.p).p == place && ((Arc)petriUnitList.p).weight == -1) {
                return null;
            }
            petriUnitList = petriUnitList.next;
        }
        Arc arc = transition.AddArcIn(place, n, n2);
        place.AddArc(arc);
        return arc;
    }

    Arc AddArcOut(Place place, Transition transition, int n, int n2) {
        PetriUnitList petriUnitList = transition.ArcsOut;
        while (petriUnitList != null) {
            if (((Arc)petriUnitList.p).p == place) {
                return null;
            }
            petriUnitList = petriUnitList.next;
        }
        Arc arc = transition.AddArcOut(place, n, n2);
        place.AddArc(arc);
        return arc;
    }

    void AddComment(PetriUnit petriUnit) {
        this.Comments = new PetriUnitList(petriUnit, this.Comments);
        petriUnit.setBound();
    }

    void AddHighLights(PetriUnit petriUnit) {
        if (this.HighLights == null) {
            this.HighLights = new PetriUnitList(petriUnit, this.HighLights);
        } else {
            PetriUnitList petriUnitList = this.HighLights;
            while (petriUnitList.next != null) {
                petriUnitList = petriUnitList.next;
            }
            petriUnitList.next = new PetriUnitList(petriUnit, null);
        }
        petriUnit.setBound();
    }

    void AddPlace(Place place) {
        this.Places = new PetriUnitList(place, this.Places);
        do {
            place.setName("p" + this.LowestPlace);
            ++this.LowestPlace;
        } while (!this.validName(place));
        place.setBound();
    }

    void AddSubnet(Subnet subnet) {
        System.out.println("Adding a subnet");
        while (!this.validName(subnet)) {
            subnet.setName("s" + this.LowestSubnet);
            ++this.LowestSubnet;
        }
        this.Subnets = new PetriUnitList(subnet, this.Subnets);
        subnet.setBound();
    }

    void AddTransition(Transition transition) {
        this.Transitions = new PetriUnitList(transition, this.Transitions);
        do {
            transition.setName("t" + this.LowestTransition);
            ++this.LowestTransition;
        } while (!this.validName(transition));
        transition.setBound();
    }

    PetriUnit Find(int n, int n2) {
        PetriUnit petriUnit;
        if (this.Places != null && (petriUnit = this.Places.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.Transitions != null && (petriUnit = this.Transitions.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.Subnets != null) {
            petriUnit = this.Subnets.Find(n, n2);
            return petriUnit;
        }
        return null;
    }

    PetriUnit FindAll(int n, int n2) {
        PetriUnit petriUnit;
        if (this.Places != null && (petriUnit = this.Places.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.Transitions != null && (petriUnit = this.Transitions.FindAll(n, n2)) != null) {
            return petriUnit;
        }
        if (this.Subnets != null && (petriUnit = this.Subnets.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.ArcFromSubnet != null && (petriUnit = this.ArcFromSubnet.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.Comments != null && (petriUnit = this.Comments.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.HighLights != null && (petriUnit = this.HighLights.Find(n, n2)) != null) {
            return petriUnit;
        }
        return null;
    }

    Arc FindArc(int n, int n2) {
        Arc arc;
        if (this.ArcFromSubnet != null && (arc = (Arc)this.ArcFromSubnet.Find(n, n2)) != null) {
            return arc;
        }
        if (this.Transitions != null) {
            return this.Transitions.FindArc(n, n2);
        }
        return null;
    }

    Arc addArcByName(Subnet subnet, String string, Subnet subnet2, String string2, int n, int n2) {
        return this.addArcByName(subnet, string, subnet2, string2, n, n2, null);
    }

    Arc addArcByName(Subnet subnet, String string, Subnet subnet2, String string2, int n, int n2, Point[] pointArray) {
        Petri petri = subnet == null ? this : subnet.getPetri();
        Petri petri2 = subnet2 == null ? this : subnet2.getPetri();
        Place place = null;
        Transition transition = null;
        Arc arc = null;
        if (petri.Transitions != null) {
            transition = (Transition)petri.Transitions.findByName(string);
        }
        if (transition != null) {
            if (petri2.Places != null) {
                place = (Place)petri2.Places.findByName(string2);
            }
            if (place == null || transition == null) {
                return null;
            }
            arc = this.AddArcOut(place, transition, n, n2);
        } else {
            if (petri2.Transitions != null) {
                transition = (Transition)petri2.Transitions.findByName(string2);
            }
            if (petri.Places != null) {
                place = (Place)petri.Places.findByName(string);
            }
            if (place == null || transition == null) {
                return null;
            }
            arc = this.AddArcIn(place, transition, n, n2);
        }
        if (arc == null) {
            return arc;
        }
        if (petri != this) {
            arc.from = subnet;
            while (arc.from.Parent != null) {
                arc.from = arc.from.Parent;
            }
        }
        if (petri2 != this) {
            arc.to = subnet2;
        }
        if (arc.from.getType() != 3 && arc.to.getType() != 3) {
            this.AddArcFromSubnet(arc);
        }
        if (arc.from.getType() == 4 || arc.to.getType() == 4) {
            arc.resetHandle();
            arc.setBound();
        }
        if (pointArray != null) {
            arc.points = pointArray;
            arc.numpoints = pointArray.length;
            arc.setBound();
            transition.setBound();
            place.setBound();
        }
        return arc;
    }

    void addArcWithSubnets(String string, String string2, String string3, String string4, int n) {
        Subnet subnet = null;
        Subnet subnet2 = null;
        if (this.Subnets != null) {
            subnet = (Subnet)this.Subnets.findByName(string);
            subnet2 = (Subnet)this.Subnets.findByName(string3);
        }
        this.addArcByName(subnet, string2, subnet2, string4, n, 1);
    }

    public void cutSelected(Petri petri, boolean bl) {
        Object object;
        Object object2;
        PetriUnitList petriUnitList = null;
        if (petri.Places != null) {
            petriUnitList = petri.Places;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Place)petriUnitList.p).copyPlace((Place)petriUnitList.p);
                    this.AddPlace((Place)object2);
                    ((PetriUnit)object2).name = petriUnitList.p.name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Transitions != null) {
            petriUnitList = petri.Transitions;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Transition)petriUnitList.p).copyTransition((Transition)petriUnitList.p);
                    this.AddTransition((Transition)object2);
                    ((PetriUnit)object2).name = petriUnitList.p.name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Subnets != null) {
            petriUnitList = petri.Subnets;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Subnet)petriUnitList.p).copySubnet((Subnet)petriUnitList.p);
                    this.AddSubnet((Subnet)object2);
                    ((PetriUnit)object2).name = petriUnitList.p.name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.ArcFromSubnet != null) {
            petriUnitList = petri.ArcFromSubnet;
            while (petriUnitList != null) {
                if (((Arc)petriUnitList.p).selected[0] || bl) {
                    object2 = ((Arc)petriUnitList.p).copyArc((Arc)petriUnitList.p);
                    this.AddArcFromSubnet((Arc)object2);
                    ((Arc)object2).points = ((Arc)petriUnitList.p).copyPoints();
                    object = this.findByName(((Arc)petriUnitList.p).from.name);
                    if (object != null) {
                        ((Arc)object2).from = object;
                    }
                    if ((object = this.findByName(((Arc)petriUnitList.p).to.name)) != null) {
                        ((Arc)object2).to = object;
                    }
                    if ((object = this.findByName(((Arc)petriUnitList.p).p.name)) != null) {
                        ((Arc)object2).p = (Place)object;
                    }
                    if ((object = this.findByName(((Arc)petriUnitList.p).t.name)) != null) {
                        ((Arc)object2).t = (Transition)object;
                    }
                    ((Arc)object2).setBound();
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Comments != null) {
            petriUnitList = petri.Comments;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Comment)petriUnitList.p).copyComment((Comment)petriUnitList.p);
                    this.AddComment((PetriUnit)object2);
                    ((PetriUnit)object2).name = petriUnitList.p.name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.HighLights != null) {
            petriUnitList = petri.HighLights;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((HighLight)petriUnitList.p).copyHighLight((HighLight)petriUnitList.p);
                    this.AddHighLights((PetriUnit)object2);
                    ((PetriUnit)object2).name = petriUnitList.p.name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Transitions != null) {
            petriUnitList = petri.Transitions;
            while (petriUnitList != null) {
                PetriUnit petriUnit;
                Arc arc;
                object2 = ((Transition)petriUnitList.p).ArcsIn;
                while (object2 != null) {
                    if (((Arc)((PetriUnitList)object2).p).from.selected && ((Arc)((PetriUnitList)object2).p).to.selected) {
                        object = (Arc)((PetriUnitList)object2).p;
                        arc = ((Arc)((PetriUnitList)object2).p).copyArc((Arc)((PetriUnitList)object2).p);
                        arc.points = ((Arc)((PetriUnitList)object2).p).copyPoints();
                        petriUnit = this.findByName(((Arc)((PetriUnitList)object2).p).from.name);
                        if (petriUnit != null) {
                            arc.from = petriUnit;
                        }
                        if ((petriUnit = this.findByName(((Arc)((PetriUnitList)object2).p).to.name)) != null) {
                            arc.to = petriUnit;
                        }
                        if ((petriUnit = this.findByName(((Arc)((PetriUnitList)object2).p).p.name)) != null) {
                            arc.p = (Place)petriUnit;
                        }
                        if ((petriUnit = this.findByName(((Arc)((PetriUnitList)object2).p).t.name)) != null) {
                            arc.t = (Transition)petriUnit;
                            if (arc.toPlace) {
                                arc.t.ArcsOut = new PetriUnitList(arc, arc.t.ArcsOut);
                            } else {
                                arc.t.ArcsIn = new PetriUnitList(arc, arc.t.ArcsIn);
                            }
                        }
                        arc.setBound();
                    }
                    object2 = ((PetriUnitList)object2).next;
                }
                object = ((Transition)petriUnitList.p).ArcsOut;
                while (object != null) {
                    if (((Arc)((PetriUnitList)object).p).from.selected && ((Arc)((PetriUnitList)object).p).to.selected) {
                        arc = (Arc)((PetriUnitList)object).p;
                        petriUnit = ((Arc)((PetriUnitList)object).p).copyArc((Arc)((PetriUnitList)object).p);
                        ((Arc)petriUnit).points = ((Arc)((PetriUnitList)object).p).copyPoints();
                        PetriUnit petriUnit2 = this.findByName(((Arc)((PetriUnitList)object).p).from.name);
                        if (petriUnit2 != null) {
                            ((Arc)petriUnit).from = petriUnit2;
                        }
                        if ((petriUnit2 = this.findByName(((Arc)((PetriUnitList)object).p).to.name)) != null) {
                            ((Arc)petriUnit).to = petriUnit2;
                        }
                        if ((petriUnit2 = this.findByName(((Arc)((PetriUnitList)object).p).p.name)) != null) {
                            ((Arc)petriUnit).p = (Place)petriUnit2;
                        }
                        if ((petriUnit2 = this.findByName(((Arc)((PetriUnitList)object).p).t.name)) != null) {
                            ((Arc)petriUnit).t = (Transition)petriUnit2;
                            if (((Arc)petriUnit).toPlace) {
                                ((Arc)petriUnit).t.ArcsOut = new PetriUnitList(petriUnit, ((Arc)petriUnit).t.ArcsOut);
                            }
                        }
                        ((Arc)petriUnit).setBound();
                    }
                    object = ((PetriUnitList)object).next;
                }
                petriUnitList = petriUnitList.next;
            }
        }
    }

    Petri deepCopy(Subnet subnet) {
        this.writePetri("Current.Petri.Temp");
        Petri petri = new Petri(null);
        petri.readPetri("Current.Petri.Temp");
        return petri;
    }

    public void deepCopy1() {
        if (this.Places != null) {
            this.Places = this.Places.deepCopy1();
        }
        if (this.Transitions != null) {
            this.Transitions = this.Transitions.deepCopy1();
        }
        if (this.Subnets != null) {
            this.Subnets = this.Subnets.deepCopy1();
        }
    }

    public void deepCopy2() {
        if (this.Places != null) {
            this.Places.deepCopy2();
        }
        if (this.Transitions != null) {
            this.Transitions.deepCopy2();
        }
        if (this.Subnets != null) {
            this.Subnets.deepCopy2();
        }
    }

    public void deepCopy3() {
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet = this.ArcFromSubnet.deepCopy3();
        }
    }

    void delete(PetriUnit petriUnit) {
        if (petriUnit instanceof Arc) {
            ((Arc)petriUnit).t.delete(petriUnit);
            ((Arc)petriUnit).p.delete(petriUnit);
        }
        if (this.Places != null) {
            this.Places = this.Places.deleteByObject(petriUnit);
        }
        if (this.Transitions != null) {
            this.Transitions = this.Transitions.deleteByObject(petriUnit);
        }
        if (this.Subnets != null) {
            this.Subnets = this.Subnets.deleteByObject(petriUnit);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet = this.ArcFromSubnet.deleteByObject(petriUnit);
            if (petriUnit.getType() == 4) {
                this.ArcFromSubnet.removeArc(petriUnit);
            }
        }
        if (this.Comments != null) {
            this.Comments = this.Comments.deleteByObject(petriUnit);
        }
        if (this.HighLights != null) {
            this.HighLights = this.HighLights.deleteByObject(petriUnit);
        }
    }

    void deleteSelected() {
        if (this.Places != null) {
            this.Places = this.Places.deleteSelected();
        }
        if (this.Transitions != null) {
            this.Transitions = this.Transitions.deleteSelected();
        }
        if (this.Subnets != null) {
            this.Subnets = this.Subnets.deleteSelected();
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet = this.ArcFromSubnet.deleteSelected();
        }
        if (this.Comments != null) {
            this.Comments = this.Comments.deleteSelected();
        }
        if (this.HighLights != null) {
            this.HighLights = this.HighLights.deleteSelected();
        }
    }

    PetriUnit findByName(String string) {
        PetriUnit petriUnit;
        if (this.Places != null && (petriUnit = this.Places.findByName(string)) != null) {
            return petriUnit;
        }
        if (this.Transitions != null && (petriUnit = this.Transitions.findByName(string)) != null) {
            return petriUnit;
        }
        if (this.Subnets != null) {
            petriUnit = this.Subnets.findByName(string);
            return petriUnit;
        }
        return null;
    }

    PetriUnit findUnit() {
        if (this.Places != null) {
            return this.Places.p;
        }
        if (this.Transitions != null) {
            return this.Transitions.p;
        }
        if (this.Subnets != null) {
            return this.Subnets.p;
        }
        if (this.ArcFromSubnet != null) {
            return this.ArcFromSubnet.p;
        }
        if (this.Comments != null) {
            return this.Comments.p;
        }
        if (this.HighLights != null) {
            return this.HighLights.p;
        }
        return null;
    }

    public PetriUnitList getAllSubPlaces(PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = this.Subnets;
        while (petriUnitList2 != null) {
            petriUnitList = ((Subnet)petriUnitList2.p).getAllPlaces(petriUnitList);
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    public PetriUnitList getAllSubTrans(PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = this.Subnets;
        while (petriUnitList2 != null) {
            petriUnitList = ((Subnet)petriUnitList2.p).getAllTransitions(petriUnitList);
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    public Rectangle getBound() {
        Rectangle rectangle = new Rectangle();
        PetriUnit petriUnit = this.findUnit();
        if (petriUnit != null) {
            rectangle.setLocation(petriUnit.x, petriUnit.y);
        }
        if (this.ArcFromSubnet != null) {
            rectangle.add(this.ArcFromSubnet.getBound());
        }
        if (this.Transitions != null) {
            rectangle.add(this.Transitions.getBound());
        }
        if (this.Places != null) {
            rectangle.add(this.Places.getBound());
        }
        if (this.Subnets != null) {
            rectangle.add(this.Subnets.getBound());
        }
        if (this.Comments != null) {
            rectangle.add(this.Comments.getBound());
        }
        if (this.HighLights != null) {
            rectangle.add(this.HighLights.getBound());
        }
        return rectangle;
    }

    public void getEnabled() {
        Transition transition;
        PetriUnitList petriUnitList = this.Transitions;
        boolean bl = false;
        while (petriUnitList != null) {
            transition = (Transition)petriUnitList.p;
            transition.setEnabled();
            if (transition.isEnabled() && transition.Type) {
                bl = true;
            }
            petriUnitList = petriUnitList.next;
        }
        if (bl) {
            petriUnitList = this.Transitions;
            while (petriUnitList != null) {
                transition = (Transition)petriUnitList.p;
                if (!transition.Type) {
                    transition.Enabled = false;
                }
                petriUnitList = petriUnitList.next;
            }
        }
    }

    public boolean getEnabled(PetriUnitList petriUnitList) {
        Transition transition;
        boolean bl = false;
        PetriUnitList petriUnitList2 = petriUnitList;
        boolean bl2 = false;
        while (petriUnitList2 != null) {
            transition = (Transition)petriUnitList2.p;
            transition.setEnabled();
            if (transition.isEnabled() && transition.Type) {
                bl2 = true;
            }
            petriUnitList2 = petriUnitList2.next;
        }
        if (bl2) {
            bl = true;
            petriUnitList2 = this.Transitions;
            while (petriUnitList2 != null) {
                transition = (Transition)petriUnitList2.p;
                if (!transition.Type) {
                    transition.Enabled = false;
                }
                petriUnitList2 = petriUnitList2.next;
            }
        }
        return bl;
    }

    public String getFileName() {
        return this.FileName;
    }

    String[] getPath(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    protected String getPathFrom(PetriUnit petriUnit) {
        String string = new String();
        if (petriUnit.Parent == null) {
            string = String.valueOf(string) + "SubnetFrom:\nthis\n" + petriUnit.getName();
        } else {
            Subnet subnet = petriUnit.Parent;
            while (subnet != null) {
                string = String.valueOf(string) + "SubnetFrom:\n" + subnet.getName() + "\n";
                subnet = subnet.Parent;
            }
            string = String.valueOf(string) + petriUnit.getName();
        }
        return string;
    }

    protected String getPathTo(PetriUnit petriUnit) {
        String string = new String();
        if (petriUnit.Parent == null) {
            string = String.valueOf(string) + "SubnetTo:\nthis\n" + petriUnit.getName();
        } else {
            Subnet subnet = petriUnit.Parent;
            while (subnet != null) {
                string = String.valueOf(string) + "SubnetTo:\n" + subnet.getName() + "\n";
                subnet = subnet.Parent;
            }
            string = String.valueOf(string) + petriUnit.getName();
        }
        return string;
    }

    public Subnet getPetriSubnet(Petri petri) {
        System.out.println("Fred's here");
        if (this.Parent == null) {
            return null;
        }
        PetriUnitList petriUnitList = petri.petriParent == null ? this.Subnets : petri.petriParent.Subnets;
        while (petriUnitList != null) {
            System.out.println(((Subnet)petriUnitList.p).getFileName());
            if (((Subnet)petriUnitList.p).getPetri() == petri) {
                return (Subnet)petriUnitList.p;
            }
            petriUnitList = petriUnitList.next;
        }
        System.out.println("About to return null");
        return null;
    }

    Subnet getSubnetFromPath(String[] stringArray) {
        PetriUnitList petriUnitList = this.Subnets;
        Subnet subnet = null;
        int n = 0;
        while (n < stringArray.length) {
            subnet = this.returnSubnetByName(stringArray[n], petriUnitList);
            if (subnet == null) {
                return null;
            }
            petriUnitList = subnet.getPetri().Subnets;
            ++n;
        }
        return subnet;
    }

    protected void initLevels(Petri petri, int n) {
        petri.Level = n;
        PetriUnitList petriUnitList = petri.Places;
        while (petriUnitList != null) {
            petriUnitList.p.Level = n;
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = petri.Transitions;
        while (petriUnitList != null) {
            petriUnitList.p.Level = n;
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = petri.Subnets;
        while (petriUnitList != null) {
            this.initLevels(((Subnet)petriUnitList.p).getPetri(), ++n);
            petriUnitList = petriUnitList.next;
        }
    }

    protected boolean isCorrectLevel() {
        return false;
    }

    void moveSelected(int n, int n2) {
        if (this.Places != null) {
            this.Places.moveSelected(n, n2);
        }
        if (this.Transitions != null) {
            this.Transitions.moveSelected(n, n2);
        }
        if (this.Subnets != null) {
            this.Subnets.moveSelected(n, n2);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.moveSelected(n, n2);
        }
        if (this.Comments != null) {
            this.Comments.moveSelected(n, n2);
        }
        if (this.HighLights != null) {
            this.HighLights.moveSelected(n, n2);
        }
        this.resetBound();
    }

    void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.d.printText = !((double)this.d.scale < 0.7);
        Rectangle rectangle = graphics.getClipBounds();
        PetriUnitList.bound.setSize((int)((float)rectangle.width / this.d.scale), (int)((float)rectangle.height / this.d.scale));
        PetriUnitList.bound.setLocation((int)((float)rectangle.x / this.d.scale), (int)((float)rectangle.y / this.d.scale));
        this.d.g = graphics;
        graphics.setFont(new Font("Serif", 0, (int)(this.d.scale * 12.0f)));
        PetriUnit.fontMetrics = graphics.getFontMetrics();
        if (this.HighLights != null) {
            this.HighLights.p.setscale(this.d.scale);
            this.HighLights.paint(this.d);
        }
        if (n != -1) {
            graphics.setColor(Color.blue);
            if (n5 != 12 && n5 != 19) {
                graphics.drawLine(n, n2, n3, n4);
            }
        }
        graphics.setColor(Color.black);
        Arc.Parent = this.Parent;
        if (this.Comments != null) {
            this.Comments.p.setscale(this.d.scale);
            this.Comments.paint(this.d);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.p.setscale(this.d.scale);
            this.ArcFromSubnet.paint(this.d);
        }
        if (this.Transitions != null) {
            this.Transitions.p.setscale(this.d.scale);
            this.Transitions.paint(this.d);
        }
        if (this.Places != null) {
            this.Places.p.setscale(this.d.scale);
            this.Places.paint(this.d);
        }
        if (this.Subnets != null) {
            this.Subnets.p.setscale(this.d.scale);
            this.Subnets.paint(this.d);
        }
    }

    public void pasteSelected(Petri petri, boolean bl) {
        Object object;
        Object object2;
        this.setSelect(false);
        PetriUnitList petriUnitList = null;
        if (petri.Places != null) {
            petriUnitList = petri.Places;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Place)petriUnitList.p).copyPlace((Place)petriUnitList.p);
                    this.AddPlace((Place)object2);
                    ((PetriUnit)object2).selected = true;
                    ((Place)object2).setBound();
                    petriUnitList.p.pasname = ((PetriUnit)object2).name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Transitions != null) {
            petriUnitList = petri.Transitions;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Transition)petriUnitList.p).copyTransition((Transition)petriUnitList.p);
                    this.AddTransition((Transition)object2);
                    ((PetriUnit)object2).selected = true;
                    ((Transition)object2).setBound();
                    petriUnitList.p.pasname = ((PetriUnit)object2).name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Subnets != null) {
            petriUnitList = petri.Subnets;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Subnet)petriUnitList.p).copySubnet((Subnet)petriUnitList.p);
                    this.AddSubnet((Subnet)object2);
                    ((PetriUnit)object2).selected = true;
                    ((Subnet)object2).setBound();
                    petriUnitList.p.pasname = ((PetriUnit)object2).name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.ArcFromSubnet != null) {
            petriUnitList = petri.ArcFromSubnet;
            while (petriUnitList != null) {
                if (((Arc)petriUnitList.p).selected[0] || bl) {
                    object2 = (Arc)petriUnitList.p;
                    object = ((Arc)petriUnitList.p).copyArc((Arc)petriUnitList.p);
                    this.AddArcFromSubnet((Arc)object);
                    ((Arc)object).points = ((Arc)petriUnitList.p).copyPoints();
                    int n = 0;
                    while (n < ((Arc)object).selected.length) {
                        ((Arc)object).selected[n] = true;
                        ++n;
                    }
                    ((Arc)object).from = ((Arc)object2).from.pasname != null ? this.findByName(((Arc)object2).from.pasname) : petri.findByName(((Arc)object2).from.name);
                    ((Arc)object).to = ((Arc)object2).to.pasname != null ? this.findByName(((Arc)object2).to.pasname) : petri.findByName(((Arc)object2).to.name);
                    ((Arc)object).t = ((Arc)object2).t.pasname != null ? (Transition)this.findByName(((Arc)object2).t.pasname) : (Transition)petri.findByName(((Arc)object2).t.name);
                    ((Arc)object).p = ((Arc)object2).p.pasname != null ? (Place)this.findByName(((Arc)object2).p.pasname) : (Place)petri.findByName(((Arc)object2).p.name);
                    ((Arc)object).setBound();
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Comments != null) {
            petriUnitList = petri.Comments;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((Comment)petriUnitList.p).copyComment((Comment)petriUnitList.p);
                    this.AddComment((PetriUnit)object2);
                    ((PetriUnit)object2).selected = true;
                    ((Comment)object2).setBound();
                    petriUnitList.p.pasname = ((PetriUnit)object2).name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.HighLights != null) {
            petriUnitList = petri.HighLights;
            while (petriUnitList != null) {
                if (petriUnitList.p.selected || bl) {
                    object2 = ((HighLight)petriUnitList.p).copyHighLight((HighLight)petriUnitList.p);
                    this.AddHighLights((PetriUnit)object2);
                    ((PetriUnit)object2).selected = true;
                    ((HighLight)object2).setBound();
                    petriUnitList.p.pasname = ((PetriUnit)object2).name;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        if (petri.Transitions != null) {
            petriUnitList = petri.Transitions;
            while (petriUnitList != null) {
                object2 = ((Transition)petriUnitList.p).ArcsIn;
                while (object2 != null) {
                    if (((Arc)((PetriUnitList)object2).p).from.selected && ((Arc)((PetriUnitList)object2).p).to.selected || bl) {
                        object = (Arc)((PetriUnitList)object2).p;
                        Arc arc = ((Arc)((PetriUnitList)object2).p).copyArc((Arc)((PetriUnitList)object2).p);
                        arc.points = ((Arc)((PetriUnitList)object2).p).copyPoints();
                        int n = 0;
                        while (n < arc.selected.length) {
                            arc.selected[0] = true;
                            ++n;
                        }
                        arc.from = ((Arc)object).from.pasname != null ? this.findByName(((Arc)object).from.pasname) : petri.findByName(((Arc)object).from.name);
                        arc.to = ((Arc)object).to.pasname != null ? this.findByName(((Arc)object).to.pasname) : petri.findByName(((Arc)object).to.name);
                        if (((Arc)object).t.pasname != null) {
                            arc.t = (Transition)this.findByName(((Arc)object).t.pasname);
                            if (arc.toPlace) {
                                arc.t.ArcsOut = new PetriUnitList(arc, arc.t.ArcsOut);
                            } else {
                                arc.t.ArcsIn = new PetriUnitList(arc, arc.t.ArcsIn);
                            }
                        } else {
                            arc.t = (Transition)petri.findByName(((Arc)object).t.name);
                            if (arc.toPlace) {
                                arc.t.ArcsOut = new PetriUnitList(arc, arc.t.ArcsOut);
                            } else {
                                arc.t.ArcsIn = new PetriUnitList(arc, arc.t.ArcsIn);
                            }
                        }
                        arc.p = ((Arc)object).p.pasname != null ? (Place)this.findByName(((Arc)object).p.pasname) : (Place)petri.findByName(((Arc)object).p.name);
                        arc.setBound();
                    }
                    object2 = ((PetriUnitList)object2).next;
                }
                object = ((Transition)petriUnitList.p).ArcsOut;
                while (object != null) {
                    if (((Arc)((PetriUnitList)object).p).from.selected && ((Arc)((PetriUnitList)object).p).to.selected || bl) {
                        Arc arc = (Arc)((PetriUnitList)object).p;
                        Arc arc2 = ((Arc)((PetriUnitList)object).p).copyArc((Arc)((PetriUnitList)object).p);
                        arc2.points = ((Arc)((PetriUnitList)object).p).copyPoints();
                        int n = 0;
                        while (n < arc2.selected.length) {
                            arc2.selected[0] = true;
                            ++n;
                        }
                        arc2.from = arc.from.pasname != null ? this.findByName(arc.from.pasname) : petri.findByName(arc.from.name);
                        arc2.to = arc.to.pasname != null ? this.findByName(arc.to.pasname) : petri.findByName(arc.to.name);
                        if (arc.t.pasname != null) {
                            arc2.t = (Transition)this.findByName(arc.t.pasname);
                            if (arc2.toPlace) {
                                arc2.t.ArcsOut = new PetriUnitList(arc2, arc2.t.ArcsOut);
                            } else {
                                arc2.t.ArcsIn = new PetriUnitList(arc2, arc2.t.ArcsIn);
                            }
                        } else {
                            arc2.t = (Transition)petri.findByName(arc.t.name);
                            if (arc2.toPlace) {
                                arc2.t.ArcsOut = new PetriUnitList(arc2, arc2.t.ArcsOut);
                            } else {
                                arc2.t.ArcsIn = new PetriUnitList(arc2, arc2.t.ArcsIn);
                            }
                        }
                        arc2.p = arc.p.pasname != null ? (Place)this.findByName(arc.p.pasname) : (Place)petri.findByName(arc.p.name);
                        arc2.setBound();
                    }
                    object = ((PetriUnitList)object).next;
                }
                petriUnitList = petriUnitList.next;
            }
        }
        this.resetBound();
    }

    void print() {
        if (this.Places != null) {
            this.Places.print();
        }
        if (this.Transitions != null) {
            this.Transitions.print();
        }
        if (this.Subnets != null) {
            this.Subnets.print();
            Petri petri = ((Subnet)this.Subnets.p).getPetri();
            petri.print();
        }
    }

    public void print(Graphics graphics) {
        Rectangle rectangle;
        this.printToFit = DFrame.MyFrame.PrintToFit.isSelected();
        this.printScale = DFrame.MyFrame.scale;
        Rectangle rectangle2 = new Rectangle(((PrintGraphics)((Object)graphics)).getPrintJob().getPageDimension());
        if (this.printRect == null) {
            rectangle = this.getBound();
            rectangle.width += 20;
            rectangle.height += 20;
        } else {
            rectangle = new Rectangle(this.printRect);
            rectangle.x = (int)((float)rectangle.x / this.d.scale);
            rectangle.y = (int)((float)rectangle.y / this.d.scale);
            rectangle.width = (int)((float)rectangle.width / this.d.scale);
            rectangle.height = (int)((float)rectangle.height / this.d.scale);
        }
        PrintDraw printDraw = new PrintDraw(graphics, 1.0f);
        if (this.printToFit) {
            printDraw.scale = (float)rectangle2.width / (float)rectangle.width;
            if ((float)rectangle2.height / (float)rectangle.height < printDraw.scale) {
                printDraw.scale = rectangle2.height / rectangle.height;
            }
        } else {
            printDraw.scale = this.printScale;
        }
        if ((double)printDraw.scale < 0.2) {
            printDraw.printText = false;
        }
        graphics.translate((int)((float)(-rectangle.x) * printDraw.scale), (int)((float)(-rectangle.y) * printDraw.scale));
        PetriUnitList.bound.setSize(rectangle.width, rectangle.height);
        PetriUnitList.bound.setLocation(rectangle.x, rectangle.y);
        graphics.setFont(new Font("Serif", 0, (int)(printDraw.scale * 12.0f)));
        PetriUnit.fontMetrics = graphics.getFontMetrics();
        if (this.HighLights != null) {
            this.HighLights.p.setscale(printDraw.scale);
            this.HighLights.paint(printDraw);
        }
        graphics.setColor(Color.black);
        if (this.Comments != null) {
            this.Comments.p.setscale(printDraw.scale);
            this.Comments.paint(printDraw);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.p.setscale(printDraw.scale);
            this.ArcFromSubnet.paint(printDraw);
        }
        if (this.Transitions != null) {
            this.Transitions.p.setscale(printDraw.scale);
            this.Transitions.paint(printDraw);
        }
        if (this.Places != null) {
            this.Places.p.setscale(printDraw.scale);
            this.Places.paint(printDraw);
        }
        if (this.Subnets != null) {
            this.Subnets.p.setscale(printDraw.scale);
            this.Subnets.paint(printDraw);
        }
        System.gc();
    }

    /*
     * Exception decompiling
     */
    protected void readArcs(BufferedReader var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 2[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void readComments(BufferedReader bufferedReader) throws IOException {
        String string = new String();
        string = bufferedReader.readLine();
        while (!string.equals("Comments [")) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        while (stringTokenizer.hasMoreTokens()) {
            int n = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = new String(String.valueOf(string2) + " " + stringTokenizer.nextToken("\n"));
            }
            Comment comment = new Comment(n, n2, string2);
            this.AddComment(comment);
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        }
    }

    protected void readHighLights(BufferedReader bufferedReader) throws IOException {
        String string = new String();
        string = bufferedReader.readLine();
        while (!string.equals("HighLights [")) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        while (stringTokenizer.hasMoreTokens()) {
            int n = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            int n3 = new Integer(stringTokenizer.nextToken());
            int n4 = new Integer(stringTokenizer.nextToken());
            Color color = new Color(new Integer(stringTokenizer.nextToken()));
            Color color2 = new Color(new Integer(stringTokenizer.nextToken()));
            HighLight highLight = new HighLight(n, n2, n3 + n, n4 + n2, color, color2);
            this.AddHighLights(highLight);
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        }
    }

    public int readPetri(String string) {
        this.FileName = string;
        BufferedReader bufferedReader = null;
        try {
            try {
                boolean bl = false;
                bufferedReader = new BufferedReader(new FileReader(string));
                if (lPetri == null) {
                    this.petriParent = null;
                    lPetri = this;
                    bl = true;
                }
                this.readPlaces(bufferedReader);
                this.readTransitions(bufferedReader);
                this.readSubnets(bufferedReader);
                this.readArcs(bufferedReader);
                this.readComments(bufferedReader);
                this.readHighLights(bufferedReader);
                if (bl) {
                    lPetri = null;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                int n = -1;
                Object var5_7 = null;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                return n;
            }
            catch (IOException iOException) {
                int n = -1;
                Object var5_8 = null;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                return n;
            }
            catch (Exception exception) {
                int n = -1;
                Object var5_9 = null;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {}
                return n;
            }
            Object var5_10 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        return 0;
    }

    protected void readPlaces(BufferedReader bufferedReader) throws IOException {
        String string = new String();
        string = bufferedReader.readLine();
        while (!string.equals("Places [")) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        while (stringTokenizer.hasMoreTokens()) {
            int n = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            int n3 = new Integer(stringTokenizer.nextToken());
            int n4 = new Integer(stringTokenizer.nextToken());
            int n5 = new Integer(stringTokenizer.nextToken());
            boolean bl = stringTokenizer.nextToken().equals("isPip");
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = new String(String.valueOf(string2) + stringTokenizer.nextToken("\n"));
            }
            System.out.println(">>>>> Place name=" + string2);
            Place place = new Place(n, n2, string2, n3, n5, bl, this.Parent);
            ++this.LowestPlace;
            this.Places = new PetriUnitList(place, this.Places);
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        }
    }

    protected void readSubnets(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (!string.equals("Subnets [")) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        while (stringTokenizer.hasMoreTokens()) {
            Subnet subnet;
            System.out.println("11111111111111111");
            int n = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            System.out.println("Subnet Filename =" + string2);
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = new String(String.valueOf(string3) + stringTokenizer.nextToken("\n"));
            }
            System.out.println(">>>> Subnet name=" + string3);
            if (this.TopLevelPetri) {
                subnet = null;
            } else {
                System.out.println("222222222222");
                subnet = this.getPetriSubnet(this);
                System.out.println("33333333333333333");
                if (subnet == null) {
                    System.out.println("Error getting Subnet");
                }
            }
            System.out.println("44444444444444444");
            Subnet subnet2 = new Subnet(n, n2, string3, string2, subnet, true);
            if (subnet2.getPetri() == null) {
                throw new IOException();
            }
            System.out.println("555555555555555");
            ++this.LowestSubnet;
            this.AddSubnet(subnet2);
            subnet2.getPetri().petriParent = this;
            subnet2.getPetri().readPetri(string2);
            System.out.println("666666666666666");
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        }
    }

    protected void readTransitions(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (!string.equals("Transitions [")) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        while (stringTokenizer.hasMoreTokens()) {
            int n = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            boolean bl = !stringTokenizer.nextToken().equals("horizontal");
            boolean bl2 = !stringTokenizer.nextToken().equals("timed");
            double d = new Double(stringTokenizer.nextToken());
            boolean bl3 = !stringTokenizer.nextToken().equals("notTip");
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = new String(String.valueOf(string2) + stringTokenizer.nextToken("\n"));
            }
            Transition transition = new Transition(n, n2, string2, d, bl2, bl, bl3, this.Parent);
            ++this.LowestTransition;
            this.Transitions = new PetriUnitList(transition, this.Transitions);
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "(,) ]");
        }
    }

    public void resetBound() {
        if (this.Places != null) {
            this.Places.resetBound();
        }
        if (this.Transitions != null) {
            this.Transitions.resetBound();
        }
        if (this.Subnets != null) {
            this.Subnets.resetBound();
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.resetBound();
        }
        if (this.Comments != null) {
            this.Comments.resetBound();
        }
        if (this.HighLights != null) {
            this.HighLights.resetBound();
        }
    }

    void resetScale() {
        if (this.Comments != null) {
            this.Comments.p.setscale(this.d.scale);
            this.Comments.setBound();
        }
        if (this.HighLights != null) {
            this.HighLights.p.setscale(this.d.scale);
            this.HighLights.setBound();
        }
        if (this.Places != null) {
            this.Places.p.setscale(this.d.scale);
            this.Places.setBound();
        }
        if (this.Transitions != null) {
            this.Transitions.p.setscale(this.d.scale);
            this.Transitions.setBound();
        }
        if (this.Subnets != null) {
            this.Subnets.p.setscale(this.d.scale);
            this.Subnets.setBound();
        }
    }

    public PetriUnitList retrieveEnabled(PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = petriUnitList;
        PetriUnitList petriUnitList3 = null;
        boolean bl = false;
        while (petriUnitList2 != null) {
            if (((Transition)petriUnitList2.p).Type) {
                ((Transition)petriUnitList2.p).setEnabled();
                if (((Transition)petriUnitList2.p).isEnabled()) {
                    bl = true;
                    break;
                }
            }
            petriUnitList2 = petriUnitList2.next;
        }
        if (bl) {
            petriUnitList2 = petriUnitList;
            while (petriUnitList2 != null) {
                Transition transition = (Transition)petriUnitList2.p;
                if (transition.Type) {
                    transition.setEnabled();
                    if (transition.isEnabled()) {
                        petriUnitList3 = new PetriUnitList(transition, petriUnitList3);
                    }
                } else {
                    transition.Enabled = false;
                }
                petriUnitList2 = petriUnitList2.next;
            }
        } else {
            petriUnitList2 = petriUnitList;
            while (petriUnitList2 != null) {
                Transition transition = (Transition)petriUnitList2.p;
                transition.setEnabled();
                if (transition.isEnabled()) {
                    petriUnitList3 = new PetriUnitList(transition, petriUnitList3);
                }
                petriUnitList2 = petriUnitList2.next;
            }
        }
        return petriUnitList3;
    }

    Subnet returnSubnetByName(String string, PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = petriUnitList;
        while (petriUnitList2 != null) {
            if (petriUnitList2.p.getName().equals(string)) {
                return (Subnet)petriUnitList2.p;
            }
            petriUnitList2 = petriUnitList2.next;
        }
        return null;
    }

    public PetriUnitList reverseList(PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = null;
        PetriUnitList petriUnitList3 = new PetriUnitList();
        if (petriUnitList == null) {
            return null;
        }
        petriUnitList3.p = petriUnitList.p;
        petriUnitList3.next = null;
        if (petriUnitList.next == null) {
            petriUnitList2 = petriUnitList3;
        }
        PetriUnitList petriUnitList4 = petriUnitList.next;
        while (petriUnitList4 != null) {
            petriUnitList2 = new PetriUnitList();
            petriUnitList2.p = petriUnitList4.p;
            petriUnitList2.next = petriUnitList3;
            petriUnitList3 = petriUnitList2;
            petriUnitList4 = petriUnitList4.next;
        }
        return petriUnitList2;
    }

    public void setEnabledSubnets() {
        PetriUnitList petriUnitList = this.Subnets;
        while (petriUnitList != null) {
            ((Subnet)petriUnitList.p).isEnabled();
            petriUnitList = petriUnitList.next;
        }
    }

    public void setFileName(String string) {
        this.FileName = string;
    }

    public void setSelect(boolean bl) {
        if (this.Places != null) {
            this.Places.setSelect(bl);
        }
        if (this.Transitions != null) {
            this.Transitions.setSelect(bl);
        }
        if (this.Subnets != null) {
            this.Subnets.setSelect(bl);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.setSelect(bl);
        }
        if (this.Comments != null) {
            this.Comments.setSelect(bl);
        }
        if (this.HighLights != null) {
            this.HighLights.setSelect(bl);
        }
    }

    public void setSelect(boolean bl, Rectangle rectangle) {
        if (this.Places != null) {
            this.Places.setSelect(bl, rectangle);
        }
        if (this.Transitions != null) {
            this.Transitions.setSelect(bl, rectangle);
        }
        if (this.Subnets != null) {
            this.Subnets.setSelect(bl, rectangle);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.setSelect(bl, rectangle);
        }
        if (this.Comments != null) {
            this.Comments.setSelect(bl, rectangle);
        }
        if (this.HighLights != null) {
            this.HighLights.setSelect(bl, rectangle);
        }
    }

    public void toggleSelect(Rectangle rectangle) {
        if (this.Places != null) {
            this.Places.toggleSelect(rectangle);
        }
        if (this.Transitions != null) {
            this.Transitions.toggleSelect(rectangle);
        }
        if (this.Subnets != null) {
            this.Subnets.toggleSelect(rectangle);
        }
        if (this.ArcFromSubnet != null) {
            this.ArcFromSubnet.toggleSelect(rectangle);
        }
        if (this.Comments != null) {
            this.Comments.toggleSelect(rectangle);
        }
        if (this.HighLights != null) {
            this.HighLights.toggleSelect(rectangle);
        }
    }

    public boolean validName(PetriUnit petriUnit) {
        if (petriUnit instanceof Arc || petriUnit instanceof HighLight || petriUnit instanceof Comment) {
            return true;
        }
        PetriUnitList petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            if (petriUnit.name.equals(petriUnitList.p.getName()) && petriUnit != petriUnitList.p) {
                return false;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Places;
        while (petriUnitList != null) {
            if (petriUnit.name.equals(petriUnitList.p.getName()) && petriUnit != petriUnitList.p) {
                return false;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Subnets;
        while (petriUnitList != null) {
            if (petriUnit.name.equals(petriUnitList.p.getName()) && petriUnit != petriUnitList.p) {
                return false;
            }
            petriUnitList = petriUnitList.next;
        }
        return true;
    }

    protected void writeArcs(PrintWriter printWriter) {
        PetriUnitList petriUnitList;
        String string = new String();
        PetriUnitList petriUnitList2 = petriUnitList = this.reverseList(this.Transitions);
        while (petriUnitList2 != null) {
            int n;
            Arc arc;
            Transition transition = (Transition)petriUnitList2.p;
            PetriUnitList petriUnitList3 = transition.ArcsIn;
            while (petriUnitList3 != null) {
                string = new String();
                string = String.valueOf(string) + "Edge (\n";
                arc = (Arc)petriUnitList3.p;
                if (arc.p.Level >= this.Level && transition.Level >= this.Level) {
                    string = String.valueOf(string) + arc.weight + "\n";
                    string = String.valueOf(string) + arc.type + "\n";
                    n = 0;
                    while (n < arc.numpoints) {
                        string = String.valueOf(string) + "(" + arc.points[n].x + "," + arc.points[n].y + ") ";
                        ++n;
                    }
                    string = String.valueOf(string) + "\n";
                    string = String.valueOf(string) + this.getPathFrom(arc.p) + "\n";
                    string = String.valueOf(string) + this.getPathTo(transition);
                    printWriter.println(String.valueOf(string) + "\n)");
                }
                petriUnitList3 = petriUnitList3.next;
            }
            petriUnitList3 = transition.ArcsOut;
            while (petriUnitList3 != null) {
                string = new String();
                string = String.valueOf(string) + "Edge (\n";
                arc = (Arc)petriUnitList3.p;
                if (arc.p.Level >= this.Level && transition.Level >= this.Level) {
                    string = String.valueOf(string) + arc.weight + "\n";
                    string = String.valueOf(string) + arc.type + "\n";
                    n = 0;
                    while (n < arc.numpoints) {
                        string = String.valueOf(string) + "(" + arc.points[n].x + "," + arc.points[n].y + ") ";
                        ++n;
                    }
                    string = String.valueOf(string) + "\n";
                    string = String.valueOf(string) + this.getPathFrom(transition) + "\n";
                    string = String.valueOf(string) + this.getPathTo(arc.p);
                    printWriter.println(String.valueOf(string) + "\n)");
                }
                petriUnitList3 = petriUnitList3.next;
            }
            petriUnitList2 = petriUnitList2.next;
        }
    }

    protected void writeComments(PrintWriter printWriter) {
        String string = new String();
        PetriUnitList petriUnitList = this.Comments;
        while (petriUnitList != null) {
            string = new String();
            Comment comment = (Comment)petriUnitList.p;
            string = String.valueOf(string) + "(" + comment.x + "," + comment.y + ") ";
            string = String.valueOf(string) + comment.getName();
            printWriter.println(string);
            petriUnitList = petriUnitList.next;
        }
    }

    protected void writeHighLights(PrintWriter printWriter) {
        String string = new String();
        PetriUnitList petriUnitList = this.HighLights;
        while (petriUnitList != null) {
            string = new String();
            HighLight highLight = (HighLight)petriUnitList.p;
            string = String.valueOf(string) + "(" + highLight.x + "," + highLight.y + ") ";
            string = String.valueOf(string) + "(" + highLight.x2 + "," + highLight.y2 + ") ";
            string = String.valueOf(string) + highLight.drawColor.getRGB() + " ";
            string = String.valueOf(string) + highLight.fillColor.getRGB();
            printWriter.println(string);
            petriUnitList = petriUnitList.next;
        }
    }

    public void writePetri(String string) {
        try {
            this.FileName = string;
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            if (!string.endsWith(".bim")) {
                string = String.valueOf(string) + ".bim";
            }
            if (this.TopLevelPetri) {
                this.initLevels(this, 1);
            }
            printWriter.println("#PetriNet");
            PetriUnitList petriUnitList = this.Subnets;
            while (petriUnitList != null) {
                this.writeSubnet((Subnet)petriUnitList.p);
                petriUnitList = petriUnitList.next;
            }
            String string2 = new String("Places [");
            printWriter.println(string2);
            this.writePlaces(printWriter);
            printWriter.println("]\n");
            string2 = new String("Transitions [");
            printWriter.println(string2);
            this.writeTransitions(printWriter);
            printWriter.println("]\n");
            string2 = new String("Subnets [");
            printWriter.println(string2);
            this.writeSubnets(printWriter);
            printWriter.println("]\n");
            string2 = new String("Arcs [");
            printWriter.println(string2);
            this.writeArcs(printWriter);
            this.writeSubnetArcs(printWriter);
            printWriter.println("]");
            string2 = new String("Comments [");
            printWriter.println(string2);
            this.writeComments(printWriter);
            printWriter.println("]");
            string2 = new String("HighLights [");
            printWriter.println(string2);
            this.writeHighLights(printWriter);
            printWriter.println("]");
            printWriter.close();
        }
        catch (Exception exception) {}
    }

    protected void writePlaces(PrintWriter printWriter) {
        PetriUnitList petriUnitList;
        String string = new String();
        PetriUnitList petriUnitList2 = petriUnitList = this.reverseList(this.Places);
        while (petriUnitList2 != null) {
            string = new String();
            Place place = (Place)petriUnitList2.p;
            string = "(" + place.getCenterX() + "," + place.getCenterY() + ")";
            string = String.valueOf(string) + " " + place.initTokens + " " + place.tokens + " " + place.limit;
            string = place.isiPs() ? String.valueOf(string) + " isPip " : String.valueOf(string) + " notPip";
            string = String.valueOf(string) + " " + place.getName();
            printWriter.println(string);
            petriUnitList2 = petriUnitList2.next;
        }
    }

    protected void writeSubnet(Subnet subnet) {
        String string = subnet.getFileName();
        if (string.endsWith(".wam")) {
            string = String.valueOf(string.substring(0, string.length() - 3)) + "bim";
        }
        subnet.setFileName(string);
        subnet.getPetri().print();
    }

    protected void writeSubnetArcs(PrintWriter printWriter) {
        String string = new String();
        PetriUnitList petriUnitList = this.Subnets;
        while (petriUnitList != null) {
            Subnet subnet = (Subnet)petriUnitList.p;
            PetriUnitList petriUnitList2 = subnet.getPetri().Transitions;
            while (petriUnitList2 != null) {
                Transition transition = (Transition)petriUnitList2.p;
                if (transition.isiPs()) {
                    int n;
                    Arc arc;
                    PetriUnitList petriUnitList3 = transition.ArcsIn;
                    while (petriUnitList3 != null) {
                        arc = (Arc)petriUnitList3.p;
                        if (arc.p.Level >= this.Level && transition.Level >= this.Level && arc.p.getParent() != transition.getParent()) {
                            string = new String();
                            string = String.valueOf(string) + "Edge (\n";
                            string = String.valueOf(string) + arc.weight + "\n";
                            string = String.valueOf(string) + arc.type + "\n";
                            n = 0;
                            while (n < arc.numpoints) {
                                string = String.valueOf(string) + "(" + arc.points[n].x + "," + arc.points[n].y + ") ";
                                ++n;
                            }
                            string = String.valueOf(string) + "\n";
                            string = String.valueOf(string) + this.getPathFrom(arc.p) + "\n";
                            string = String.valueOf(string) + this.getPathTo(transition) + "\n";
                            printWriter.println(String.valueOf(string) + ")\n");
                        }
                        petriUnitList3 = petriUnitList3.next;
                    }
                    petriUnitList3 = transition.ArcsOut;
                    while (petriUnitList3 != null) {
                        arc = (Arc)petriUnitList3.p;
                        if (arc.p.Level >= this.Level && transition.Level >= this.Level && arc.p.getParent() != transition.getParent()) {
                            string = new String();
                            string = String.valueOf(string) + "Edge (\n";
                            string = String.valueOf(string) + arc.weight + "\n";
                            string = String.valueOf(string) + arc.type + "\n";
                            n = 0;
                            while (n < arc.numpoints) {
                                string = String.valueOf(string) + "(" + arc.points[n].x + "," + arc.points[n].y + ") ";
                                ++n;
                            }
                            string = String.valueOf(string) + "\n";
                            string = String.valueOf(string) + this.getPathFrom(transition) + "\n";
                            string = String.valueOf(string) + this.getPathTo(arc.p) + "\n";
                            printWriter.println(String.valueOf(string) + ")\n");
                        }
                        petriUnitList3 = petriUnitList3.next;
                    }
                }
                petriUnitList2 = petriUnitList2.next;
            }
            petriUnitList = petriUnitList.next;
        }
    }

    protected void writeSubnets(PrintWriter printWriter) {
        String string = new String();
        PetriUnitList petriUnitList = this.Subnets;
        while (petriUnitList != null) {
            string = new String();
            Subnet subnet = (Subnet)petriUnitList.p;
            string = String.valueOf(string) + "(" + subnet.getCenterX() + "," + subnet.getCenterY() + ")";
            string = String.valueOf(string) + " " + subnet.getFileName();
            string = String.valueOf(string) + " " + subnet.getName();
            printWriter.println(string);
            petriUnitList = petriUnitList.next;
        }
    }

    protected void writeTransitions(PrintWriter printWriter) {
        PetriUnitList petriUnitList;
        String string = new String();
        PetriUnitList petriUnitList2 = petriUnitList = this.reverseList(this.Transitions);
        while (petriUnitList2 != null) {
            string = new String();
            Transition transition = (Transition)petriUnitList2.p;
            string = String.valueOf(string) + "(" + transition.getCenterX() + "," + transition.getCenterY() + ")";
            string = transition.Orientation ? String.valueOf(string) + " vertical" : String.valueOf(string) + " horizontal";
            string = transition.Type ? String.valueOf(string) + " immediate" : String.valueOf(string) + " timed";
            string = String.valueOf(string) + " " + transition.Rate;
            string = transition.isiPs() ? String.valueOf(string) + " isTip " : String.valueOf(string) + " notTip ";
            string = String.valueOf(string) + transition.getName();
            printWriter.println(string);
            petriUnitList2 = petriUnitList2.next;
        }
    }
}

