/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.Comment;
import DaNAMiCS.DFrame;
import DaNAMiCS.HighLight;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.PrintCanvas;
import DaNAMiCS.Subnet;
import DaNAMiCS.Transition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class PetriCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener,
InternalFrameListener {
    public static final int NOTHING = 0;
    public static final int PLACE = 1;
    public static final int ARC = 2;
    public static final int TRANSITION = 3;
    public static final int TOKEN = 4;
    public static final int TOGGLETRANS = 5;
    public static final int TOGGLEIMM = 6;
    public static final int TOGGLEIP = 22;
    public static final int DESTROY = 7;
    public static final int MOVE = 8;
    public static final int REMHANDLE = 9;
    public static final int ADDHANDLE = 10;
    public static final int LABELPOS = 11;
    public static final int SELECT = 12;
    public static final int PROPERTIES = 13;
    public static final int STRAIGHT = 14;
    public static final int SUBNET = 15;
    public static final int OPENSUBNET = 16;
    public static final int INHIBITOR = 17;
    public static final int COMMENT = 18;
    public static final int HIGHLIGHT = 19;
    public static final int ANIMATE = 20;
    public static final int IMMEDIATE = 21;
    public static final int CONTROL_ARCSET = 23;
    public Petri p = null;
    public PetriUnit MultiSource = null;
    public PetriUnit MultiDestination = null;
    public PetriUnitList FiredTransitions;
    public int action = 0;
    int x;
    int y;
    int x2;
    int y2;
    int oldx2;
    int oldy2;
    PetriUnit P = null;
    Subnet Parent;
    int xGrid;
    int yGrid;
    int inc;
    int dx = 0;
    int dy = 0;
    boolean paintGrid = false;
    int placecount = 0;
    JDialog SFD;
    JTextField SFDsname;
    JTextField SFDfname;
    String sname;
    String fname;
    boolean no = false;
    boolean gotfocus = true;
    boolean cancelled = false;
    Rectangle maxbound;
    Rectangle bound = this.maxbound = new Rectangle(0, 0, 10000, 10000);
    Rectangle useBound = new Rectangle();
    Rectangle arcBound = null;

    PetriCanvas(Subnet subnet) {
        this.Parent = subnet;
        this.x = -1;
        this.action = 1;
        this.xGrid = 10;
        this.yGrid = 10;
        this.setPreferredSize(new Dimension(10000, 10000));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void SFDsnameAction(ActionEvent actionEvent) {
        this.sname = new String(this.SFDsname.getText());
        this.fname = new String(this.SFDfname.getText());
        this.SFD.dispose();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "Place") {
            this.action = 1;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarPlace, DFrame.MyFrame.PlaceIconSel);
        } else if (actionEvent.getActionCommand() == "Arc") {
            this.action = 2;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarArc, DFrame.MyFrame.ArcIconSel);
        } else if (actionEvent.getActionCommand() == "Transition") {
            this.action = 3;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarTransition, DFrame.MyFrame.TransIconSel);
        } else if (actionEvent.getActionCommand() == "ImmediateTransition") {
            this.action = 21;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarImmediateTransition, DFrame.MyFrame.ImtraIconSel);
        } else if (actionEvent.getActionCommand() == "Add Tokens") {
            this.action = 4;
            this.inc = 1;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarAddTokens, DFrame.MyFrame.AddtokIconSel);
        } else if (actionEvent.getActionCommand() == "Remove Tokens") {
            this.action = 4;
            this.inc = -1;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarRemoveTokens, DFrame.MyFrame.SubtokIconSel);
        } else if (actionEvent.getActionCommand() == "ToggleTransition") {
            this.action = 5;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarToggleTrans, DFrame.MyFrame.ToggleIconSel);
        } else if (actionEvent.getActionCommand() == "ToggleIP") {
            this.action = 22;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarToggleIP, DFrame.MyFrame.TglipIconSel);
        } else if (actionEvent.getActionCommand() == "ToggleImm") {
            this.action = 6;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarToggleImm, DFrame.MyFrame.ToggleIconImmSel);
        } else if (actionEvent.getActionCommand() == "Destroy") {
            this.action = 7;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarDestroy, DFrame.MyFrame.DesIconSel);
        } else if (actionEvent.getActionCommand() == "Move") {
            this.action = 8;
            this.setCursor(new Cursor(13));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarMove, DFrame.MyFrame.MoveIconSel);
        } else if (actionEvent.getActionCommand() == "Remove Handle") {
            this.action = 9;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarRemoveHandle, DFrame.MyFrame.SubhanIconSel);
        } else if (actionEvent.getActionCommand() == "Add Handle") {
            this.action = 10;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarAddHandle, DFrame.MyFrame.AddhanIconSel);
        } else if (actionEvent.getActionCommand() == "Label Pos") {
            this.action = 11;
            this.setCursor(new Cursor(1));
        } else if (actionEvent.getActionCommand() == "Select") {
            this.action = 12;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarSelect, DFrame.MyFrame.SelIconSel);
        } else if (actionEvent.getActionCommand() == "Text") {
            this.action = 13;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarText, DFrame.MyFrame.TextIconSel);
        } else if (actionEvent.getActionCommand() == "Straight") {
            this.action = 14;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarStr, DFrame.MyFrame.StrlIconSel);
        } else if (actionEvent.getActionCommand() == "Subnet") {
            this.action = 15;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarSubnet, DFrame.MyFrame.SubIconSel);
        } else if (actionEvent.getActionCommand() == "OpenSubnet") {
            this.action = 16;
            this.setCursor(new Cursor(12));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarOpenSubnet, DFrame.MyFrame.ZoomIconSel);
        } else if (actionEvent.getActionCommand() == "Inhibitor") {
            this.action = 17;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarInhibitor, DFrame.MyFrame.InhIconSel);
        } else if (actionEvent.getActionCommand() == "Comment") {
            this.action = 18;
            this.setCursor(new Cursor(2));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarComment, DFrame.MyFrame.CommIconSel);
        } else if (actionEvent.getActionCommand() == "Highlight") {
            this.action = 19;
            this.setCursor(new Cursor(1));
            DFrame.MyFrame.setSelectedIcon(DFrame.MyFrame.DToolBarHighlight, DFrame.MyFrame.HighIconSel);
        } else if (actionEvent.getActionCommand() == "Select All") {
            this.p.setSelect(true);
        } else if (actionEvent.getActionCommand() == "Deselect All") {
            this.p.setSelect(false);
        } else {
            if (!this.gotfocus) {
                return;
            }
            if (actionEvent.getActionCommand() == "Print") {
                this.action = 0;
                DFrame.MyFrame.setSelectedIcon(null, null);
                Frame frame = new Frame("Printing Test");
                PrintCanvas printCanvas = new PrintCanvas(this.p);
                frame.add("Center", printCanvas);
                frame.pack();
                PrintJob printJob = this.getToolkit().getPrintJob(frame, "Printing Test", null);
                if (printJob != null) {
                    Graphics graphics = printJob.getGraphics();
                    if (graphics != null) {
                        printCanvas.print(graphics);
                        graphics.dispose();
                    }
                    printJob.end();
                }
            } else if (actionEvent.getActionCommand() == "Scale Up") {
                if (this.p.d.scale < 3.0f) {
                    this.p.d.scale = (float)((double)this.p.d.scale * 1.1);
                    this.p.resetScale();
                    this.setSize(new Dimension((int)(10000.0f * this.p.d.scale), (int)(10000.0f * this.p.d.scale)));
                    this.repaint();
                    return;
                }
            } else if (actionEvent.getActionCommand() == "Scale Down" && (double)this.p.d.scale > 0.3) {
                this.p.d.scale = (float)((double)this.p.d.scale / 1.1);
                this.p.resetScale();
                this.setSize(new Dimension((int)(10000.0f * this.p.d.scale), (int)(10000.0f * this.p.d.scale)));
                this.repaint();
                return;
            }
        }
    }

    public void browseAction(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)DFrame.MyFrame, "Open DaNAMiCS file");
        fileDialog.show();
        this.fname = fileDialog.getFile();
        this.SFDfname.setText(this.fname);
    }

    public void cancelAction(ActionEvent actionEvent) {
        this.no = true;
        this.SFD.dispose();
    }

    PetriCanvas deepCopy() {
        PetriCanvas petriCanvas = new PetriCanvas(null);
        if (this.p != null) {
            petriCanvas.p = this.p.deepCopy(null);
        }
        return petriCanvas;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = true;
        DFrame.c = this;
        DFrame.p = this.p;
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        if (this.p.changed) {
            DFrame.MyFrame.DMainMenuBarFileSaveAction(this.p);
        }
        DFrame.MyFrame.internalWindowPanel.deletePetri2(this);
        DFrame.MyFrame.makeMainMenuBarWindow(DFrame.MyFrame.DMainMenuBarWindow);
        this.gotfocus = false;
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = false;
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = false;
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = true;
        DFrame.c = this;
        DFrame.p = this.p;
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = false;
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        this.gotfocus = true;
        DFrame.c = this;
        DFrame.p = this.p;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.action) {
            case 8: {
                if (this.P != null) {
                    this.dx += (int)((float)mouseEvent.getPoint().x / this.p.d.scale) - this.x2;
                    this.dy += (int)((float)mouseEvent.getPoint().y / this.p.d.scale) - this.y2;
                    this.x2 = (int)((float)mouseEvent.getPoint().x / this.p.d.scale);
                    this.y2 = (int)((float)mouseEvent.getPoint().y / this.p.d.scale);
                    if (this.P.isSelected()) {
                        this.p.moveSelected((this.dx + this.xGrid / 2) / this.xGrid * this.xGrid, (this.dy + this.yGrid / 2) / this.yGrid * this.yGrid);
                        this.bound = this.maxbound;
                    } else {
                        this.P.move((this.dx + this.xGrid / 2) / this.xGrid * this.xGrid, (this.dy + this.yGrid / 2) / this.yGrid * this.yGrid);
                        this.P.resetBound();
                        this.bound = this.arcBound;
                        Rectangle rectangle = this.P.moveBound();
                        this.bound.add(rectangle.x - 10, rectangle.y - 10);
                        this.bound.add(rectangle.x + rectangle.width + 10, rectangle.y + rectangle.height + 10);
                    }
                    this.dx -= (this.dx + this.xGrid / 2) / this.xGrid * this.xGrid;
                    this.dy -= (this.dy + this.yGrid / 2) / this.yGrid * this.yGrid;
                }
                this.repaint();
                return;
            }
            case 2: 
            case 14: 
            case 17: {
                if (this.x == -1) {
                    return;
                }
            }
            case 12: 
            case 19: {
                this.x2 = mouseEvent.getPoint().x;
                this.y2 = mouseEvent.getPoint().y;
                this.bound = this.arcBound;
                this.bound.add((int)((float)this.x2 / this.p.d.scale) - 10, (int)((float)this.y2 / this.p.d.scale) - 10);
                this.bound.add((int)((float)this.x2 / this.p.d.scale) + 10, (int)((float)this.y2 / this.p.d.scale) + 10);
                this.bound.add((int)((float)this.x / this.p.d.scale) - 10, (int)((float)this.y / this.p.d.scale) - 10);
                this.bound.add((int)((float)this.x / this.p.d.scale) + 10, (int)((float)this.y / this.p.d.scale) + 10);
                this.repaint();
                return;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = (int)((float)mouseEvent.getPoint().x / this.p.d.scale);
        int n2 = (int)((float)mouseEvent.getPoint().y / this.p.d.scale);
        switch (this.action) {
            case 8: {
                this.P = this.p.FindAll(n, n2);
                if (this.P != null) {
                    this.arcBound = new Rectangle(this.P.moveBound());
                }
                this.x2 = (int)((float)mouseEvent.getPoint().x / this.p.d.scale);
                this.y2 = (int)((float)mouseEvent.getPoint().y / this.p.d.scale);
                this.dx = 0;
                this.dy = 0;
                return;
            }
            case 2: 
            case 14: 
            case 17: {
                this.P = this.p.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                this.arcBound = new Rectangle();
                this.arcBound.setLocation(n - 10, n2 - 10);
                this.arcBound.add(n + 10, n2 + 10);
                this.x = this.x2 = (int)((float)this.P.getCenterX() * this.p.d.scale);
                this.y = this.y2 = (int)((float)this.P.getCenterY() * this.p.d.scale);
                return;
            }
            case 12: 
            case 19: {
                this.arcBound = new Rectangle();
                this.arcBound.setLocation(n, n2);
                this.arcBound.add(n + 10, n2 + 10);
                this.arcBound.add(n - 10, n2 - 10);
                this.x = this.x2 = n;
                this.y = this.y2 = n2;
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = (int)((float)mouseEvent.getPoint().x / this.p.d.scale);
        int n2 = (int)((float)mouseEvent.getPoint().y / this.p.d.scale);
        int n3 = (n + this.xGrid / 2) / this.xGrid * this.xGrid;
        int n4 = (n2 + this.yGrid / 2) / this.yGrid * this.yGrid;
        if (!mouseEvent.isControlDown()) {
            this.MultiSource = null;
        }
        switch (this.action) {
            case 18: {
                this.p.changed = true;
                Comment comment = new Comment(n3, n4, "");
                comment.dialog();
                if (comment.name.length() != 0) {
                    this.p.AddComment(comment);
                    comment.setBound();
                    this.bound = comment.bound;
                    this.repaint();
                    return;
                }
                return;
            }
            case 1: {
                ++this.placecount;
                this.p.changed = true;
                Place place = new Place(n3, n4, "", 0, null);
                this.p.AddPlace(place);
                this.bound = place.bound;
                this.repaint();
                return;
            }
            case 3: {
                this.p.changed = true;
                Transition transition = new Transition(n3, n4, "", false, null);
                this.p.AddTransition(transition);
                this.bound = transition.bound;
                this.repaint();
                return;
            }
            case 21: {
                this.p.changed = true;
                Transition transition = new Transition(n3, n4, "", true, null);
                this.p.AddTransition(transition);
                this.bound = transition.bound;
                this.repaint();
                return;
            }
            case 5: {
                if (this.p.Transitions == null) {
                    return;
                }
                this.P = this.p.Transitions.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                ((Transition)this.P).Orientation ^= true;
                this.P.setBound();
                this.bound = this.P.bound;
                this.repaint();
                return;
            }
            case 6: {
                if (this.p.Transitions == null) {
                    return;
                }
                this.P = this.p.Transitions.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                ((Transition)this.P).Type ^= true;
                this.P.setBound();
                this.bound = this.P.bound;
                this.repaint();
                return;
            }
            case 22: {
                this.P = null;
                if (this.p.Transitions != null) {
                    this.P = this.p.Transitions.Find(n, n2);
                }
                if (this.P == null && this.p.Places != null) {
                    this.P = this.p.Places.Find(n, n2);
                }
                if (this.P == null) {
                    return;
                }
                this.P.iPs ^= true;
                this.P.setBound();
                this.bound = this.P.bound;
                this.repaint();
                return;
            }
            case 4: {
                this.p.changed = true;
                this.P = this.p.Places.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                ((Place)this.P).tokens += this.inc;
                ((Place)this.P).initTokens += this.inc;
                if (((Place)this.P).tokens < 0) {
                    ((Place)this.P).tokens = 0;
                    ((Place)this.P).initTokens = 0;
                }
                this.P.setBound();
                this.bound = this.P.bound;
                this.repaint();
                return;
            }
            case 13: {
                System.out.println("1");
                this.p.changed = true;
                System.out.println("2");
                this.P = this.p.FindAll(n, n2);
                System.out.println("3");
                if (this.P == null) {
                    return;
                }
                String string = this.P.getName();
                System.out.println("4");
                this.P.dialog();
                while (!this.p.validName(this.P)) {
                    JOptionPane.showMessageDialog(null, "Name already exists. \nEnter a different name.", "Name Error", 0);
                    this.P.setName(string);
                    this.P.dialog();
                }
                this.repaint();
                return;
            }
            case 15: {
                boolean bl = false;
                while (!bl) {
                    this.p.changed = true;
                    this.fname = new String();
                    this.sname = new String();
                    this.SFD = new JDialog(DFrame.MyFrame, "New Subnet", true);
                    this.SFD.getContentPane().setLayout(new BorderLayout());
                    JPanel jPanel = new JPanel(new GridLayout(2, 2));
                    JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
                    JLabel jLabel = new JLabel("Subnet Name:");
                    this.SFDsname = new JTextField();
                    this.SFDsname.setColumns(10);
                    this.SFDsname.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PetriCanvas.this.SFDsnameAction(actionEvent);
                        }
                    });
                    JLabel jLabel2 = new JLabel("Filename:");
                    this.SFDfname = new JTextField();
                    this.SFDfname.setColumns(10);
                    this.SFDfname.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PetriCanvas.this.SFDsnameAction(actionEvent);
                        }
                    });
                    JButton jButton = new JButton("Browse");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PetriCanvas.this.browseAction(actionEvent);
                        }
                    });
                    JButton jButton2 = new JButton("Cancel");
                    jButton2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PetriCanvas.this.cancelAction(actionEvent);
                        }
                    });
                    JButton jButton3 = new JButton("OK");
                    jButton3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PetriCanvas.this.SFDsnameAction(actionEvent);
                        }
                    });
                    this.no = false;
                    jPanel.add(jLabel);
                    jPanel.add(this.SFDsname);
                    jPanel.add(jLabel2);
                    jPanel.add(this.SFDfname);
                    jPanel2.add(jButton);
                    jPanel2.add(jButton2);
                    jPanel2.add(jButton3);
                    jPanel2.setPreferredSize(new Dimension(300, 20));
                    this.SFD.getContentPane().add((Component)jPanel, "Center");
                    this.SFD.getContentPane().add((Component)jPanel2, "South");
                    this.SFD.pack();
                    Place place = new Place(0, 0, "s0", 0, null);
                    while (true) {
                        if (!this.p.validName(place)) {
                            place.setName("s" + this.p.LowestSubnet);
                            ++this.p.LowestSubnet;
                            continue;
                        }
                        if (this.p.validName(place)) break;
                    }
                    this.SFDsname.setText(place.name);
                    place = null;
                    ((Component)this.SFD).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.SFD.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.SFD.getBounds().height / 2);
                    this.SFD.show();
                    if (this.no) {
                        return;
                    }
                    if (this.fname.compareTo("") == 0) {
                        JOptionPane.showMessageDialog(DFrame.MyFrame, "You must enter a filename", "Alert", 0);
                        return;
                    }
                    if (this.no) continue;
                    Subnet subnet = new Subnet(n, n2, this.sname, this.fname, this.Parent, true);
                    if (this.p.validName(subnet)) {
                        bl = true;
                        this.p.AddSubnet(subnet);
                        subnet.setName(this.sname);
                        return;
                    }
                    JOptionPane.showMessageDialog(null, "Name already exists. \nEnter a different name.", "Name Error", 0);
                    return;
                }
            }
            case 7: {
                this.p.changed = true;
                PetriUnit petriUnit = this.p.FindAll(n, n2);
                if (petriUnit == null) {
                    return;
                }
                this.bound = petriUnit.moveBound();
                if (petriUnit.isSelected()) {
                    this.p.deleteSelected();
                    this.bound = this.maxbound;
                } else {
                    this.p.delete(petriUnit);
                }
                this.repaint();
                return;
            }
            case 16: {
                this.P = this.p.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                if (this.P instanceof Subnet) {
                    DFrame.MyFrame.DMainMenuBarFileOpenAction(((Subnet)this.P).getFileName());
                }
                DFrame.MyFrame.internalWindowPanel.petriList.c.setCursor(new Cursor(12));
                return;
            }
            case 20: {
                this.setCursor(new Cursor(12));
                this.P = this.p.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                if (this.P instanceof Transition) {
                    if (((Transition)this.P).isEnabled()) {
                        ((Transition)this.P).fire();
                        this.repaint();
                        this.FiredTransitions = new PetriUnitList(this.P, this.FiredTransitions);
                        this.p.getEnabled();
                        DFrame.animatedp.setEnabledSubnets();
                    }
                } else if (this.P instanceof Subnet) {
                    PetriCanvas petriCanvas = new PetriCanvas(this.p.getPetriSubnet(this.p));
                    DFrame.MyFrame.registerCanvas(petriCanvas, ((Subnet)this.P).getPetri());
                    petriCanvas.action = 20;
                    petriCanvas.setCursor(new Cursor(12));
                    DFrame.MyFrame.internalWindowPanel.addPetri(petriCanvas, true);
                    PetriUnitList petriUnitList = petriCanvas.p.Transitions;
                    while (petriUnitList != null) {
                        ((Transition)petriUnitList.p).Animating = true;
                        petriUnitList = petriUnitList.next;
                    }
                    DFrame.MyFrame.getContentPane().add((Component)DFrame.MyFrame.internalWindowPanel, "Center");
                    return;
                }
                return;
            }
            case 9: {
                this.p.changed = true;
                Arc arc = this.p.FindArc(n, n2);
                if (arc == null) {
                    return;
                }
                arc.removeHandle();
                this.bound = arc.bound;
                this.repaint();
                return;
            }
            case 10: {
                this.p.changed = true;
                Arc arc = this.p.FindArc(n, n2);
                if (arc == null) {
                    return;
                }
                arc.addHandle();
                this.bound = arc.bound;
                this.repaint();
                return;
            }
            case 11: {
                this.p.changed = true;
                this.P = this.p.Find(n, n2);
                if (this.P == null) {
                    return;
                }
                Rectangle rectangle = new Rectangle(this.P.bound);
                this.P.toggleLabelPos();
                this.P.setBound();
                this.bound = this.P.bound.union(rectangle);
                this.repaint();
                return;
            }
            case 2: {
                if (mouseEvent.isControlDown()) {
                    if (this.MultiSource == null) {
                        this.MultiSource = this.p.Find(n, n2);
                        return;
                    }
                    this.p.AddArc(this.MultiSource.x, this.MultiSource.y, n, n2, 1, 0);
                    this.p.changed = true;
                    this.x = -1;
                    this.repaint();
                    return;
                }
                this.p.changed = true;
                this.p.AddArc((int)((float)this.x / this.p.d.scale), (int)((float)this.y / this.p.d.scale), n, n2, 1, 0);
                this.x = -1;
                this.repaint();
                return;
            }
            case 14: {
                if (mouseEvent.isControlDown()) {
                    if (this.MultiSource == null) {
                        this.MultiSource = this.p.Find(n, n2);
                        return;
                    }
                    this.p.changed = true;
                    this.x = -1;
                    this.repaint();
                    this.p.AddArc(this.MultiSource.x, this.MultiSource.y, n, n2, 1, 1);
                    return;
                }
                this.p.changed = true;
                this.p.AddArc((int)((float)this.x / this.p.d.scale), (int)((float)this.y / this.p.d.scale), n, n2, 1, 1);
                this.x = -1;
                this.repaint();
                return;
            }
            case 17: {
                if (mouseEvent.isControlDown()) {
                    if (this.MultiSource == null) {
                        this.MultiSource = this.p.Find(n, n2);
                        return;
                    }
                    this.p.AddArc(this.MultiSource.x, this.MultiSource.y, n, n2, -1, 1);
                    this.p.changed = true;
                    this.x = -1;
                    this.repaint();
                    return;
                }
                this.p.changed = true;
                this.p.AddArc((int)((float)this.x / this.p.d.scale), (int)((float)this.y / this.p.d.scale), n, n2, -1, 1);
                this.x = -1;
                this.repaint();
                return;
            }
            case 12: {
                int n5;
                Rectangle rectangle = new Rectangle();
                if (this.x > this.x2) {
                    n5 = this.x;
                    this.x = this.x2;
                    this.x2 = n5;
                }
                if (this.y > this.y2) {
                    n5 = this.y;
                    this.y = this.y2;
                    this.y2 = n5;
                }
                rectangle.setBounds((int)((float)this.x / this.p.d.scale), (int)((float)this.y / this.p.d.scale), (int)((float)(this.x2 - this.x) / this.p.d.scale), (int)((float)(this.y2 - this.y) / this.p.d.scale));
                this.p.toggleSelect(rectangle);
                this.x = -1;
                this.repaint();
                return;
            }
            case 19: {
                int n6;
                this.p.changed = true;
                if (this.x > this.x2) {
                    n6 = this.x;
                    this.x = this.x2;
                    this.x2 = n6;
                }
                if (this.y > this.y2) {
                    n6 = this.y;
                    this.y = this.y2;
                    this.y2 = n6;
                }
                HighLight highLight = new HighLight(this.x, this.y, this.x2, this.y2, Color.red, Color.gray);
                highLight.dialog();
                this.p.AddHighLights(highLight);
                this.bound = this.arcBound;
                this.x = -1;
                this.repaint();
                return;
            }
            case 8: {
                this.p.changed = true;
                this.x = -1;
                if (this.P != null) {
                    if (this.P instanceof Subnet) {
                        this.p.resetBound();
                    } else {
                        this.P.resetBound();
                    }
                    if (this.P.getType() == 1) {
                        ((Arc)this.P).from.setBound();
                        ((Arc)this.P).to.setBound();
                    }
                    this.bound = this.arcBound;
                    if (this.P.isSelected()) {
                        this.bound = this.maxbound;
                    }
                    this.P = null;
                    this.repaint();
                    return;
                }
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.paintGrid) {
            int n2;
            Rectangle rectangle = graphics.getClipBounds();
            n = rectangle.x;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y;
            int n5 = rectangle.y + rectangle.height;
            int n6 = (int)((float)this.xGrid * this.p.d.scale);
            int n7 = (int)((float)this.yGrid * this.p.d.scale);
            graphics.setColor(Color.darkGray);
            if (n6 > 1) {
                n2 = (n + n6) / n6 * n6;
                while (n2 < n3) {
                    graphics.drawLine(n2, n4, n2, n5);
                    n2 += n6;
                }
            }
            if (n7 > 1) {
                n2 = (n4 + n7) / n7 * n7;
                while (n2 < n5) {
                    graphics.drawLine(n, n2, n3, n2);
                    n2 += n7;
                }
            }
        }
        graphics.setFont(new Font("Serif", 0, 12));
        PetriUnit.boundFontMetrics = graphics.getFontMetrics();
        PetriUnit.boundFontMetrics = graphics.getFontMetrics();
        PetriUnit.fontMetrics = graphics.getFontMetrics();
        if (this.x != -1) {
            graphics.setColor(Color.blue);
            if (this.action != 12 && this.action != 19) {
                graphics.drawLine(this.x, this.y, this.x2, this.y2);
            }
        }
        if (this.p != null) {
            this.p.paint(graphics, this.x, this.y, this.x2, this.y2, this.action);
        }
        if (this.x != -1) {
            graphics.setColor(Color.blue);
            if (this.action == 12 || this.action == 19) {
                int n8 = this.x < this.x2 ? this.x : this.x2;
                n = this.y < this.y2 ? this.y : this.y2;
                graphics.drawRect(n8, n, Math.abs(this.x2 - this.x), Math.abs(this.y2 - this.y));
            }
        }
    }

    public void repaint() {
        if (this.p != null) {
            this.useBound.x = (int)((float)this.bound.x * this.p.d.scale);
            this.useBound.y = (int)((float)this.bound.y * this.p.d.scale);
            this.useBound.width = (int)((float)this.bound.width * this.p.d.scale);
            this.useBound.height = (int)((float)this.bound.height * this.p.d.scale);
            this.repaint(this.useBound);
            this.bound = this.maxbound;
        }
    }

    public void saySomething(String string, MouseEvent mouseEvent) {
    }

    public void setPetri(Petri petri) {
        this.p = petri;
    }
}

