/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Subnet;
import DaNAMiCS.TextPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Place
extends PetriUnit {
    public int tokens;
    public int initTokens;
    public int limit;
    PetriUnitList arcs;
    JDialog PDialog;
    JTextField PDPText;
    JTextField PDPToksval;
    JTextField PDPCap;
    JCheckBox bndCheck;
    JCheckBox PDPipcheck;

    public Place(int n, int n2, String string, int n3, int n4, boolean bl, Subnet subnet) {
        this.set(n, n2, string);
        this.tokens = this.initTokens = n3;
        this.arcs = null;
        this.limit = n4;
        this.Parent = subnet;
        this.setiPs(bl);
        this.labelPos = 1;
        this.setBound();
    }

    public Place(int n, int n2, String string, int n3, Subnet subnet) {
        this.set(n, n2, string);
        this.tokens = this.initTokens = n3;
        this.arcs = null;
        this.Parent = subnet;
        this.setiPs(false);
        this.labelPos = 1;
        this.limit = -1;
        this.setBound();
    }

    public void AddArc(Arc arc) {
        this.arcs = new PetriUnitList(arc, this.arcs);
    }

    public void PDOKButtonAction(ActionEvent actionEvent) {
        try {
            this.setName(this.PDPText.getText());
            Integer n = new Integer(this.PDPToksval.getText());
            if (n < 0) {
                n = new Integer(0);
            }
            this.tokens = n;
            this.initTokens = n;
            this.iPs = this.PDPipcheck.isSelected();
            if (!this.PDPCap.getText().equals("")) {
                n = new Integer(this.PDPCap.getText());
                this.limit = n;
            } else {
                this.limit = -1;
            }
            if (this.limit < 0) {
                this.limit = -1;
            }
            if (!this.bndCheck.isSelected()) {
                this.limit = -1;
            }
            this.PDialog.dispose();
            DFrame.c.bound = this.bound;
            DFrame.c.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane jOptionPane = new JOptionPane("Invalid Number!", 0);
            JDialog jDialog = jOptionPane.createDialog(DFrame.MyFrame, "Error!");
            ((Component)jDialog).setLocation(this.PDialog.getLocation().x, this.PDialog.getLocation().y);
            jDialog.show();
        }
    }

    public Place copyPlace(Place place) {
        return new Place(place.x, place.y, place.name, place.tokens, place.limit, place.iPs, place.Parent);
    }

    public void deepCopy2() {
    }

    void delete() {
        PetriUnitList petriUnitList = this.arcs;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).t.delete(petriUnitList.p);
            petriUnitList = petriUnitList.next;
        }
    }

    public void dialog() {
        this.PDialog = new JDialog(DFrame.MyFrame, "Place Attributes", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2));
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel("Place Name:");
        JLabel jLabel2 = new JLabel("Tokens:");
        JLabel jLabel3 = new JLabel("Capacity:");
        this.PDPText = new JTextField();
        this.PDPToksval = new JTextField();
        this.PDPCap = new JTextField();
        this.PDPText.setText(this.name);
        this.PDPText.setColumns(10);
        Integer n = new Integer(this.tokens);
        this.PDPToksval.setText(n.toString());
        this.PDPToksval.setColumns(10);
        n = new Integer(this.limit);
        this.PDPCap.setText(n.toString());
        this.PDPCap.setColumns(10);
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Place.this.PDOKButtonAction(actionEvent);
            }
        });
        this.PDPText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Place.this.PDOKButtonAction(actionEvent);
            }
        });
        this.PDPToksval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Place.this.PDOKButtonAction(actionEvent);
            }
        });
        this.PDPCap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Place.this.PDOKButtonAction(actionEvent);
            }
        });
        this.PDPipcheck = new JCheckBox("Interaction Pt.", this.iPs);
        this.PDPipcheck.setSelected(this.iPs);
        this.bndCheck = new JCheckBox("Limited", this.limit != -1);
        if (this.limit == -1) {
            this.PDPCap.setEnabled(false);
            this.PDPCap.setText("");
        }
        this.bndCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Place.this.PDPCap.setEnabled(Place.this.PDPCap.isEnabled() ^ true);
                Place.this.PDPCap.repaint();
            }
        });
        this.PDialog.getContentPane().add((Component)jPanel, "North");
        jPanel.add(jLabel);
        jPanel.add(this.PDPText);
        jPanel.add(jLabel2);
        jPanel.add(this.PDPToksval);
        jPanel.add(jLabel3);
        jPanel.add(this.PDPCap);
        jPanel.add(this.PDPipcheck);
        jPanel.add(this.bndCheck);
        this.PDialog.getContentPane().add((Component)jButton, "South");
        this.PDialog.getContentPane().add((Component)new TextPosition(this), "Center");
        this.PDialog.pack();
        ((Component)this.PDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.PDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.PDialog.getBounds().height / 2);
        this.PDialog.show();
    }

    public int getType() {
        return 2;
    }

    boolean in(int n, int n2) {
        return (this.x - n) * (this.x - n) + (this.y - n2) * (this.y - n2) <= 100;
    }

    Rectangle moveBound() {
        if (this.arcs != null) {
            return this.bound.union(this.arcs.getBound());
        }
        return this.bound;
    }

    void paint(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * PetriUnit.scale);
        int n2 = (int)((float)this.y * PetriUnit.scale);
        if (this.selected) {
            draw.background = PetriUnit.selectedColor;
            draw.edge = PetriUnit.selectedColor;
            draw.circle(n, n2, PetriUnit.ten + PetriUnit.two);
            draw.edge = Color.black;
        }
        int n3 = n2 + PetriUnit.four;
        int n4 = n2 - PetriUnit.four;
        int n5 = n + PetriUnit.four;
        int n6 = n - PetriUnit.four;
        draw.edge = this.iPs ? Color.cyan : Color.black;
        draw.background = Color.white;
        draw.circle(n, n2, PetriUnit.ten);
        draw.edge = Color.black;
        graphics.setColor(Color.black);
        draw.background = Color.black;
        switch (this.tokens) {
            case 1: {
                draw.circle(n, n2, PetriUnit.two);
                break;
            }
            case 2: {
                draw.circle(n5, n2, PetriUnit.two);
                draw.circle(n6, n2, PetriUnit.two);
                break;
            }
            case 3: {
                draw.circle(n, n4, PetriUnit.two);
                draw.circle(n5, n3, PetriUnit.two);
                draw.circle(n6, n3, PetriUnit.two);
                break;
            }
            case 4: {
                draw.circle(n5, n3, PetriUnit.two);
                draw.circle(n5, n4, PetriUnit.two);
                draw.circle(n6, n3, PetriUnit.two);
                draw.circle(n6, n4, PetriUnit.two);
                break;
            }
            case 5: {
                draw.circle(n5, n3, PetriUnit.two);
                draw.circle(n5, n4, PetriUnit.two);
                draw.circle(n6, n3, PetriUnit.two);
                draw.circle(n6, n4, PetriUnit.two);
                draw.circle(n, n2, PetriUnit.two);
                break;
            }
            default: {
                if (!draw.printText) {
                    return;
                }
                String string = this.tokens < 100 ? Integer.toString(this.tokens) : "*";
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n7 = fontMetrics.stringWidth(string);
                int n8 = fontMetrics.getMaxAdvance();
                int n9 = fontMetrics.getMaxDescent();
                int n10 = n - n7 / 2;
                int n11 = n2 - (n9 - n8) / 3;
                if (this.tokens > 99) {
                    n11 = n2 - (n9 - n8) / 2;
                }
                graphics.drawString(string, n10, n11);
            }
            case 0: 
        }
        this.paintName(draw);
    }

    void paint2(Draw draw) {
        draw.background = Color.red;
        draw.edge = Color.red;
        draw.circle((int)((float)this.x * PetriUnit.scale), (int)((float)this.y * PetriUnit.scale), PetriUnit.ten + PetriUnit.two);
        draw.edge = Color.black;
        this.paint(draw);
    }

    void print() {
        System.out.println("Place " + this.name + " at (" + this.x + "," + this.y + ") with " + this.tokens + " tokens and " + this.initTokens + " initial tokens.");
    }

    void resetBound() {
        this.setBound();
        PetriUnitList petriUnitList = null;
        petriUnitList = this.arcs;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).resetHandle();
            petriUnitList.p.setBound();
            this.bound.add(petriUnitList.p.bound);
            petriUnitList = petriUnitList.next;
        }
    }

    public void resetTokens() {
        this.tokens = this.initTokens;
    }

    void setBound() {
        this.bound.setSize(31, 31);
        this.bound.setLocation(this.x - 15, this.y - 15);
        this.bound.add(this.x - 15, this.y - 15);
        this.bound.add(this.x + 16, this.y + 16);
        this.boundLabel();
    }

    int xEdge(int n, int n2) {
        double d = Math.atan2(n2, n);
        return (int)((double)((float)this.x * PetriUnit.scale) + (double)PetriUnit.ten * Math.cos(d));
    }

    int yEdge(int n, int n2) {
        double d = Math.atan2(n2, n);
        return (int)((double)((float)this.y * PetriUnit.scale) + (double)PetriUnit.ten * Math.sin(d));
    }
}

