/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.AnimDead;
import DaNAMiCS.AnimUnb;
import DaNAMiCS.CPetri;
import DaNAMiCS.Cover;
import DaNAMiCS.GridBagExtra;
import DaNAMiCS.Invariant;
import DaNAMiCS.Marking;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.ResultsPetriCanvas;
import DaNAMiCS.SRPetriCanvas;
import DaNAMiCS.Simul;
import DaNAMiCS.Steady;
import DaNAMiCS.Transition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Results
extends JFrame
implements Runnable {
    boolean gotInv = false;
    boolean gotCov = false;
    boolean gotSim = false;
    boolean gotPer = false;
    AnimDead mydead = null;
    AnimUnb myunb = null;
    String ResultsFile = null;
    boolean usefile = false;
    Petri p;
    JTabbedPane ResTabPane;
    ImageIcon InvIcon;
    ImageIcon CovIcon;
    ImageIcon SimIcon;
    ImageIcon PerfIcon;
    JMenuItem ResetInvar;
    JMenuItem ResetCover;
    JMenuItem ResetSimul;
    JMenuItem ResetPerfo;
    JPanel InvariantBeforePanel;
    JPanel InvariantPanel;
    JPanel InvariantAfterPanel;
    JPanel CoverabilityBeforePanel;
    JPanel CoverabilityPanel;
    JPanel CoverabilityAfterPanel;
    JPanel SimulationBeforePanel;
    JPanel SimulationPanel;
    JPanel SimulationAfterPanel;
    JPanel PerformanceBeforePanel;
    JPanel PerformancePanel;
    JPanel PerformanceAfterPanel;
    static JCheckBox Pinv;
    static JCheckBox Tinv;
    static JCheckBox GenIM;
    static JCheckBox GenEqns;
    static JButton doitInv;
    JTextArea TStat;
    JTextArea PStat;
    JTextArea IncMat;
    JTextArea InvEqns;
    JTextArea Pinvs;
    JTextArea Tinvs;
    JCheckBox livenessCheck;
    JCheckBox boundednessCheck;
    JCheckBox homestatesCheck;
    JCheckBox graphCheck;
    JCheckBox canvasCheck;
    JCheckBox persistenceCheck;
    JCheckBox safenessCheck;
    JCheckBox modelFilesCheck;
    JTextArea liveBoxText;
    JTextArea boundBoxText;
    JTextArea homeBoxText;
    JTextArea graphBoxText;
    Marking InitMark;
    ResultsPetriCanvas canvasBox;
    PetriUnitList deadList;
    JButton showDead;
    Cover Cov;
    JButton showUnb;
    boolean dead = true;
    JTextField simBox;
    JTextArea meanBox;
    JTextArea transBox;
    JTextField timeBox;
    JTextField threshBox;
    Simul sim;
    Petri simp;
    SRPetriCanvas simcanvas;

    public Results(Petri petri) {
        this.ResultsFile = petri.getFileName();
        if (this.ResultsFile == null) {
            this.ResultsFile = "noname.ttt";
        }
        this.ResultsFile = String.valueOf(this.ResultsFile.substring(0, this.ResultsFile.length() - 4)) + ".res";
        if (petri instanceof CPetri) {
            this.simp = ((CPetri)petri).unfold();
            this.p = ((CPetri)petri).unfold();
        } else {
            this.p = petri.deepCopy(null);
            this.simp = petri.deepCopy(null);
        }
        this.InitMark = new Marking();
        int n = 0;
        PetriUnitList petriUnitList = null;
        PetriUnitList petriUnitList2 = this.p.Places;
        while (petriUnitList2 != null) {
            petriUnitList = new PetriUnitList(petriUnitList2.p, petriUnitList);
            petriUnitList2 = petriUnitList2.next;
        }
        petriUnitList2 = petriUnitList = this.p.getAllSubPlaces(petriUnitList);
        while (petriUnitList2 != null) {
            ++n;
            petriUnitList2 = petriUnitList2.next;
        }
        this.InitMark.set(n, petriUnitList, this.p, null, null);
        this.setupMenuBar();
        this.ResTabPane = new JTabbedPane(1);
        this.InvariantBeforePanel = new JPanel();
        this.setupInvariantBeforePanel();
        this.InvariantPanel = this.InvariantBeforePanel;
        this.InvIcon = new ImageIcon("DaNAMiCS/Images/invar.gif");
        this.ResTabPane.addTab("Invariant", this.InvIcon, this.InvariantPanel, "Invariant Analysis");
        this.CoverabilityBeforePanel = new JPanel();
        this.CovIcon = new ImageIcon("DaNAMiCS/Images/cover.gif");
        this.setupCoverabilityBeforePanel();
        this.CoverabilityPanel = this.CoverabilityBeforePanel;
        this.ResTabPane.addTab("Coverability", this.CovIcon, this.CoverabilityPanel, "Coverability Graph");
        this.SimulationBeforePanel = new JPanel();
        this.SimIcon = new ImageIcon("DaNAMiCS/Images/simu.gif");
        this.setupSimulationBeforePanel();
        this.SimulationPanel = this.SimulationBeforePanel;
        this.ResTabPane.addTab("Simulation", this.SimIcon, this.SimulationPanel, "Simulation");
        this.PerformanceBeforePanel = new JPanel();
        this.PerfIcon = new ImageIcon("DaNAMiCS/Images/pefr.gif");
        this.setupPerformanceBeforePanel();
        this.PerformancePanel = this.PerformanceBeforePanel;
        this.ResTabPane.addTab("Performance", this.PerfIcon, this.PerformancePanel, "Performance Analysis");
        this.getContentPane().add((Component)this.ResTabPane, "Center");
        this.setTitle("DaNAMiCS Results Viewer");
    }

    public Results(Petri petri, String string) {
        this.ResultsFile = string;
        this.p = null;
        this.setupMenuBar();
        this.ResetInvar.setEnabled(false);
        this.ResetCover.setEnabled(false);
        this.ResetSimul.setEnabled(false);
        this.ResetPerfo.setEnabled(false);
        this.ResTabPane = new JTabbedPane(1);
        this.InvariantAfterPanel = new JPanel();
        this.setupInvariantAfterPanel();
        this.InvariantPanel = this.InvariantAfterPanel;
        if (new File(String.valueOf(this.ResultsFile) + ".inv").exists()) {
            this.readInv(String.valueOf(this.ResultsFile) + ".inv");
        }
        this.InvIcon = new ImageIcon("DaNAMiCS/Images/invar.gif");
        this.ResTabPane.addTab("Invariant", this.InvIcon, this.InvariantPanel, "Invariant Analysis");
        this.CoverabilityAfterPanel = new JPanel();
        this.CovIcon = new ImageIcon("DaNAMiCS/Images/cover.gif");
        this.setupCoverabilityAfterPanel();
        this.canvasBox.p = null;
        this.showDead.setEnabled(false);
        this.showUnb.setEnabled(false);
        this.CoverabilityPanel = this.CoverabilityAfterPanel;
        if (new File(String.valueOf(this.ResultsFile) + ".cov").exists()) {
            this.readCov(String.valueOf(this.ResultsFile) + ".cov");
        }
        this.ResTabPane.addTab("Coverability", this.CovIcon, this.CoverabilityPanel, "Coverability Graph");
        this.SimulationAfterPanel = new JPanel();
        this.SimIcon = new ImageIcon("DaNAMiCS/Images/simu.gif");
        this.setupSimulationAfterPanel();
        this.SimulationPanel = this.SimulationAfterPanel;
        if (new File(String.valueOf(this.ResultsFile) + ".sim").exists()) {
            this.readSim(String.valueOf(this.ResultsFile) + ".sim");
        }
        this.ResTabPane.addTab("Simulation", this.SimIcon, this.SimulationPanel, "Simulation");
        this.PerformanceBeforePanel = new JPanel();
        this.PerfIcon = new ImageIcon("DaNAMiCS/Images/pefr.gif");
        this.setupPerformanceBeforePanel();
        this.PerformancePanel = this.PerformanceBeforePanel;
        this.ResTabPane.addTab("Performance", this.PerfIcon, this.PerformancePanel, "Performance Analysis");
        this.getContentPane().add((Component)this.ResTabPane, "Center");
        this.setTitle("DaNAMiCS Results Viewer");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.gc();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public void ExitAction(ActionEvent actionEvent) {
        if (this.mydead != null) {
            this.mydead.stop();
        }
        if (this.myunb != null) {
            this.myunb.stop();
        }
        this.dispose();
        this.mydead = null;
        this.myunb = null;
        System.gc();
    }

    public void LoadAction(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open DaNAMiCS Results File");
        fileDialog.setFile("*.res");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        String string3 = String.valueOf(string2) + string;
        if (string == null) {
            return;
        }
        File file = new File(String.valueOf(string3) + ".inv");
        if (file.exists()) {
            this.readInv(String.valueOf(string3) + ".inv");
        }
        if ((file = new File(String.valueOf(string3) + ".cov")).exists()) {
            this.readCov(String.valueOf(string3) + ".cov");
        }
        if ((file = new File(String.valueOf(string3) + ".sim")).exists()) {
            this.readSim(String.valueOf(string3) + ".sim");
        }
        this.canvasBox.p = null;
        this.showDead.setEnabled(false);
        this.showUnb.setEnabled(false);
    }

    public void ResetCoverAction(ActionEvent actionEvent) {
        this.setupCoverabilityBeforePanel();
        this.ResTabPane.removeTabAt(1);
        this.CoverabilityPanel = this.CoverabilityBeforePanel;
        this.ResTabPane.insertTab("Coverability", this.CovIcon, this.CoverabilityPanel, "Coverability Analysis Results", 1);
        this.CoverabilityPanel.validate();
        this.validate();
        this.gotCov = false;
    }

    public void ResetInvarAction(ActionEvent actionEvent) {
        this.setupInvariantBeforePanel();
        this.ResTabPane.removeTabAt(0);
        this.InvariantPanel = this.InvariantBeforePanel;
        this.ResTabPane.insertTab("Invariant", this.InvIcon, this.InvariantPanel, "Invariant Analysis Results", 0);
        this.InvariantPanel.validate();
        this.validate();
        this.gotInv = false;
    }

    public void ResetPerfoAction(ActionEvent actionEvent) {
        this.setupPerformanceBeforePanel();
        this.ResTabPane.removeTabAt(3);
        this.PerformancePanel = this.PerformanceBeforePanel;
        this.ResTabPane.insertTab("Performance", this.PerfIcon, this.PerformancePanel, "Performance Results", 3);
        this.PerformancePanel.validate();
        this.validate();
        this.gotPer = false;
    }

    public void ResetSimulAction(ActionEvent actionEvent) {
        this.setupSimulationBeforePanel();
        this.ResTabPane.removeTabAt(2);
        this.SimulationPanel = this.SimulationBeforePanel;
        this.ResTabPane.insertTab("Simulation", this.SimIcon, this.SimulationPanel, "Simulation Results", 2);
        this.SimulationPanel.validate();
        this.validate();
        this.SimulationPanel.repaint();
        this.SimulationPanel.validate();
        this.simBox.setVisible(true);
        this.gotSim = false;
    }

    public void SaveAction(ActionEvent actionEvent) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.ResultsFile));
            printWriter.println("Results File Controller for :" + this.ResultsFile.substring(0, this.ResultsFile.length() - 4) + ".bim");
            printWriter.close();
        }
        catch (IOException iOException) {
            return;
        }
        if (this.gotInv) {
            this.writeInv();
        }
        if (this.gotCov) {
            this.writeCov();
        }
        if (this.gotSim) {
            this.writeSim();
        }
        JOptionPane.showMessageDialog(this, "Results have been saved.", "Save Confirmed", 1);
    }

    public void calcButAction(ActionEvent actionEvent) {
        Object object;
        Object object2;
        int n;
        this.CoverabilityAfterPanel = new JPanel();
        this.setupCoverabilityAfterPanel();
        this.Cov = new Cover(this.p);
        this.deadList = this.Cov.constructCover();
        if (this.modelFilesCheck.isSelected()) {
            this.Cov.saveCoverabilityGraphToFile(this.ResultsFile);
        }
        if (this.Cov.G == null) {
            this.liveBoxText.append("Unable to determine liveness, out of memory\n");
            this.boundBoxText.append("Unable to determine boundedness, out of memory\n");
            this.ResTabPane.removeTabAt(1);
            this.CoverabilityPanel = this.CoverabilityAfterPanel;
            this.ResTabPane.insertTab("Coverability", this.CovIcon, this.CoverabilityPanel, "Coverability Analysis Results", 1);
            this.validate();
            this.gotCov = true;
            return;
        }
        PetriUnitList petriUnitList = this.Cov.getPossiblyUnbounded();
        if (this.livenessCheck.isSelected()) {
            this.Cov.doStrongComponents();
            n = this.Cov.doFinal();
            this.Cov.resetInitial();
            if (this.deadList != null) {
                this.liveBoxText.append("The net is not Live.\nIt contains a deadlock via the following firing vector:\n");
                PetriUnitList petriUnitList2 = this.deadList;
                int n2 = 0;
                while (petriUnitList2 != null) {
                    ++n2;
                    object2 = petriUnitList2.p.getHeritage();
                    object = new String();
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        object = ((String)object).concat(object2[n3]);
                        if (n3 != ((String[])object2).length - 1) {
                            object = ((String)object).concat("::");
                        }
                        ++n3;
                    }
                    if (petriUnitList2.next == null) {
                        this.liveBoxText.append((String)object);
                    } else {
                        this.liveBoxText.append(String.valueOf(object) + " ; ");
                        if (n2 % 10 == 0) {
                            this.liveBoxText.append("\n");
                        }
                    }
                    petriUnitList2 = petriUnitList2.next;
                }
            } else if (n == 0) {
                this.liveBoxText.append("The net is not live.");
                int n4 = 0;
                while (n4 < this.Cov.G.finalComponents.length) {
                    if (!this.Cov.G.finalComponents[n4]) {
                        this.liveBoxText.append("\n\nFinal Component " + n4 + " can enable:\n");
                        PetriUnitList petriUnitList3 = this.Cov.getEnabledInComponent(n4);
                        while (petriUnitList3 != null) {
                            object2 = petriUnitList3.p.getHeritage();
                            object = new String();
                            int n5 = 0;
                            while (n5 < ((String[])object2).length) {
                                object = ((String)object).concat(object2[n5]);
                                if (n5 != ((String[])object2).length - 1) {
                                    object = ((String)object).concat("::");
                                }
                                ++n5;
                            }
                            this.liveBoxText.append((String)object);
                            if (petriUnitList3.next != null) {
                                this.liveBoxText.append(" ; ");
                            }
                            petriUnitList3 = petriUnitList3.next;
                        }
                        this.liveBoxText.append("\nbut not:\n");
                        object2 = this.Cov.trans;
                        while (object2 != null) {
                            if (!((Transition)object2.p).chosen) {
                                object = object2.p.getHeritage();
                                String string = new String();
                                int n6 = 0;
                                while (n6 < ((String[])object).length) {
                                    string = string.concat((String)object[n6]);
                                    if (n6 != ((Object)object).length - 1) {
                                        string = string.concat("::");
                                    }
                                    ++n6;
                                }
                                this.liveBoxText.append(string);
                                if (object2.next != null) {
                                    this.liveBoxText.append(" ; ");
                                }
                            }
                            object2 = object2.next;
                        }
                    }
                    ++n4;
                }
            } else if (petriUnitList == null) {
                this.liveBoxText.append("The net is Live.");
            } else {
                this.liveBoxText.append("The net is possibly Live.");
            }
        }
        if (this.boundednessCheck.isSelected()) {
            int n7;
            n = 0;
            PetriUnitList petriUnitList4 = this.Cov.getUnbounded();
            this.canvasBox.setUnbPlaces(petriUnitList4);
            if (petriUnitList != null) {
                this.boundBoxText.append("The net has Possibly Unbounded Places:\n");
                n = 1;
            }
            if (petriUnitList4 != null) {
                this.boundBoxText.append("The net has Unbounded Places:\n");
            } else if (petriUnitList == null) {
                this.boundBoxText.append("The net is Bounded.\n");
            }
            PetriUnitList petriUnitList5 = petriUnitList4;
            while (petriUnitList5 != null) {
                object2 = petriUnitList5.p.getHeritage();
                object = new String();
                int n8 = 0;
                while (n8 < ((String[])object2).length) {
                    object = ((String)object).concat(object2[n8]);
                    if (n8 != ((String[])object2).length - 1) {
                        object = ((String)object).concat("::");
                    }
                    ++n8;
                }
                this.boundBoxText.append((String)object);
                if (petriUnitList5.next != null) {
                    this.boundBoxText.append(" ; ");
                }
                petriUnitList5 = petriUnitList5.next;
            }
            this.boundBoxText.append("\n");
            object2 = this.Cov.marks;
            int n9 = 0;
            while (n9 < this.Cov.UnboundedSequence.length) {
                if (this.Cov.UnboundedSequence[n9] != null) {
                    int n10;
                    String string;
                    String[] stringArray;
                    String[] stringArray2 = object2.p.getHeritage();
                    String string2 = new String();
                    n7 = 0;
                    while (n7 < stringArray2.length) {
                        string2 = string2.concat(stringArray2[n7]);
                        if (n7 != stringArray2.length - 1) {
                            string2 = string2.concat("::");
                        }
                        ++n7;
                    }
                    PetriUnitList petriUnitList6 = this.Cov.UnboundedSequence[n9];
                    boolean bl = false;
                    if (petriUnitList6.p != null) {
                        bl = true;
                        this.boundBoxText.append("\n" + string2 + " becomes unbounded by firing:\n");
                    }
                    while (petriUnitList6.p != null) {
                        stringArray = petriUnitList6.p.getHeritage();
                        string = new String();
                        n10 = 0;
                        while (n10 < stringArray.length) {
                            string = string.concat(stringArray[n10]);
                            if (n10 != stringArray.length - 1) {
                                string = string.concat("::");
                            }
                            ++n10;
                        }
                        this.boundBoxText.append(string);
                        if (petriUnitList6.next.p != null) {
                            this.boundBoxText.append(" ; ");
                        }
                        petriUnitList6 = petriUnitList6.next;
                    }
                    petriUnitList6 = petriUnitList6.next;
                    if (bl) {
                        this.boundBoxText.append("\nAnd then firing the following repeatedly:\n");
                    } else {
                        this.boundBoxText.append("\n" + string2 + " becomes unbounded by firing the following repeatedly:\n");
                    }
                    while (petriUnitList6 != null) {
                        stringArray = petriUnitList6.p.getHeritage();
                        string = new String();
                        n10 = 0;
                        while (n10 < stringArray.length) {
                            string = string.concat(stringArray[n10]);
                            if (n10 != stringArray.length - 1) {
                                string = string.concat("::");
                            }
                            ++n10;
                        }
                        this.boundBoxText.append(string);
                        if (petriUnitList6.next != null) {
                            this.boundBoxText.append(" ; ");
                        }
                        petriUnitList6 = petriUnitList6.next;
                    }
                }
                object2 = object2.next;
                ++n9;
            }
            if (n != 0) {
                this.boundBoxText.append("The possibly unbounded places are: \n");
                petriUnitList5 = petriUnitList;
                while (petriUnitList5 != null) {
                    String[] stringArray = petriUnitList5.p.getHeritage();
                    String string = new String();
                    n7 = 0;
                    while (n7 < stringArray.length) {
                        string = string.concat(stringArray[n7]);
                        if (n7 != stringArray.length - 1) {
                            string = string.concat("::");
                        }
                        ++n7;
                    }
                    this.boundBoxText.append(string);
                    if (petriUnitList5.next != null) {
                        this.boundBoxText.append(" ; ");
                    }
                    petriUnitList5 = petriUnitList5.next;
                }
                this.boundBoxText.append("\n");
            }
        }
        if (this.homestatesCheck.isSelected()) {
            n = this.Cov.G.numFinal;
            if (n == 1) {
                this.homeBoxText.setText("The net has Home States.\n");
            } else {
                this.homeBoxText.setText("The net contains no Home States.\n");
            }
        }
        if (this.safenessCheck.isSelected()) {
            this.Cov.performSafeness(this.homeBoxText);
        }
        if (this.persistenceCheck.isSelected()) {
            this.Cov.performPersistent(this.homeBoxText);
        }
        if (this.graphCheck.isSelected()) {
            this.Cov.printCover(this.graphBoxText);
        }
        if (this.canvasCheck.isSelected() && this.livenessCheck.isSelected()) {
            if (this.deadList != null) {
                this.mydead = new AnimDead(this.deadList, this.p, this.canvasBox, this, this.Cov);
                this.mydead.start();
            } else {
                this.showDead.setEnabled(false);
            }
        }
        if (this.canvasCheck.isSelected() && this.boundednessCheck.isSelected()) {
            n = 0;
            int n11 = 0;
            while (n11 < this.Cov.UnboundedSequence.length) {
                if (this.Cov.UnboundedSequence[n11] != null) {
                    n = 1;
                }
                ++n11;
            }
            if (n != 0) {
                this.myunb = new AnimUnb(this.Cov.UnboundedSequence, this.p, this.canvasBox, this, this.Cov);
                if (this.deadList == null) {
                    this.myunb.start();
                }
            } else {
                this.showUnb.setEnabled(false);
            }
        }
        if (!this.canvasCheck.isSelected()) {
            this.canvasBox.p = null;
            this.showDead.setEnabled(false);
            this.showUnb.setEnabled(false);
        }
        if (!this.boundednessCheck.isSelected()) {
            this.showUnb.setEnabled(false);
        }
        if (!this.livenessCheck.isSelected()) {
            this.showDead.setEnabled(false);
        }
        this.ResTabPane.removeTabAt(1);
        this.CoverabilityPanel = this.CoverabilityAfterPanel;
        this.ResTabPane.insertTab("Coverability", this.CovIcon, this.CoverabilityPanel, "Coverability Analysis Results", 1);
        this.validate();
        this.gotCov = true;
    }

    public void doitInvAction(ActionEvent actionEvent) {
        Invariant invariant;
        Invariant invariant2 = new Invariant(this.p);
        this.InvariantAfterPanel = new JPanel();
        this.setupInvariantAfterPanel();
        if (GenIM.isSelected()) {
            invariant2.printIncidenceMatrix(this.IncMat);
        }
        if (Pinv.isSelected()) {
            invariant = new Invariant(this.p);
            invariant.calcPInvariants(this.PStat, this.Pinvs);
            if (GenEqns.isSelected()) {
                invariant.generateEquations(this.InvEqns);
            }
        }
        if (Tinv.isSelected()) {
            invariant = new Invariant(this.p);
            invariant.calcTInvariants(this.TStat, this.Tinvs);
        }
        this.ResTabPane.removeTabAt(0);
        this.InvariantPanel = this.InvariantAfterPanel;
        this.ResTabPane.insertTab("Invariant", this.InvIcon, this.InvariantPanel, "Invariant Analysis Results", 0);
        this.validate();
        this.Pinvs.repaint();
        this.Tinvs.repaint();
        this.TStat.repaint();
        this.PStat.repaint();
        this.IncMat.repaint();
        this.InvEqns.repaint();
        this.InvariantPanel.repaint();
        this.gotInv = true;
    }

    public void readCov(String string) {
        this.liveBoxText.setText("");
        this.boundBoxText.setText("");
        this.homeBoxText.setText("");
        this.graphBoxText.setText("");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            while (string2.compareTo("\\end{Coverability}") != 0) {
                if (string2.compareTo("\\begin{Liveness}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{Liveness}") != 0) {
                        this.liveBoxText.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{Boundedness}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{Boundedness}") != 0) {
                        this.boundBoxText.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{HomeStates}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{HomeStates}") != 0) {
                        this.homeBoxText.setText(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{Graph}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{Graph}") != 0) {
                        this.graphBoxText.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void readInv(String string) {
        this.TStat.setText("");
        this.PStat.setText("");
        this.IncMat.setText("");
        this.InvEqns.setText("");
        this.Pinvs.setText("");
        this.Tinvs.setText("");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            while (string2.compareTo("\\end{Invariant}") != 0) {
                if (string2.compareTo("\\begin{T-Statistics}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{T-Statistics}") != 0) {
                        this.TStat.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{P-Statistics}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{P-Statistics}") != 0) {
                        this.PStat.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{T-Invariants}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{T-Invariants}") != 0) {
                        this.Tinvs.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{P-Invariants}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{P-Invariants}") != 0) {
                        this.Pinvs.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{Equations}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{Equations}") != 0) {
                        this.InvEqns.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{IncidenceMatrix}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{IncidenceMatrix}") != 0) {
                        this.IncMat.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void readSim(String string) {
        this.meanBox.setText("");
        this.transBox.setText("");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            while (string2.compareTo("\\end{Simulation}") != 0) {
                if (string2.compareTo("\\begin{transitionThroughput}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{transitionThroughput}") != 0) {
                        this.transBox.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{meanTokensPerPlace}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{meanTokensPerPlace}") != 0) {
                        this.meanBox.append(String.valueOf(string2) + "\n");
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2.compareTo("\\begin{TimeTaken}") == 0) {
                    string2 = bufferedReader.readLine();
                    while (string2.compareTo("\\end{TimeTaken}") != 0) {
                        this.timeBox.setText(string2);
                        string2 = bufferedReader.readLine();
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void run() {
        this.setResizable(true);
        this.show();
        this.toFront();
        this.requestFocus();
        this.repaint();
    }

    public JPanel setNC(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jComponent, "North");
        jPanel.add((Component)jComponent2, "Center");
        return jPanel;
    }

    public void setTTButAction(ActionEvent actionEvent) {
        try {
            this.simcanvas.setThreshold(new Double(this.threshBox.getText()));
            this.simcanvas.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void setupCoverabilityAfterPanel() {
        this.CoverabilityAfterPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        this.liveBoxText = new JTextArea(3, 20);
        this.boundBoxText = new JTextArea(3, 20);
        this.homeBoxText = new JTextArea(3, 20);
        JScrollPane jScrollPane = new JScrollPane(this.liveBoxText);
        JScrollPane jScrollPane2 = new JScrollPane(this.boundBoxText);
        JScrollPane jScrollPane3 = new JScrollPane(this.homeBoxText);
        JLabel jLabel = new JLabel("Liveness");
        JLabel jLabel2 = new JLabel("Boundedness");
        JLabel jLabel3 = new JLabel("General Information");
        this.graphBoxText = new JTextArea(11, 32);
        JScrollPane jScrollPane4 = new JScrollPane(this.graphBoxText);
        JLabel jLabel4 = new JLabel("Coverability Graph");
        this.canvasBox = new ResultsPetriCanvas(null);
        this.canvasBox.setPetri(this.p);
        this.canvasBox.action = 37;
        JScrollPane jScrollPane5 = new JScrollPane(this.canvasBox);
        jScrollPane5.setPreferredSize(new Dimension(450, 170));
        JLabel jLabel5 = new JLabel("Processed net");
        this.showDead = new JButton("Show Deadlock");
        this.showDead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.showDeadAction(actionEvent);
            }
        });
        this.showUnb = new JButton("Show Unboundedness");
        this.showUnb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.showUnbAction(actionEvent);
            }
        });
        jPanel5.add(this.showDead);
        jPanel5.add(this.showUnb);
        jPanel4.add(this.setNC(jLabel4, jScrollPane4));
        jPanel3.add(this.setNC(jLabel, jScrollPane));
        jPanel3.add(this.setNC(jLabel2, jScrollPane2));
        jPanel3.add(this.setNC(jLabel3, jScrollPane3));
        jPanel2.add((Component)jLabel5, "North");
        jPanel2.add((Component)jScrollPane5, "Center");
        jPanel2.add((Component)jPanel5, "South");
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.CoverabilityAfterPanel.add(jPanel);
        this.CoverabilityAfterPanel.add(jPanel2);
    }

    public void setupCoverabilityBeforePanel() {
        this.CoverabilityBeforePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.livenessCheck = new JCheckBox("Liveness", true);
        this.boundednessCheck = new JCheckBox("Boundedness", true);
        this.homestatesCheck = new JCheckBox("Home States", true);
        this.persistenceCheck = new JCheckBox("Persistence", false);
        this.safenessCheck = new JCheckBox("Safeness", false);
        this.graphCheck = new JCheckBox("Draw Coverability Graph", false);
        this.canvasCheck = new JCheckBox("Show Petri net", false);
        this.modelFilesCheck = new JCheckBox("Save Model Checking Results", true);
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.livenessCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(10, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.boundednessCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.homestatesCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.persistenceCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.safenessCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.graphCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.canvasCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)this.modelFilesCheck, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(6, 160, 0, 0));
        JButton jButton = new JButton("Calculate");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.calcButAction(actionEvent);
            }
        });
        GridBagExtra.addGridBagComponent(this.CoverabilityBeforePanel, (Component)jButton, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 10, new Insets(6, 0, 0, 0));
        this.CoverabilityBeforePanel.setLayout(gridBagLayout);
    }

    public void setupInvariantAfterPanel() {
        this.InvariantAfterPanel.setLayout(new GridLayout(3, 1));
        JLabel jLabel = new JLabel("T-Invariant Results");
        JLabel jLabel2 = new JLabel("P-Invariant Results");
        this.TStat = new JTextArea(3, 40);
        this.PStat = new JTextArea(3, 40);
        this.TStat.setLineWrap(true);
        this.PStat.setLineWrap(true);
        this.IncMat = new JTextArea(8, 20);
        this.InvEqns = new JTextArea(8, 20);
        JScrollPane jScrollPane = new JScrollPane(this.IncMat);
        JScrollPane jScrollPane2 = new JScrollPane(this.InvEqns);
        JScrollPane jScrollPane3 = new JScrollPane(this.TStat);
        JScrollPane jScrollPane4 = new JScrollPane(this.PStat);
        JLabel jLabel3 = new JLabel("Incidence Matrix:");
        JLabel jLabel4 = new JLabel("Equations:");
        JLabel jLabel5 = new JLabel("P-Invariants:");
        JLabel jLabel6 = new JLabel("T-Invariants:");
        this.Pinvs = new JTextArea(8, 20);
        this.Tinvs = new JTextArea(8, 20);
        JScrollPane jScrollPane5 = new JScrollPane(this.Pinvs);
        JScrollPane jScrollPane6 = new JScrollPane(this.Tinvs);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(this.setNC(jLabel5, jScrollPane5));
        jPanel3.add(this.setNC(jLabel6, jScrollPane6));
        jPanel2.add(this.setNC(jLabel3, jScrollPane));
        jPanel2.add(this.setNC(jLabel4, jScrollPane2));
        jPanel.add(this.setNC(jLabel2, jScrollPane4));
        jPanel.add(this.setNC(jLabel, jScrollPane3));
        this.InvariantAfterPanel.add(jPanel);
        this.InvariantAfterPanel.add(jPanel2);
        this.InvariantAfterPanel.add(jPanel3);
    }

    public void setupInvariantBeforePanel() {
        JPanel jPanel = new JPanel();
        Pinv = new JCheckBox("Calculate P-Invariants", true);
        Tinv = new JCheckBox("Calculate T-Invariants", false);
        GenIM = new JCheckBox("Show Incidence Matrix", false);
        GenEqns = new JCheckBox("Form P-Invariant Equations", true);
        doitInv = new JButton("Calculate");
        doitInv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.doitInvAction(actionEvent);
            }
        });
        jPanel.setLayout(new GridLayout(4, 1));
        jPanel.add(Pinv);
        jPanel.add(Tinv);
        jPanel.add(GenIM);
        jPanel.add(GenEqns);
        this.InvariantBeforePanel = new JPanel();
        this.InvariantBeforePanel.setLayout(new BorderLayout());
        this.InvariantBeforePanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.add(doitInv);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.InvariantBeforePanel.add((Component)jPanel2, "North");
        this.InvariantBeforePanel.add((Component)jPanel3, "South");
        this.InvariantBeforePanel.add((Component)jPanel5, "East");
        this.InvariantBeforePanel.add((Component)jPanel4, "West");
        jPanel2.setPreferredSize(new Dimension(500, 150));
        jPanel3.setPreferredSize(new Dimension(500, 150));
        jPanel4.setPreferredSize(new Dimension(150, 200));
        jPanel5.setPreferredSize(new Dimension(100, 200));
    }

    public void setupMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        this.ResetInvar = new JMenuItem();
        this.ResetCover = new JMenuItem();
        this.ResetSimul = new JMenuItem();
        this.ResetPerfo = new JMenuItem();
        jMenu2.setText("Calculate");
        this.ResetInvar.setText("Re-Calculate Invariants");
        this.ResetInvar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.ResetInvarAction(actionEvent);
            }
        });
        this.ResetCover.setText("Re-Calculate Coverability");
        this.ResetCover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.ResetCoverAction(actionEvent);
            }
        });
        this.ResetSimul.setText("Re-Simulate");
        this.ResetSimul.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.ResetSimulAction(actionEvent);
            }
        });
        this.ResetPerfo.setText("Re-Calculate Steady State");
        this.ResetPerfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.ResetPerfoAction(actionEvent);
            }
        });
        jMenu.setText("File");
        jMenuItem.setText("Load Results");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.LoadAction(actionEvent);
            }
        });
        jMenuItem2.setText("Save Results");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.SaveAction(actionEvent);
            }
        });
        jMenuItem3.setText("Exit Results Viewer");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.ExitAction(actionEvent);
            }
        });
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(jMenu);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu2);
        jMenu2.add(this.ResetInvar);
        jMenu2.add(this.ResetCover);
        jMenu2.add(this.ResetSimul);
        jMenu2.add(this.ResetPerfo);
    }

    public void setupPerformanceAfterPanel() {
    }

    public void setupPerformanceBeforePanel() {
        JTextArea jTextArea = null;
        JTextArea jTextArea2 = null;
        JTextArea jTextArea3 = null;
        jTextArea = new JTextArea(Steady.getMeanTokens(String.valueOf(this.ResultsFile) + ".steady"));
        jTextArea2 = new JTextArea(Steady.getThroughput(String.valueOf(this.ResultsFile) + ".steady"));
        jTextArea3 = new JTextArea(Steady.getDistribution(String.valueOf(this.ResultsFile) + ".steady"));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel("Mean number of Tokens per Place", 0);
        JLabel jLabel2 = new JLabel("Transition Enabled Probability and Throughput", 0);
        JLabel jLabel3 = new JLabel("Distribution of Tokens per Place", 0);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", jLabel);
        jPanel2.add("Center", new JScrollPane(jTextArea));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", jLabel2);
        jPanel3.add("Center", new JScrollPane(jTextArea2));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add("North", jLabel3);
        jPanel4.add("Center", new JScrollPane(jTextArea3));
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.PerformanceBeforePanel = new JPanel();
        this.PerformanceBeforePanel.setLayout(new BorderLayout());
        this.PerformanceBeforePanel.add((Component)jPanel, "Center");
        this.PerformanceBeforePanel.repaint();
    }

    public void setupSimulationAfterPanel() {
        this.meanBox = new JTextArea(10, 52);
        this.transBox = new JTextArea(10, 52);
        this.timeBox = new JTextField(20);
        this.threshBox = new JTextField(10);
        this.threshBox.setText("0.0");
        JScrollPane jScrollPane = new JScrollPane(this.meanBox);
        JScrollPane jScrollPane2 = new JScrollPane(this.transBox);
        JLabel jLabel = new JLabel("Mean Number of Tokens per Place");
        JLabel jLabel2 = new JLabel("Transition Throughput");
        this.simcanvas = new SRPetriCanvas(null);
        this.simcanvas.setPetri(this.simp);
        this.simcanvas.action = 37;
        JScrollPane jScrollPane3 = new JScrollPane(this.simcanvas);
        JButton jButton = new JButton("Set Threshold");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.setTTButAction(actionEvent);
            }
        });
        this.SimulationAfterPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new GridLayout(1, 3));
        jPanel3.add(this.setNC(jLabel2, jScrollPane2));
        jPanel3.add(this.setNC(jLabel, jScrollPane));
        jPanel4.add((Component)jScrollPane3, "Center");
        jPanel5.add(new JLabel("Throughput Threshold:"));
        jPanel5.add(this.threshBox);
        jPanel5.add(jButton);
        jPanel4.add((Component)jPanel5, "North");
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add(this.timeBox);
        this.SimulationAfterPanel.add((Component)jPanel2, "Center");
        this.SimulationAfterPanel.add((Component)jPanel, "South");
    }

    public void setupSimulationBeforePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagExtra gridBagExtra = new GridBagExtra();
        this.SimulationBeforePanel = new JPanel(gridBagLayout);
        this.simBox = new JTextField(10);
        JLabel jLabel = new JLabel("Enter simulation run length:");
        JButton jButton = new JButton("Calculate");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Results.this.simcalcAction(actionEvent);
            }
        });
        GridBagExtra.addGridBagComponent(this.SimulationBeforePanel, (Component)jLabel, gridBagLayout, 0.0, 0.0, -1, 1, -1, -1, 0, 17, new Insets(10, 100, 0, 0));
        GridBagExtra.addGridBagComponent(this.SimulationBeforePanel, (Component)this.simBox, gridBagLayout, 0.0, 0.0, 0, 1, -1, -1, 0, 17, new Insets(10, 6, 0, 0));
        GridBagExtra.addGridBagComponent(this.SimulationBeforePanel, (Component)jButton, gridBagLayout, 1.0, 0.0, 0, 1, -1, -1, 0, 10, new Insets(6, 0, 0, 0));
    }

    public void showDeadAction(ActionEvent actionEvent) {
        if (this.myunb != null && this.mydead != null) {
            this.myunb.stop();
        }
        if (this.mydead != null) {
            this.mydead.stop();
            this.mydead = new AnimDead(this.deadList, this.p, this.canvasBox, this, this.Cov);
            this.mydead.start();
        }
    }

    void showPerformanceResults() {
        this.ResTabPane.setSelectedComponent(this.PerformancePanel);
    }

    public void showUnbAction(ActionEvent actionEvent) {
        if (this.mydead != null && this.myunb != null) {
            this.mydead.stop();
        }
        if (this.myunb != null) {
            this.myunb.stop();
            this.myunb = new AnimUnb(this.Cov.UnboundedSequence, this.p, this.canvasBox, this, this.Cov);
            this.myunb.start();
        }
    }

    public void simcalcAction(ActionEvent actionEvent) {
        this.SimulationAfterPanel = new JPanel();
        this.setupSimulationAfterPanel();
        this.SimulationPanel = this.SimulationAfterPanel;
        this.sim = new Simul(this.simp);
        this.InitMark.setMarking(this.sim.marks);
        try {
            this.sim.simulation(new Integer(this.simBox.getText()), this.transBox, this.meanBox, this.timeBox);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.simcanvas.setThroughputs(this.sim.transitionThroughput);
        this.ResTabPane.removeTabAt(2);
        this.ResTabPane.insertTab("Simulation", this.SimIcon, this.SimulationPanel, "Simulation Results", 2);
        this.SimulationPanel.validate();
        this.validate();
        this.gotSim = true;
    }

    public void writeCov() {
        String string = String.valueOf(this.ResultsFile) + ".cov";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            return;
        }
        printWriter.println("\\begin{Coverability}");
        String string2 = this.liveBoxText.getText();
        if (string2 != null) {
            printWriter.println("\\begin{Liveness}");
            printWriter.println(string2);
            printWriter.println("\\end{Liveness}");
        }
        if ((string2 = this.boundBoxText.getText()) != null) {
            printWriter.println("\\begin{Boundedness}");
            printWriter.println(string2);
            printWriter.println("\\end{Boundedness}");
        }
        if ((string2 = this.homeBoxText.getText()) != null) {
            printWriter.println("\\begin{HomeStates}");
            printWriter.println(string2);
            printWriter.println("\\end{HomeStates}");
        }
        if ((string2 = this.graphBoxText.getText()) != null) {
            printWriter.println("\\begin{Graph}");
            printWriter.println(string2);
            printWriter.println("\\end{Graph}");
        }
        printWriter.println("\\end{Coverability}");
        printWriter.close();
    }

    public void writeInv() {
        String string = String.valueOf(this.ResultsFile) + ".inv";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            return;
        }
        printWriter.println("\\begin{Invariant}");
        String string2 = this.TStat.getText();
        if (string2 != null) {
            printWriter.println("\\begin{T-Statistics}");
            printWriter.println(string2);
            printWriter.println("\\end{T-Statistics}");
        }
        if ((string2 = this.PStat.getText()) != null) {
            printWriter.println("\\begin{P-Statistics}");
            printWriter.println(string2);
            printWriter.println("\\end{P-Statistics}");
        }
        if ((string2 = this.Pinvs.getText()) != null) {
            printWriter.println("\\begin{P-Invariants}");
            printWriter.println(string2);
            printWriter.println("\\end{P-Invariants}");
        }
        if ((string2 = this.Tinvs.getText()) != null) {
            printWriter.println("\\begin{T-Invariants}");
            printWriter.println(string2);
            printWriter.println("\\end{T-Invariants}");
        }
        if ((string2 = this.InvEqns.getText()) != null) {
            printWriter.println("\\begin{Equations}");
            printWriter.println(string2);
            printWriter.println("\\end{Equations}");
        }
        if ((string2 = this.IncMat.getText()) != null) {
            printWriter.println("\\begin{IncidenceMatrix}");
            printWriter.println(string2);
            printWriter.println("\\end{IncidenceMatrix}");
        }
        printWriter.println("\\end{Invariant}");
        printWriter.close();
    }

    public void writeSim() {
        String string = String.valueOf(this.ResultsFile) + ".sim";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            return;
        }
        printWriter.println("\\begin{Simulation}");
        String string2 = this.transBox.getText();
        if (string2 != null) {
            printWriter.println("\\begin{transitionThroughput}");
            printWriter.println(string2);
            printWriter.println("\\end{transitionThroughput}");
        }
        if ((string2 = this.meanBox.getText()) != null) {
            printWriter.println("\\begin{meanTokensPerPlace}");
            printWriter.println(string2);
            printWriter.println("\\end{meanTokensPerPlace}");
        }
        if ((string2 = this.timeBox.getText()) != null) {
            printWriter.println("\\begin{TimeTaken}");
            printWriter.println(string2);
            printWriter.println("\\end{TimeTaken}");
        }
        printWriter.println("\\end{Simulation}");
        printWriter.close();
    }
}

