/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.DNAmacaClient;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Results;
import DaNAMiCS.Transition;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class Steady {
    Petri P;
    PetriUnitList Places;
    PetriUnitList Transitions;
    PetriUnitList Arcs;
    DNAmacaClient cl;
    JFrame Window;
    byte[] results;
    int length;

    public Steady(Petri petri, JFrame jFrame) {
        this.P = petri;
        this.setPlaces();
        this.setTransitions();
        this.writeModel();
        this.Window = jFrame;
    }

    public static String getDistribution(String string) {
        try {
            String string2 = new String();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3.indexOf("\\begin{tokenDistribution}") == -1) {
                string3 = bufferedReader.readLine();
            }
            string3 = bufferedReader.readLine();
            while (string3.indexOf("\\end{tokenDistribution}") == -1) {
                string2 = String.valueOf(string2) + string3 + "\n";
                string3 = bufferedReader.readLine();
            }
            string2 = String.valueOf(string2) + "\n";
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getDistributionName(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("place p");
        int n2 = new Integer(string.substring(n += 7, string.length() - 1));
        string2 = this.getNameFromID(n2, this.Places);
        string3 = new String("Sate Measure : Distibution of tokens on place " + string2);
        return string3;
    }

    public static String getMeanTokens(String string) {
        try {
            String string2 = new String();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3.indexOf("\\begin{meanTokens}") == -1) {
                string3 = bufferedReader.readLine();
            }
            string3 = bufferedReader.readLine();
            while (string3.indexOf("\\end{meanTokens}") == -1) {
                string2 = String.valueOf(string2) + string3 + "\n";
                string3 = bufferedReader.readLine();
            }
            string2 = String.valueOf(string2) + "\n";
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getNameFromID(int n, PetriUnitList petriUnitList) {
        String[] stringArray = null;
        String string = null;
        PetriUnitList petriUnitList2 = petriUnitList;
        while (petriUnitList2 != null) {
            if (petriUnitList2.p.UniqueNumber == n) {
                stringArray = petriUnitList2.p.getHeritage();
                string = new String();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 != 0) {
                        string = String.valueOf(string) + "::";
                    }
                    string = String.valueOf(string) + stringArray[n2];
                    ++n2;
                }
            }
            petriUnitList2 = petriUnitList2.next;
        }
        return string;
    }

    String getStateName(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("place p");
        if (n == -1) {
            n = string.indexOf("transition t");
            int n2 = new Integer(string.substring(n += 12, string.length() - 1));
            string2 = this.getNameFromID(n2, this.Transitions);
            string3 = new String("State Measure : Enabled probability for transition " + string2);
        } else {
            int n3 = new Integer(string.substring(n += 7, string.length() - 1));
            string2 = this.getNameFromID(n3, this.Places);
            string3 = new String("State Measure : Mean tokens on place " + string2);
        }
        return string3;
    }

    public static String getThroughput(String string) {
        try {
            String string2 = new String();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3.indexOf("\\begin{transitionMeasures}") == -1) {
                string3 = bufferedReader.readLine();
            }
            string3 = bufferedReader.readLine();
            while (string3.indexOf("\\end{transitionMeasures}") == -1) {
                string2 = String.valueOf(string2) + string3 + "\n";
                string3 = bufferedReader.readLine();
            }
            string2 = String.valueOf(string2) + "\n";
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getTransitionName(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("transition t");
        if ((n += 12) >= string.length()) {
            return null;
        }
        int n2 = new Integer(string.substring(n, string.length() - 1));
        string2 = this.getNameFromID(n2, this.Transitions);
        string3 = new String("Count Measure : Throughput for transition " + string2);
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    void parseResults(byte[] var1_1, int var2_2) {
        this.results = var1_1;
        this.length = var2_2;
        try {
            var3_3 = this.P.getFileName();
            if (this.P.getFileName().endsWith(".bim")) {
                var3_3 = String.valueOf(this.P.getFileName().substring(0, this.P.getFileName().length() - 4)) + ".res";
            }
            var4_5 = new FileOutputStream("results.tmp");
            var4_5.write(this.results, 0, this.length);
            var4_5.close();
            var5_6 = new BufferedReader(new FileReader("results.tmp"));
            var6_7 = new PrintWriter(new FileWriter(String.valueOf(var3_3) + ".steady"));
            var7_8 = var5_6.readLine();
            var6_7.println("\\begin{meanTokens}");
            while (var7_8 != null) {
                if (var7_8.indexOf("tokens") != -1) {
                    var7_8 = this.getStateName(var7_8);
                    var6_7.println(var7_8);
                    var7_8 = var5_6.readLine();
                    while (var7_8.indexOf("distribution") == -1) {
                        var6_7.println(var7_8);
                        var7_8 = var5_6.readLine();
                    }
                    var6_7.println();
                }
                var7_8 = var5_6.readLine();
            }
            var6_7.println("\\end{meanTokens}");
            var5_6.close();
            var5_6 = new BufferedReader(new FileReader("results.tmp"));
            var6_7.println("\\begin{transitionMeasures}");
            var7_8 = var5_6.readLine();
            while (var7_8 != null) {
                block14: {
                    if (var7_8.indexOf("transition") == -1) break block14;
                    if (var7_8.startsWith("State Measure")) {
                        var7_8 = this.getStateName(var7_8);
                    }
                    if (var7_8.startsWith("Count Measure")) {
                        var7_8 = this.getTransitionName(var7_8);
                    }
                    var6_7.println(var7_8);
                    var7_8 = var5_6.readLine();
                    if (var7_8 != null) ** GOTO lbl44
                    break;
lbl-1000:
                    // 1 sources

                    {
                        var6_7.println(var7_8);
                        var7_8 = var5_6.readLine();
                        if (var7_8 == null) break;
lbl44:
                        // 2 sources

                        ** while (var7_8.indexOf((String)"Measure") == -1)
                    }
lbl45:
                    // 2 sources

                    var6_7.println();
                    continue;
                }
                var7_8 = var5_6.readLine();
            }
            var6_7.println("\\end{transitionMeasures}");
            var5_6.close();
            var5_6 = new BufferedReader(new FileReader("results.tmp"));
            var6_7.println("\\begin{tokenDistribution}");
            var7_8 = var5_6.readLine();
            while (var7_8 != null) {
                if (var7_8.indexOf("tokens") != -1) {
                    var7_8 = this.getDistributionName(var7_8);
                    var6_7.println(var7_8);
                    var7_8 = var5_6.readLine();
                    while (var7_8.indexOf("distribution") == -1) {
                        var7_8 = var5_6.readLine();
                    }
                    var6_7.println(var7_8);
                    var7_8 = var5_6.readLine();
                    while (var7_8.indexOf("e") != -1) {
                        var6_7.println(var7_8);
                        var7_8 = var5_6.readLine();
                    }
                    var6_7.println();
                }
                var7_8 = var5_6.readLine();
            }
            var6_7.println("\\end{tokenDistribution}");
            var5_6.close();
            var5_6.close();
            var6_7.close();
            var8_9 = new JOptionPane();
            JOptionPane.showMessageDialog(null, "The server has returned the results.", "DaNAMiCS : Server returned", 1);
            var9_10 = new Results(this.P);
            var9_10.setSize(500, 500);
            var9_10.setLocation(this.Window.getLocation().x + this.Window.getBounds().width / 2 - var9_10.getBounds().width / 2, this.Window.getLocation().y + this.Window.getBounds().height / 2 - var9_10.getBounds().height / 2);
            var9_10.setResizable(false);
            var9_10.showPerformanceResults();
            var9_10.show();
            var9_10.toFront();
            var9_10.requestFocus();
            var9_10.repaint();
        }
        catch (Exception var3_4) {
            System.out.println("HAHAHAHAHA");
            var3_4.printStackTrace();
            System.out.println(var3_4.getMessage());
        }
    }

    private void printPath(PetriUnitList petriUnitList) {
        PetriUnitList petriUnitList2 = petriUnitList;
        while (petriUnitList2 != null) {
            String[] stringArray = petriUnitList2.p.getHeritage();
            int n = 0;
            while (n < stringArray.length) {
                ++n;
            }
            petriUnitList2 = petriUnitList2.next;
        }
    }

    void setPlaces() {
        int n = 0;
        PetriUnitList petriUnitList = this.P.Places;
        while (petriUnitList != null) {
            this.Places = new PetriUnitList(petriUnitList.p, this.Places);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Places = this.P.getAllSubPlaces(this.Places);
        while (petriUnitList != null) {
            petriUnitList.p.UniqueNumber = n++;
            petriUnitList = petriUnitList.next;
        }
    }

    void setTransitions() {
        int n = 0;
        PetriUnitList petriUnitList = this.P.Transitions;
        while (petriUnitList != null) {
            this.Transitions = new PetriUnitList(petriUnitList.p, this.Transitions);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.Transitions = this.P.getAllSubTrans(this.Transitions);
        while (petriUnitList != null) {
            petriUnitList.p.UniqueNumber = n++;
            petriUnitList = petriUnitList.next;
        }
    }

    void writeAction(Transition transition, PrintWriter printWriter) {
        String string;
        Arc arc;
        printWriter.println("\t\t\\action{");
        PetriUnitList petriUnitList = transition.ArcsIn;
        while (petriUnitList != null) {
            arc = (Arc)petriUnitList.p;
            if (arc.weight != -1) {
                string = new String("p" + arc.p.UniqueNumber);
                printWriter.println("\t\t\tnext->" + string + " = " + string + " - " + arc.weight + ";");
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = transition.ArcsOut;
        while (petriUnitList != null) {
            arc = (Arc)petriUnitList.p;
            string = new String("p" + arc.p.UniqueNumber);
            printWriter.println("\t\t\tnext->" + string + " = " + string + " + " + arc.weight + ";");
            petriUnitList = petriUnitList.next;
        }
        printWriter.println("\t\t}");
    }

    void writeCondition(Transition transition, PrintWriter printWriter) {
        printWriter.print("\t\t\\condition{");
        PetriUnitList petriUnitList = transition.ArcsIn;
        while (petriUnitList != null) {
            Arc arc = (Arc)petriUnitList.p;
            if (arc.weight == -1) {
                printWriter.print("p" + arc.p.UniqueNumber + " == 0 ");
            } else {
                printWriter.print("p" + arc.p.UniqueNumber + " > " + (arc.weight - 1) + " ");
            }
            if (petriUnitList.next != null) {
                printWriter.print("&& ");
            }
            petriUnitList = petriUnitList.next;
        }
        if (transition.ArcsIn != null) {
            printWriter.println("\n\t\t}");
        } else {
            printWriter.println("1\t\t\n}");
        }
    }

    void writeExpression(Transition transition, PrintWriter printWriter) {
        printWriter.print("\t\t\t\\expression{ ");
        PetriUnitList petriUnitList = transition.ArcsIn;
        while (petriUnitList != null) {
            Arc arc = (Arc)petriUnitList.p;
            if (arc.weight == -1) {
                printWriter.print("(p" + arc.p.UniqueNumber + " == 0) ");
            } else {
                printWriter.print("(p" + arc.p.UniqueNumber + " > " + (arc.weight - 1) + ") ");
            }
            if (petriUnitList.next != null) {
                printWriter.print("&& ");
            }
            petriUnitList = petriUnitList.next;
        }
        if (transition.ArcsIn != null) {
            printWriter.println("? 1 : 0 }");
        } else {
            printWriter.println("1 }");
        }
    }

    void writeInitial(PrintWriter printWriter) {
        printWriter.println("\t\\initial{");
        PetriUnitList petriUnitList = this.Places;
        while (petriUnitList != null) {
            printWriter.println("\t\tp" + petriUnitList.p.UniqueNumber + " = " + ((Place)petriUnitList.p).initTokens + ";");
            petriUnitList = petriUnitList.next;
        }
        printWriter.println("\t}");
    }

    void writeModel() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("wmca.mod"));
            printWriter.println("\\model {");
            this.writeStateVector(printWriter);
            this.writeInitial(printWriter);
            this.writeTransitions(printWriter);
            printWriter.println("}");
            this.writePerformanceMeasures(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {}
    }

    void writePerformanceMeasures(PrintWriter printWriter) {
        printWriter.println("\\performance{");
        this.writePlaceStateMeasures(printWriter);
        this.writeTransitionStateMeasures(printWriter);
        this.writeTransitionCountMeasures(printWriter);
        printWriter.println("}");
    }

    void writePlaceStateMeasures(PrintWriter printWriter) {
        PetriUnitList petriUnitList = this.Places;
        while (petriUnitList != null) {
            printWriter.println("\t\\statemeasure{Mean tokens on place p" + petriUnitList.p.UniqueNumber + "} {");
            printWriter.println("\t\t\\estimator{mean variance distribution}");
            printWriter.println("\t\t\\expression {p" + petriUnitList.p.UniqueNumber + "}");
            printWriter.println("\t}");
            petriUnitList = petriUnitList.next;
        }
    }

    void writeStateVector(PrintWriter printWriter) {
        printWriter.println("\t\\statevector{");
        printWriter.print("\t\t\\type{long} {");
        PetriUnitList petriUnitList = this.Places;
        while (petriUnitList != null) {
            printWriter.print("p" + petriUnitList.p.UniqueNumber);
            if (petriUnitList.next != null) {
                printWriter.print(", ");
            } else {
                printWriter.println("}");
            }
            petriUnitList = petriUnitList.next;
        }
        printWriter.println("\t}");
    }

    void writeTransitionCountMeasures(PrintWriter printWriter) {
        PetriUnitList petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            if (!((Transition)petriUnitList.p).Type) {
                printWriter.println("\t\\countmeasure{Throughput for transition t" + petriUnitList.p.UniqueNumber + "} {");
                printWriter.println("\t\t\\estimator{mean}");
                printWriter.println("\t\t\\precondition{1}");
                printWriter.println("\t\t\\postcondition{1}");
                printWriter.println("\t\t\\transition{t" + petriUnitList.p.UniqueNumber + "}");
                printWriter.println("\t}");
            }
            petriUnitList = petriUnitList.next;
        }
    }

    void writeTransitionStateMeasures(PrintWriter printWriter) {
        PetriUnitList petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            printWriter.println("\t\\statemeasure{Enabled probability for transition t" + petriUnitList.p.UniqueNumber + "} {");
            printWriter.println("\t\t\\estimator{mean}");
            this.writeExpression((Transition)petriUnitList.p, printWriter);
            printWriter.println("\t}");
            petriUnitList = petriUnitList.next;
        }
    }

    void writeTransitions(PrintWriter printWriter) {
        PetriUnitList petriUnitList = this.Transitions;
        while (petriUnitList != null) {
            printWriter.println("\t\\transition{t" + petriUnitList.p.UniqueNumber + "} {");
            this.writeCondition((Transition)petriUnitList.p, printWriter);
            this.writeAction((Transition)petriUnitList.p, printWriter);
            if (!((Transition)petriUnitList.p).Type) {
                printWriter.println("\t\t\\rate{" + ((Transition)petriUnitList.p).Rate + "}");
            } else {
                printWriter.println("\t\t\\weight{" + ((Transition)petriUnitList.p).Rate + "}");
            }
            printWriter.println("\t}");
            petriUnitList = petriUnitList.next;
        }
    }
}

