/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.Export;
import DaNAMiCS.Petri;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.TextPosition;
import DaNAMiCS.Transition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class Subnet
extends PetriUnit {
    private Petri p;
    private String FileName;
    boolean enabled = false;
    static Rectangle mBound = new Rectangle(0, 0, 10000, 10000);
    JDialog SDialog;
    JTextField SDPText;

    Subnet(int n, int n2, String string, String string2, Subnet subnet) {
        this.set(n, n2, string);
        this.p = null;
        this.FileName = string2;
        this.Parent = subnet;
        this.setiPs(false);
        Export export = new Export();
        try {
            this.p = export.importWam(this.FileName, this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Subnet file not found: " + this.FileName);
        }
        this.setBound();
    }

    Subnet(int n, int n2, String string, String string2, Subnet subnet, boolean bl) {
        this.set(n, n2, string);
        this.p = new Petri(this);
        this.FileName = string2;
        this.Parent = subnet;
        this.setiPs(false);
        boolean bl2 = false;
        if (bl2) {
            System.out.println("An error occurred reading subnet " + this.FileName);
            this.p = null;
        }
        this.setBound();
    }

    public void SDOKButtonAction(ActionEvent actionEvent) {
        this.name = this.SDPText.getText();
        this.SDialog.dispose();
    }

    public Subnet copySubnet(Subnet subnet) {
        return new Subnet(subnet.x, subnet.y, subnet.name, subnet.FileName, subnet.Parent, true);
    }

    public PetriUnit deepCopy1() {
        try {
            this.copy = (PetriUnit)this.clone();
            ((Subnet)this.copy).p.deepCopy1();
            return this.copy;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void deepCopy2() {
        this.p.deepCopy2();
    }

    public PetriUnit deepCopy3() {
        this.p.deepCopy3();
        return this;
    }

    public void dialog() {
        this.SDialog = new JDialog(DFrame.MyFrame, "Subnet Attributes", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel("Subnet Name:");
        this.SDPText = new JTextField(this.name);
        this.SDPText.setPreferredSize(new Dimension(20, 20));
        this.SDPText.setColumns(10);
        PetriUnitList petriUnitList = this.getPetri().Places;
        Vector<PetriUnit> vector = new Vector<PetriUnit>();
        int n = 0;
        while (petriUnitList != null) {
            if (petriUnitList.p.isiPs()) {
                vector.addElement(petriUnitList.p);
                ++n;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.getPetri().Transitions;
        while (petriUnitList != null) {
            if (petriUnitList.p.isiPs()) {
                vector.addElement(petriUnitList.p);
                ++n;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.getPetri().Subnets;
        while (petriUnitList != null) {
            if (petriUnitList.p.isiPs()) {
                vector.addElement(petriUnitList.p);
                ++n;
            }
            petriUnitList = petriUnitList.next;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(((PetriUnit)vector.elementAt((int)n2)).name);
            ++n2;
        }
        JList<String> jList = new JList<String>(stringArray);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jList.setPreferredSize(new Dimension(150, 200));
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Subnet.this.SDOKButtonAction(actionEvent);
            }
        });
        this.SDPText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Subnet.this.SDOKButtonAction(actionEvent);
            }
        });
        jPanel.add(jLabel);
        jPanel.add(this.SDPText);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)new TextPosition(this), "Center");
        this.SDialog.getContentPane().add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("  Interaction Points:"), "North");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)new JLabel("  "), "West");
        this.SDialog.getContentPane().add((Component)jButton, "South");
        this.SDialog.getContentPane().add((Component)jPanel3, "East");
        this.SDialog.pack();
        ((Component)this.SDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.SDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.SDialog.getBounds().height / 2);
        this.SDialog.show();
    }

    public PetriUnitList getAllPlaces(PetriUnitList petriUnitList) {
        petriUnitList = this.p.Places.insert(petriUnitList, this.p.Places);
        PetriUnitList petriUnitList2 = this.p.Subnets;
        while (petriUnitList2 != null) {
            petriUnitList = ((Subnet)petriUnitList2.p).getAllPlaces(petriUnitList);
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    public PetriUnitList getAllTransitions(PetriUnitList petriUnitList) {
        petriUnitList = this.p.Transitions.insert(petriUnitList, this.p.Transitions);
        PetriUnitList petriUnitList2 = this.p.Subnets;
        while (petriUnitList2 != null) {
            petriUnitList = ((Subnet)petriUnitList2.p).getAllTransitions(petriUnitList);
            petriUnitList2 = petriUnitList2.next;
        }
        return petriUnitList;
    }

    int getCenterX() {
        return this.x;
    }

    int getCenterY() {
        return this.y;
    }

    public String getFileName() {
        return this.FileName;
    }

    public Petri getPetri() {
        return this.p;
    }

    public int getType() {
        return 4;
    }

    boolean in(int n, int n2) {
        if (n < this.x - 20) {
            return false;
        }
        if (n2 < this.y - 30) {
            return false;
        }
        if (n > this.x + 20) {
            return false;
        }
        return n2 <= this.y + 30;
    }

    public boolean isEnabled() {
        boolean bl = false;
        PetriUnitList petriUnitList = this.p.Transitions;
        while (petriUnitList != null) {
            ((Transition)petriUnitList.p).setEnabled();
            if (((Transition)petriUnitList.p).isEnabled()) {
                this.enabled = true;
                return true;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.p.Subnets;
        while (petriUnitList != null) {
            bl = ((Subnet)petriUnitList.p).isEnabled();
            if (bl) {
                this.enabled = true;
                return bl;
            }
            petriUnitList = petriUnitList.next;
        }
        this.enabled = false;
        return bl;
    }

    Rectangle moveBound() {
        return mBound;
    }

    void paint(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * draw.scale);
        int n2 = (int)((float)this.y * draw.scale);
        if (this.selected) {
            graphics.setColor(PetriUnit.selectedColor);
            graphics.fillRect(n - PetriUnit.twenty - PetriUnit.two, n2 - 3 * PetriUnit.ten - PetriUnit.two, 2 * PetriUnit.twenty + PetriUnit.four, 3 * PetriUnit.twenty + PetriUnit.four);
        }
        if (this.enabled) {
            graphics.setColor(Color.green);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(n - PetriUnit.twenty + 1, n2 - 3 * PetriUnit.ten + 1, 2 * PetriUnit.twenty - 1, 3 * PetriUnit.twenty - 1);
        graphics.setColor(Color.black);
        graphics.drawRect(n - PetriUnit.twenty, n2 - 3 * PetriUnit.ten, 2 * PetriUnit.twenty, 3 * PetriUnit.twenty);
        this.paintName(draw);
    }

    void resetBound() {
        this.setBound();
        PetriUnitList petriUnitList = null;
        if (DFrame.p == null) {
            return;
        }
        petriUnitList = DFrame.p.ArcFromSubnet;
        while (petriUnitList != null) {
            if (((Arc)petriUnitList.p).from == this || ((Arc)petriUnitList.p).to == this) {
                ((Arc)petriUnitList.p).resetHandle();
            }
            petriUnitList.p.setBound();
            petriUnitList = petriUnitList.next;
        }
        PetriUnitList petriUnitList2 = DFrame.p.Transitions;
        while (petriUnitList2 != null) {
            petriUnitList = ((Transition)petriUnitList2.p).ArcsIn;
            while (petriUnitList != null) {
                if (((Arc)petriUnitList.p).from == this || ((Arc)petriUnitList.p).to == this) {
                    ((Arc)petriUnitList.p).resetHandle();
                }
                petriUnitList.p.setBound();
                petriUnitList = petriUnitList.next;
            }
            petriUnitList = ((Transition)petriUnitList2.p).ArcsOut;
            while (petriUnitList != null) {
                if (((Arc)petriUnitList.p).from == this || ((Arc)petriUnitList.p).to == this) {
                    ((Arc)petriUnitList.p).resetHandle();
                }
                petriUnitList.p.setBound();
                petriUnitList = petriUnitList.next;
            }
            petriUnitList2 = petriUnitList2.next;
        }
    }

    void setBound() {
        this.bound.setSize(45, 65);
        this.bound.setLocation(this.x - 22, this.y - 32);
        this.boundLabel();
    }

    public void setFileName(String string) {
        this.FileName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSubnet(int n, int n2, String string) {
        this.set(n, n2, string);
    }

    int xEdge(int n, int n2) {
        if (3 * n >= 2 * (n2 = Math.abs(n2))) {
            return (int)((float)this.x * PetriUnit.scale + (float)PetriUnit.twenty);
        }
        if (-3 * n >= 2 * n2) {
            return (int)((float)this.x * PetriUnit.scale - (float)PetriUnit.twenty);
        }
        return (int)((float)this.x * PetriUnit.scale + (float)(PetriUnit.ten * 3 * n / n2));
    }

    int yEdge(int n, int n2) {
        if (3 * (n = Math.abs(n)) <= 2 * n2) {
            return (int)((float)this.y * PetriUnit.scale + (float)PetriUnit.ten + (float)PetriUnit.twenty);
        }
        if (-3 * n >= 2 * n2) {
            return (int)((float)this.y * PetriUnit.scale - (float)PetriUnit.ten - (float)PetriUnit.twenty);
        }
        return (int)((float)this.y * PetriUnit.scale + (float)(PetriUnit.twenty * n2 / n));
    }
}

