/*
 * Decompiled with CFR 0.152.
 */
package DaNAMiCS;

import DaNAMiCS.Arc;
import DaNAMiCS.DFrame;
import DaNAMiCS.Draw;
import DaNAMiCS.PetriUnit;
import DaNAMiCS.PetriUnitList;
import DaNAMiCS.Place;
import DaNAMiCS.Subnet;
import DaNAMiCS.TextPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Transition
extends PetriUnit {
    public boolean Enabled;
    public boolean Orientation;
    public double Rate;
    public boolean Type;
    public boolean Animating;
    boolean chosen = false;
    public PetriUnitList ArcsIn;
    public PetriUnitList ArcsOut;
    static Rectangle maxbound = new Rectangle();
    JDialog TDialog;
    JTextField TDPRateval;
    JTextField TDPText;
    JCheckBox immCheck;
    JCheckBox orCheck;
    JCheckBox ipCheck;

    public Transition(int n, int n2, String string, double d, boolean bl, boolean bl2, boolean bl3, Subnet subnet) {
        this.set(n, n2, string);
        this.ArcsIn = null;
        this.ArcsOut = null;
        this.Enabled = false;
        this.Parent = subnet;
        this.Animating = false;
        this.Rate = d;
        this.Type = bl;
        this.Orientation = bl2;
        this.setiPs(bl3);
        this.setBound();
    }

    public Transition(int n, int n2, String string, boolean bl, Subnet subnet) {
        this.Orientation = false;
        this.set(n, n2, string);
        this.ArcsIn = null;
        this.ArcsOut = null;
        this.Enabled = false;
        this.Parent = subnet;
        this.Animating = false;
        this.Rate = 1.0;
        this.Type = bl;
        this.setiPs(false);
        this.setBound();
    }

    Arc AddArcIn(Place place, int n, int n2) {
        Arc arc = new Arc(place, n, this, place, this, n2);
        this.ArcsIn = new PetriUnitList(arc, this.ArcsIn);
        this.setBound();
        return arc;
    }

    Arc AddArcOut(Place place, int n, int n2) {
        Arc arc = new Arc(this, n, place, place, this, n2);
        this.ArcsOut = new PetriUnitList(arc, this.ArcsOut);
        this.setBound();
        return arc;
    }

    PetriUnit Find(int n, int n2) {
        PetriUnit petriUnit;
        if (this.in(n, n2)) {
            return this;
        }
        if (this.ArcsIn != null && (petriUnit = this.ArcsIn.Find(n, n2)) != null) {
            return petriUnit;
        }
        if (this.ArcsOut != null) {
            petriUnit = this.ArcsOut.Find(n, n2);
            return petriUnit;
        }
        return null;
    }

    Arc FindArc(int n, int n2) {
        PetriUnit petriUnit;
        if (this.ArcsIn != null && (petriUnit = this.ArcsIn.Find(n, n2)) != null) {
            return (Arc)petriUnit;
        }
        if (this.ArcsOut != null) {
            petriUnit = this.ArcsOut.Find(n, n2);
            return (Arc)petriUnit;
        }
        return null;
    }

    public void TDOKButtonAction(ActionEvent actionEvent) {
        try {
            System.out.println("5");
            this.setName(this.TDPText.getText());
            Double d = new Double(this.TDPRateval.getText());
            if (d < 0.0) {
                d = new Double(0.0);
            }
            this.Rate = d;
            System.out.println("6");
            this.Type = this.immCheck.isSelected();
            this.Orientation = this.orCheck.isSelected();
            this.iPs = this.ipCheck.isSelected();
            this.TDialog.dispose();
            System.out.println("7");
            DFrame.c.bound = this.bound;
            DFrame.c.repaint();
            System.out.println("8");
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane jOptionPane = new JOptionPane("Invalid Number!", 0);
            JDialog jDialog = jOptionPane.createDialog(DFrame.MyFrame, "Error!");
            ((Component)jDialog).setLocation(this.TDialog.getLocation().x, this.TDialog.getLocation().y);
            jDialog.show();
        }
    }

    public Transition copyTransition(Transition transition) {
        return new Transition(transition.x, transition.y, transition.name, transition.Rate, transition.Type, transition.Orientation, transition.iPs, transition.Parent);
    }

    public PetriUnit deepCopy1() {
        try {
            this.copy = (PetriUnit)this.clone();
            if (this.ArcsIn != null) {
                ((Transition)this.copy).ArcsIn = this.ArcsIn.deepCopy1();
            }
            if (this.ArcsOut != null) {
                ((Transition)this.copy).ArcsOut = this.ArcsOut.deepCopy1();
            }
            return this.copy;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void deepCopy2() {
        if (this.ArcsIn != null) {
            this.ArcsIn.deepCopy2();
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.deepCopy2();
        }
    }

    boolean delete(PetriUnit petriUnit) {
        if (this.ArcsIn != null) {
            this.ArcsIn = this.ArcsIn.deleteByObject(petriUnit);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut = this.ArcsOut.deleteByObject(petriUnit);
        }
        if (petriUnit == this) {
            this.delete();
            return true;
        }
        return false;
    }

    boolean deleteSelected() {
        if (this.selected) {
            this.delete();
            return true;
        }
        if (this.ArcsIn != null) {
            this.ArcsIn = this.ArcsIn.deleteSelected();
        }
        if (this.ArcsOut != null) {
            this.ArcsOut = this.ArcsOut.deleteSelected();
        }
        return false;
    }

    public void dialog() {
        this.TDialog = new JDialog(DFrame.MyFrame, "Transition Attributes", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel("Transition Name:");
        JLabel jLabel2 = new JLabel("Rate:");
        this.TDPText = new JTextField();
        this.TDPRateval = new JTextField();
        this.TDPText.setText(this.name);
        this.TDPText.setColumns(10);
        Double d = new Double(this.Rate);
        this.TDPRateval.setText(d.toString());
        this.TDPRateval.setColumns(10);
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Transition.this.TDOKButtonAction(actionEvent);
            }
        });
        this.TDPText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Transition.this.TDOKButtonAction(actionEvent);
            }
        });
        this.TDPRateval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Transition.this.TDOKButtonAction(actionEvent);
            }
        });
        this.immCheck = new JCheckBox("Immediate", this.Type);
        this.immCheck.setSelected(this.Type);
        this.orCheck = new JCheckBox("Vertical", this.Orientation);
        this.orCheck.setSelected(this.Orientation);
        this.ipCheck = new JCheckBox("Interaction Pt.", this.iPs);
        this.ipCheck.setSelected(this.iPs);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3));
        this.TDialog.getContentPane().add((Component)jPanel, "North");
        jPanel2.add(jLabel);
        jPanel2.add(this.TDPText);
        jPanel3.add(jLabel2);
        jPanel3.add(this.TDPRateval);
        jPanel4.add(this.immCheck);
        jPanel4.add(this.orCheck);
        jPanel4.add(this.ipCheck);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.TDialog.getContentPane().add((Component)jButton, "South");
        this.TDialog.getContentPane().add((Component)new TextPosition(this), "Center");
        this.TDialog.pack();
        ((Component)this.TDialog).setLocation(DFrame.MyFrame.getLocation().x + DFrame.MyFrame.getBounds().width / 2 - this.TDialog.getBounds().width / 2, DFrame.MyFrame.getLocation().y + DFrame.MyFrame.getBounds().height / 2 - this.TDialog.getBounds().height / 2);
        this.TDialog.show();
    }

    public void fire() {
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).fireFrom();
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).fireTo();
            petriUnitList = petriUnitList.next;
        }
    }

    public Rectangle firebound() {
        PetriUnitList petriUnitList;
        Place place;
        Arc arc;
        maxbound.setSize(this.bound.getSize());
        maxbound.setLocation(this.bound.getLocation());
        PetriUnitList petriUnitList2 = this.ArcsIn;
        while (petriUnitList2 != null) {
            arc = (Arc)petriUnitList2.p;
            maxbound.add(arc.p.bound);
            place = arc.p;
            petriUnitList = place.arcs;
            while (petriUnitList != null) {
                maxbound.add(((Arc)petriUnitList.p).t.bound);
                petriUnitList = petriUnitList.next;
            }
            petriUnitList2 = petriUnitList2.next;
        }
        petriUnitList2 = this.ArcsOut;
        while (petriUnitList2 != null) {
            arc = (Arc)petriUnitList2.p;
            maxbound.add(arc.p.bound);
            place = arc.p;
            petriUnitList = place.arcs;
            while (petriUnitList != null) {
                maxbound.add(((Arc)petriUnitList.p).t.bound);
                petriUnitList = petriUnitList.next;
            }
            petriUnitList2 = petriUnitList2.next;
        }
        return maxbound;
    }

    PetriUnitList getSelected(Rectangle rectangle, PetriUnitList petriUnitList) {
        if (rectangle.contains(this.x, this.y)) {
            return new PetriUnitList(this, this.ArcsIn.getSelected(rectangle, this.ArcsOut.getSelected(rectangle, petriUnitList)));
        }
        return this.ArcsIn.getSelected(rectangle, this.ArcsOut.getSelected(rectangle, petriUnitList));
    }

    public int getType() {
        return 3;
    }

    boolean in(int n, int n2) {
        if (this.Orientation) {
            if (n < this.x - 5) {
                return false;
            }
            if (n2 < this.y - 10) {
                return false;
            }
            if (n > this.x + 5) {
                return false;
            }
            if (n2 > this.y + 10) {
                return false;
            }
        } else {
            if (n < this.x - 10) {
                return false;
            }
            if (n2 < this.y - 5) {
                return false;
            }
            if (n > this.x + 10) {
                return false;
            }
            if (n2 > this.y + 5) {
                return false;
            }
        }
        return true;
    }

    public boolean isEnabled() {
        return this.Enabled;
    }

    boolean moveSelected(int n, int n2) {
        if (this.selected) {
            this.x += n;
            this.y += n2;
        }
        if (this.ArcsIn != null) {
            this.ArcsIn.moveSelected(n, n2);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.moveSelected(n, n2);
        }
        return this.selected;
    }

    void paint(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * draw.scale);
        int n2 = (int)((float)this.y * draw.scale);
        if (this.selected) {
            graphics.setColor(PetriUnit.selectedColor);
            if (this.Orientation) {
                graphics.fillRect(n - PetriUnit.five - PetriUnit.two, n2 - PetriUnit.ten - PetriUnit.two, PetriUnit.ten + PetriUnit.four + 1, PetriUnit.twenty + PetriUnit.four + 1);
            } else {
                graphics.fillRect(n - PetriUnit.ten - PetriUnit.two, n2 - PetriUnit.five - PetriUnit.two, PetriUnit.twenty + PetriUnit.four + 1, PetriUnit.ten + PetriUnit.four + 1);
            }
        }
        graphics.setColor(Color.black);
        if (this.ArcsIn != null) {
            this.ArcsIn.paint(draw);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.paint(draw);
        }
        if (this.Animating) {
            if (!this.isEnabled()) {
                if (this.Type) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.white);
                }
            } else if (this.Type) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.green);
            }
        } else if (this.Type) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        if (this.Orientation) {
            graphics.fillRect(n - PetriUnit.five + 1, n2 - PetriUnit.ten + 1, PetriUnit.ten - 1, PetriUnit.twenty - 1);
            if (this.iPs) {
                graphics.setColor(Color.cyan);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawRect(n - PetriUnit.five, n2 - PetriUnit.ten, PetriUnit.ten, PetriUnit.twenty);
        } else {
            graphics.fillRect(n - PetriUnit.ten + 1, n2 - PetriUnit.five + 1, PetriUnit.twenty - 1, PetriUnit.ten - 1);
            if (this.iPs) {
                graphics.setColor(Color.cyan);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawRect(n - PetriUnit.ten, n2 - PetriUnit.five, PetriUnit.twenty, PetriUnit.ten);
        }
        graphics.setColor(Color.black);
        this.paintName(draw);
    }

    void paint2(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * draw.scale);
        int n2 = (int)((float)this.y * draw.scale);
        graphics.setColor(Color.red);
        if (this.Orientation) {
            graphics.fillRect(n - PetriUnit.five + 1, n2 - PetriUnit.ten + 1, PetriUnit.ten - 1, PetriUnit.twenty - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(n - PetriUnit.five, n2 - PetriUnit.ten, PetriUnit.ten, PetriUnit.twenty);
        } else {
            graphics.fillRect(n - PetriUnit.ten + 1, n2 - PetriUnit.five + 1, PetriUnit.twenty - 1, PetriUnit.ten - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(n - PetriUnit.ten, n2 - PetriUnit.five, PetriUnit.twenty, PetriUnit.ten);
        }
        this.paintName(draw);
    }

    void paint3(Draw draw) {
        Graphics graphics = draw.g;
        int n = (int)((float)this.x * draw.scale);
        int n2 = (int)((float)this.y * draw.scale);
        graphics.setColor(Color.yellow);
        if (this.Orientation) {
            graphics.fillRect(n - PetriUnit.five + 1, n2 - PetriUnit.ten + 1, PetriUnit.ten - 1, PetriUnit.twenty - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(n - PetriUnit.five, n2 - PetriUnit.ten, PetriUnit.ten, PetriUnit.twenty);
        } else {
            graphics.fillRect(n - PetriUnit.ten + 1, n2 - PetriUnit.five + 1, PetriUnit.twenty - 1, PetriUnit.ten - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(n - PetriUnit.ten, n2 - PetriUnit.five, PetriUnit.twenty, PetriUnit.ten);
        }
        this.paintName(draw);
    }

    void print() {
    }

    void resetBound() {
        if (this.Orientation) {
            this.bound.setSize(11, 21);
            this.bound.setLocation(this.x - 5, this.y - 10);
            this.bound.add(this.x - 5, this.y - 10);
            this.bound.add(this.x + 6, this.y + 11);
        } else {
            this.bound.setSize(21, 11);
            this.bound.setLocation(this.x - 10, this.y - 5);
            this.bound.add(this.x - 10, this.y - 5);
            this.bound.add(this.x + 11, this.y + 6);
        }
        this.boundLabel();
        PetriUnitList petriUnitList = null;
        petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).resetHandle();
            petriUnitList.p.setBound();
            this.bound.add(petriUnitList.p.bound);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).resetHandle();
            petriUnitList.p.setBound();
            this.bound.add(petriUnitList.p.bound);
            petriUnitList = petriUnitList.next;
        }
    }

    void setBound() {
        if (this.Orientation) {
            this.bound.setSize(11, 21);
            this.bound.setLocation(this.x - 5, this.y - 10);
            this.bound.add(this.x - 5, this.y - 10);
            this.bound.add(this.x + 6, this.y + 11);
        } else {
            this.bound.setSize(21, 11);
            this.bound.setLocation(this.x - 10, this.y - 5);
            this.bound.add(this.x - 10, this.y - 5);
            this.bound.add(this.x + 11, this.y + 6);
        }
        this.boundLabel();
        PetriUnitList petriUnitList = null;
        petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            this.bound.add(petriUnitList.p.bound);
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            this.bound.add(petriUnitList.p.bound);
            petriUnitList = petriUnitList.next;
        }
    }

    public void setEnabled() {
        this.Enabled = true;
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            if (!((Arc)petriUnitList.p).canFireFrom()) {
                this.Enabled = false;
                return;
            }
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            if (!((Arc)petriUnitList.p).canFireTo()) {
                this.Enabled = false;
                return;
            }
            petriUnitList = petriUnitList.next;
        }
    }

    public void setSelect(boolean bl) {
        this.selected = bl;
        if (this.ArcsIn != null) {
            this.ArcsIn.setSelect(bl);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.setSelect(bl);
        }
    }

    public void setSelect(boolean bl, Rectangle rectangle) {
        if (rectangle.contains(this.x, this.y)) {
            this.selected = bl;
        }
        if (this.ArcsIn != null) {
            this.ArcsIn.setSelect(bl, rectangle);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.setSelect(bl, rectangle);
        }
    }

    public void toggleSelect(Rectangle rectangle) {
        if (rectangle.contains(this.x, this.y)) {
            this.selected ^= true;
        }
        if (this.ArcsIn != null) {
            this.ArcsIn.toggleSelect(rectangle);
        }
        if (this.ArcsOut != null) {
            this.ArcsOut.toggleSelect(rectangle);
        }
    }

    public void unFire() {
        PetriUnitList petriUnitList = this.ArcsIn;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).unFireFrom();
            petriUnitList = petriUnitList.next;
        }
        petriUnitList = this.ArcsOut;
        while (petriUnitList != null) {
            ((Arc)petriUnitList.p).unFireTo();
            petriUnitList = petriUnitList.next;
        }
    }

    int xEdge(int n, int n2) {
        n2 = Math.abs(n2);
        if (this.Orientation) {
            if (2.5 * (double)n >= (double)n2) {
                return (int)((float)this.x * PetriUnit.scale + (float)PetriUnit.five);
            }
            if (-2.5 * (double)n >= (double)n2) {
                return (int)((float)this.x * PetriUnit.scale - (float)PetriUnit.five);
            }
            return (int)((float)this.x * PetriUnit.scale + (float)(PetriUnit.ten * n / n2));
        }
        if (n >= 2 * n2) {
            return (int)((float)this.x * PetriUnit.scale + (float)PetriUnit.ten);
        }
        if (-n >= 2 * n2) {
            return (int)((float)this.x * PetriUnit.scale - (float)PetriUnit.ten);
        }
        return (int)((float)this.x * PetriUnit.scale + (float)(PetriUnit.five * n / n2));
    }

    int yEdge(int n, int n2) {
        n = Math.abs(n);
        if (this.Orientation) {
            if (2 * n <= n2) {
                return (int)((float)this.y * PetriUnit.scale + (float)PetriUnit.ten);
            }
            if (-2 * n >= n2) {
                return (int)((float)this.y * PetriUnit.scale - (float)PetriUnit.ten);
            }
            return (int)((float)this.y * PetriUnit.scale + (float)(PetriUnit.five * n2 / n));
        }
        if ((double)n <= 2.5 * (double)n2) {
            return (int)((float)this.y * PetriUnit.scale + (float)PetriUnit.five);
        }
        if ((double)(-n) >= 2.5 * (double)n2) {
            return (int)((float)this.y * PetriUnit.scale - (float)PetriUnit.five);
        }
        return (int)((float)this.y * PetriUnit.scale + (float)(PetriUnit.ten * n2 / n));
    }
}

