divert(-1)dnl
define(`M4FILE', `perl.m4')
define(`FILE_PROLOG', `define(`FILENAME', $1)
=pod
Perl prolog file - the following information was generated by
DBOW, the database object generator.  Do not edit the contents
of this file but instead the source file from which it was
generated.  Changes to this file will be lost.
=cut
package $1;
use Dbow;
use strict;
use Date::Manip;
')

define(`FILE_EPILOG',`
1;
')

define(`STYPE_UNSIGNED',	`my $')
define(`STYPE_TINYINT',		`my $$1')
define(`STYPE_SMALLINT',	`my $$1')
define(`STYPE_MEDINT',		`my $$1')
define(`STYPE_INT',		`my $$1')
define(`STYPE_BIGINT',		`my $$1')
define(`STYPE_FLOAT',		`my $$1')
define(`STYPE_DOUBLE',		`my $$1')
define(`STYPE_NUMERIC',		`my $$1')
define(`STYPE_DATE',		`my $$1')
define(`STYPE_TIME',		`my $$1')
define(`STYPE_DATETIME',	`my $$1')
define(`STYPE_TSTAMP',		`my $$1')
define(`STYPE_YEAR',		`my $$1')
define(`STYPE_CHAR',		`my $$1')
define(`STYPE_VARCHAR',		`my $$1')
define(`STYPE_TINYBLOB',	`my $$1')
define(`STYPE_TINYTEXT',	`my $$1')
define(`STYPE_BLOB',		`my $$1')
define(`STYPE_TEXT',		`my $$1')
define(`STYPE_MEDBLOB',		`my $$1')
define(`STYPE_MEDTEXT',		`my $$1')
define(`STYPE_LONGBLOB',	`my $$1')
define(`STYPE_LONGTEXT',	`my $$1')
define(`STYPE_ENUM',		`<error>')
define(`STYPE_SET',		`my @$1')

define(`FTYPE_TINYINT',`')
define(`FTYPE_SMALLINT',`')
define(`FTYPE_MEDINT',`')
define(`FTYPE_INT',`')
define(`FTYPE_BIGINT',`')
define(`FTYPE_FLOAT',`')
define(`FTYPE_DOUBLE',`')
define(`FTYPE_NUMERIC',`')
define(`FTYPE_DATE',`')
define(`FTYPE_TIME',`')
define(`FTYPE_DATETIME',`')
define(`FTYPE_TSTAMP',`')
define(`FTYPE_YEAR',`')
define(`FTYPE_CHAR',`')
define(`FTYPE_VARCHAR',`')
define(`FTYPE_TINYBLOB',`')
define(`FTYPE_TINYTEXT',`')
define(`FTYPE_BLOB',`')
define(`FTYPE_TEXT',`')
define(`FTYPE_MEDBLOB',`')
define(`FTYPE_MEDTEXT',`')
define(`FTYPE_LONGBLOB',`')
define(`FTYPE_LONGTEXT',`')
define(`FTYPE_ENUM',`')
define(`FTYPE_SET',`')

define(ATYPE_TINYINT,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_SMALLINT,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_MEDINT,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_INT,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_BIGINT,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_FLOAT,`	$1 = (defined $2 &&  $2 =~ /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/) ? $2:0.0;')
define(ATYPE_DOUBLE,`	$1 = (defined $2 &&  $2 =~ /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/) ? $2:0.0;')
define(ATYPE_NUMERIC,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_DATE,`	$1 = &UnixDate(&ParseDate($2), "%s");')
define(ATYPE_TIME,`	$1 = &UnixDate(&ParseDate($2), "%s");')
define(ATYPE_DATETIME,`	$1 = &UnixDate(&ParseDate($2), "%s");')
define(ATYPE_TSTAMP,`	$1 = &UnixDate(&ParseDate($2), "%s");')
define(ATYPE_YEAR,`	$1 = (defined $2) ? int($2):0;')
define(ATYPE_CHAR,`	$1 = $2')
define(ATYPE_VARCHAR,`	$1 = $2')
define(ATYPE_TINYBLOB,`	$1 = $2')
define(ATYPE_TINYTEXT,`	$1 = $2')
define(ATYPE_BLOB,`	$1 = $2')
define(ATYPE_TEXT,`	$1 = $2')
define(ATYPE_MEDBLOB,`	$1 = $2')
define(ATYPE_MEDTEXT,`	$1 = $2')
define(ATYPE_MEDBLOB,`	$1 = $2')
define(ATYPE_LONGBLOB,`	$1 = $2')
define(ATYPE_LONGTEXT,`	$1 = $2')
define(ATYPE_ENUM,`err "ENUM type unsupported."')
define(ATYPE_SET,`err "SET type unsupported."')
define(QTYPE_TINYINT,`$a')
define(QTYPE_SMALLINT,`$b')
define(QTYPE_MEDINT,`$c')
define(QTYPE_INT,`$d')
define(QTYPE_BIGINT,`$e')
define(QTYPE_FLOAT,`$f')
define(QTYPE_DOUBLE,`$g')
define(QTYPE_NUMERIC,`$h')
define(QTYPE_DATE,`$i')
define(QTYPE_TIME,`$j')
define(QTYPE_DATETIME,`$k')
define(QTYPE_TSTAMP,`$l')
define(QTYPE_YEAR,`$m')
define(QTYPE_CHAR,`$n')
define(QTYPE_VARCHAR,`$o')
define(QTYPE_TINYBLOB,`$p')
define(QTYPE_TINYTEXT,`$q')
define(QTYPE_BLOB,`$r')
define(QTYPE_TEXT,`$s')
define(QTYPE_MEDBLOB,`$t')
define(QTYPE_MEDTEXT,`$u')
define(QTYPE_LONGBLOB,`$v')
define(QTYPE_LONGTEXT,`$w')
define(QTYPE_ENUM,`$x')
define(QTYPE_SET,`$y')

define(PTYPE_TINYINT,`	print FP "$1 = $2\n";')
define(PTYPE_SMALLINT,`	print FP "$1 = $2\n";')
define(PTYPE_MEDINT,`	print FP "$1 = $2\n";')
define(PTYPE_INT,`	print FP "$1 = $2\n";')
define(PTYPE_BIGINT,`	print FP "$1 = $2\n";')
define(PTYPE_FLOAT,`	print FP "$1 = $2\n";')
define(PTYPE_DOUBLE,`	print FP "$1 = $2\n";')
define(PTYPE_NUMERIC,`	print FP "$1 = $2\n";')
define(PTYPE_DATE,`	print FP "$1 = " . gmtime($2) . "\n";')
define(PTYPE_TIME,`	print FP "$1 = " . gmtime($2)."\n";')
define(PTYPE_DATETIME,`	print FP "$1 = " . gmtime($2)."\n";')
define(PTYPE_TSTAMP,`	print FP "$1 = " . gmtime($2)."\n";')
define(PTYPE_YEAR,`	print FP "$1 = $2\n";')
define(PTYPE_CHAR,`	print FP "$1 = $2\n";')
define(PTYPE_VARCHAR,`	print FP "$1 = $2\n";')
define(PTYPE_TINYBLOB,`	print FP "$1 = $2\n";')
define(PTYPE_TINYTEXT,`	print FP "$1 = $2\n";')
define(PTYPE_BLOB,`	print FP "$1 = $2\n";')
define(PTYPE_TEXT,`	print FP "$1 = $2\n";')
define(PTYPE_MEDBLOB,`	print FP "$1 = $2\n";')
define(PTYPE_MEDTEXT,`	print FP "$1 = $2\n";')
define(PTYPE_LONGBLOB,`	print FP "$1 = $2\n";')
define(PTYPE_LONGTEXT,`	print FP "$1 = $2\n";')
define(PTYPE_ENUM,`	print FP "$1 = ENUM?\n";')
define(PTYPE_SET,`	print FP "$1 = SET?\n";')

define(`forloop',
       `pushdef(`$1', `$2')_forloop(`$1', `$2', `$3', `$4')popdef(`$1')')
define(`_forloop',
       `$4`'ifelse($1, `$3', ,
	   `define(`$1', incr($1))_forloop(`$1', `$2', `$3', `$4')')')
define(`concat',`$1$2')

define(STRNAME,`STR_$1_NAME$2')
define(STRTYPE,`STR_$1_TYPE$2')
define(STYPE,`concat(S,STR_$1_TYPE$2)')
define(QTYPE,`concat(Q,STR_$1_TYPE$2)')
define(FTYPE,`concat(F,STR_$1_TYPE$2)(p->STRNAME($1, $2))')
define(ATYPE,`concat(A,STR_$1_TYPE$2)(p->STRNAME($1, $2),row[$2])')
define(PTYPE,`concat(P,STR_$1_TYPE$2)(STRNAME($1, $2), p->STRNAME($1, $2))')

define(STRUCT_BODY,`')
define(INIT_PROTO, `')

define(INIT_BODY, `
=pod
Parameters:
	dbh - database handle
	q - query

Returns:
	List of hashref, containing column-value pairs of the result
=cut

sub db_run$1query
{
	my $dbh = `shift';
	my $q = `shift';

	my $sth = $dbh->prepare($q);
	my $r = $sth->execute();
	unless($r)
	{
		return undef;
	}
	
	return $sth->fetchall_arrayref({});
}

')

define(INSERT_PROTO, `')
define(INSERT_BODY, `
=pod
Parameters:
	dbh - database handle
	val - hash, containing column-value pairs to be inserted

Returns:
	True, on success, false otherwise
=cut

sub $2
{
	my $dbh = `shift';
	my $hr = `shift';

	my $sth = $dbh->prepare("INSERT INTO $1(".join(",", sort keys %$hr).") VALUES (".join(",", map {"?"} keys %$hr).")" );
	returns $sth->execute(map {$hr->{$_}} sort keys %$hr );
')

define(DELETE_PROTO, `')
define(DELETE_BODY, `
=pod
Parameters:
	dbh - database handle
	x - the value of the STRNAME($1,$3) of the rows to be deleted

Returns:
	True on success, false otherwise.
=cut

sub $2
{
	my $dbh = `shift';
	my $x = `shift';

	my $sth = $dbh->prepare("DELETE FROM $1 WHERE STRNAME($1,$3) = ?");
	return $sth->execute($x);
}
')

define(SEARCH_PROTO,`')
define(SEARCH_BODY,`
=pod
Parameters:
	dbh - database handle
	x - The value of STRNAME($1,$3) to be searched

Returns:
	List of hash references with column/value pairs
=cut

sub $2
{
	my $dbh = `shift';
	my $x = `shift';

	my $sth = $dbh->prepare("SELECT * FROM $1 WHERE STRNAME($1,$3) = ?");
	my $rv = $sth->execute($x);

	unless($rv)
	{
		return undef;
	}
	
	return $sth->fetchall_arrayref({});
}
')


define(UPDATE_PROTO,`')
define(UPDATE_BODY,`
=pod
Parameters:
	dbh - database handler
	hr - hashref with column/values pairs for update
	i - the value of the STRNAME($1,$3) to update

Returns:
	True on success, false otherwise
=cut

sub $2
{
	my $dbh = `shift';
	my $hr = `shift';
	my $x = `shift';

	my $sth = $dbh->prepare("UPDATE $1 " . join(",", map {"SET $_=?"} sort keys %$hr). " WHERE STRNAME($1, $3) = ?");
	return $sth->execute(map {$hr->{$_}} sort keys %$hr, $x);
}
')

define(DUMP_PROTO, `')

define(DUMP_BODY,`
=pod
Dumps object to STDOUT, or whatever was "select"ed before call to this function
Parameters:
	hr - hash, containing column/value pairs;
	
=cut

sub $2
{
	my $hr = `shift';
	print join "\n", map {$_ . " = " $hr->{$_}} sort keys %$hr;
}
')

divert(0)dnl
