/***************************************************************************
                          cdcproto.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCPROTO_H
#define CDCPROTO_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/cthread.h>

class CMessageSearchFile;

class DLL_EXPORT CDCProto : public CConnection {
public: 
	/** */
	CDCProto();
	/** */
	virtual ~CDCProto();

	/** chat message */
	int SendChat( CString sNick, CString s );
	/** send version info */
	int SendVersion( CString sVersion );
	/** send myinfo */
	int SendMyInfo( CString sNick, CString sComment, CString sConnectionType, eUserAwayMode eAwayMode, CString sEMail, CString sShare );
	/** send key */
	int SendKey( CString s );
	/** send validate nick */
	int SendValidateNick( CString sNick );
	/** send lock */
	int SendLock();
	/** send send */
	int SendSend();
	/** send my nick */
	int SendMyNick( CString sNick );
	/** send get */
	int SendGet( CString file, ulonglong pos, ulonglong size = 0 );
	/** send direction */
	int SendDirection( eDirection Direction, int level );
	/** send private message */
	virtual int SendPrivateMessage( CString sNick, CString sTo, CString sMsg, CString sFromNick = "" );
	/** send request nick list */
	virtual int RequestNickList();
	/** send rev connect to me */
	int SendRevConnectToMe( CString sNick, CString sDstNick );
	/** send error */
	int SendError( CString message );
	/** */
	int SendFileLength( ulonglong len );
	/** */
	int SendListLen( ulonglong len );
	/** */
	int SendGetListLen();
	/** */
	int SendConnectToMe( CString sDstNick, CString host );
	/** */
	int SendCanceled();
	/** send string */
	int SendString( CString message );
	/** send password */
	int SendPass( CString pass );
	/** operator kick */
	int SendKick( CString nick );
	/** operator force move a user */
	int SendOpForceMove( CString nick, CString host, CString message );
	/** */
	int SendMaxedOut();
	/** */
	int SendGetInfo( CString sNick, CString sMyNick );
	/** */
	int SendSupports( CString s );
	/** */
	int SendSearch( CMessageSearchFile * msg );

private:
	/** */
	CThread DCProtoThread;
};

#endif
