/***************************************************************************
                          cthread.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTHREAD_H
#define CTHREAD_H

/**
  *@author Mathias Kster
  */

#include <pthread.h>

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>

class _CCallback;

class DLL_EXPORT CMutex {
public:
	/** */
	CMutex();
	/** */
	virtual ~CMutex();

	/** */
	int Lock();
	/** */
	bool TryLock();
	/** */
	int UnLock();

private:
	/** */
	pthread_mutex_t mutex;
};

class DLL_EXPORT CThread : public CMutex {
public:
	/** */
	CThread();
	/** */
	virtual ~CThread();

	/** */
	int Start();
	/** */
	int Stop( bool bHard = TRUE );
	/** */
	bool Stopped() const;

	/** */
	void NanoSleep( unsigned int );
	/** */
	void SetThreadCallBackFunction( _CCallback * callback );

	/** */
	virtual void Thread(CObject *) {};


protected:
	/** */
	int iRun;

private:
	/** callback function */
	_CCallback * _thread_callback_function;
	/** */
	pthread_t thread;
	/** */
	int iStop;
	/** */
	static void * MainThread(void *object);
};

/** */
inline bool CThread::Stopped() const
{ return (iStop==1); }

#endif
