/***************************************************************************
                           csharelist.cpp  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <unistd.h>
#include <stdlib.h>
#endif

#include <dclib/core/che3.h>
#include <dclib/core/cbz.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cxml.h>
#include <dclib/core/cbytearray.h>
#include <dclib/cconfig.h>
#include <dclib/csearchindex.h>

#include "csharelist.h"

/** */
CShareList::CShareList()
{
	m_nShareSize        = 0;
	m_pHE3ShareBuffer   = 0;
	m_pBZShareBuffer    = 0;
	m_pXMLBZShareBuffer = 0;
}

/** */
CShareList::~CShareList()
{
	m_MutexShareList.Lock();

	if ( m_pHE3ShareBuffer )
	{
		delete m_pHE3ShareBuffer;
		 m_pHE3ShareBuffer = 0;
	}

	if ( m_pBZShareBuffer )
	{
		delete m_pBZShareBuffer;
		m_pBZShareBuffer = 0;
	}

	if ( m_pXMLBZShareBuffer )
	{
		delete m_pXMLBZShareBuffer;
		m_pXMLBZShareBuffer = 0;
	}
	
	m_MutexShareList.UnLock();
}

/** */
bool CShareList::Load()
{
	bool res = FALSE;
	CDir dir;
	FILE * in;
	CString s;
	CByteArray ba;
	ulonglong size;

	m_MutexShareList.Lock();
	
	s = CConfig::Instance()->GetConfigPath() + DC_USER_INDEXLIST;

	size = dir.getFileSize(s,FALSE);

	if ( size != 0 )
	{
		if ( ba.LoadFromFile(s) == TRUE )
		{
			s.Set((const char*)ba.Data(),ba.Size());
			res = TRUE;
		}
	}

	m_sIndexShareBuffer = s;
	
	m_MutexShareList.UnLock();
	
	return res;
}

/** */
void CShareList::Save()
{
	FILE * out;
	CString s;

	m_MutexShareList.Lock();

	s = CConfig::Instance()->GetConfigPath() + DC_USER_INDEXLIST;

	if ( (out = fopen(s.Data(),"wb")) != 0 )
	{
		if ( fwrite( m_sIndexShareBuffer.Data(), m_sIndexShareBuffer.Length(), 1, out ) == (ulonglong)m_sIndexShareBuffer.Length() )
		{
		}

		fclose(out);
	}
	else
	{
		printf("[ERROR] open %s\n",s.Data());
	}
	
	m_MutexShareList.UnLock();
}

/** */
void CShareList::SetIndexBuffer( CString s )
{
	m_MutexShareList.Lock();
	
	m_sIndexShareBuffer = s;
	
	m_MutexShareList.UnLock();
}

/** */
void CShareList::CreateList( CSearchIndex * si )
{
	CDir dir;
	int err;
	CString s,s1,slength;
	CByteArray ba;
	long i,j,d;
	ulonglong sharesize;
	ulonglong index,oindex;
	CString res,resnew;
	struct filebaseobject fbo;
	int den,deo,dde;
	CXml xml;
	
	m_MutexShareList.Lock();

	err = -1;

	m_nShareSize = 0;

	if ( m_pHE3ShareBuffer )
	{
		delete m_pHE3ShareBuffer;
		m_pHE3ShareBuffer = 0;
	}

	if ( m_pBZShareBuffer )
	{
		delete m_pBZShareBuffer;
		m_pBZShareBuffer = 0;
	}

	if ( m_pXMLBZShareBuffer )
	{
		delete m_pXMLBZShareBuffer;
		m_pXMLBZShareBuffer = 0;
	}
	
	resnew  = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>";
	resnew += "<FileListing Version=\"1\" Generator=\"Valknut\">";
	
	sharesize = 0;
	i = j = 0;
	CString fi="\xD\xA";
	den = 0;
	deo = -1;
	dde = 0;
	oindex = 0;
	
	while((i=m_sIndexShareBuffer.Find(fi,j))>0)
	{
		s1 = m_sIndexShareBuffer.Mid(j,i-j);

		d = s1.FindRev('|');
		if ( d != -1 )
		{
			// file
			index = s1.Mid(d+1,s1.Length()-d-1).asULL();
			
			if ( index != oindex )
			{
				res = resnew = "";
				sharesize = 0;
				break;
			}
			
			oindex++;
			
			if ( si->GetFileBaseObject(index,&fbo) )
			{
				sharesize += fbo.m_nSize;

				res += s1.Left(d) + "|" + CString().setNum(fbo.m_nSize) + fi;
				
				s1 = s1.Left(d).Replace("\x9","");
				resnew += "<File Name=\"";
				resnew += xml.ToUTF8(s1);
				resnew += "\" Size=\"";
				resnew += CString().setNum(fbo.m_nSize);
				resnew += "\" TTH=\"";
				resnew += si->GetHash(fbo.m_nHashIndex).Replace("TTH:","");
				resnew += "\"/>\n";
			}
		}
		else
		{
			// path
			res += s1 + fi;

			// dir end node
			for(den=0;den<s1.Length();den++)
				if ( s1.Data()[den] != '\x9' )
					break;

			while ( deo >= den )
			{
				dde--;
				deo--;
				resnew += "</Directory>\n";
			}
			dde++;
			resnew += "<Directory Name=\"";
			s1 = s1.Replace("\x9","");
			resnew += xml.ToUTF8(s1);
			resnew += "\">\n";

			deo = den;
		}
		
		j = i+2;
	}

	if ( resnew != "" )
	{
		while(dde)
		{
			resnew += "</Directory>\n";
			dde--;
		}
		resnew += "</FileListing>\n";
	}

	//printf("%s\n",resnew.Data());
	
	CreateBuffer( esbtHE3, res );
	CreateBuffer( esbtBZ, res );
	CreateBuffer( esbtXMLBZ, resnew );

	m_nShareSize = sharesize;

	m_MutexShareList.UnLock();
	
	// save share list
	Save();
}

/** */
void CShareList::CreateBuffer( enum eShareBufferType e, CString sharebuffer )
{
	CByteArray * ba;
	CByteArray iba;
	CHE3  * he3;
	CBZ * bz;

	if ( e == esbtHE3 )
	{
		if ( m_pHE3ShareBuffer )
		{
			delete m_pHE3ShareBuffer;
			m_pHE3ShareBuffer = 0;
		}
		
		if ( sharebuffer != "" )
		{
			// he3 compression
			he3 = new CHE3();
			ba = he3->encode_he3_data(&sharebuffer);
			delete he3;

			if ( ba != 0 )
			{
				m_pHE3ShareBuffer = ba;
			}
			else
			{
				printf("[ERROR] he3 compression failed\n");
			}
		}
	}
	else if ( e == esbtBZ )
	{
		if ( m_pBZShareBuffer )
		{
			delete m_pBZShareBuffer;
			m_pBZShareBuffer = 0;
		}

		if ( sharebuffer != "" )
		{
#ifdef HAVE_LIBBZ2
			// bz compression
			m_pBZShareBuffer = new CByteArray();

			iba.Append(sharebuffer.Data(),sharebuffer.Length());

			bz = new CBZ();
			if ( !bz->Compress(&iba,m_pBZShareBuffer) )
			{
				delete m_pBZShareBuffer;
				m_pBZShareBuffer = 0;
				printf("[ERROR] bz2 compression failed\n");
			}
			delete bz;
#endif
		}
	}
	else if ( e == esbtXMLBZ )
	{
		if ( m_pXMLBZShareBuffer )
		{
			delete m_pXMLBZShareBuffer;
			m_pXMLBZShareBuffer = 0;
		}

		if ( sharebuffer != "" )
		{
#ifdef HAVE_LIBBZ2
			// bz compression
			m_pXMLBZShareBuffer = new CByteArray();

			iba.Append(sharebuffer.Data(),sharebuffer.Length());

			bz = new CBZ();
			if ( !bz->Compress(&iba,m_pXMLBZShareBuffer) )
			{
				delete m_pXMLBZShareBuffer;
				m_pXMLBZShareBuffer = 0;
				printf("[ERROR] xmlbz2 compression failed\n");
			}
			delete bz;
#endif
		}
	}
}

/** */
int CShareList::GetShareBuffer( eShareBufferType type, CByteArray * sharebuffer, bool decompress )
{
	int err;

	m_MutexShareList.Lock();

	err = 0;

	if( !sharebuffer )
	{
		err = -1;
	}
	else
	{
		sharebuffer->SetSize(0);

		switch(type)
		{
			case esbtHE3:
				if ( !m_pHE3ShareBuffer )
					err = -1;
				else if ( decompress )
				{
					CString * s;
					CHE3 * he3 = new CHE3();
					s = he3->decode_he3_data(m_pHE3ShareBuffer);
					delete he3;
					if ( s )
					{
						sharebuffer->Append(s->Data(),s->Length());
						delete s;
					}
					else
						err = -1;
				}
				else
					sharebuffer->Append(m_pHE3ShareBuffer->Data(),m_pHE3ShareBuffer->Size());
				break;
			case esbtBZ:
				if ( !m_pBZShareBuffer )
					err = -1;
#ifdef HAVE_LIBBZ2
				else if ( decompress )
				{
					CBZ * bz = new CBZ();
					if ( !bz->Decompress( m_pBZShareBuffer, sharebuffer ) )
						err = -1;
					delete bz;
				}
				else
					sharebuffer->Append(m_pBZShareBuffer->Data(),m_pBZShareBuffer->Size());
#endif
				break;
			case esbtXMLBZ:
				if ( !m_pXMLBZShareBuffer )
					err = -1;
#ifdef HAVE_LIBBZ2
				else if ( decompress )
				{
					CBZ * bz = new CBZ();
					if ( !bz->Decompress( m_pXMLBZShareBuffer, sharebuffer ) )
						err = -1;
					delete bz;
				}
				else
					sharebuffer->Append(m_pXMLBZShareBuffer->Data(),m_pXMLBZShareBuffer->Size());
#endif
				break;
			default:
				err = -1;
				break;
		}
	}

	m_MutexShareList.UnLock();

	return err;
}

/** */
unsigned long CShareList::GetShareBufferSize( eShareBufferType type )
{
	unsigned long i;

	m_MutexShareList.Lock();

	i = 0;

	switch(type)
	{
		case esbtHE3:
			if ( m_pHE3ShareBuffer )
				i = m_pHE3ShareBuffer->Size();
			break;
		case esbtBZ:
			if ( m_pBZShareBuffer )
				i = m_pBZShareBuffer->Size();
			break;
		case esbtXMLBZ:
			if ( m_pXMLBZShareBuffer )
				i = m_pXMLBZShareBuffer->Size();
			break;
		default:
			break;
	}

	m_MutexShareList.UnLock();

	return i;
}

/** */
ulonglong CShareList::GetShareSize() const
{
	return m_nShareSize;
}
