/***************************************************************************
                          cuserlist.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/clist.h>
#include <dclib/dcobject.h>
#include <dclib/cquerymanager.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cconnectionmanager.h>
#include <dclib/cencrypt.h>
#include <dclib/cmessagehandler.h>
#include <dclib/core/cstringlist.h>
#include <dclib/cconfig.h>

#include "cuserlist.h"

CUserList::CUserList()
{
	m_nShareSize = 0;
	m_pUserList = new CThreadStringList(2);
}

CUserList::~CUserList()
{
	if ( m_pUserList )
	{
		delete m_pUserList;
		m_pUserList = 0;
	}
}

/** */
void CUserList::Clear()
{
	if ( m_pUserList )
	{
		m_pUserList->Lock();
		m_pUserList->Clear();
		m_pUserList->UnLock();
	}
	
	m_nShareSize = 0;
}

/** */
void CUserList::InitUserList( CMessageNickList * nicklist )
{
	CString *nick;

	if (!nicklist)
		return;
	if (!m_pUserList)
		return;

	m_nShareSize = 0;

	for(nick=0;(nick=nicklist->m_NickList.Next(nick))!=0;)
	{
		AppendUser(*nick);
	}
}

/** */
void CUserList::InitOperatorList( CMessageNickList * nicklist )
{
	CString *nick;
	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return;

	// set in the nicklist the operator status
	for(nick=0;(nick=nicklist->m_NickList.Next(nick))!=0;)
	{
		m_pUserList->Lock();
		if ( m_pUserList->Get( *nick, (CObject*&)myinfo) == 0 )
		{
			myinfo->m_bOperator = TRUE;
		}
		m_pUserList->UnLock();
	}
}

/** */
bool CUserList::AppendUser( CString & nick, bool getinfo )
{
	bool res = FALSE;
	CString s;
	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return res;

	m_pUserList->Lock();

	if ( m_pUserList->Get( nick, (CObject*&)myinfo ) != 0 )
	{
		myinfo = new CMessageMyInfo();
		myinfo->m_sNick     = nick;
		myinfo->m_eAwayMode = euamNORMAL;

		m_pUserList->Add(nick,myinfo);

		if ( getinfo )
			res = TRUE;
	}

	m_pUserList->UnLock();
	
	return res;
}

/** */
void CUserList::RemoveUser( CString & nick )
{
	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return;

	m_pUserList->Lock();

	if ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
	{
		if ( myinfo->m_nShared > m_nShareSize )
			m_nShareSize = 0;
		else
			m_nShareSize -= myinfo->m_nShared;

		m_pUserList->Del(nick);
	}

	m_pUserList->UnLock();
}

/** */
bool CUserList::UpdateUser( CMessageMyInfo * pMyInfo )
{
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if (!pMyInfo)
		return res;
	if (!m_pUserList)
		return res;

	m_pUserList->Lock();

	if ( m_pUserList->Get( pMyInfo->m_sNick, (CObject*&)myinfo ) == 0 )
	{
		if ( myinfo->m_nShared >= m_nShareSize )
			m_nShareSize = 0;
		else
			m_nShareSize -= myinfo->m_nShared;
	}
	else
	{
		myinfo = new CMessageMyInfo();
		m_pUserList->Add(pMyInfo->m_sNick,myinfo);

		res = TRUE;
	}

	// don't send old data to the gui
	if ( myinfo->m_sNick != pMyInfo->m_sNick )
		res = TRUE;
	else if ( myinfo->m_sComment != pMyInfo->m_sComment )
		res = TRUE;
	else if ( myinfo->m_sUnknown != pMyInfo->m_sUnknown )
		res = TRUE;
	else if ( myinfo->m_eUserSpeed != pMyInfo->m_eUserSpeed )
		res = TRUE;
	else if ( myinfo->m_sUserSpeed != pMyInfo->m_sUserSpeed )
		res = TRUE;
	else if ( myinfo->m_sEMail != pMyInfo->m_sEMail )
		res = TRUE;
	else if ( myinfo->m_nShared != pMyInfo->m_nShared )
		res = TRUE;
	else if ( myinfo->m_eAwayMode != pMyInfo->m_eAwayMode )
		res = TRUE;
	else if ( pMyInfo->m_bOperator != myinfo->m_bOperator )
		res = TRUE;
	else if ( myinfo->m_sVerComment != pMyInfo->m_sVerComment )
		res = TRUE;
	else if ( myinfo->m_eClientVersion != pMyInfo->m_eClientVersion )
		res = TRUE;
	else if ( myinfo->m_eClientMode != pMyInfo->m_eClientMode )
		res = TRUE;
	else if ( myinfo->m_nFreeSlot != pMyInfo->m_nFreeSlot )
		res = TRUE;
	else if ( myinfo->m_nMaxSlot != pMyInfo->m_nMaxSlot )
		res = TRUE;

	if ( res == TRUE )
	{
		pMyInfo->m_bOperator = myinfo->m_bOperator;
		*myinfo = *pMyInfo;
	}

	m_nShareSize += myinfo->m_nShared;

	m_pUserList->UnLock();

	return res;
}

/** */
bool CUserList::UpdateUserSlots( CMessageSearchResult * pSearchResult )
{
	int err;
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if ( (!pSearchResult) || (!m_pUserList) )
		return res;

	m_pUserList->Lock();

	if ( m_pUserList->Get( pSearchResult->m_sNick, (CObject*&)myinfo ) == 0 )
	{
		if ( (myinfo->m_nFreeSlot != pSearchResult->m_nFreeSlot) ||
		     (myinfo->m_nMaxSlot != pSearchResult->m_nMaxSlot) )
		{
			myinfo->m_nFreeSlot = pSearchResult->m_nFreeSlot;
			myinfo->m_nMaxSlot  = pSearchResult->m_nMaxSlot;

			res = TRUE;
		}
	}

	m_pUserList->UnLock();
	
	return res;
}

/** */
bool CUserList::IsUserOnline( CString & nick )
{
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return res;

	m_pUserList->Lock();
	res = ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 );
	m_pUserList->UnLock();

	return res;
}

/** */
bool CUserList::IsAdmin( const CString & nick ) const
{
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return res;

	m_pUserList->Lock();
	if ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
		res = myinfo->m_bOperator;
	m_pUserList->UnLock();

	return res;
}

/** */
eUserClientVersion CUserList::GetUserClientVersion( const CString & nick ) const
{
	eUserClientVersion res = eucvNONE;

	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return res;

	m_pUserList->Lock();
	if ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
		res = myinfo->m_eClientVersion;
	m_pUserList->UnLock();

	return res;
}

/** */
bool CUserList::GetUserMyInfo( CString nick, CMessageMyInfo * p )
{
	bool res = FALSE;

	CMessageMyInfo *myinfo=0;

	if (!m_pUserList)
		return res;

	m_pUserList->Lock();
	if ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
	{
		*p = *myinfo;
		res = TRUE;
	}
	m_pUserList->UnLock();

	return res;
}

/** */
bool CUserList::SetUserTransferInfo( CString nick, CDCMessage * msg )
{
	bool res = FALSE;
	int err;	
	CMessageMyInfo *myinfo=0;
	CMessageMyInfo *myinfo1=0;
	
	if ( msg )
	{
		m_pUserList->Lock();

		if ( m_pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
		{
			if ( msg->m_eType == DC_MESSAGE_CONNECT_CLIENT)
			{
				myinfo->m_sTransferHost = ((DCMessageConnectClient*)msg)->m_sHubHost;
				res = TRUE;			
			}
			else if ( msg->m_eType == DC_MESSAGE_LOCK)
			{
				myinfo->m_MessageLock = *((CMessageLock*)msg);
				res = TRUE;
			}
			else if ( msg->m_eType == DC_MESSAGE_SUPPORTS)
			{
				myinfo->m_MessageSupports = *((CMessageSupports*)msg);
				res = TRUE;
			}
		}

		m_pUserList->UnLock();
	}

	return res;
}
