/***************************************************************************
                          clistenmanager.h  -  description
                             -------------------
    begin                : Sun Feb 29 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLISTENMANAGER_H
#define CLISTENMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>

class CListen;
class CListenManager;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CListenManager>;
#endif

class  DLL_EXPORT CListenManager : public CSingleton<CListenManager>, public CObject {
public: 
	/** */
	CListenManager();
	/** */
	virtual ~CListenManager();

	/** */
	unsigned int GetListenPort( bool connectionwait = FALSE );
	/** */
	void AddConnectionWait();
	/** */
	void RemoveConnectionWait();
	
	
protected:

private:
	/** */
	int ManagerCallback( CObject *, CObject * );
	/** */
	int ListenCallback( CObject *, CObject * );
	/** */
	void StartListen();
	
	/** current used port */
	unsigned int m_nListenPort;
	/** */
	ulonglong m_nConnectionWait;
	/** socket error message */
	CString m_sSocketError;

	/** */
	CThread m_Thread;
	/** */
	CListen * m_pListen;
	/** */
	_CCallback * m_pCallback;
};

#endif
