/***************************************************************************
                           cxml.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "cxml.h"

/** */
CXml::CXml()
{
	pDoc = 0;

	if ( xmlParserVersion != CString("20510") )
	{
		xmlInitParser();
	}
}

/** */
CXml::~CXml()
{
	FreeDoc();

#if LIBXML_VERSION > 20510
	if ( xmlParserVersion != CString("20510") )
	{
		xmlCleanupParser();
	}
#endif
}

/** */
void CXml::FreeDoc()
{
	if (pDoc)
	{
		xmlFreeDoc(pDoc);
		pDoc = 0;
	}
}

/** */
bool CXml::NewDoc()
{
	FreeDoc();

	if ( (pDoc = xmlNewDoc((const xmlChar*)"1.0")) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
bool CXml::ParseFile( CString name )
{
	FreeDoc();

	if ( (pDoc = xmlParseFile(name.Data())) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
bool CXml::ParseMemory( const char * s, int size )
{
	FreeDoc();

	if ( (pDoc = xmlParseMemory(s,size)) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
CString CXml::content( xmlNodePtr node )
{
	xmlChar *c;
	CString s = "";

	if ( (c = xmlNodeGetContent(node)) != 0 )
	{
		s = FromUtf8((char*)c);
		xmlFree(c);
	}

	return s;
}

/** */
CString CXml::prop( xmlNodePtr node, CString prop )
{
	xmlChar *c;
	CString s = "";

	if ( (c = xmlGetProp(node,(const xmlChar*)prop.Data())) != 0 )
	{
		s = (char*)c;
		xmlFree(c);
	}

	return s;
}

/** */
CString CXml::xml_UTF8Toisolat1( char * s, int len )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;

	if ( (s == 0) || (len <= 0) )
	{
		return "";
	}

	inlen  = len;
	outlen = inlen*4;

	b = (unsigned char*) calloc(1,outlen);

	res = UTF8Toisolat1( b, &outlen, (unsigned char*)s, &inlen );

	if ( res == -2 )
		printf("UTF8Toisolat1 transcoding fail: '%s'\n",s);
	else if ( res == -1 )
		printf("UTF8Toisolat1 fail: '%s'\n",s);
	else if ( res == 0 )
		r = (char*)b;
	else
		printf("CXml::xml_UTF8Toisolat1 error %d\n",res);

	free(b);

	return r;
}

/** */
CString CXml::xml_isolat1ToUTF8( char * s, int len )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;

	if ( (s == 0) || (len <= 0) )
	{
		return "";
	}

	inlen  = len;
	outlen = inlen*4;

	b = (unsigned char*) calloc(1,outlen);

	res = isolat1ToUTF8( b, &outlen, (unsigned char*)s, &inlen );

	if ( res == -1 )
		printf("isolat1ToUTF8 fail: '%s'\n",s);
	else if ( res == 0 )
		r = (char*)b;

	free(b);

	return r;
}

/** */
CString CXml::ToUTF8( const char * s )
{
	CString str = s;

	return ToUTF8(str);
}

/** */
CString CXml::FromUtf8( const char * s )
{
	CString str = s;

	return FromUtf8(str);
}

/** */
CString CXml::ToUTF8( CString & s )
{
	CString c = "";
	xmlChar * xc = 0;

	if ( s != "" )
	{
		c = xml_isolat1ToUTF8( s.Data(), s.Length() );
	
		xc = xmlEncodeEntitiesReentrant(NULL, (xmlChar*) c.Data() );

		if ( xc )
		{
			c = (char*)xc;
			xmlFree(xc);
		}
		else
		{
			c = "";
		}	
	}

	c = c.Replace("\"","&quot;");
	
	return c;
}

/** */
CString CXml::FromUtf8( CString & s )
{
	int i,i1;
	CString c = "",c1 = "";
	CString t;
	
	if ( s != "" )
	{
		c = xml_UTF8Toisolat1( s.Data(), s.Length() );
	}

	for(i=0;i<c.Length();i++)
	{
		if ( c.Data()[i] == '&' )
		{
			if ( c.Mid(i,2) == "&#" )
			{
				if ( (i1 = c.Find(';',i)) != -1 )
				{
					if ( (i1-i) <= 5 )
					{
						t = c.Mid(i,i1-i);				
						//printf("%s\n",t.Data());
						
						t = t.Mid(2);
						
						if ( t.Left(1) == "x" )
						{
							t = t.Mid(1);
							
							c1 += t.asINT(16);
						}
						else
						{
							c1 += t.asINT();
						}
						
						//printf("%s\n",t.Data());
						i += i1-i;
						continue;
					}
				}
			}
		}
		
		c1 += c.Data()[i];
	}

	c1 = c1.Replace("&apos;", "\'");
	c1 = c1.Replace("&quot;", "\"");
	c1 = c1.Replace("&lt;",   "<");
	c1 = c1.Replace("&gt;",   ">");
	c1 = c1.Replace("&amp;",  "&");

	return c1;
}
	
/** */
xmlNodePtr CXml::xmlNewBoolChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, bool b )
{
	CString s;
	
	if (b)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	return xmlNewChild( parent, ns, name, (const xmlChar*)(const char*)s.Data() );
}

/** */
xmlNodePtr CXml::xmlNewStringChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, CString s, bool createempty )
{
	if ( (createempty==TRUE) || (s!="") )
		return xmlNewChild( parent, ns, name, (const xmlChar*)ToUTF8(s).Data() );
	else
		return 0;
}

/** */
void CXml::xmlNewStringProp( xmlNodePtr node, CString prop, CString value )
{
	xmlNewProp( node, (const xmlChar*)prop.Data(), (const xmlChar*)ToUTF8(value).Data() );
}

/** */
bool CXml::getBoolChild( xmlNodePtr node )
{
	if ( content(node) == XML_TRUE )
		return TRUE;
	else
		return FALSE;
}
