/***************************************************************************
                           cdir.h  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002-2005 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDIR_H
#define CDIR_H

/**
  *@author Mathias Kster
  */

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/core/clist.h>

class DLL_EXPORT CFileInfo : public CObject {
public:
	/** */
	CFileInfo() {};
	/** */
	virtual ~CFileInfo() {};

	/** */
	CString name;
	/** */
	ulonglong size;
	/** */
	bool m_bSymlink;
	/** */
	time_t st_a_time;
	/** */
	time_t st_m_time;
	/** */
	time_t st_c_time;
};

class DLL_EXPORT CDir : public CObject {

public:
	/** */
	CDir();
	/** */
	CDir( CString path );
	/** */
	virtual ~CDir();

	typedef enum FilterSpec {
		Dirs  = 0x0001,
		Files = 0x0002
	};

	/** */
	static CString HomeDirPath();
	/** */
	bool cd( CString path );
	/** */
	static CString Extension( CString file );
	/** */
	CString Path();
	/** */
	CString DirName();
	/** */
	CString CleanDirPath( CString path );
	/** */
	static CString ConvertSeparators( CString path );
	/** */
	CString SimplePath( CString path );
	/** */
	ulonglong getFileSize( CString filename, bool rel = TRUE );

	/** */
	void SplitPathFile( CString string, CString & path, CString & file );
	/** */
	bool CreatePath( CString path );
	/** */
	bool ReadEntrys( FilterSpec filterspec, CList<CFileInfo> * list );
	/** */
	bool IsDir( CString s, bool rel = TRUE );
	/** */
	bool IsFile( CString s, bool rel = TRUE );
	/** */
	CString ReadLink( CString string );

	/** */
	void SetPath( CString path );
	/** */
	bool FreeDiscSpace( CString path, ulonglong * res );

private:
#ifdef WIN32
	/** */
	bool GetStat( CString & s, struct _stat * buf, bool rel = TRUE );
	/** */
	bool GetLStat( CString & s, struct _stat * buf, bool rel = TRUE );
#else
	/** */
	bool GetStat( CString & s, struct stat * buf, bool rel = TRUE );
	/** */
	bool GetLStat( CString & s, struct stat * buf, bool rel = TRUE );
#endif

	/** */
	CString sPath;
	/** */
	CString sDrive;
};

#endif
