/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 * Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h> /* for retreiving visual and colormap */
#include "diacolor.h"

static GdkColorContext *color_context = NULL;
DiaColor dia_color_black = { 0.0f, 0.0f, 0.0f };
DiaColor dia_color_white = { 1.0f, 1.0f, 1.0f };
GdkColor dia_color_gdk_black, dia_color_gdk_white;

void 
dia_color_init ()
{
  GdkVisual *visual = gtk_widget_get_default_visual(); 
  GdkColormap *colormap = gtk_widget_get_default_colormap(); 
  color_context = gdk_color_context_new(visual, colormap);

  dia_color_convert(&dia_color_black, &dia_color_gdk_black);
  dia_color_convert(&dia_color_white, &dia_color_gdk_white);
}

void
dia_color_convert(DiaColor *color, GdkColor *gdkcolor)
{
  gint failed;
  
  gdkcolor->red = color->red*65535;
  gdkcolor->green = color->green*65535;
  gdkcolor->blue = color->blue*65535;

  
  gdkcolor->pixel =
    gdk_color_context_get_pixel(color_context,
				gdkcolor->red,
				gdkcolor->green,
				gdkcolor->blue,
				&failed);
}

gboolean
dia_color_equals(DiaColor *color1, DiaColor *color2)
{
  return (color1->red == color2->red) &&
    (color1->green == color2->green) &&
    (color1->blue == color2->blue);
}


