/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* diaentry.h
 * -------------
 * This is the base class for text objects. It does not have handles and it
 * can not let other objects connect. This makes it very easy to add this
 * object to composite objects (like UML classes, cases, etc.).
 * Note that this objets supports the most simple type of text (= single line
 * text).
 */

#ifndef __DIA_ENTRY_H__
#define __DIA_ENTRY_H__

#include <diacanvas/diabasetext.h> /* parent object */

DIA_OPEN

#define DIA_ENTRY(x) ((DiaEntry*) x)

/* These are the foreground and background color of selected text: */
extern DiaColor dia_entry_selection_bg_color; // Blue
extern DiaColor dia_entry_selection_fg_color; // White

typedef struct _DiaEntry DiaEntry;

struct _DiaEntry
{
  DiaBaseText text;

  gint has_selection: 1;
  
  /* selection stuff */
  gint selection_start;
  /* selection ends where the cursor is placed... */
};

DiaObjectType* dia_entry_get_type ();

void dia_entry_init (DiaEntry *entry);

/* A "new" funtion needs pointer parameters for use with the create tool... */
DiaObject* dia_entry_new (Point *pos);

/* protected: */
/* NOTE: in these functions no type checking is done (since they should
 * only be used in Entry or an inherited variant)!!! */
void dia_entry_draw_selection (DiaEntry* entry, DiaRenderer* renderer,
				   gfloat text_bottom);


DIA_CLOSE

#endif /* __DIA_ENTRY_H__ */



