/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __DIA_GROUP_H__
#define __DIA_GROUP_H__

#include <diacanvas/diaobject.h> /* parent object */

DIA_OPEN

#define DIA_GROUP(x) ((DiaGroup*) x)

typedef struct _DiaGroup DiaGroup;

struct _DiaGroup
{
  DiaObject     object;

  GList        *objects;
};

DiaObjectType* dia_group_get_type ();

void dia_group_init (DiaGroup *object);

/* Do not create groups using a creation tool: no handles will be created */
DiaObject* dia_group_new ();
     
/* Note that objects are not destroyed if they are removed from the group
 */
void     dia_group_add_object (DiaGroup *group, DiaObject *object);
gboolean dia_group_remove_object (DiaGroup *group, DiaObject *object);

gboolean dia_group_has_object (DiaGroup *group, DiaObject *object);

/* The list will be copied... free it yourself!
 */
void     dia_group_add_object_list (DiaGroup *group, GList *list);
void     dia_group_remove_object_list (DiaGroup *group, GList *list);

DIA_CLOSE

#endif /* __DIA_GROUP_H__ */



