/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 * Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* dialayer.h
 * ----------
 * A layer holds the objects (more than one layer can be placed in a diagram,
 * just like DIA :-).
 * NOTE: all positions are ABSOLUTE (relative to the origin (0,0).
 */

#ifndef __DIA_LAYER_H__
#define __DIA_LAYER_H__

#include <glib.h>
#include <diacanvas/geometry.h>
#include <diacanvas/diarenderer.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

#define DIA_LAYER(x) ((DiaLayer*) x)

typedef struct _DiaLayer DiaLayer;

#include <diacanvas/diaobject.h>

struct _DiaLayer {
  gchar *name;
  Rectangle extents;      /* The extents of the layer */

  GList *objects;         /* List of objects in the layer,
			     sorted by decreasing z-valued,
			     objects can ONLY be connected to objects
			     in the same layer! */
  gint visible: 1;
};

/* What shoudl I do with this? */
typedef void (*DiaObjectRenderer)(DiaObject *obj, DiaRenderer *renderer,
				  gpointer data);

DiaLayer*  dia_layer_new (gchar *name);

void       dia_layer_destroy (DiaLayer *layer);

void       dia_layer_render (DiaLayer *layer, DiaRenderer *renderer,
			     DiaObjectRenderer obj_renderer /* Can be NULL */,
			     Rectangle *update_box, gpointer data);

/* Use the DiaDiagram wrappers instead of these functions! */
void       dia_layer_add_object (DiaLayer *layer, DiaObject *obj);
void       dia_layer_add_object_first (DiaLayer *layer, DiaObject *obj);
//void       dia_layer_add_objects (DiaLayer *layer, GList *obj_list);
//void       dia_layer_add_objects_first (DiaLayer *layer, GList *obj_list);
void       dia_layer_remove_object (DiaLayer *layer, DiaObject *obj);

/* Find operations
 */
GList*     dia_layer_find_objects_in_rectangle (DiaLayer *layer, 
						Rectangle *rect);

DiaObject* dia_layer_find_closest_object (DiaLayer *layer, Point *pos,
					  gfloat maxdist);
DiaObject* dia_layer_find_closest_object_by_type (DiaLayer *layer, Point *pos,
					  gfloat maxdist, DiaObjectType *type);

/* Returns the connection point that is closest to the handle, but not part
 * of the same object. The distance from the handle to the connection point
 * is returned.
 * *handle is the handle that is requesting the connection point.
 * **closest_obj will contain the closest object.
 * *con_pos will contain the closest point where the handle could be connected.
 * **closest_cp will contain the connection point if it already exists, NULL
 *           otherwise.
 */
gfloat  dia_layer_find_closest_cp (DiaLayer *layer,
				   DiaHandle *handle,
				   DiaObject **closest_obj,
				   Point *con_pos,
				   DiaConnectionPoint **closest_cp);

/* like the function above... The handle is now direct connected if it's
 * distance from the connection point is less than
 * DIA_CONNECTION_POINT_TRESHOLD. Nothing will be done if the handle is
 * allready connected to a connection point.
 */
//DiaConnectionPoint* dia_layer_find_connection_point (DiaLayer *layer,
//						     DiaHandle *handle);

gfloat     dia_layer_find_closest_handle (DiaLayer *layer, Point *pos,
					  DiaHandle **handle);

void       dia_layer_replace_object_with_list (DiaLayer *layer, DiaObject *obj,
					       GList *list);

/* Do not use this function directly! Use dia_diagram_update_extents! */
gint       dia_layer_update_extents (DiaLayer *layer);

DIA_CLOSE

#endif /* __DIA_LAYER_H__ */






