/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "diamagnifytool.h"
#include "math.h"

static void free_magnify_tool (DiaTool *tool);

static gint magnify_tool_event_handler (DiaMagnifyTool *tool, DiaEvent *event, 
				       DiaDisplay *ddisp);

DiaTool*
dia_magnify_tool_new ()
{
  DiaMagnifyTool *tool;

  tool = g_new(DiaMagnifyTool, 1);
  tool->tool.event = (DiaToolEventFunc) &magnify_tool_event_handler;
  tool->tool.destroy = (DiaToolDestroyFunc) &free_magnify_tool;

  //tool->box = FALSE;
  
  return (DiaTool*) tool;
}

static void
free_magnify_tool (DiaTool *tool)
{
  g_free (tool);
}

static gint
magnify_tool_event_handler (DiaMagnifyTool *tool, DiaEvent *event, 
			    DiaDisplay *ddisp)
{
  switch (event->type)
    {
    case DIA_BUTTON_PRESS:
      if (event->button.button == 1)
	{
	  ddisp->drawing_box = TRUE;
	  ddisp->start_box = event->button.pos;
	  ddisp->end_box = event->button.pos;
	  //dia_display_draw_selection_box (ddisp, &tool->start_box,
	  //			  &tool->end_box);
	  return TRUE;
	}
      break;
    case DIA_BUTTON_RELEASE:  
      if (ddisp->drawing_box)
	{
	  Rectangle r;
  	  
	  //dia_display_end_selection_box (ddisp);
      
	  r.left = MIN (ddisp->start_box.x, ddisp->end_box.x);
	  r.right = MAX (ddisp->start_box.x, ddisp->end_box.x);
	  r.top = MIN (ddisp->start_box.y, ddisp->end_box.y);
	  r.bottom = MAX (ddisp->start_box.y, ddisp->end_box.y);
      
	  if ((ddisp->start_box.x == ddisp->end_box.x) &&
	      (ddisp->start_box.y == ddisp->end_box.y) &&
	      (event->button.button == 1))  
	    {
	      if (event->button.modifier & DIA_SHIFT_MASK)
		dia_display_zoom (ddisp, &event->button.pos, M_SQRT1_2);
	      else
		dia_display_zoom (ddisp, &event->button.pos, M_SQRT2);
	    }
	  else
	    {
	      Point p;
	      p.x = r.left;
	      p.y = r.top;
	      dia_display_zoom_box (ddisp, &p, r.right - r.left, r.bottom - r.top);
	    }
	  //dia_display_flush (ddisp);
	  
	  ddisp->drawing_box = FALSE;
	  return TRUE;
	}
      break;
    case DIA_MOTION:
      if (ddisp->drawing_box)
	{
	  Rectangle r;

	  r.left = MIN (ddisp->start_box.x,
			MIN (ddisp->end_box.x, event->motion.pos.x));
	  r.right = MAX (ddisp->start_box.x,
			 MAX (ddisp->end_box.x, event->motion.pos.x));
	  r.top = MIN (ddisp->start_box.y,
		       MIN (ddisp->end_box.y, event->motion.pos.y));
	  r.bottom = MAX (ddisp->start_box.y,
			  MAX (ddisp->end_box.y, event->motion.pos.y));
	  
	  ddisp->end_box = event->motion.pos;

	  dia_display_add_update (ddisp, &r);

	  return TRUE;
	}
      break;
    default:
    } /* switch */
  return FALSE;
}







