/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdk.h>
#include "diamodifytool.h"

static void free_modify_tool (DiaTool *tool);

static gint modify_tool_event_handler (DiaModifyTool *tool, DiaEvent *event, 
				       DiaDisplay *ddisp);

static DiaToolEventFunc parent_event;
static DiaToolDestroyFunc parent_destroy;

void
dia_modify_tool_init (DiaModifyTool *tool)
{
  
  dia_base_modify_tool_init ((DiaBaseModifyTool*)tool);

  parent_event = ((DiaTool*) tool)->event;
  parent_destroy = ((DiaTool*) tool)->destroy;

  ((DiaTool*) tool)->event = (DiaToolEventFunc) &modify_tool_event_handler;
  ((DiaTool*) tool)->destroy = (DiaToolDestroyFunc) &free_modify_tool;
}

DiaTool*
dia_modify_tool_new ()
{
  DiaModifyTool *tool;

  tool = g_new(DiaModifyTool, 1);

  dia_modify_tool_init (tool);
  
  return (DiaTool*) tool;
}

static void
free_modify_tool (DiaTool *tool)
{
  parent_destroy (tool);
}

static gboolean
modify_tool_box_select (DiaModifyTool *tool, DiaEvent *event, 
			DiaDisplay *ddisp)
{
  //Point point;
  Rectangle r;
  //DiaRenderer *renderer = DIA_RENDERER (ddisp->renderer);
  
  switch (event->type)
    {
    case DIA_BUTTON_PRESS:
      if (event->button.button == 1)
	{
	  //g_message ("start selection box");
	  
	  ddisp->drawing_box = TRUE;
	  ddisp->start_box = event->button.pos;
	  ddisp->end_box = event->button.pos;
	  
	  //dia_display_draw_selection_box (ddisp, &tool->start_box,
	  //				  &tool->end_box);
	  return TRUE;
	}
      break;
    case DIA_BUTTON_RELEASE:
      if (ddisp->drawing_box)//tool->state == DIA_STATE_BOX_SELECT)
	{
	  GList *list;
	  
	  //dia_display_end_selection_box (ddisp);
	  
	  r.left = MIN (ddisp->start_box.x, ddisp->end_box.x);
	  r.top = MIN (ddisp->start_box.y, ddisp->end_box.y);
	  r.right = MAX (ddisp->start_box.x, ddisp->end_box.x);
	  r.bottom = MAX (ddisp->start_box.y, ddisp->end_box.y);
	  dia_display_add_update (ddisp, &r);
	  
	  list = dia_layer_find_objects_in_rectangle (ddisp->active_layer, &r);
	  //g_message ("list: %d", g_list_length (list));
	  

	  if (!(event->any.modifier & (DIA_CONTROL_MASK | DIA_SHIFT_MASK)))
	    {
	      dia_display_unselect_all (ddisp);
	    }
	  
	  while (list)
	    {
	      dia_display_select (ddisp, DIA_OBJECT (list->data), TRUE);
	      list = g_list_next (list);
	    }
	  
	  g_list_free (list);
	  
	  dia_display_set_focus (ddisp, NULL);
	  
	  //dia_display_flush (ddisp);
	  
	  //tool->state = DIA_STATE_NONE;
	  ddisp->drawing_box = FALSE;
	  //g_message ("end sel. box");
	  
	  return TRUE;
	}
      break;
    case DIA_MOTION:
      if (ddisp->drawing_box)//tool->state == DIA_STATE_BOX_SELECT)
	{
	  r.left = MIN (ddisp->start_box.x,
			MIN (ddisp->end_box.x, event->motion.pos.x));
	  r.right = MAX (ddisp->start_box.x,
			 MAX (ddisp->end_box.x, event->motion.pos.x));
	  r.top = MIN (ddisp->start_box.y,
		       MIN (ddisp->end_box.y, event->motion.pos.y));
	  r.bottom = MAX (ddisp->start_box.y,
			  MAX (ddisp->end_box.y, event->motion.pos.y));
	  
	  ddisp->end_box = event->motion.pos;

	  dia_display_add_update (ddisp, &r);
	  
	  return TRUE;
	}
      break;
    default:
      break;
    } /* switch */
  return FALSE;
}

/* modify_tool_event_handler
 * Description: forward the event to the objects on the canvas in a
 *     predefined order:
 *      1a) if an object has grab, give that object the event
 *      1b) else give the event to the object under the mouse pointer
 *      2)  handle event and handle special requests (select, grab, etc.)
 *      3a) if object is selected, send event to all selected objects
 *      3b) else just handle the requests
 */
static gint
modify_tool_event_handler (DiaModifyTool *tool, DiaEvent *event, 
			   DiaDisplay *ddisp)
{
  gboolean result = FALSE;
  DiaObject *object = NULL;
  
  if (!ddisp->drawing_box)//(tool->state != DIA_STATE_BOX_SELECT)
    {
      if (ddisp->grab)
	object = ddisp->grab;
  
      result = parent_event ((DiaTool*)tool, event, ddisp);
    }

  if (object && (object->request & DIA_REQUEST_REENTER))
    result |= modify_tool_event_handler (tool, event, ddisp);
  
  if (!result)
    {
      result = modify_tool_box_select (tool, event, ddisp);
    }
  
  return result;
}











