/* DiaCanvas test application 1: just a display.
 * Copyright (C) 1999 Arjan Molenaar
 */

#include <diadiagram.h>
#include <diadisplay.h>
#include "diamain.h"
/* This defines the size of the canvas, in pixels */
#define CANVAS_SIZE 300

static void
exit_clicked (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

void
main (int argc, char **argv)
{
  GtkWidget *window;
  DiaLayer *layer;
  DiaDiagram *dia;
    
  /* init GTK (you've seen this before...) */
  gtk_init (&argc, &argv);

  /* initialize DIA stuff */
  dia_init ();
  
  /* First create a diagram */
  dia = dia_diagram_new ("name");
  dia_diagram_set_auto_resize (dia, FALSE);
  dia_diagram_set_extents (dia, -10.0, -10.0, 0.0, 0.0);

  /* Create a new layer */
  layer = dia_layer_new ("");
    
  dia_diagram_add_layer (dia, layer);
  
  dia_diagram_update_extents (dia);
  
  /* create a display in a window */
  window = dia_display_new_in_window (dia, CANVAS_SIZE, CANVAS_SIZE,
				      "TestCanvas");
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (exit_clicked), window);    
  gtk_widget_show (window);
  
  gtk_main ();
}


