/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Test tool for the geometry package
 */

#include <glib.h>
#include "geometry.h"
#include <stdio.h>

gboolean
line_line_intersection1 (Point *start1, Point *end1,
			 Point *start2, Point *end2,
			 Point *intersect)
{
  gfloat a1, a2;
  gfloat b1, b2;
  gboolean vertical1 = FALSE;
  gboolean vertical2 = FALSE;
  Rectangle bb1, bb2;
  Point p;
  
  //a1 = calc_dc (start1->y - end1->y, (gfloat)(start1->x - end1->x));
  //a2 = calc_dc (start2->y - end2->y, (gfloat)(start2->x - end2->x));
  /* first line: y1 = a1*x + b1 */
  if ((start1->x - end1->x) != 0.0) /* line is vertical? */
    {
      a1 = (start1->y - end1->y) / (start1->x - end1->x);
      b1 = start1->y - a1 * start1->x;
    }
  else
    {
      vertical1 = TRUE;
    }
  
  if ((start2->x - end2->x) != 0.0)
    {
      a2 = (start2->y - end2->y)/ (start2->x - end2->x);
      b2 = start2->y - a2 * start2->x;
    }
  else
    {
      vertical2 = TRUE;
    }
  
  
  if (vertical1 && vertical2)       /* two parallel vertical lines */ 
     return FALSE;

  if (vertical1)                    /* line one is vertical */
    {
      p.x = start1->x;
      p.y = a2 * p.x + b2;
    }
  else
    if (vertical2)                  /* line two is vertical */
      {
	p.x = start2->x;
	p.y = a1 * p.x + b1;
      }
    else
      if (a1 == a2)     /* two parallel lines */
	return FALSE;
      else                          /* two normal crossing lines */
	{
	  p.x = (b2 - b1) / (a1 - a2);
	  p.y = a1 * p.x + b1;
	}
  
  g_message ("a1 = %f, a2 = %f, b1 = %f, b2 = %f", a1, a2, b1, b2);
  g_message ("Point is: (%f, %f)", p.x, p.y);
  
  /* If the intersection point is within both bounding boxes, there is a
     valid intersection. */
  bb1.top = MIN (start1->y, end1->y);
  bb1.bottom = MAX (start1->y, end1->y);
  bb1.left = MIN (start1->x, end1->x);
  bb1.right = MAX (start1->x, end1->x);

  bb2.top = MIN (start2->y, end2->y);
  bb2.bottom = MAX (start2->y, end2->y);
  bb2.left = MIN (start2->x, end2->x);
  bb2.right = MAX (start2->x, end2->x);
  
  if (point_in_rectangle (&bb1, &p) &&
      point_in_rectangle (&bb2, &p))
    {
      if (intersect)
	*intersect = p;
      return TRUE;
    }

  return FALSE;
}

void
line_rectangle_intersection_test ()
{
  Point p1;
  Point p2 = { 0.0f, 0.0f};
  Point *intersects;
  Rectangle r = {-1.0f, -1.0f, 1.0f, 1.0f};
  
  for (p1.y = -5.0f; p1.y < 5.0f; p1.y += 0.1f)
    {
      for (p1.x = -5.0f; p1.x < 5.0f; p1.x += 0.1f)
	{
	  if (line_rectangle_intersection (&p1, &p2, &r, &intersects))
	    {
	      g_free (intersects);
	      g_print ("X");
	    }
	  else
	    g_print (" ");
	}
      g_print ("\n");
    }
}

void
main ()
{
  Point p[4], cross;
  int i;
  
  line_rectangle_intersection_test ();
  return;
  
  while (1)
    {
      for (i = 0; i < 4; i++)
	{
	  printf ("Give coords for point %d (like: point point):", i);
	  scanf ("%f %f", &p[i].x, &p[i].y);
	  printf ("Point = (%2.3f, %2.3f)\n", p[i].x, p[i].y);
	}
      if (line_line_intersection (&p[0], &p[1], &p[2], &p[3], &cross))
	printf ("(1) Intersection point = (%f, %f).\n", cross.x, cross.y);
      else
	printf ("(1) No intersection.\n");

      if (line_line_intersection1 (&p[0], &p[1], &p[2], &p[3], &cross))
	printf ("(2) Intersection point = (%f, %f).\n", cross.x, cross.y);
      else
	printf ("(2) No intersection.\n");
    }
}
