/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com
*/


#ifndef __dir_entry_h
#define __dir_entry_h 1

#include <glib.h>
#include <gnome.h>

typedef struct _dir_entry dir_entry;

typedef enum _dir_entry_type dir_entry_type;

enum _dir_entry_type
{ DENTRY_UNDEFINED, DENTRY_USER, DENTRY_GROUP, DENTRY_ORGUNIT };

struct _dir_entry
{
  gchar *dn;
  gchar *name;
  gchar *cn;
  gchar *uid;
  gchar *ou;
  gint uidnumber;
  gint gidnumber;
  dir_entry_type type;
};

void dir_entry_destroy (dir_entry * entry);

dir_entry *dir_entry_new (dir_entry * entry);

dir_entry *dir_entry_user_new (gchar * dn, gchar * uid, gchar *cn,
 gint uidnumber, gint gidnumber);

dir_entry *dir_entry_group_new (gchar * dn, gchar * cn, gint gidnumber);

dir_entry *dir_entry_orgunit_new (gchar * dn, gchar * ou);

dir_entry *dir_entry_undef_new (gchar * dn);



char* dir_entry_get_name(dir_entry* d); char* dir_entry_get_dn(dir_entry*
d);
char* dir_entry_get_cn(dir_entry* d);
char* dir_entry_get_uid(dir_entry* d);
gint dir_entry_get_uidnumber(dir_entry* d);
gint dir_entry_get_gidnumber(dir_entry* d);

 int dir_entry_is_user(dir_entry* d);
  int dir_entry_is_group(dir_entry*d);
   int dir_entry_is_orgunit(dir_entry*d);

dir_entry *
dir_entry_list_getbydn (GList * connec, gchar *nombre);
dir_entry *
dir_entry_list_getbyuid (GList * connec, gchar *uid);
dir_entry *
dir_entry_list_getbygidnumber (GList * connec, gint gidnumber);
void dir_entry_dump (dir_entry *s);
int dir_entry_compare (dir_entry *one, dir_entry* two);

dir_entry *
dir_entry_list_getgroupbygidnumber (GList * connec, gint gidnumber);

dir_entry *
dir_entry_list_getfirstgroup (GList* connec);
dir_entry *
dir_entry_list_getfirstou (GList* connec);

dir_entry* dir_entry_list_getgroupbycn (GList * connec, gchar* cn);


#endif



