import java.io.File;
import java.io.FileOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.RandomAccessFile;
import java.io.IOException;
import java.io.EOFException;
import java.net.Socket;
import java.net.URL;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class downloadfactory
{
 public final static byte DOWNLOAD_OK=0;
 public final static byte DOWNLOAD_ERR=1;
 public final static byte DOWNLOAD_FATAL=2;
 public final static byte DOWNLOAD_REDIRECT=3;
 public final static byte DOWNLOAD_BUSY=4;
 public final static byte DOWNLOAD_RESUME=5;

 public final static int RESUME_UNKNOWN=0;
 public final static int RESUME_NOCACHE=1;
 public final static int RESUME_DIRECT=2;
 public final static int RESUME_NONE=3;

 public static String checkreferer[]; /* url with special referer checks */
 public static String sendreferer[];  /* referer to send */

 public static String checkcookie[]; /* url with special cookie */
 public static String sendcookie[];  /* Cookie to sent */
 
 public static String useragent;
 public static boolean send_useragent;
 public static boolean send_referer;

 // protected data = file information
 protected long  lastModified;  /* lastmod timestamp */
 protected long  fileSize;    /* total size of file */
 protected long  contentSize; /* size of downloaded chunk 0 if unknown */
 protected byte  rc; /* return code DOWNLOAD_ */
 protected long  havebytes;  /* how many bytes of file we have */
 protected URL   url; /* URL of downloaded data */
 protected qfile qf; /* qfile of downloaded data */
 protected boolean direct; /* direct, noproxy download ?*/

 /* master connection DATA streams */
 protected DataInputStream datain;
 protected DataOutputStream dataout;

 downloadfactory(String URL,qfile qf,boolean dirc) throws java.net.MalformedURLException
 {
    this.direct=dirc;
    this.qf=qf;
    this.url=new URL(URL);
    this.havebytes=new File(dmachine.tmp_dir,qf.getLocalName()).length();
 }

 public static final int downloadFactory(String URL,qfile qf) 
    throws java.net.MalformedURLException, java.io.IOException
 {
  /* REQUEST PROXY/DIRECT SWITCHER CODE */
  String localname=qf.getLocalName();
  int skipbytes=(int)new File(dmachine.tmp_dir,qf.getLocalName()).length();
  URL url=new URL(URL);
  // posleme request FTP-proxy serveru?
  if(url.getProtocol().equalsIgnoreCase("ftp"))
    if(dmachine.ftp_proxydefined)
    {
        boolean nocache=false;
        if(skipbytes>0)
	{
	   if(dmachine.ftp_resume==RESUME_NOCACHE) nocache=true;
            else if(dmachine.ftp_resume==RESUME_DIRECT)
               return GenericTransferLogic(InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():21, true,new ftpfactory(URL,qf,true));
	}
	/* no resume, going to ftp proxy */
        return GenericTransferLogic(dmachine.ftp_proxyserver,dmachine.ftp_proxyport,nocache,new downloadfactory(URL,qf,false));
      }
      else
      {
	    /* direct ftp connection */
             return GenericTransferLogic(InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():21, true,new ftpfactory(URL,qf,true));
	}
   
  else  /* HTTP direct connection? */
   if(!dmachine.http_proxydefined && url.getProtocol().equalsIgnoreCase("http"))
        return 
	  GenericTransferLogic(InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():80, false,new downloadfactory(URL,qf,true));
    else  /* FSP protocol connection */
   if(url.getProtocol().equalsIgnoreCase("fsp"))
       return GenericTransferLogic(InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():21, false,new fspfactory(URL,qf,true));
   else  /* handle HTTP and other reqs via http_proxy */
  {
    //handle HTTP and other reqs via http_proxy
    if(!dmachine.http_proxydefined) return DOWNLOAD_FATAL; 
                                        // no luck here, unknown protocol 
    boolean nocache=false;
    if(skipbytes>0)
    {
       if(dmachine.http_resume==RESUME_NOCACHE) nocache=true;
        else
	  if(dmachine.http_resume==RESUME_DIRECT)
              return GenericTransferLogic(InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():80, false,new downloadfactory(URL,qf,true));
    }
    return GenericTransferLogic(dmachine.http_proxyserver,dmachine.http_proxyport,nocache,new downloadfactory(URL,qf,false));
  }
 }
 
 private final void sendHTTPRequest(java.net.InetAddress adr,int port, boolean nocache) throws java.io.IOException
 {
  Socket s;
  s=new Socket(adr,port);
  s.setSoTimeout(dmachine.timeout);  

  // otevrit data output stream
  dataout=new DataOutputStream(new java.io.BufferedOutputStream(s.getOutputStream(),1024));
  datain=new DataInputStream(s.getInputStream());

  // send request
  StringBuffer sb;
  sb=new StringBuffer(1024);
  sb.append("GET ");
  if(direct) sb.append(url.getFile());
   else
             sb.append(url);
  if(havebytes==0) sb.append(" HTTP/1.0");
   else
  sb.append(" HTTP/1.1");
   
  sb.append("\r\nHost: "+url.getHost());
  sb.append("\r\nAccept: */*");
  if(send_useragent) 
      sb.append("\r\nUser-Agent: "+useragent);

  //referer check
  String referer=null;
  
  if(checkreferer==null) checkreferer=sendreferer=new String[0];

  for(int i=checkreferer.length-1;i>=0;i--)
   if(url.toString().startsWith(checkreferer[i]))
    {
     referer=sendreferer[i];
     break;
    }

  if(referer==null && send_referer)
  {
      /* set default referer */
      referer="http://"+url.getHost()+"/index.html";
  }
 
  if(referer!=null)
  {
      sb.append("\r\nReferer: ");
      sb.append(referer);
  }
  
  sb.append("\r\nConnection: close\r\nProxy-Connection: close\r\n");
  if(nocache) sb.append("Pragma: no-cache\r\n");
  if(havebytes>0) sb.append("Range: bytes="+havebytes+"-\r\n");
  
  /* add custom cookie header */
  if(checkcookie==null) checkcookie=sendcookie=new String[0];
  for(int i=checkcookie.length-1;i>=0;i--)
   if(url.toString().startsWith(checkcookie[i]))
    {
     sb.append("Cookie: ");
     sb.append(sendcookie[i]);
     sb.append("\r\n");
     break;
    }
  
  // add proxy auth
  
  if(direct==false)
  {
     if(dmachine.http_auth!=null &&
	   url.getProtocol().equals("http"))
	sb.append(dmachine.http_auth);
	
     if(dmachine.ftp_auth!=null &&
	   url.getProtocol().equals("ftp"))
	sb.append(dmachine.ftp_auth);
  }
  
  // end of HTTP/1.0+ Request
  sb.append("\r\n"); 
  dataout.writeBytes(sb.toString());
  dataout.flush();
}

 /* prevede HTTP RC kod na dmachine rc kod */
 private final byte getHTTPRC() throws java.io.IOException
 {
    // read http-encoded reply
    int httprc;
    String line;
    line=datain.readLine(); /* HTTP/1.0 XX OK */
    if(line==null) throw new EOFException("Connection closed");
    /* precteme si tedy httprc kod */
    StringTokenizer st;
    st=new StringTokenizer(line);
    
    /* WARN: tady to spadne pri remote HTTP 0.9 serveru */
    try
    {
      st.nextToken(); /* http/1.0 - nezajimave */
      httprc=Integer.valueOf(st.nextToken()).intValue();
    } 
     catch (Exception http09)
    {
      System.out.println("HTTP Response was: "+line);
      dmachine.log_fatal(url+" HTTP 0.9 server is unsupported");
      return DOWNLOAD_FATAL;
    }
 
 /* HTTP RC test */
 if(httprc>400 && httprc< 500)
 {
   dmachine.log_fatal("Error "+httprc+" when loading "+url); 
   return DOWNLOAD_FATAL;   
 }
 else if(httprc>=300 && httprc<400 && httprc!=305) return DOWNLOAD_REDIRECT;
 else if(httprc==206) return DOWNLOAD_RESUME;
 else if(httprc==200 || httprc==202) return DOWNLOAD_OK;
 else if(httprc==503 || httprc==502) return DOWNLOAD_BUSY; // server busy
 else if(httprc==500) return DOWNLOAD_ERR; // server overloaded/tmp error
 else if(httprc==504) return DOWNLOAD_ERR; // gateway timeout
 else if(httprc>=500) {
   dmachine.log_fatal("Error "+httprc+" when loading "+url); 
  return DOWNLOAD_FATAL;
  }
 else
  { 
    dmachine.log_err("GOT httprc="+httprc+" when loading "+url+" - will retry"); 
    return DOWNLOAD_ERR; 
  } 
 }
 
 private final void getHTTPHeaderData(qfile qf,URL url) throws IOException
 {
  contentSize=0;

  /* cteme hlavicky */
  while(true)
  { 
      int j;
      String s1,s2,line;
      line=datain.readLine();
      if(line==null) break;
      if(line.length()==0) break;
    j=line.indexOf(':',0);
    if(j==-1) continue;
    s1=line.substring(0,j).toLowerCase();
    s2=line.substring(j+1).trim();
    
    if(s1.equals("location")) 
     { 
       /* kill # */
         int in = s2.indexOf('#');
	 if (in>-1)
	        s2 = s2.substring(0,in);
       /* get new URL */
       URL nurl;
       nurl=new URL(url,s2);
       qf.redirect(url.toString(),nurl.toString());
       // return DOWNLOAD_REDIRECT; ?? 
       // no! we are supporting multiple redirects ...
      }        
    else if(s1.equals("content-length"))
    {
             try
              {
                 contentSize=Integer.valueOf(s2).intValue(); 
              }
              catch (Exception ignore)
              {}
              continue;
    }
    else if(s1.equals("last-modified"))
    {
             try
              {
		lastModified=new java.util.Date(s2).getTime();
	      }
	      catch (IllegalArgumentException e)
	      { lastModified=0;}
              continue;
    }
  } /* hlavicky */
  /* compute final filesize if possible */
  if(rc==DOWNLOAD_OK && contentSize>0)
      fileSize=contentSize;
  else
      if(rc==DOWNLOAD_RESUME && contentSize>0)
	  fileSize=havebytes+contentSize;
}

/* 
 * note: You must call this function twice, one for data skiping and
 * second for data loading. if skipbytes>0 then data onlyskip will be done
*/

private final int DataTransfer(long skipbytes) throws IOException
{
 long lastrep,ct,start;
 DataOutputStream dos;
 byte b[]=new byte[4096];
 int rb;  // how many bytes was read in last turn
 long total=0;  // how many bytes we have read
 dos=null;
 start=System.currentTimeMillis()-1100L;
 lastrep=start-dmachine.reptime+10000L;  // first report at 10 sec.

 if(skipbytes>0) { 
     System.err.println("[INFO] Resume on "+url+" is not supported by server.");
 } else
 {
     //open tmp outputfile
     dos=new DataOutputStream(new java.io.BufferedOutputStream(
     new java.io.FileOutputStream(dmachine.tmp_dir+File.separator+qf.getLocalName(),true),4096));
 }

 while( (dos==null && skipbytes>0) || dos!=null)
 {
      try
      {
       if(dos!=null || skipbytes>=4096)
	   rb=datain.read(b); 
       else
	   rb=datain.read(b,0,(int)skipbytes);
      }
      catch (IOException ioe)
      { 
	  if(dos!=null) 
	      dos.close();
	  throw ioe;
      }
       
      if(rb==-1) break; /* konec dat! */
      total+=rb;
      if(skipbytes>0) skipbytes-=rb;
      if(dos!=null) dos.write(b,0,rb);
      ct=System.currentTimeMillis();
      if(ct-lastrep>dmachine.reptime) 
      {
	 long CPS=total/( (ct-start)/1000L);

	 System.err.println(
	 (skipbytes>0?"[SKIP] ":"[LOAD] ")+qf.getName()+" "+(havebytes-skipbytes+total)+"/"+(fileSize)+" B ("+(int)(100*(float)(havebytes-skipbytes+total)/(float)(fileSize))+"%), ETA="+util.timeToString(ct-start)+" of "+util.timeToString(1000L*contentSize/CPS)+
	 ", BPS="+CPS);
	 lastrep=ct;
      }
 }
 
 if(dos!=null) {
      dos.close();
      datain.close();
 }

 if(skipbytes>0)
 {
   dmachine.log_err("Connection closed on "+url);
   return DOWNLOAD_ERR;
 }

 if(dos==null) return DOWNLOAD_OK;
 
 if(total<contentSize) { dmachine.log_err("Connection closed on "+url+" Got "+total+"B, expected "+contentSize+"B.");
                    return DOWNLOAD_ERR;
                  }     
 // hotovo
 dmachine.log_ok("*** Download of "+qf.getName()+" ("+new File(dmachine.tmp_dir,qf.getLocalName()).length()+" B) was SUCCESSFULL ***");
 
 // move downloaded file to right directory
 if(!handleDownloadedFile(qf))
     return DOWNLOAD_FATAL;

 /* we are done! */
 return DOWNLOAD_OK;
}

/* return false on error */
private final boolean handleDownloadedFile(qfile qf)
{
 int i;
 /* default savedir */
 File savedir=new File(dmachine.download_dir);
 /* find save directory */
 i=qf.isInRegexpArray(this.url.toString(),qf.saveto,0);
 if(i>-1) savedir=qf.saveto_dir[i];
    
 if(! new File(dmachine.tmp_dir,qf.getLocalName()).renameTo
   (new File(savedir,qf.getLocalName()))
  )
 {
    // rename after download failed.
    dmachine.log_err("Can not rename file "+qf.getLocalName()+" from "+dmachine.tmp_dir+" to "+savedir);
    if(i==-1)
    {
	// no fallback possible
	return false;
    }
    // retry to default savedir
    if(! new File(dmachine.tmp_dir,qf.getLocalName()).renameTo
	 (new File(dmachine.download_dir,qf.getLocalName())))
    {
	dmachine.log_fatal("Can not move downloaded file "+qf.getLocalName()+" from temporary directory "+dmachine.tmp_dir+" to download directory "+dmachine.download_dir);
	return false;
    }
    else
    {
	dmachine.log_ok("File "+qf.getName()+" moved to normal download directory instead.");
    }
 }
  
 if(!qf.getName().equals(qf.getLocalName()))
 {
  dmachine.log_ok("*** File "+qf.getName()+" saved as "+qf.getLocalName()+" ***");
  String autonm=qfile.genAutoName(qf.getName());
  if(!qf.getLocalName().equals(autonm)) qf.touch();
 }
 return true;
}

public static boolean addReferer(String urlmask, String referer)
{
  if(urlmask==null || referer==null) return false;
  if(urlmask.length()==0 || referer.length()==0) return false;

  if(checkreferer==null) checkreferer=sendreferer=new String[0];
  
  for(int i=checkreferer.length-1;i>=0;i--)
   if(checkreferer[i].startsWith(urlmask)) 
    {
     sendreferer[i]=referer;
     return false;
    }
    
  // add new record
  checkreferer=util.addStringToArray(urlmask,checkreferer);
  sendreferer= util.addStringToArray(referer,sendreferer);
  return true;
}

public static boolean addCookie(String urlmask, String cookie)
{
  if(urlmask==null || cookie==null) return false;
  if(urlmask.length()==0 || cookie.length()==0) return false;

  if(checkcookie==null) checkcookie=sendcookie=new String[0];
  
  for(int i=checkcookie.length-1;i>=0;i--)
   if(checkcookie[i].startsWith(urlmask)) 
    {
     sendcookie[i]=cookie;
     return false;
    }
    
  // add new record
  checkcookie=util.addStringToArray(urlmask,checkcookie);
  sendcookie= util.addStringToArray(cookie,sendcookie);

  return true;
}

/* this procedure should modify protected variables as result */
/* Download factory MUST implement this! */
/* prepares data connection for download */ 
protected void processRequest(InetAddress server,int port,boolean nocache) throws IOException,java.net.MalformedURLException
{
 sendHTTPRequest(server,port,nocache);  
 /* precist httprc */
 rc=getHTTPRC();
 if(rc==DOWNLOAD_FATAL) return;
 getHTTPHeaderData(qf,url);
}

/* operates on open control connection to server */
public final static int GenericTransferLogic(InetAddress server,int port,boolean nocache,downloadfactory df) throws java.net.MalformedURLException, IOException
 {
  // Socket s; /* connection to server */
  df.processRequest(server,port,nocache);
  long skipbytes=df.havebytes; // nasty hack for now
  switch(df.rc)
  {
       case DOWNLOAD_FATAL: df.close();return DOWNLOAD_FATAL;
       case DOWNLOAD_ERR: df.close();return DOWNLOAD_ERR;
       case DOWNLOAD_BUSY: df.close();return DOWNLOAD_BUSY;
  }

 /* skipbytes = bytes to skip from our request */
 if(df.rc!=DOWNLOAD_OK && df.rc!=DOWNLOAD_RESUME)
  {
   // System.out.println("[INTERNAL ERROR] rc="+rc);
   df.close();return df.rc;
  }
  /* BROKEN CODE!!! check if ctsize < skipbytes */
  if(df.rc==DOWNLOAD_OK && df.contentSize<skipbytes && df.contentSize>0)
  {
    // move into attic directory
    new File(dmachine.attic_dir).mkdirs();
    new File(dmachine.attic_dir,df.qf.getLocalName()).delete();
    new File(dmachine.tmp_dir,df.qf.getLocalName()).renameTo
     (new File(dmachine.attic_dir,df.qf.getLocalName()));

    // file on the server is smaller than ours, download it again
    dmachine.log_err("Temporary file "+df.qf.getLocalName()+" for "+df.url+" is bigger than expected. Moving it into Attic directory.");
    skipbytes=0;
    df.havebytes=0;
  }

   if(df.rc==DOWNLOAD_RESUME)
   {
    System.out.println("[INFO] Continuing download of "+df.qf.getLocalName()+" on pos="+df.havebytes+".");
    skipbytes=0;
   } 
   else 
       skipbytes=df.havebytes;
  
  /* skip firsts bytes if needed */
  if(skipbytes>0) 
      if(df.DataTransfer(skipbytes)==DOWNLOAD_ERR) 
	  return DOWNLOAD_ERR;
  
  return df.DataTransfer(0);
}

/* close connection to server */
/* Download factory should override this if needed */
protected synchronized void close()
{
  if(datain!=null)
      try
      { 
	  datain.close();
      }
      catch (IOException ignore) {}
  
  if(dataout!=null)
      try
      { 
	  dataout.close();
      }
      catch (IOException ignore) {}
  dataout=null;
  datain=null;
}

}  /* class */
