import java.io.*;
import java.net.*;
import java.util.*;

public final class qfile implements Runnable
{
 // static cfg data
 public static regexp checkalso[];
 public static File checkalso_dir[];
 
 public static regexp saveto[];
 public static File   saveto_dir[];
 
 // location INFO
 private String name; 				// jmeno souboru
 private String localname;			// jmeno pro ulozeni na hadr
 private String URL[];				// na kterych URL je

 // retry status
 private int URLstatus[]; 		// kolikrat se z nej downloadovalo
 private short retry;			// kolikrat se nahravalo celkem
 private int mindown;			// minimalni pocet downloadu v URLstatus poli
 
 private boolean ok;			// already downloaded?
 private boolean hold;			// HOLD=fatal error or retry exhausted
 
 private Thread downloader;		// pro killnuti, not yet used

 qfile(String simplename,String url)
 {
  name=simplename;
  URL=new String[1];
  URL[0]=url;
  URLstatus=new int[1];
  URLstatus[0]=0;
  ok=false;
  hold=false;
  downloader=null;
  retry=-1;
  mindown=0;
  
  if(!isGoodFilename(simplename)) localname=genAutoName(simplename);
   else localname=simplename;

  //check for - OK file downloaded.
  checkOK();  
 }

 private final void checkOK()
 {
   File dir;
   int i;

   for(int z=0;z<URL.length;z++)
   {
       dir=new File(dmachine.download_dir);
       i=0;
       while(true)
       {
	  if(new File(dir,localname).exists()) 
	   {
	    ok=true;
	    System.out.println("[OK] File "+name+(localname.equals(name)?"":" ("+localname+")")+" already sucessfully downloaded in directory "+dir);
	    removeFromQueues();
	    return;
	   }
	  
	  i=isInRegexpArray(URL[z],checkalso,i);
	  if(i>-1) dir=checkalso_dir[i++];
	  else 
	     break;
       }
   }
 }

 public final void addURL(String URL)
 {
  if(this.ok) return; /* no need to add anything */
  // dupe check
  for(int i=this.URL.length-1;i>=0;i--)
   if(this.URL[i].equals(URL)) return;
   
  System.out.println("[QUEUE] Alternate URL "+URL+" added for file "+name);
  
  this.URL=util.addStringToArray(URL,this.URL);
  this.URLstatus=util.incIntArraySize(this.URLstatus);
  mindown=0;
  // unhold
  hold=false; 
  
  if(retry+dmachine.uretry>dmachine.retry)
  {
    retry-=dmachine.uretry; 
    retry=(short)Math.max(0,retry);
  }
  
 }
 
 public final void run()
 {
  downloader=Thread.currentThread();
  int siteidx=-1;
  try
  {
   retry++;
   
   // najit vhodny sajt. Zatim bereme ten prvni co se namane
   if(mindown>=dmachine.uretry || retry>=dmachine.retry) 
      { 
        hold=true; // no more retries
	downloader=null;
	return;
      }

   idxscan:while(siteidx==-1)
   {
   for(int i=0;i<URLstatus.length;i++)
    if(URLstatus[i]<=mindown) {siteidx=i;break idxscan;}
   mindown++;
   if(mindown>=dmachine.uretry) 
     { 
       hold=true; // no more retries
       downloader=null;
       return;
     }
   }
   System.out.println("[TRYING] URL="+URL[siteidx]);
   URLstatus[siteidx]++;
   int i; 
   switch(downloadfactory.downloadFactory(URL[siteidx],this))
   {
    case downloadfactory.DOWNLOAD_OK:
       ok=true;
       hold=true;
       removeFromQueues();
       break;
    case downloadfactory.DOWNLOAD_FATAL:
       URLstatus[siteidx]=dmachine.uretry;break;
    case downloadfactory.DOWNLOAD_BUSY:
       URLstatus[siteidx]--;break; // BUSY FTP server
   }
   
  }
  catch(java.net.UnknownHostException e)
  {
    dmachine.log_fatal("URL="+URL[siteidx]+" err="+
        e.getMessage()+": Host unknown.");
    
    URLstatus[siteidx]=dmachine.uretry;
  }
  catch(IOException e)
   {
    dmachine.log_err(name+" I/O err="+e);
   }
  catch(Exception e)
   {e.printStackTrace();}
  finally
   {
    downloader=null;
   }
 }
 
 public final boolean equals(Object o)
 {
  qfile q;
  if(o instanceof qfile) { q=(qfile)o; return name.equals(q.name);}
   else return false;
 }

 public final void redirect(String from,String to)
 {
  int i=0;
  for(;i<URL.length;i++)
    if(URL[i].equals(from))
      {
        URLstatus[i]=dmachine.uretry; // no longer needed
        System.out.println("[REDIRECT] "+from+" => "+to);
	addURL(to);
        if(!isGoodFilename(name) && genLocalName(to)!=null)
	 {
	  localname=genLocalName(to);
          checkOK();
	  if(ok==true) touch();
	 }
	return;
      }
 }

 private final static boolean isGoodFilename(String n)
 {
  if(n==null) return false;
  if(n.length()==0) return false;
  if(n.indexOf("/")>-1) return false;
  if(n.indexOf("\\")>-1) return false;
  if(n.indexOf(":")>-1) return false;
  return true;
 }
 
 public final static String genAutoName(String uname)
 {
    java.util.zip.CRC32 crc;
    crc=new java.util.zip.CRC32();
    crc.update(uname.getBytes());
    return dmachine.auto_prefix+Long.toHexString(crc.getValue())+dmachine.auto_suffix;
 }

 private final static String genLocalName(String uname)
 {
  String result;
  try
  {
   URL u;
   u=new URL(uname);
   result=dmachine.getFilename(u.getFile());
   if(result==null || result.length()==0) return null; else return result;
  }
  catch (Exception e)
   { return null; }
 }

 /* info methods */
 public final String getName()
 {
   return name;
 }

 public final String getLocalName()
 {
   return localname;
 }

public final boolean isActive()
{
  if(downloader!=null) return true;
   else return false;
}

 public final boolean needsDownload()
 {
  if(ok==true) return false;
  if(isActive()) return false;
  if(hold==true) return false;
  return true;
 }
 
 /* create auto-touch generated name */
 public final void touch()
 {
    File f=new File(dmachine.download_dir,genAutoName(name));
    try
     {
      FileOutputStream fos;
      fos=new FileOutputStream(f.toString(),true);
      for(int i=0;i<URL.length;i++)
      {
        fos.write(URL[i].getBytes());
        fos.write('\n');
      }
      fos.write(localname.getBytes());
      fos.write('\n');
      fos.close();
      System.out.println("[INFO] Touched "+genAutoName(name)+" for "+name);
     }
     catch (IOException io) {}
  }

    final private void removeFromQueues()
    {
	queuefile q;
	
	for(int i=dmachine.queue_files.length-1;i>=0;i--)
	{
	    q=dmachine.queue_files[i];
	    for(int j=URL.length-1;j>=0;j--)
	    {
		q.removeURL(URL[j]);
	    }
	    q.savefile();
	}
    }
		
		
   /* netestuje duplicity! */
   final static regexp[] addRegexpToArray(String what,regexp[] array)
   {
    if(what==null) return array;
    if(array==null) { array=new regexp[1];array[0]=new regexp(what,true);return array;}
    
    regexp[] tmp;
    tmp=new regexp[array.length+1];
    System.arraycopy(array,0,tmp,0,array.length);
    tmp[array.length]=new regexp(what,true);
    return tmp;
   }

final static int isInRegexpArray(String what,regexp[] array,int start)
{
 if(array==null) return -1;

 for(int i=start;i<array.length;i++)
  if(array[i].matches(what)) { return i;}
 return -1;
}

final static File  [] addFileToArray(File what,File[] array)
{
 if(what==null) return array;
 if(array==null) { array=new File  [1];array[0]=what;return array;}
 File  [] tmp;
 int ar=array.length;
 tmp=new File  [ar+1];
 System.arraycopy(array,0,tmp,0,ar);
 tmp[ar]=what;
 return tmp;
}

final static void addCheckAlso(String regexp,String dir)
{
   int i=0;

   while(true)
   {
     i=isInRegexpArray(regexp,checkalso,i);
     if(i==-1)
     {
	//System.out.println("Added checkalso "+regexp+" "+dir);
	checkalso=addRegexpToArray(regexp,checkalso);
	checkalso_dir=addFileToArray(new File(dir),checkalso_dir);
	return;
     }

     if(checkalso_dir[i].equals(new File(dir))) return;
     i++;
   }
}

 // static cfg data
 //public static regexp checkalso[];
 //public static File checkalso_dir[];

final static void addSaveto(String regexp,String dir)
{
   int i=0;

     i=isInRegexpArray(regexp,saveto,0);
     if(i==-1)
     {
	saveto=addRegexpToArray(regexp,saveto);
	saveto_dir=addFileToArray(new File(dir),saveto_dir);
     } else
     {
	saveto_dir[i]=new File(dir);
     }
}

}
