import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;

public class queuefile {

    public final static String nl=(String)System.getProperties().get("line.separator");
    
    private String name;
    private boolean removeurls;
    private boolean keepempty;

    // status
    private long lastmod;
    private boolean changed;
    // file content
    private Vector lines;
    
    public queuefile(String fn)
    {
	this(fn,dmachine.removefromqueues,dmachine.keepemptyqueues);
    }

    /* creates a new queue file class */
    public queuefile(String fn,boolean rem,boolean keep)
    {
	if(fn==null) throw new IllegalArgumentException("Queue file can not be null");
	this.name=fn;
	this.removeurls=rem;
	this.keepempty=keep;
	this.lastmod=0L;
	this.changed=false;
	this.lines=new Vector();
    }

    /* return true if file was externaly on-disk modified */
    public boolean isModified()
    {
	File qf;

	qf=new File(name);

	// file appeared
	if(lastmod==0)
	{
	    if(qf.isFile() && qf.canRead())
		return true;
	    else
		return false;
	}
	// file deleted
	if(!qf.isFile() || ! qf.canRead())
	    return true;
	// check lastmod date
	if(qf.lastModified()!=lastmod)
	    return true;
	else
	    return false;
    }

    public void loadfile()
    {
	loadfile(name);
    }
    
    /* loads file from disk to memory, line by line. updates lastmod */
    public void loadfile(String fname)
    {
	    boolean loaded;
	    lines=new Vector(lines.size()+1);

	    loaded=appendFile(fname);
	    changed=false;
	    
	    if(!loaded && !keepempty)
	    {
		new File(fname).delete();
	    } 
		
	    lastmod=new File(fname).lastModified();
    }

    /* appends file to memory, do not updates anything */
    /* returns true if input file was non-empty */
    public boolean appendFile(String fname)
    {
	boolean empty=true;
	try
	{
	    DataInputStream dis=new DataInputStream(new BufferedInputStream(
				new FileInputStream(fname) ) );
	    String line;

	    while ( (line = dis.readLine()) != null)
	    {
		if(line.trim().length()>0) { empty=false;changed=true;}
		lines.addElement(line);
	    }
            dis.close();
	}
	catch (IOException ioe)
	{ empty=true;}

	return !empty;
    }
   
	
    /* save file from memory to disk, line by line. updates lastmod */
    public void savefile()
    {
	if(!changed) return;
	if(lines.size()==0)
	    if(!keepempty)
	    {
		new File(name).delete();
		lastmod=0;
		changed=false;
		return;
	    }
	try
	{
	    DataOutputStream dos=new DataOutputStream(new BufferedOutputStream(
				new FileOutputStream(name), 4096 ) );
	    String line;

	    for(int i=0;i<lines.size();i++)
	    {
		line=(String)lines.elementAt(i);
		dos.writeBytes(line);
		dos.writeBytes(nl);
	    }
	    dos.close();
	    lastmod=new File(name).lastModified();
	    changed=false;
	}
	catch (IOException ioe)
	{}
    }

    /* removes URL from file */
    public void removeURL(String url)
    {
	if(url==null) return;
	if(removeurls==false) return;
	int i=lines.size()-1;
	String line;
	StringTokenizer st;
	
	if(!dmachine.case_sensitive)
	{
	    url=url.toLowerCase();
	}
	for(;i>=0;i--)
	{
	    line=(String)lines.elementAt(i);
	    st=new StringTokenizer(line,"\r\n\t #");
	    if(!st.hasMoreTokens()) continue;
	    line=st.nextToken();
	    if(!dmachine.case_sensitive)
	    {
		line=line.toLowerCase();
	    }
	    if(line.equals(url))
	    {
		lines.removeElementAt(i);
		changed=true;
	    }
	}
    }

    /* return copy of lines */
    public Vector getLines()
    {
	return (Vector)lines.clone();
    }

    /* exist file on the disk? */
    public boolean exists()
    {
	if(lastmod>0) 
	    return true;
	else
	    return false;
    }

    /* return filename */
    public String getName()
    {
	return name;
    }

    /* clears queue */
    public void clear()
    {
	lines.setSize(0);
	changed=true;
    }
}
