import java.io.*;
import java.net.*;
import java.util.*;

public class dmachine
{

 public static final String VERSION="0.22";
 public static final String NAME="Download Machine";
 public static final String COPYRIGHT="Copyright (c) 1999-2005 Radim Kolar. Open Source Software; There is NO warranty.\n"+
 "See the GNU General Public Licence version 2 or later for copying conditions.";

 /* proxy servers */
 public static InetAddress http_proxyserver;
 public static String	   http_auth;
 public static int         http_proxyport;
 public static boolean     http_proxydefined;
 public static int	   http_resume;

 public static InetAddress  ftp_proxyserver;
 public static String	    ftp_auth;
 public static int          ftp_proxyport;
 public static boolean      ftp_proxydefined;
 public static int	    ftp_resume;

 /* misc flags */
 public static int exitonempty;
 public static boolean keepemptyqueues;
 public static boolean removefromqueues;
 
 /* queue files */
 public static queuefile queue_files[];
 public static queuefile dropdir_queue;

 public static String alive_flag;

 /* directories */
 public static String download_dir;
 public static String tmp_dir;
 public static String attic_dir;
 public static String drop_dir;

 public static boolean case_sensitive;

 /* retry configuration */
 public static short threads,retry,uretry;  
 public static int timeout;
 /* activity conf. */
 public static long qchecktime,reptime;

 public static String auto_prefix,auto_suffix;

 /* log setup */
 public static String log_fatal;
 public static String log_ok;
 public static String log_err;
 
 // system data
 public static Hashtable files; /* for fast search by name */
 public static Vector queue;
 public static int qhead;
 
 public static ThreadGroup runners;
  
 public static final void main(String argv[])
 {
  // print copyright
  System.out.println(NAME+" "+VERSION+"\n"+COPYRIGHT+"\n");

  // sysinit
  files=new Hashtable();
  queue=new Vector();
  qhead=-1;
  queue_files=new queuefile[0];
  auto_prefix=auto_suffix="";
  runners=new ThreadGroup(NAME+"-workers");
  URL.setURLStreamHandlerFactory(new FSPStreamHandler());

  // cfginit
  defaultinit();
  try
  {
     configure("dmachine.cnf");
  }
  catch (IOException i)
  {
      addQueueFile("queue");
  }

  watchQueue();
 }

private static final void checkQueueFiles()
{
   // check queue files
   for(int i=queue_files.length-1;i>=0;i--)
   {
     queuefile q;
     q=queue_files[i];
     
     if( !q.isModified() ) continue;
     q.loadfile();
     if(q.exists())
     {
       System.out.println("[QUEUE] Loaded queue file: "+q.getName());
       parseQueue(q);
     }
   }
}

private static final void checkDropDirectory()
{
   // check if something new is in drop directory

   if(drop_dir==null) return;
   File dropdir=new File(drop_dir);
   if(!dropdir.isDirectory()) return;

   String filez[];
   filez=dropdir.list();
   if(filez==null) return;
   if(filez.length==0) return;

   for(int i=filez.length-1;i>=0;i--)
   {
     File f;
     queuefile q;
     f=new File(dropdir,filez[i]);
     if(dropdir_queue!=null) 
	 q=dropdir_queue;
     else
	 q=new queuefile(f.toString(),false,false);
     q.appendFile(f.toString());
     System.out.println("[QUEUE] Loaded drop directory file: "+f.toString());
     parseQueue(q);
     q.savefile();
     f.delete();
   }
}

 private static final void watchQueue()
 {
   boolean empty=false;
   long timerstart=System.currentTimeMillis();
  
   while(true)
   {
     checkQueueFiles();
     checkDropDirectory();
     touch_flag(alive_flag);
      
     if(!startThreads())
     {
       /* empty queue */
       if(exitonempty>0) 
       {
          if(exitonempty==1 || System.currentTimeMillis()-timerstart>exitonempty*1000L)
	  {
	     System.out.println("[QUEUE] Ending operation, because queue is empty.");
	     check_flag(alive_flag);
	     return;
	  }
       }
	 
       if(empty==false)
       {
          System.out.print("[QUEUE] Download Machine is idle.");
	  if(exitonempty>0)
	      System.out.print(" DM will stop after "+exitonempty+"s.");
	  System.out.println("");
	  empty=true;
       }
     }
    else 
    {
      timerstart=System.currentTimeMillis();
      empty=false;
    }
     
   try
   {
     Thread.sleep(qchecktime);
   }
   catch(InterruptedException intr)
    {
      System.out.println("[YUP!] GOT INTR, QueueWatch ended.");
      break;
    }
  }
 } /* watchQueue */

 private static final void defaultinit()
 {
  /* init to defaults */
  keepemptyqueues=true;
  removefromqueues=true;
  ftp_proxydefined=http_proxydefined=false;
  download_dir="files";
  tmp_dir=download_dir+File.separatorChar+"tmp";
  attic_dir=download_dir+File.separatorChar+"attic";
  drop_dir="drop";
  case_sensitive=true;
  threads=2; retry=15;uretry=5;
  timeout=60*3*1000;
  qchecktime=15L*1000L;
  reptime=45L*1000L;
  downloadfactory.useragent=dmachine.NAME+"/"+dmachine.VERSION+" (Java Virtual Machine)";
  ftpfactory.nopasv=false;
  log_fatal="fatal.log";
  log_ok="download.log";
  alive_flag=null;
  exitonempty=0;
  downloadfactory.send_useragent=true;
  downloadfactory.send_referer=true;
 }
 
private static final void configure(String cfgfile) throws IOException
{
  DataInputStream dis=new DataInputStream(new BufferedInputStream(
                        new FileInputStream(cfgfile) ) );
  int lineno=0;                        
  String line,token;
  StringTokenizer st;                        
  
  while ( (line = dis.readLine()) != null)
  {
          lineno++;
          if(line.startsWith("#")) continue;
	  st=new StringTokenizer(line);
          if(st.hasMoreTokens()==false) continue;
          token=st.nextToken();
          token=token.toLowerCase();
          try
          {
           if(token.equals("http_proxy")) 
	   {
	       try
	        {
                  http_proxyserver=InetAddress.getByName(st.nextToken());
                  http_proxyport=Integer.valueOf(st.nextToken()).intValue();
                  http_proxydefined=true;
		  if(st.countTokens()>0) http_auth="Proxy-authorization: Basic "+HTUU.encode_string(st.nextToken())+"\r\n";
		}
		catch (UnknownHostException hnf) 
		{
		  System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" http_proxy "+hnf.getMessage()+": Host not found.");
		}
		continue;
	   }
          else                                      
          if(token.equals("ftp_proxy")) 
	  {
	    try
	    {
             ftp_proxyserver=InetAddress.getByName(st.nextToken());
             ftp_proxyport=Integer.valueOf(st.nextToken()).intValue();
             ftp_proxydefined=true;
	     if(st.countTokens()>0) ftp_auth="Proxy-authorization: Basic "+HTUU.encode_string(st.nextToken())+"\r\n";
	     }
	     catch (java.net.UnknownHostException hnf) {
		  System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" ftp_proxy "+hnf.getMessage()+":Host not found.");
	     }
	     continue;
	  }
	  else
          if(token.equals("ftp_proxy_resume")) 
	    {
             ftp_resume=decoderesumekw(st.nextToken());
	    }
	  else
          if(token.equals("alive_flag")) 
	    {
             alive_flag=st.nextToken();
	    }
	  else
          if(token.equals("http_proxy_resume")) 
	    {
             http_resume=decoderesumekw(st.nextToken());
	    }
          else                                      
          if(token.equals("queue_file")) 
                                      { 
				        addQueueFile(st.nextToken());
                                        continue;
                                      }
	  else
          if(token.equals("drop_directory_queue")) 
                                      { 
					 dropdir_queue=new queuefile(st.nextToken(),true,false);
                                         queue_files=util.addQFToArray(dropdir_queue,queue_files);
                                         continue;
                                       }
	  else			      
          if(token.equals("auto_prefix")) 
                                      { 
				        auto_prefix=st.nextToken();
                                        continue;
				      }
          else				      
          if(token.equals("user_agent")) 
                                      { 
				        downloadfactory.useragent=st.nextToken("\n").trim();
                                        continue;
				      }
	  else
          if(token.equals("keep_empty_queue_file")) 
                                      { 
				        keepemptyqueues=getYesNo(st.nextToken());
                                        continue;
				      }
	  else
          if(token.equals("remove_downloads_from_queue_file")) 
                                      { 
				        removefromqueues=getYesNo(st.nextToken());
                                        continue;
				      }
	  else
          if(token.equals("send_user_agent")) 
                                      { 
				        downloadfactory.send_useragent=getYesNo(st.nextToken());
                                        continue;
				      }
	  else
          if(token.equals("send_referer")) 
                                      { 

					downloadfactory.send_referer=getYesNo(st.nextToken());
                                        continue;
				      }
          else                        
          if(token.equals("log_fatal")
	  || token.equals("fatal_log")
	  ) 
                                      { 
				        log_fatal=st.nextToken();
                                        continue;
                                      }
          else
          if(token.equals("log_ok") 
	  || token.equals("ok_log") )
                                      { 
				        log_ok=st.nextToken();
                                        continue;
                                      }
          else
          if(token.equals("log_err") 
	  || token.equals("err_log") )
                                      { 
				        log_err=st.nextToken();
                                        continue;
                                      }
          else
          if(token.equals("auto_suffix")) 
                                      { 
				        auto_suffix=st.nextToken();
                                        continue;
                                      }
          else                                      
          if(token.equals("download_directory")) 
                                      {  
                                         download_dir=kill_end_slash(st.nextToken());
                                         continue;
                                       }
	  else                                       
          if(token.equals("temporary_directory")) 
                                      {  
                                         tmp_dir=kill_end_slash(st.nextToken());
                                         continue;
                                      }
          else				      
          if(token.equals("attic_directory")) 
                                      {  
                                         attic_dir=kill_end_slash(st.nextToken());
                                         continue;
                                       }
          else                                      
          if(token.equals("drop_directory")) 
                                      {  
                                         drop_dir=kill_end_slash(st.nextToken());
                                         continue;
                                       }
          else                                      
          if(token.equals("case_sensitive_filenames")) {
	                                                   case_sensitive=getYesNo(st.nextToken());
                                                           continue;
                                                      }
          else                                      
          if(token.equals("ftp_nopasv")) {
                                                           ftpfactory.nopasv=getYesNo(st.nextToken());
                                                           continue;
                                                      }
          else                                      
          if(token.equals("download_threads")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   threads=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else                                      
          if(token.equals("file_retry_count")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   retry=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else                                      
          if(token.equals("url_retry_count")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   uretry=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
                                                      
          else                                      
          if(token.equals("download_timeout")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   timeout=1000*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
          else
          if(token.equals("fsp_delay")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   fspfactory.delay=Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else
          if(token.equals("fsp_maxdelay")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   fspfactory.maxdelay=Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
          else                                      
          if(token.equals("report_time")) {                // Java 1.0.X doesn't have Short class, using Integer
          				                   reptime=1000*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
                                                      
          else                                      
          if(token.equals("queue_check_time")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   qchecktime=1000L*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
          else                                      
          if(token.equals("exit_on_empty_queue")) {
	  					    int rc;
						    rc=Integer.valueOf(st.nextToken()).intValue();
						    if(rc>0) exitonempty=rc; else exitonempty=0;
	  }else
          System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" Unknown keyword: "+token);
          
          }
          catch (NoSuchElementException nse)
           { System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" Missing arguent(s).");
             continue;}                                     
  }                      
  new File(download_dir).mkdirs();
  new File(tmp_dir).mkdirs();
  dis.close();                        
 }
 
 private final static void parseQueue(queuefile q)
 {
    String line;
    int lineno=0;             
    URL url;
    Vector lines;
    int ln;
    lines=q.getLines();
    ln=lines.size();
    
    for ( int i=0;i<ln;i++)
    {
	  line=(String)lines.elementAt(i);
          lineno++;
          if(line.startsWith("#")) continue;
          try
          {
            StringTokenizer st=new StringTokenizer(line);
            line=st.nextToken();
	    if(line.indexOf("://")==-1)
	    {
	      /* check for special commands */
	      line=line.toLowerCase();
	      if(line.equals("referer"))
	      {
	        String f1,f2;
	        f1=st.nextToken();
	        f2=st.nextToken();
                downloadfactory.addReferer(f1,f2);
	        continue;
	      }
	      else if(line.equals("cookie"))
	      {
	        String f1,f2;
	        f1=st.nextToken();
	        f2=st.nextToken("\n").trim();
                downloadfactory.addCookie(f1,f2);
	        continue;
	      }
	      else if(line.equals("check_also")||
		      line.equals("checkalso")
		    )
	      {
	        String f1,f2;
	        f1=st.nextToken().trim();
	        f2=st.nextToken("\n").trim();
                f2=kill_end_slash(f2);
                qfile.addCheckAlso(f1,f2);
	        continue;
	      }
	      else if(line.equals("save_to") ||
		      line.equals("saveto")
		    )
	      {
	        String f1,f2;
	        f1=st.nextToken().trim();
	        f2=st.nextToken("\n").trim();
                f2=kill_end_slash(f2);
                qfile.addSaveto(f1,f2);
	        continue;
	      }
	      else if(line.equals("end")) break;
	      
              System.out.println("[QUEUE] Bad command '"+line+"' at line "+lineno);
	      continue;
	    }
          }
          catch(NoSuchElementException kurva) 
	  {
	    continue;
	  }

	  /* add filename */  
          try
          {
            String fn;
            qfile qf;
	    fn=null;
	    if(line.indexOf('#')>-1)
	     {
	      int z=line.indexOf('#');
	      fn=line.substring(z+1);
	      line=line.substring(0,z);
	     }
            url=new URL(line);
	    if(fn==null) fn=getFilename(url.getFile());
            if(fn!=null && fn.length()!=0)
             {
	       if(!case_sensitive) fn=fn.toLowerCase();
             } else fn=line;
             
            qf=(qfile)files.get(fn);
            if(qf==null)
             {
              qf=new qfile(fn,line);
	      if(qf.needsDownload())
                    System.out.println("[QUEUE] New file "+fn+" added. url="+line);
              files.put(fn,qf);
              queue.addElement(qf);
             } else
              qf.addURL(line);
              
          }
          catch (MalformedURLException grr)
           {
            System.out.println(grr+"\n[QUEUE] Bad URL="+line+" at line "+lineno);continue;
           }
  }  
 } /* parse_queue */
 
/* vraci true pokud je DM aktivni */
private final static synchronized boolean startThreads()
{
 int ac=runners.activeCount();
 boolean active=false;
 if(ac>0) active=true;
 if(ac>=threads) return true;
 
 boolean rotated=false;
 int qs=queue.size();
 if(qs==0) return active; // empty queue
 while(true)
 {
  qhead++;
  if(qhead>=qs)
  {
   if(rotated) return active;
     else
   {
     qhead=0;
     rotated=true;
   }
  }
   
  qfile qf;
  qf=(qfile)queue.elementAt(qhead);
  if(!qf.needsDownload()) continue;
  // start it up!
  active=true;
  Thread t;
  t=new Thread(runners,qf);
  // qf.downloader=t;
  t.start();
  Thread.yield();
  ac++;
  if(ac>=threads) return true;
 }
} 

public final static String getFilename(String fileurl)
{
   /* new code (from smart cache) */
   
   byte v[];
   int j=fileurl.length();
   
   v=new byte[j];
   fileurl.getBytes(0,j,v,0);
   loop1:for(int zz=0;zz<j;zz++)
    {
      switch(v[zz])
      {
        case 0x3b: // ;
        case 0x3a: // :
        case 0x3d: // =
        case 0x3f: // ?
	case 0x7c: // |
         //  case 0x23: // # - je jiz odstranen
	 
           return null; // je to dotaz!
      }
    }
      
    /* novy kod - konec! */
   if(fileurl.length()<2) return "";
   j=fileurl.lastIndexOf('/',j);
   int i=fileurl.indexOf('~');
   if (i!=-1 && j<i) return "";
    else 
     return fileurl.substring(j+1); // soubor
}

private final static void log_write(String fname,String msg) throws IOException
{
 if(fname==null) return;
  DataOutputStream dos=new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fname,true)));
  dos.writeBytes(new Date().toString());
  dos.writeBytes(" ");
  dos.writeBytes(msg);
  dos.writeBytes("\n");
  dos.close();
}

public synchronized static void log_fatal(String msg)
{
 System.out.println("[FATAL_ERR] "+msg);
 try
 {
  log_write(log_fatal,msg);
 }
catch (IOException i)
 {
  log_fatal=null;
 }
}

public synchronized static void log_err(String msg)
{
 System.out.println("[ERR] "+msg);
 try
 {
  log_write(log_err,msg);
 }
catch (IOException i)
 {
  log_err=null;
 }
}

public synchronized static void log_ok(String msg)
{
 System.out.println("[OK] "+msg);
 try
 {
  log_write(log_ok,msg);
 }
catch (IOException i)
 {
  log_ok=null;
 }
}
 
private final static void addQueueFile(String name)
{
 if(name==null || name.length()==0) return;
 
 for(int i=queue_files.length-1;i>=0;i--)
  if(queue_files[i].getName().equals(name)) return;
 
 queue_files=util.addQFToArray(new queuefile(name),queue_files);
}

private final static int decoderesumekw(String kw)
{
 int res=downloadfactory.RESUME_UNKNOWN;
 kw=kw.toLowerCase();
 if(kw.equals("none")|| kw.equals("normal")|| kw.equals("standard"))
  res=downloadfactory.RESUME_NONE;
 else 
 if(kw.equals("pragma")|| kw.equals("nocache"))
  res=downloadfactory.RESUME_NOCACHE;
 else
 if(kw.equals("direct"))
  res=downloadfactory.RESUME_DIRECT;
 else
   System.err.println("[CONFIG_ERROR] Unknown resume option "+kw);
   
 return res;

}
private final static String kill_end_slash(String str)
{
   if(str.endsWith(File.separator)) str=download_dir.substring(0,download_dir.length()-1);
   return str;
}

final static private void touch_flag(String s)
{
 if(s==null) return;
 try
 {
  java.io.FileOutputStream f=new java.io.FileOutputStream(s);
  f.close();
 }
 catch (IOException ignore)
 {}
}

final static private boolean check_flag(String f)
{
 if(f==null) return false;
 File fl=new File(f);
 if(fl.canRead())
    {fl.delete();return true;}
 return false;
}

final private static boolean getYesNo(String s)
{
  if(s==null) return false;
  if(s.length()==0) return false;
  
  s=s.toLowerCase();

  if(s.equals("off") || s.equals("no") || s.equals("0") || s.equals("false"))
    return false;
    
  if(s.equals("on") || s.equals("yes") || s.equals("1") || s.equals("true"))
    return true;

  System.err.println("[CONFIG_ERROR] Can not determine if `"+s+"` means yes or no.");
  return false;
}


}
